/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.IncrementalResourceDistributionStatsSnapshot;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class IncrementalResourceDistributionGoalMetrics {
    static final String NUM_BROKERS_ABOVE_LOWER_BOUND_METRIC_NAME = "num-brokers-above-lower-bound-threshold";
    static final String DESIRED_MEAN_UTILIZATION_METRIC_NAME = "desired-mean-utilization";
    private final Map<String, String> tags;
    private final DataBalancerMetricsRegistry metricsRegistry;
    private volatile IncrementalResourceDistributionStatsSnapshot snapshot;

    public IncrementalResourceDistributionGoalMetrics(String goalName, DataBalancerMetricsRegistry metricsRegistry, Class<?> metricClass) {
        this.tags = Collections.singletonMap("goal", goalName);
        this.metricsRegistry = metricsRegistry;
        this.registerMetrics(metricClass);
    }

    public void update(IncrementalResourceDistributionStatsSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    private void registerMetrics(Class<?> metricClass) {
        this.metricsRegistry.newGauge(metricClass, NUM_BROKERS_ABOVE_LOWER_BOUND_METRIC_NAME, this::numBrokersAboveLowerBoundThreshold, this.tags);
        this.metricsRegistry.newGauge(metricClass, DESIRED_MEAN_UTILIZATION_METRIC_NAME, this::clusterMeanUtilizationPercentage, this.tags);
    }

    private int numBrokersAboveLowerBoundThreshold() {
        return Optional.ofNullable(this.snapshot).map(IncrementalResourceDistributionStatsSnapshot::numBrokersAboveLowerBoundThreshold).orElse(0);
    }

    private double clusterMeanUtilizationPercentage() {
        return Optional.ofNullable(this.snapshot).map(IncrementalResourceDistributionStatsSnapshot::clusterMeanUtilizationPercentage).orElse(0.0);
    }
}

