/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.linkedin.kafka.cruisecontrol.config.GoalConfigChangeNotifier;
import com.linkedin.kafka.cruisecontrol.config.SbcGoalsConfig;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class UpdatableSbcGoalsConfig
implements GoalConfigChangeNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatableSbcGoalsConfig.class);
    private volatile SbcGoalsConfig sbcGoalsConfig;
    private final List<GoalConfigChangeNotifier.GoalConfigChangeListener> listeners = new ArrayList<GoalConfigChangeNotifier.GoalConfigChangeListener>();

    public UpdatableSbcGoalsConfig(SbcGoalsConfig sbcGoalsConfig) {
        this.sbcGoalsConfig = sbcGoalsConfig;
    }

    public SbcGoalsConfig config() {
        return this.sbcGoalsConfig;
    }

    public synchronized void update(SbcGoalsConfig newConfig) {
        this.sbcGoalsConfig = newConfig;
        LOG.info("Goals config updated to (newConfig -> {})", (Object)newConfig);
        for (GoalConfigChangeNotifier.GoalConfigChangeListener goalConfigChangeListener : this.listeners) {
            try {
                goalConfigChangeListener.onChange(newConfig);
            }
            catch (Exception e) {
                LOG.warn("Updating listener {} of the goal config change (newConfig -> {}) failed due to an exception.", new Object[]{goalConfigChangeListener.name(), newConfig, e});
            }
        }
    }

    @Override
    public synchronized void registerListener(GoalConfigChangeNotifier.GoalConfigChangeListener listener) {
        this.listeners.add(listener);
    }

    public String toString() {
        return "UpdatableSbcGoalsConfig{rebalancingGoals=" + this.sbcGoalsConfig.rebalancingGoals() + ", triggeringGoals=" + this.sbcGoalsConfig.triggeringGoals() + ", incrementalBalancingEnabled=" + this.sbcGoalsConfig.isIncrementalBalancingEnabled() + ", incrementalBalancingGoals=" + this.sbcGoalsConfig.incrementalBalancingGoals() + "}";
    }
}

