/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.utils;

import io.confluent.databalancer.record.CellOverloadOccurrenceDelta;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import kafka.server.KafkaConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CellOverloadOccurrence {
    public static final long CELL_OVERLOAD_DETECTION_INTERVAL_MS = Duration.ofHours(1L).toMillis();
    private static final Logger LOG = LoggerFactory.getLogger(CellOverloadOccurrence.class);
    private final Map<Integer, Integer> cellOverloadOccurrences;
    private final long maxCellOverloadOccurrences;

    public CellOverloadOccurrence(KafkaConfig config) {
        this.maxCellOverloadOccurrences = this.maxCellOverloadOccurrences(config);
        this.cellOverloadOccurrences = new ConcurrentHashMap<Integer, Integer>();
    }

    private long maxCellOverloadOccurrences(KafkaConfig config) {
        long cellOverloadDurationMs = config.getLong("confluent.balancer.cell.overload.duration.ms");
        return Math.max(1L, cellOverloadDurationMs / CELL_OVERLOAD_DETECTION_INTERVAL_MS);
    }

    public boolean isOverloaded(int cellId) {
        return this.occurrences(cellId) >= this.maxCellOverloadOccurrences;
    }

    public long occurrences(int cellId) {
        return this.cellOverloadOccurrences.getOrDefault(cellId, 0).intValue();
    }

    public void replay(CellOverloadOccurrenceDelta.CellOverloadOccurrenceDeltaProto cellOverloadOccurrenceDelta) {
        int version = cellOverloadOccurrenceDelta.getVersion();
        if (version == 1) {
            CellOverloadOccurrenceDelta.Operation op = cellOverloadOccurrenceDelta.getOp();
            int cellId = cellOverloadOccurrenceDelta.getCellId();
            switch (op) {
                case record_once: {
                    this.recordOnce(cellId);
                    break;
                }
                case delete_once: {
                    this.deleteOnce(cellId);
                    break;
                }
                case clear: {
                    this.clear(cellId);
                }
            }
        } else {
            LOG.warn("Invalid version {} is found for the CellOverloadOccurrenceDelta, ignoring the record...", (Object)version);
        }
    }

    void recordOnce(int cellId) {
        this.cellOverloadOccurrences.merge(cellId, 1, Integer::sum);
    }

    void deleteOnce(int cellId) {
        this.cellOverloadOccurrences.compute(cellId, (id, occurrences) -> {
            if (occurrences == null) {
                return -1;
            }
            if (occurrences == 1) {
                return null;
            }
            return occurrences - 1;
        });
    }

    void clear(int cellId) {
        this.cellOverloadOccurrences.remove(cellId);
    }
}

