/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityInfo;
import com.linkedin.kafka.cruisecontrol.model.Broker;

public abstract class Capacity {
    static Capacity from(Broker broker, BrokerCapacityInfo capacityInfo) {
        return broker.isAlive() ? new SingleEntityCapacity(broker, capacityInfo) : new DeadEntityCapacity(-1.0);
    }

    static Capacity create() {
        return new CompositeCapacity();
    }

    static Capacity dead(double deadCapacityValue) {
        return new DeadEntityCapacity(deadCapacityValue);
    }

    public abstract void addCapacity(Capacity var1);

    public abstract double totalCapacityFor(Resource var1);

    public abstract double ignoredSourceCapacityFor(Resource var1);

    public abstract double eligibleSourceCapacityFor(Resource var1);

    public abstract double ignoredDestinationCapacityFor(Resource var1);

    public abstract double eligibleDestinationCapacityFor(Resource var1);

    private static double getResourceCapacity(Resource resource, double capacity, int numCpuCores) {
        return capacity * (double)(resource == Resource.CPU ? numCpuCores : 1);
    }

    private static class DeadEntityCapacity
    extends Capacity {
        private final double deadCapacity;

        public DeadEntityCapacity(double deadCapacity) {
            this.deadCapacity = deadCapacity;
        }

        @Override
        public double totalCapacityFor(Resource resource) {
            return this.deadCapacity;
        }

        @Override
        public double ignoredSourceCapacityFor(Resource resource) {
            return this.deadCapacity;
        }

        @Override
        public double eligibleSourceCapacityFor(Resource resource) {
            return this.deadCapacity;
        }

        @Override
        public double ignoredDestinationCapacityFor(Resource resource) {
            return this.deadCapacity;
        }

        @Override
        public double eligibleDestinationCapacityFor(Resource resource) {
            return this.deadCapacity;
        }

        @Override
        public void addCapacity(Capacity capacity) {
            throw new UnsupportedOperationException("Capacity cannot be added to a dead entity");
        }
    }

    private static class SingleEntityCapacity
    extends Capacity {
        private final double[] capacity = new double[Resource.cachedValues().size()];
        private final Broker broker;

        SingleEntityCapacity(Broker broker, BrokerCapacityInfo capacityInfo) {
            if (capacityInfo.capacity() == null) {
                throw new IllegalArgumentException("Capacity is null: " + capacityInfo);
            }
            this.broker = broker;
            capacityInfo.capacity().forEach((resource, resourceCapacity) -> {
                this.capacity[resource.id()] = Capacity.getResourceCapacity(resource, resourceCapacity, capacityInfo.numCpuCores());
            });
        }

        @Override
        public double totalCapacityFor(Resource resource) {
            return this.capacity[resource.id()];
        }

        @Override
        public double ignoredSourceCapacityFor(Resource resource) {
            return this.broker.isEligibleSource() ? 0.0 : this.totalCapacityFor(resource);
        }

        @Override
        public double eligibleSourceCapacityFor(Resource resource) {
            return this.broker.isEligibleSource() ? this.totalCapacityFor(resource) : 0.0;
        }

        @Override
        public double ignoredDestinationCapacityFor(Resource resource) {
            return this.broker.isEligibleDestination() ? 0.0 : this.totalCapacityFor(resource);
        }

        @Override
        public double eligibleDestinationCapacityFor(Resource resource) {
            return this.broker.isEligibleDestination() ? this.totalCapacityFor(resource) : 0.0;
        }

        @Override
        public void addCapacity(Capacity capacity) {
            throw new UnsupportedOperationException("Capacity cannot be added to a single entity");
        }
    }

    private static class CompositeCapacity
    extends Capacity {
        private final double[] capacity = new double[Resource.cachedValues().size()];
        private final double[] ignoredSourceCapacity = new double[Resource.cachedValues().size()];
        private final double[] eligibleSourceCapacity = new double[Resource.cachedValues().size()];
        private final double[] ignoredDestinationCapacity = new double[Resource.cachedValues().size()];
        private final double[] eligibleDestinationCapacity = new double[Resource.cachedValues().size()];

        private CompositeCapacity() {
        }

        @Override
        public void addCapacity(Capacity capacity) {
            if (capacity instanceof DeadEntityCapacity) {
                throw new IllegalArgumentException("Cannot add dead capacity");
            }
            Resource.cachedValues().forEach(resource -> {
                int n = resource.id();
                this.capacity[n] = this.capacity[n] + capacity.totalCapacityFor((Resource)((Object)resource));
                int n2 = resource.id();
                this.ignoredSourceCapacity[n2] = this.ignoredSourceCapacity[n2] + capacity.ignoredSourceCapacityFor((Resource)((Object)resource));
                int n3 = resource.id();
                this.eligibleSourceCapacity[n3] = this.eligibleSourceCapacity[n3] + capacity.eligibleSourceCapacityFor((Resource)((Object)resource));
                int n4 = resource.id();
                this.ignoredDestinationCapacity[n4] = this.ignoredDestinationCapacity[n4] + capacity.ignoredDestinationCapacityFor((Resource)((Object)resource));
                int n5 = resource.id();
                this.eligibleDestinationCapacity[n5] = this.eligibleDestinationCapacity[n5] + capacity.eligibleDestinationCapacityFor((Resource)((Object)resource));
            });
        }

        @Override
        public double totalCapacityFor(Resource resource) {
            return this.capacity[resource.id()];
        }

        @Override
        public double ignoredSourceCapacityFor(Resource resource) {
            return this.ignoredSourceCapacity[resource.id()];
        }

        @Override
        public double eligibleSourceCapacityFor(Resource resource) {
            return this.eligibleSourceCapacity[resource.id()];
        }

        @Override
        public double ignoredDestinationCapacityFor(Resource resource) {
            return this.ignoredDestinationCapacity[resource.id()];
        }

        @Override
        public double eligibleDestinationCapacityFor(Resource resource) {
            return this.eligibleDestinationCapacity[resource.id()];
        }
    }
}

