/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.ResourceUtilizationRatioThresholdsProvider;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ResourceStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class ClusterModelHelper {
    public static Set<Broker> brokersWithUtilizationUnderCapacityThreshold(Collection<Broker> brokers, Resource resource, double capacityThreshold) {
        ClusterModel.CapacityLimitProvider provider = broker -> ClusterModelHelper.resourceStatsFor(broker, resource).capacity().totalCapacityFor(resource) * capacityThreshold;
        return ClusterModelHelper.brokersWithUtilizationUnderCapacity(brokers, resource, provider);
    }

    public static Set<Broker> brokersWithUtilizationUnderCapacityThreshold(Collection<Broker> brokers, Resource resource, ClusterModel.ThresholdProvider thresholdProvider) {
        ClusterModel.CapacityLimitProvider capacityLimitProvider = broker -> ClusterModelHelper.resourceStatsFor(broker, resource).capacity().totalCapacityFor(resource) * thresholdProvider.threshold(broker);
        return ClusterModelHelper.brokersWithUtilizationUnderCapacity(brokers, resource, capacityLimitProvider);
    }

    public static Set<Broker> brokersWithUtilizationUnderCapacity(Collection<Broker> brokers, Resource resource, ClusterModel.CapacityLimitProvider capacityLimitProvider) {
        return brokers.stream().filter(broker -> {
            double capacity = capacityLimitProvider.capacityLimit((Broker)broker);
            double utilization = ClusterModelHelper.resourceStatsFor(broker, resource).load().expectedUtilizationFor(resource);
            return utilization < capacity;
        }).collect(Collectors.toSet());
    }

    public static Set<Broker> brokersWithUtilizationOverThreshold(Collection<Broker> originalBrokers, Resource resource, double utilizationThreshold) {
        return originalBrokers.stream().filter(broker -> ClusterModelHelper.resourceStatsInHierarchicalOrder(broker, resource).stream().anyMatch(stats -> {
            double capacity = stats.capacity().totalCapacityFor(resource) * utilizationThreshold;
            double utilization = stats.load().expectedUtilizationFor(resource);
            return utilization > capacity;
        })).collect(Collectors.toSet());
    }

    public static Set<Broker> brokersWithUtilizationOverLowUtilizationRatioThreshold(Collection<Broker> brokers, ResourceUtilizationRatioThresholdsProvider thresholds) {
        return brokers.stream().filter(broker -> ClusterModelHelper.resourceStatsInHierarchicalOrder(broker, thresholds.resource()).stream().anyMatch(stats -> {
            double capacity = stats.capacity().totalCapacityFor(thresholds.resource()) * thresholds.lowUtilizationRatio((Broker)broker);
            double utilization = stats.load().expectedUtilizationFor(thresholds.resource());
            return utilization > capacity;
        })).collect(Collectors.toSet());
    }

    public static ResourceStats resourceStatsFor(Broker broker, Resource resource) {
        if (resource.isBrokerResource()) {
            return broker;
        }
        if (resource.isHostResource()) {
            return broker.host();
        }
        throw new IllegalStateException(String.format("Provided %s resource is not broker or host level resource", new Object[]{resource}));
    }

    private static List<ResourceStats> resourceStatsInHierarchicalOrder(Broker broker, Resource resource) {
        ArrayList<ResourceStats> resourceStats = new ArrayList<ResourceStats>();
        if (resource.isBrokerResource()) {
            resourceStats.add(broker);
        }
        if (resource.isHostResource()) {
            resourceStats.add(broker.host());
        }
        return resourceStats;
    }

    public static Double calculatePopulationVariance(List<? extends Number> values) {
        double mean = values.stream().mapToDouble(Number::doubleValue).sum() / (double)values.size();
        double sumOfSquares = values.stream().mapToDouble(value -> Math.pow(value.doubleValue() - mean, 2.0)).sum();
        return sumOfSquares / (double)values.size();
    }
}

