/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Utilization;
import java.util.List;
import java.util.Optional;

class CompositeEntityUtilization
implements Utilization {
    private final Load load;
    private final Load eligibleSourceLoad;
    private final Load ignoredSourceLoad;
    private final Load eligibleDestinationLoad;
    private final Load ignoredDestinationLoad;

    public CompositeEntityUtilization(Load load) {
        this.load = load;
        this.eligibleSourceLoad = new Load();
        this.ignoredSourceLoad = new Load();
        this.eligibleDestinationLoad = new Load();
        this.ignoredDestinationLoad = new Load();
    }

    @Override
    public Load totalUtilization() {
        return this.load;
    }

    @Override
    public Optional<Load> ignoredSourceUtilization() {
        return Optional.ofNullable(this.ignoredSourceLoad.isEmpty() ? null : this.ignoredSourceLoad);
    }

    @Override
    public Optional<Load> eligibleSourceUtilization() {
        return Optional.ofNullable(this.eligibleSourceLoad.isEmpty() ? null : this.eligibleSourceLoad);
    }

    @Override
    public Optional<Load> ignoredDestinationUtilization() {
        return Optional.ofNullable(this.ignoredDestinationLoad.isEmpty() ? null : this.ignoredDestinationLoad);
    }

    @Override
    public Optional<Load> eligibleDestinationUtilization() {
        return Optional.ofNullable(this.eligibleDestinationLoad.isEmpty() ? null : this.eligibleDestinationLoad);
    }

    @Override
    public void addLoad(Broker.Strategy strategy, AggregatedMetricValues loadToAdd) {
        this.initializedSourceLoad(strategy).addLoad(loadToAdd);
        this.initializedDestinationLoad(strategy).addLoad(loadToAdd);
    }

    @Override
    public void addLoad(Broker.Strategy strategy, Load load) {
        this.sourceLoad(strategy).addLoad(load);
        this.destinationLoad(strategy).addLoad(load);
    }

    @Override
    public void subtractLoad(Broker.Strategy strategy, AggregatedMetricValues loadToSubtract) {
        this.initializedSourceLoad(strategy).subtractLoad(loadToSubtract);
        this.initializedDestinationLoad(strategy).subtractLoad(loadToSubtract);
    }

    @Override
    public void subtractLoad(Broker.Strategy strategy, Load load) {
        this.sourceLoad(strategy).subtractLoad(load);
        this.destinationLoad(strategy).subtractLoad(load);
    }

    @Override
    public void addMetricValues(Broker.Strategy strategy, AggregatedMetricValues aggregatedMetricValues, List<Long> windows) {
        this.sourceLoad(strategy).addMetricValues(aggregatedMetricValues, windows);
        this.destinationLoad(strategy).addMetricValues(aggregatedMetricValues, windows);
    }

    private Load sourceLoad(Broker.Strategy strategy) {
        return strategy.isEligibleSource() ? this.eligibleSourceLoad : this.ignoredSourceLoad;
    }

    private Load initializedSourceLoad(Broker.Strategy strategy) {
        Load load = this.sourceLoad(strategy);
        if (!load.isInitialized()) {
            throw new IllegalStateException("Load is not initialized.");
        }
        return load;
    }

    private Load destinationLoad(Broker.Strategy strategy) {
        return strategy.isEligibleDestination() ? this.eligibleDestinationLoad : this.ignoredDestinationLoad;
    }

    private Load initializedDestinationLoad(Broker.Strategy strategy) {
        Load load = this.destinationLoad(strategy);
        if (!load.isInitialized()) {
            throw new IllegalStateException("Load is not initialized.");
        }
        return load;
    }
}

