/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Utilization;
import java.util.List;
import java.util.Optional;

class SingleEntityUtilization
implements Utilization {
    private final Load load;
    private final Broker.Strategy strategy;

    public SingleEntityUtilization(Load load, Broker.Strategy strategy) {
        this.load = load;
        this.strategy = strategy;
    }

    @Override
    public Load totalUtilization() {
        return this.load;
    }

    @Override
    public Optional<Load> ignoredSourceUtilization() {
        return Optional.ofNullable(this.strategy.isEligibleSource() ? null : this.load);
    }

    @Override
    public Optional<Load> eligibleSourceUtilization() {
        return Optional.ofNullable(this.strategy.isEligibleSource() ? this.load : null);
    }

    @Override
    public Optional<Load> ignoredDestinationUtilization() {
        return Optional.ofNullable(this.strategy.isEligibleDestination() ? null : this.load);
    }

    @Override
    public Optional<Load> eligibleDestinationUtilization() {
        return Optional.ofNullable(this.strategy.isEligibleDestination() ? this.load : null);
    }

    @Override
    public void addLoad(Broker.Strategy strategy, Load load) {
        throw new UnsupportedOperationException("Add load not supported for this utilization class");
    }

    @Override
    public void addLoad(Broker.Strategy strategy, AggregatedMetricValues loadToSubtract) {
        throw new UnsupportedOperationException("Add load not supported for this utilization class");
    }

    @Override
    public void subtractLoad(Broker.Strategy strategy, Load load) {
        throw new UnsupportedOperationException("Subtract load not supported for this utilization class");
    }

    @Override
    public void subtractLoad(Broker.Strategy strategy, AggregatedMetricValues loadToSubtract) {
        throw new UnsupportedOperationException("Subtract load not supported for this utilization class");
    }

    @Override
    public void addMetricValues(Broker.Strategy strategy, AggregatedMetricValues aggregatedMetricValues, List<Long> windows) {
        throw new UnsupportedOperationException("Add metric values is not supported for this utilization class");
    }
}

