/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Utilization;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.message.DescribeTenantsResponseData;

public class Tenant {
    private final String tenantId;
    private Integer cellId;
    private final PartitionPlacementStrategy placementPolicy;
    private final Load load;
    private final Utilization utilization;
    private int replicaCount;

    public Tenant(String tenantId, Integer cellId, PartitionPlacementStrategy placementPolicy) {
        Objects.requireNonNull(KafkaCruiseControlUtils.convertEmptyToNull(tenantId));
        this.tenantId = tenantId;
        this.cellId = cellId;
        this.placementPolicy = placementPolicy;
        this.load = new Load();
        this.utilization = Utilization.from(this.load);
        this.replicaCount = 0;
    }

    public Tenant(DescribeTenantsResponseData.TenantDescription tenant) {
        this(tenant.tenantId(), tenant.cellId(), PartitionPlacementStrategy.toEnum((Integer)tenant.partitionPlacementStrategy()));
    }

    public void addReplicaWithGivenLoadAndUtilization(Broker.Strategy strategy, AggregatedMetricValues metricValues, List<Long> windows) {
        this.load.addMetricValues(metricValues, windows);
        this.utilization.addMetricValues(strategy, metricValues, windows);
        ++this.replicaCount;
    }

    public void addReplicaWithGivenLoadAndUtilization(Broker.Strategy strategy, Load load) {
        this.load.addLoad(load);
        this.utilization.addLoad(strategy, load);
        ++this.replicaCount;
    }

    public void transferUtilizationOfMovedLeadership(Broker.Strategy sourceStrategy, Broker.Strategy destinationStrategy, AggregatedMetricValues loadToMove) {
        this.utilization.subtractLoad(sourceStrategy, loadToMove);
        this.utilization.addLoad(destinationStrategy, loadToMove);
    }

    public void removeReplicaWithGivenLoadAndUtilization(Broker.Strategy strategy, Load load) {
        this.load.subtractLoad(load);
        this.utilization.subtractLoad(strategy, load);
        --this.replicaCount;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public Integer cellId() {
        return this.cellId;
    }

    public Load load() {
        return this.load;
    }

    public Utilization utilization() {
        return this.utilization;
    }

    public PartitionPlacementStrategy placementPolicy() {
        return this.placementPolicy;
    }

    public int replicaCount() {
        return this.replicaCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tenant tenant = (Tenant)o;
        return this.tenantId.equals(tenant.tenantId);
    }

    public int hashCode() {
        return this.tenantId.hashCode();
    }

    public String toString() {
        return "Tenant {tenantId=" + this.tenantId + ", cellId=" + this.cellId + ", placementPolicy=" + this.placementPolicy + "}";
    }
}

