/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.history;

import io.confluent.cruisecontrol.analyzer.history.EntityEventHistoryUtils;
import io.confluent.cruisecontrol.analyzer.history.SuspendedEntity;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;

@Immutable
public final class SuspendedTopicPartition
extends SuspendedEntity<TopicPartition>
implements Comparable<SuspendedTopicPartition> {
    public SuspendedTopicPartition(TopicPartition tp, long suspensionDurationMs, long epoch) {
        this(Time.SYSTEM, tp, suspensionDurationMs, epoch);
    }

    SuspendedTopicPartition(Time time, TopicPartition tp, long suspensionDurationMs, long epoch) {
        super(time, tp, suspensionDurationMs, epoch);
    }

    public SuspendedTopicPartition(Object entity, long entityPartitionSuspensionMs, long epoch) {
        this((TopicPartition)entity, entityPartitionSuspensionMs, epoch);
    }

    public String toString() {
        return "SuspendedTopicPartition{tp=" + this.entity() + ", deadlineMs=" + this.deadlineMs() + ", epoch=" + this.epoch() + '}';
    }

    @Override
    public int compareTo(@Nonnull SuspendedTopicPartition o) {
        return EntityEventHistoryUtils.compareTopicPartitionEventHistories(this, o, (TopicPartition)this.entity(), (TopicPartition)o.entity());
    }
}

