/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.history;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.model.Tenant;
import io.confluent.cruisecontrol.analyzer.history.EntityEventHistoryUtils;
import io.confluent.cruisecontrol.analyzer.history.EntityMovement;
import javax.annotation.Nonnull;
import org.apache.kafka.common.utils.Time;

public final class TenantMovement
extends EntityMovement<Tenant>
implements Comparable<TenantMovement> {
    private final int sourceCell;
    private final int destinationCell;
    private final long timestampMs;

    public TenantMovement(Tenant tenant, int sourceCell, int destinationCell, Class<? extends Goal> proposingGoal, String movementReason, long expirationMs, long epoch) {
        this(Time.SYSTEM, tenant, sourceCell, destinationCell, proposingGoal, movementReason, expirationMs, epoch);
    }

    private TenantMovement(Time time, Tenant tenant, int sourceCell, int destinationCell, Class<? extends Goal> proposingGoal, String movementReason, long expirationMs, long epoch) {
        super(time, tenant, proposingGoal, movementReason, expirationMs, epoch);
        this.sourceCell = sourceCell;
        this.destinationCell = destinationCell;
        this.timestampMs = time.milliseconds();
    }

    public int sourceCell() {
        return this.sourceCell;
    }

    public int destinationCell() {
        return this.destinationCell;
    }

    public long timestampMs() {
        return this.timestampMs;
    }

    public String tenantId() {
        return ((Tenant)this.entity()).tenantId();
    }

    @Override
    public String toString() {
        return "TenantMovement{sourceCell=" + this.sourceCell + ", destinationCell=" + this.destinationCell + ", proposingGoal='" + this.proposingGoal().getSimpleName() + '\'' + ", movementReason='" + this.movementReason() + '\'' + ", timestampMs=" + this.timestampMs + ", tenant=" + this.entity() + ", deadlineMs=" + this.deadlineMs() + ", epoch=" + this.epoch() + '}';
    }

    @Override
    public int compareTo(@Nonnull TenantMovement o) {
        return EntityEventHistoryUtils.compareTenantEventHistories(this, o, this.tenantId(), o.tenantId());
    }
}

