/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.image.ClusterDelta;
import org.apache.kafka.metadata.BrokerRegistration;

public class SbcClusterDelta {
    private final ClusterDelta clusterDelta;

    SbcClusterDelta(ClusterDelta clusterDelta) {
        this.clusterDelta = clusterDelta;
    }

    public Set<Integer> newlyDegradedBrokers() {
        DegradedBrokerFilter<BrokerRegistration> newlyDegradedFilter = (oldRegistration, newRegistration) -> this.isBrokerDegraded(newRegistration) && !this.isBrokerDegraded(oldRegistration);
        return this.filterRegisteredBrokers(newlyDegradedFilter);
    }

    public Set<Integer> newlyRecoveredBrokers() {
        DegradedBrokerFilter<BrokerRegistration> newlyRecoveredFilter = (oldRegistration, newRegistration) -> this.isBrokerDegraded(oldRegistration) && !this.isBrokerDegraded(newRegistration);
        return this.filterRegisteredBrokers(newlyRecoveredFilter);
    }

    private Set<Integer> filterRegisteredBrokers(DegradedBrokerFilter<BrokerRegistration> filter) {
        HashSet<Integer> filteredBrokers = new HashSet<Integer>();
        for (Integer brokerId : this.clusterDelta.changedBrokers().keySet()) {
            Optional newRegistration = (Optional)this.clusterDelta.changedBrokers().get(brokerId);
            Optional<BrokerRegistration> oldRegistration = Optional.ofNullable(this.clusterDelta.image().broker(brokerId.intValue()));
            if (!filter.apply(oldRegistration, newRegistration)) continue;
            filteredBrokers.add(brokerId);
        }
        return filteredBrokers;
    }

    private boolean isBrokerAvailable(Optional<BrokerRegistration> registration) {
        return registration.isPresent() && !registration.get().fenced();
    }

    private boolean isBrokerDegraded(Optional<BrokerRegistration> registration) {
        return registration.isPresent() && !registration.get().degradedComponents().isEmpty();
    }

    public List<BrokerRegistration> newBrokers() {
        ArrayList<BrokerRegistration> newBrokerList = new ArrayList<BrokerRegistration>();
        for (Optional newRegistration : this.clusterDelta.changedBrokers().values()) {
            Optional<BrokerRegistration> oldRegistration;
            if (!this.isBrokerAvailable(newRegistration) || this.isBrokerAvailable(oldRegistration = Optional.ofNullable(this.clusterDelta.image().broker(((BrokerRegistration)newRegistration.get()).id())))) continue;
            newBrokerList.add((BrokerRegistration)newRegistration.get());
        }
        return newBrokerList;
    }

    public Set<Integer> removedBrokers() {
        HashSet<Integer> removedBrokerSet = new HashSet<Integer>();
        for (Map.Entry entry : this.clusterDelta.changedBrokers().entrySet()) {
            Optional newRegistration = (Optional)entry.getValue();
            if (this.isBrokerAvailable(newRegistration) || this.clusterDelta.image().broker(((Integer)entry.getKey()).intValue()) == null) continue;
            removedBrokerSet.add((Integer)entry.getKey());
        }
        return removedBrokerSet;
    }

    ClusterDelta delta() {
        return this.clusterDelta;
    }

    @FunctionalInterface
    static interface DegradedBrokerFilter<T> {
        public boolean apply(Optional<T> var1, Optional<T> var2);
    }
}

