/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event;

import io.confluent.databalancer.SbcContext;
import io.confluent.databalancer.event.resource.SbcResource;
import io.confluent.databalancer.event.resource.SbcResources;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.queue.EventQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@NotThreadSafe
public abstract class SbcEvent
extends EventQueue.FailureLoggingEvent {
    protected static final Logger LOG = LoggerFactory.getLogger(SbcEvent.class);
    protected SbcContext eventContext;
    private final long id;

    public SbcEvent(SbcContext context) {
        super(LOG);
        this.eventContext = context;
        this.id = context.generateEventId();
    }

    public String name() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "-" + this.id;
    }

    @Nonnull
    protected abstract SbcEventHandlerResult handleEvent() throws Exception;

    protected abstract void respondToClient(ApiError var1, SbcEventHandlerResult var2);

    public final void run() throws InterruptedException {
        try {
            this.logHandlingEvent();
            SbcEventHandlerResult eventResult = this.handleEvent();
            Objects.requireNonNull(eventResult, String.format("Event %s returned a null SbcEventHandlerResult.", this.name()));
            if (!eventResult.followUpEvents().isEmpty()) {
                List<SbcEvent> followUpEvents = eventResult.followUpEvents();
                LOG.info("SBC Event {} generated {} more events to enqueue in the following order - {}. Enqueuing...", new Object[]{this.name(), followUpEvents.size(), followUpEvents.stream().map(SbcEvent::name).collect(Collectors.toList())});
                for (SbcEvent followUpEvent : followUpEvents) {
                    this.eventContext.eventQueue().enqueue(followUpEvent);
                }
            }
            if (eventResult.needsResource()) {
                this.eventContext.resourceManager().waitOnResource(eventResult.neededResource(), this);
            } else {
                this.respondToClient(ApiError.NONE, eventResult);
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.warn("Unexpected error while executing SBC event {}", (Object)this.name(), (Object)t);
            this.respondToClient(ApiError.fromThrowable((Throwable)t), new SbcEventHandlerResult());
        }
    }

    protected Level logLevel() {
        return Level.INFO;
    }

    private void logHandlingEvent() {
        Level level = this.logLevel();
        switch (level) {
            case ERROR: {
                LOG.error("Handling event {}", (Object)this.name());
                break;
            }
            case WARN: {
                LOG.warn("Handling event {}", (Object)this.name());
                break;
            }
            case INFO: {
                LOG.info("Handling event {}", (Object)this.name());
                break;
            }
            case DEBUG: {
                LOG.debug("Handling event {}", (Object)this.name());
                break;
            }
            case TRACE: {
                LOG.trace("Handling event {}", (Object)this.name());
                break;
            }
            default: {
                LOG.info("Handling event {}", (Object)this.name());
            }
        }
    }

    public String toString() {
        return this.name();
    }

    protected static class SbcEventHandlerResult {
        public static final SbcEventHandlerResult SUCCESS = new SbcEventHandlerResult();
        private Optional<SbcResource<?>> neededResource;
        private List<SbcEvent> followUpEvents;

        public static SbcEventHandlerResult needsResource(SbcResource<?> neededResource) {
            return new SbcEventHandlerResult(Optional.of(neededResource), Collections.emptyList());
        }

        public static SbcEventHandlerResult withFollowUpEvents(List<SbcEvent> followUpEvents) {
            return new SbcEventHandlerResult(Optional.empty(), followUpEvents);
        }

        protected SbcEventHandlerResult() {
            this(Optional.empty(), Collections.emptyList());
        }

        private SbcEventHandlerResult(Optional<SbcResource<?>> neededResourceOpt, List<SbcEvent> followUpEvents) {
            this.neededResource = neededResourceOpt;
            this.followUpEvents = followUpEvents;
        }

        public boolean needsResource() {
            return this.neededResource() != SbcResources.NONE;
        }

        public SbcResource<?> neededResource() {
            return this.neededResource.orElse(SbcResources.NONE);
        }

        public List<SbcEvent> followUpEvents() {
            return this.followUpEvents;
        }
    }
}

