/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import io.confluent.databalancer.operation.BrokerAdditionStateMachine;
import io.confluent.databalancer.operation.BrokerAdditionV2StateMachine;
import io.confluent.databalancer.operation.V2AdditionChecker;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import io.confluent.databalancer.persistence.BrokerAdditionStateRecord;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import kafka.common.BrokerAdditionDescriptionInternal;
import org.apache.kafka.common.protocol.BalancerOperationOverriddenException;

@ThreadSafe
public class BrokerAdditionV2StateManager
implements V2AdditionChecker {
    private final ApiStatePersistenceStore persistenceStore;
    private final Map<Integer, BrokerAdditionV2StateMachine> brokerAdditions;

    public BrokerAdditionV2StateManager(ApiStatePersistenceStore persistenceStore) {
        this.persistenceStore = persistenceStore;
        this.brokerAdditions = persistenceStore.brokerAdditionStateRecords().values().stream().collect(Collectors.toMap(BrokerAdditionStateRecord::brokerId, BrokerAdditionV2StateMachine::new));
    }

    public synchronized CancellationResult maybeCancelAddition(int brokerId, String cause) throws InterruptedException {
        BrokerAdditionV2StateMachine stateMachine = this.brokerAdditions.get(brokerId);
        if (stateMachine == null) {
            return new CancellationResult(false, String.format("The broker addition state machine for broker %d is null", brokerId));
        }
        if (((BrokerAdditionV2StateMachine.BrokerAdditionV2State)stateMachine.currentState()).isTerminal()) {
            return new CancellationResult(false, String.format("The broker addition state for broker %d is in a terminal state - %s", brokerId, stateMachine.currentState()));
        }
        BrokerAdditionV2StateMachine.BrokerAdditionV2State newState = (BrokerAdditionV2StateMachine.BrokerAdditionV2State)stateMachine.advanceState(BrokerAdditionV2StateMachine.BrokerAdditionV2Event.CANCELED);
        BrokerAdditionStateRecord recordToPersist = new BrokerAdditionStateRecord(brokerId, newState, (Exception)new BalancerOperationOverriddenException(cause), stateMachine.createTime(), stateMachine.lastUpdateTime());
        this.persistenceStore.save(recordToPersist);
        return new CancellationResult(true, "");
    }

    public synchronized List<BrokerAdditionDescriptionInternal> brokerAdditionDescriptions() {
        return this.brokerAdditions.values().stream().map(stateMachine -> new BrokerAdditionDescriptionInternal(stateMachine.brokerId(), ((BrokerAdditionV2StateMachine.BrokerAdditionV2State)stateMachine.currentState()).status(), BrokerAdditionStateMachine.convertBrokerAdditionStatus(((BrokerAdditionV2StateMachine.BrokerAdditionV2State)stateMachine.currentState()).status()), stateMachine.createTime(), stateMachine.lastUpdateTime(), this.persistenceStore.brokerAdditionStateRecords().get(stateMachine.brokerId()).exception())).collect(Collectors.toList());
    }

    @Override
    public synchronized List<PendingAddition> pendingBrokerAdditions() {
        return this.brokerAdditions.entrySet().stream().filter(additionEntry -> !((BrokerAdditionV2StateMachine.BrokerAdditionV2State)((BrokerAdditionV2StateMachine)additionEntry.getValue()).currentState()).isTerminal()).map(addition -> new PendingAddition((Integer)addition.getKey(), ((BrokerAdditionV2StateMachine)addition.getValue()).createTime())).collect(Collectors.toList());
    }

    public synchronized void initializeAddition(int brokerId) throws InterruptedException {
        if (this.brokerAdditions.containsKey(brokerId) && !((BrokerAdditionV2StateMachine.BrokerAdditionV2State)this.brokerAdditions.get(brokerId).currentState()).isTerminal()) {
            throw new IllegalStateException(String.format("The state of the broker addition operation for broker %d is already in a in progress state - initialize it again.", brokerId));
        }
        BrokerAdditionV2StateMachine stateMachine = new BrokerAdditionV2StateMachine(brokerId);
        BrokerAdditionStateRecord recordToPersist = new BrokerAdditionStateRecord(brokerId, (BrokerAdditionV2StateMachine.BrokerAdditionV2State)stateMachine.currentState(), null, stateMachine.createTime(), stateMachine.lastUpdateTime());
        this.persistenceStore.save(recordToPersist);
        this.brokerAdditions.put(brokerId, stateMachine);
    }

    public synchronized void completeAddition(int brokerId) throws InterruptedException {
        if (!this.brokerAdditions.containsKey(brokerId)) {
            throw new IllegalArgumentException(String.format("Cannot complete the broker addition operation for broker %d because no such operation is present.", brokerId));
        }
        BrokerAdditionV2StateMachine stateMachine = this.brokerAdditions.get(brokerId);
        if (((BrokerAdditionV2StateMachine.BrokerAdditionV2State)stateMachine.currentState()).isTerminal()) {
            throw new IllegalStateException(String.format("The state of the broker addition operation for broker %d is already in a terminal state %s - cannot complete it.", brokerId, stateMachine.currentState()));
        }
        BrokerAdditionV2StateMachine.BrokerAdditionV2State newState = (BrokerAdditionV2StateMachine.BrokerAdditionV2State)stateMachine.advanceState(BrokerAdditionV2StateMachine.BrokerAdditionV2Event.SUCCESS);
        BrokerAdditionStateRecord recordToPersist = new BrokerAdditionStateRecord(brokerId, newState, null, stateMachine.createTime(), stateMachine.lastUpdateTime());
        this.persistenceStore.save(recordToPersist);
    }

    @Immutable
    public static class PendingAddition {
        public final int brokerId;
        public final long createdTimeMs;

        public PendingAddition(int brokerId, long createdTimeMs) {
            this.brokerId = brokerId;
            this.createdTimeMs = createdTimeMs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PendingAddition that = (PendingAddition)o;
            return this.brokerId == that.brokerId && this.createdTimeMs == that.createdTimeMs;
        }

        public int hashCode() {
            return Objects.hash(this.brokerId, this.createdTimeMs);
        }

        public String toString() {
            return "PendingAddition{brokerId=" + this.brokerId + ", createdTimeMs=" + this.createdTimeMs + "}";
        }
    }

    public static class CancellationResult {
        public final boolean cancelled;
        public final String failureReason;

        public CancellationResult(boolean cancelled, String failureReason) {
            this.cancelled = cancelled;
            this.failureReason = failureReason;
        }

        public String toString() {
            return "CancellationResult{cancelled=" + this.cancelled + ", failureReason='" + this.failureReason + "'}";
        }
    }
}

