/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TableGenerator {
    private static final int PADDING_SIZE = 2;
    private static final String NEW_LINE = System.lineSeparator();

    public Optional<String> generateTable(List<String> headersList, List<List<String>> rowsList) {
        return this.generateTable(headersList, rowsList, 1);
    }

    public Optional<String> generateTable(List<String> headersList, List<List<String>> rowsList, int rowHeight) {
        if (!this.isInputValid(headersList, rowsList)) {
            return Optional.empty();
        }
        StringBuilder stringBuilder = new StringBuilder();
        Map<Integer, Integer> columnMaxWidthMapping = this.getMaximumWidthOfTable(headersList, rowsList);
        stringBuilder.append(NEW_LINE);
        stringBuilder.append(NEW_LINE);
        this.createRowLine(stringBuilder, headersList.size(), columnMaxWidthMapping);
        stringBuilder.append(NEW_LINE);
        for (int headerIndex = 0; headerIndex < headersList.size(); ++headerIndex) {
            this.fillCell(stringBuilder, headersList.get(headerIndex), headerIndex, columnMaxWidthMapping);
        }
        stringBuilder.append(NEW_LINE);
        this.createRowLine(stringBuilder, headersList.size(), columnMaxWidthMapping);
        for (List<String> row : rowsList) {
            for (int i = 0; i < rowHeight; ++i) {
                stringBuilder.append(NEW_LINE);
            }
            for (int cellIndex = 0; cellIndex < row.size(); ++cellIndex) {
                this.fillCell(stringBuilder, row.get(cellIndex), cellIndex, columnMaxWidthMapping);
            }
        }
        stringBuilder.append(NEW_LINE);
        this.createRowLine(stringBuilder, headersList.size(), columnMaxWidthMapping);
        stringBuilder.append(NEW_LINE);
        stringBuilder.append(NEW_LINE);
        return Optional.of(stringBuilder.toString());
    }

    private boolean isInputValid(List<String> headersList, List<List<String>> rowsList) {
        return rowsList.stream().map(List::size).allMatch(cells -> cells.intValue() == headersList.size());
    }

    private void fillSpace(StringBuilder stringBuilder, int length) {
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(" ");
        }
    }

    private void createRowLine(StringBuilder stringBuilder, int headersListSize, Map<Integer, Integer> columnMaxWidthMapping) {
        for (int i = 0; i < headersListSize; ++i) {
            if (i == 0) {
                stringBuilder.append("+");
            }
            for (int j = 0; j < columnMaxWidthMapping.get(i) + 4; ++j) {
                stringBuilder.append("-");
            }
            stringBuilder.append("+");
        }
    }

    private Map<Integer, Integer> getMaximumWidthOfTable(List<String> headersList, List<List<String>> rowsList) {
        int columnIndex;
        HashMap<Integer, Integer> columnMaxWidthMapping = new HashMap<Integer, Integer>();
        for (columnIndex = 0; columnIndex < headersList.size(); ++columnIndex) {
            columnMaxWidthMapping.put(columnIndex, 0);
        }
        for (columnIndex = 0; columnIndex < headersList.size(); ++columnIndex) {
            if (headersList.get(columnIndex).length() <= (Integer)columnMaxWidthMapping.get(columnIndex)) continue;
            columnMaxWidthMapping.put(columnIndex, headersList.get(columnIndex).length());
        }
        for (List<String> row : rowsList) {
            for (int columnIndex2 = 0; columnIndex2 < row.size(); ++columnIndex2) {
                if (row.get(columnIndex2).length() <= (Integer)columnMaxWidthMapping.get(columnIndex2)) continue;
                columnMaxWidthMapping.put(columnIndex2, row.get(columnIndex2).length());
            }
        }
        for (int columnIndex3 = 0; columnIndex3 < headersList.size(); ++columnIndex3) {
            if ((Integer)columnMaxWidthMapping.get(columnIndex3) % 2 == 0) continue;
            columnMaxWidthMapping.put(columnIndex3, (Integer)columnMaxWidthMapping.get(columnIndex3) + 1);
        }
        return columnMaxWidthMapping;
    }

    private int getOptimumCellPadding(int cellIndex, int dataLength, Map<Integer, Integer> columnMaxWidthMapping) {
        int length = dataLength;
        if (length % 2 != 0) {
            ++length;
        }
        int cellPaddingSize = 2;
        if (length < columnMaxWidthMapping.get(cellIndex)) {
            cellPaddingSize += (columnMaxWidthMapping.get(cellIndex) - length) / 2;
        }
        return cellPaddingSize;
    }

    private void fillCell(StringBuilder stringBuilder, String cell, int cellIndex, Map<Integer, Integer> columnMaxWidthMapping) {
        int cellPaddingSize = this.getOptimumCellPadding(cellIndex, cell.length(), columnMaxWidthMapping);
        if (cellIndex == 0) {
            stringBuilder.append("|");
        }
        this.fillSpace(stringBuilder, cellPaddingSize);
        stringBuilder.append(cell);
        if (cell.length() % 2 != 0) {
            stringBuilder.append(" ");
        }
        this.fillSpace(stringBuilder, cellPaddingSize);
        stringBuilder.append("|");
    }
}

