/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.loader.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public final class MetadataLoaderMetrics
implements AutoCloseable {
    private static final MetricName CURRENT_METADATA_VERSION = MetadataLoaderMetrics.getMetricName("MetadataLoader", "CurrentMetadataVersion");
    private static final MetricName HANDLE_LOAD_SNAPSHOT_COUNT = MetadataLoaderMetrics.getMetricName("MetadataLoader", "HandleLoadSnapshotCount");
    public static final MetricName CURRENT_CONTROLLER_ID = MetadataLoaderMetrics.getMetricName("MetadataLoader", "CurrentControllerId");
    private final Optional<MetricsRegistry> registry;
    private final AtomicReference<MetadataVersion> currentMetadataVersion = new AtomicReference<MetadataVersion>(MetadataVersion.MINIMUM_KRAFT_VERSION);
    private final AtomicInteger currentControllerId = new AtomicInteger(-1);
    private final AtomicLong handleLoadSnapshotCount = new AtomicLong(0L);
    private final Consumer<Long> batchProcessingTimeNsUpdater;
    private final Consumer<Integer> batchSizesUpdater;
    private final AtomicReference<MetadataProvenance> lastAppliedProvenance;

    public MetadataLoaderMetrics(Optional<MetricsRegistry> registry, Consumer<Long> batchProcessingTimeNsUpdater, Consumer<Integer> batchSizesUpdater, AtomicReference<MetadataProvenance> lastAppliedProvenance) {
        this.registry = registry;
        this.batchProcessingTimeNsUpdater = batchProcessingTimeNsUpdater;
        this.batchSizesUpdater = batchSizesUpdater;
        this.lastAppliedProvenance = lastAppliedProvenance;
        registry.ifPresent(r -> r.newGauge(CURRENT_METADATA_VERSION, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return MetadataLoaderMetrics.this.currentMetadataVersion().confluentFeatureLevel();
            }
        }));
        registry.ifPresent(r -> r.newGauge(CURRENT_CONTROLLER_ID, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return MetadataLoaderMetrics.this.currentControllerId();
            }
        }));
        registry.ifPresent(r -> r.newGauge(HANDLE_LOAD_SNAPSHOT_COUNT, (Gauge)new Gauge<Long>(){

            public Long value() {
                return MetadataLoaderMetrics.this.handleLoadSnapshotCount();
            }
        }));
    }

    public void updateBatchProcessingTimeNs(long elapsedNs) {
        this.batchProcessingTimeNsUpdater.accept(elapsedNs);
    }

    public void updateBatchSize(int size) {
        this.batchSizesUpdater.accept(size);
    }

    public void updateLastAppliedImageProvenance(MetadataProvenance lastAppliedProvenance) {
        this.lastAppliedProvenance.set(lastAppliedProvenance);
    }

    public long lastAppliedOffset() {
        return this.lastAppliedProvenance.get().lastContainedOffset();
    }

    public void setCurrentMetadataVersion(MetadataVersion metadataVersion) {
        this.currentMetadataVersion.set(metadataVersion);
    }

    public MetadataVersion currentMetadataVersion() {
        return this.currentMetadataVersion.get();
    }

    public int currentControllerId() {
        return this.currentControllerId.get();
    }

    public void setCurrentControllerId(int newCurrentControllerId) {
        this.currentControllerId.set(newCurrentControllerId);
    }

    public long incrementHandleLoadSnapshotCount() {
        return this.handleLoadSnapshotCount.incrementAndGet();
    }

    public long handleLoadSnapshotCount() {
        return this.handleLoadSnapshotCount.get();
    }

    @Override
    public void close() {
        this.registry.ifPresent(r -> Arrays.asList(CURRENT_METADATA_VERSION, CURRENT_CONTROLLER_ID, HANDLE_LOAD_SNAPSHOT_COUNT).forEach(arg_0 -> ((MetricsRegistry)r).removeMetric(arg_0)));
    }

    private static MetricName getMetricName(String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.server", (String)type, (String)name);
    }
}

