/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.config;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.config.ConfigMonitor;
import org.apache.kafka.metadata.config.ConfigMonitorKey;
import org.apache.kafka.metadata.config.ConfigMonitorKeyAndDefinition;
import org.apache.kafka.metadata.config.ConfigurationListener;
import org.apache.kafka.metadata.config.SpecificResourceConfigMonitor;
import org.slf4j.Logger;

public final class ConfigRegistry
implements ConfigurationListener {
    private final Logger log;
    private final Map<ConfigMonitorKey, ConfigMonitor> monitors;

    private ConfigRegistry(Logger log, Map<ConfigMonitorKey, ConfigMonitor> monitors) {
        this.log = log;
        this.monitors = monitors;
    }

    @Override
    public void update(ConfigResource configResource, String configKey, String newValue) {
        ConfigMonitorKey key = new ConfigMonitorKey(configResource.type(), configKey);
        ConfigMonitor monitor = this.monitors.get(key);
        if (monitor != null) {
            monitor.update(this.log, configResource.name(), newValue);
        }
    }

    public static class Builder {
        private final LogContext logContext;
        private final Logger log;
        private final KafkaConfigSchema configSchema;
        private final Map<String, Object> staticConfigMap;
        private final String nodeIdString;
        private final Supplier<Map> mapSupplier;
        private final Map<ConfigMonitorKey, ConfigMonitor> monitors = new HashMap<ConfigMonitorKey, ConfigMonitor>();

        public Builder(LogContext logContext, KafkaConfigSchema configSchema, Map<String, Object> staticConfigMap, int nodeId, Supplier<Map> mapSupplier) {
            this.logContext = logContext;
            this.log = logContext.logger(ConfigRegistry.class);
            this.configSchema = configSchema;
            this.staticConfigMap = staticConfigMap;
            this.nodeIdString = Integer.toString(nodeId);
            this.mapSupplier = mapSupplier;
        }

        public SpecificResourceConfigMonitor<Short> addShortNodeMonitor(String keyName) {
            ConfigMonitorKeyAndDefinition keyAndDefinition = ConfigMonitorKeyAndDefinition.fromSchema(ConfigResource.Type.BROKER, keyName, this.configSchema, ConfigDef.Type.SHORT);
            SpecificResourceConfigMonitor<Object> monitor = new SpecificResourceConfigMonitor<Object>(keyAndDefinition, this.nodeIdString, this.mapSupplier.get(), keyAndDefinition.loadStaticValue(this.log, this.staticConfigMap));
            this.monitors.put(monitor.key(), monitor);
            return monitor;
        }

        public SpecificResourceConfigMonitor<Integer> addIntNodeMonitor(String keyName) {
            ConfigMonitorKeyAndDefinition keyAndDefinition = ConfigMonitorKeyAndDefinition.fromSchema(ConfigResource.Type.BROKER, keyName, this.configSchema, ConfigDef.Type.INT);
            SpecificResourceConfigMonitor<Object> monitor = new SpecificResourceConfigMonitor<Object>(keyAndDefinition, this.nodeIdString, this.mapSupplier.get(), keyAndDefinition.loadStaticValue(this.log, this.staticConfigMap));
            this.monitors.put(monitor.key(), monitor);
            return monitor;
        }

        public ConfigRegistry build() {
            return new ConfigRegistry(this.log, this.monitors);
        }

        public short getStaticNodeShort(String keyName) {
            ConfigMonitorKeyAndDefinition keyAndDefinition = ConfigMonitorKeyAndDefinition.fromSchema(ConfigResource.Type.BROKER, keyName, this.configSchema, ConfigDef.Type.SHORT);
            return (Short)keyAndDefinition.loadStaticValue(this.log, this.staticConfigMap);
        }

        public int getStaticNodeInt(String keyName) {
            ConfigMonitorKeyAndDefinition keyAndDefinition = ConfigMonitorKeyAndDefinition.fromSchema(ConfigResource.Type.BROKER, keyName, this.configSchema, ConfigDef.Type.INT);
            return (Integer)keyAndDefinition.loadStaticValue(this.log, this.staticConfigMap);
        }
    }
}

