/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.confluent.rest.GetTierRecoveryDataUploadJobResultRequest;
import io.confluent.rest.GetTierRecoveryDataUploadJobResultResponse;
import io.confluent.rest.InitiateTierRecoveryDataUploadRequest;
import io.confluent.rest.InitiateTierRecoveryDataUploadResponse;
import io.confluent.rest.InternalRestServer;
import io.confluent.rest.ResponseContainer;
import io.confluent.rest.RewindTierTopicConsumerRequest;
import io.confluent.rest.RewindTierTopicConsumerResponse;
import io.confluent.rest.TierMetadataRecoveryHandle;
import io.confluent.rest.TierRecoveryDataUploadResult;
import io.confluent.rest.TierTopicHeadDataLossDetectionRequest;
import io.confluent.rest.TierTopicHeadDataLossDetectionResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TierMetadataRecoveryHandler
extends AbstractHandler {
    public static final String REWIND_PATH = "/tiertopicconsumer/rewind";
    public static final String TIER_TOPIC_HEAD_DATA_LOSS_DETECTION_PATH = "/tiertopicdatalossvalidator/detectheaddataloss";
    public static final String UPLOAD_INITIATE_PATH = "/upload/initiate";
    public static final String UPLOAD_RESULT_PATH = "/upload/result";
    private static final long MAX_DATA_LOSS_DETECTION_REQUEST_TIMEOUT_MS = Duration.ofMinutes(1L).toMillis();
    private static final Logger log = LoggerFactory.getLogger(InternalRestServer.class);
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final TierMetadataRecoveryHandle tierMetadataRecoveryHandle;
    private final long dataLossDetectionRequestServerTimeoutMs;

    public TierMetadataRecoveryHandler(TierMetadataRecoveryHandle tierMetadataRecoveryHandle, long requestServerTimeoutMs) {
        this.tierMetadataRecoveryHandle = tierMetadataRecoveryHandle;
        this.dataLossDetectionRequestServerTimeoutMs = Math.min(requestServerTimeoutMs, MAX_DATA_LOSS_DETECTION_REQUEST_TIMEOUT_MS);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        switch (target) {
            case "/tiertopicconsumer/rewind": {
                log.info("Handling REST request at path: {}", (Object)REWIND_PATH);
                this.handleRewindTierTopicConsumer(request, response);
                break;
            }
            case "/upload/initiate": {
                log.info("Handling REST request at path: {}", (Object)UPLOAD_INITIATE_PATH);
                this.handleInitiateTierRecoveryDataUpload(request, response);
                break;
            }
            case "/upload/result": {
                log.info("Handling REST request at path: {}", (Object)UPLOAD_RESULT_PATH);
                this.handleGetTierRecoveryDataUploadJobResult(request, response);
                break;
            }
            case "/tiertopicdatalossvalidator/detectheaddataloss": {
                log.info("Handling REST request at path: {}", (Object)TIER_TOPIC_HEAD_DATA_LOSS_DETECTION_PATH);
                this.handleDetectHeadDataLossInTierTopic(request, response);
                break;
            }
            default: {
                log.warn("Unable to handle request at unknown path: " + target);
                this.handleUnknownTarget(response);
            }
        }
    }

    private void handleRewindTierTopicConsumer(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            RewindTierTopicConsumerRequest rewindTierTopicConsumerRequest = (RewindTierTopicConsumerRequest)OBJECT_MAPPER.readValue((InputStream)inputStream, RewindTierTopicConsumerRequest.class);
            TierMetadataRecoveryHandler.logRequest(REWIND_PATH, request);
            Optional<Map<Integer, Map<Long, Optional<Integer>>>> partitionToPositionOpt = Optional.ofNullable(rewindTierTopicConsumerRequest.partitionToPosition);
            Map<String, Set<Integer>> skippedPartitions = this.tierMetadataRecoveryHandle.maybeRewindTierTopicConsumer(partitionToPositionOpt, rewindTierTopicConsumerRequest.forceStop, rewindTierTopicConsumerRequest.policy);
            RewindTierTopicConsumerResponse cmdResponse = new RewindTierTopicConsumerResponse(skippedPartitions);
            ResponseContainer.dataResponse(cmdResponse).write(OBJECT_MAPPER, response);
        }
        catch (Exception e) {
            this.handleException(REWIND_PATH, e, response);
        }
    }

    private void handleInitiateTierRecoveryDataUpload(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            InitiateTierRecoveryDataUploadRequest initiateTierRecoveryDataUploadRequest = (InitiateTierRecoveryDataUploadRequest)OBJECT_MAPPER.readValue((InputStream)inputStream, InitiateTierRecoveryDataUploadRequest.class);
            TierMetadataRecoveryHandler.logRequest(UPLOAD_INITIATE_PATH, request);
            UUID jobId = this.tierMetadataRecoveryHandle.maybeInitiateTierRecoveryDataUpload(initiateTierRecoveryDataUploadRequest.topicIdPartitions, initiateTierRecoveryDataUploadRequest.identifier, initiateTierRecoveryDataUploadRequest.numThreads);
            InitiateTierRecoveryDataUploadResponse cmdResponse = new InitiateTierRecoveryDataUploadResponse(jobId);
            ResponseContainer.dataResponse(cmdResponse).write(OBJECT_MAPPER, response);
        }
        catch (Exception e) {
            this.handleException(UPLOAD_INITIATE_PATH, e, response);
        }
    }

    private void handleGetTierRecoveryDataUploadJobResult(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            GetTierRecoveryDataUploadJobResultRequest getTierRecoveryDataUploadJobResultRequest = (GetTierRecoveryDataUploadJobResultRequest)OBJECT_MAPPER.readValue((InputStream)inputStream, GetTierRecoveryDataUploadJobResultRequest.class);
            TierMetadataRecoveryHandler.logRequest(UPLOAD_RESULT_PATH, request);
            TierRecoveryDataUploadResult result = this.tierMetadataRecoveryHandle.maybeGetTierRecoveryDataUploadJobResult(getTierRecoveryDataUploadJobResultRequest.jobId);
            GetTierRecoveryDataUploadJobResultResponse cmdResponse = new GetTierRecoveryDataUploadJobResultResponse(result);
            ResponseContainer.dataResponse(cmdResponse).write(OBJECT_MAPPER, response);
        }
        catch (Exception e) {
            this.handleException(UPLOAD_RESULT_PATH, e, response);
        }
    }

    private void handleDetectHeadDataLossInTierTopic(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            TierTopicHeadDataLossDetectionRequest detectionRequest = (TierTopicHeadDataLossDetectionRequest)OBJECT_MAPPER.readValue((InputStream)inputStream, TierTopicHeadDataLossDetectionRequest.class);
            TierMetadataRecoveryHandler.logRequest(TIER_TOPIC_HEAD_DATA_LOSS_DETECTION_PATH, request);
            TierTopicHeadDataLossDetectionResponse cmdResponse = this.tierMetadataRecoveryHandle.maybeDetectDataLossInTierTopicHead(detectionRequest, this.dataLossDetectionRequestServerTimeoutMs);
            ResponseContainer.dataResponse(cmdResponse).write(OBJECT_MAPPER, response);
        }
        catch (Exception e) {
            this.handleException(TIER_TOPIC_HEAD_DATA_LOSS_DETECTION_PATH, e, response);
        }
    }

    private void handleUnknownTarget(HttpServletResponse response) throws IOException {
        TierMetadataRecoveryHandler.generateErrorResponse(404, "Unknown command", response);
    }

    private void handleException(String path, Exception e, HttpServletResponse response) throws IOException {
        String errorMessage = TierMetadataRecoveryHandler.generateErrorMessage(path, e);
        log.error(errorMessage, (Throwable)e);
        int errorCode = 500;
        if (e instanceof IllegalArgumentException) {
            errorCode = 400;
        }
        TierMetadataRecoveryHandler.generateErrorResponse(errorCode, errorMessage, response);
    }

    private static String generateErrorMessage(String path, Exception e) {
        StringWriter sw = new StringWriter();
        sw.write("Failed REST request at path:");
        sw.write(path);
        sw.write(" due to:\n");
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static void generateErrorResponse(int errorCode, String message, HttpServletResponse response) throws IOException {
        log.error("Sending error message with code: {} to REST client: {}", (Object)errorCode, (Object)message);
        ResponseContainer.ErrorResponse errResponse = new ResponseContainer.ErrorResponse(0, errorCode, message);
        ResponseContainer<?> responseContainer = ResponseContainer.errorResponse(Collections.singletonList(errResponse));
        responseContainer.write(OBJECT_MAPPER, response);
    }

    private static void logRequest(String path, HttpServletRequest request) {
        log.info("At path:{}, received REST request: {}", (Object)path, (Object)request);
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(TopicIdPartition.class, (JsonSerializer)new JsonSerializer<TopicIdPartition>(){

            public void serialize(TopicIdPartition value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString(value.toString());
            }
        });
        module.addDeserializer(TopicIdPartition.class, (JsonDeserializer)new JsonDeserializer<TopicIdPartition>(){

            public TopicIdPartition deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
                return TopicIdPartition.fromString((String)p.getValueAsString());
            }
        });
        module.addKeySerializer(TopicIdPartition.class, (JsonSerializer)new JsonSerializer<TopicIdPartition>(){

            public void serialize(TopicIdPartition value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeFieldName(value.toString());
            }
        });
        module.addKeyDeserializer(TopicIdPartition.class, new KeyDeserializer(){

            public Object deserializeKey(String key, DeserializationContext ctxt) {
                return TopicIdPartition.fromString((String)key);
            }
        });
        module.addSerializer(TopicPartition.class, (JsonSerializer)new JsonSerializer<TopicPartition>(){

            public void serialize(TopicPartition value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString(value.toString());
            }
        });
        module.addDeserializer(TopicPartition.class, (JsonDeserializer)new JsonDeserializer<TopicPartition>(){

            public TopicPartition deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
                return TopicPartition.fromString((String)p.getValueAsString());
            }
        });
        OBJECT_MAPPER.registerModules(new Module[]{module, new Jdk8Module()});
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }
}

