/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicIdPartition;

public class TierRecoveryDataUploadResult {
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="status")
    private final TierRecoveryDataUploadJobStatus status;
    @JsonProperty(value="failed_partitions")
    private final Map<TopicIdPartition, String> failedPartitions;
    @JsonProperty(value="metadata_upload_completed")
    private final boolean metadataUploadCompleted;
    @JsonProperty(value="metadata_upload_failed_exception_message")
    private final String metadataUploadFailedExceptionMessage;
    @JsonProperty(value="tier_offsets_upload_completed")
    private final boolean tierOffsetsUploadCompleted;
    @JsonProperty(value="tier_offsets_upload_failed_exception_message")
    private final String tierOffsetsUploadFailedExceptionMessage;

    public TierRecoveryDataUploadResult(@JsonProperty(value="identifier", required=true) String identifier, @JsonProperty(value="status", required=true) TierRecoveryDataUploadJobStatus status, @JsonProperty(value="failed_partitions") Map<TopicIdPartition, String> failedPartitions, @JsonProperty(value="metadata_upload_completed", required=true) boolean metadataUploadCompleted, @JsonProperty(value="metadata_upload_failed_exception_message") String metadataUploadFailedExceptionMessage, @JsonProperty(value="tier_offsets_upload_completed", required=true) boolean tierOffsetsUploadCompleted, @JsonProperty(value="tier_offsets_upload_failed_exception_message") String tierOffsetsUploadFailedExceptionMessage) {
        this.status = status;
        this.identifier = identifier;
        this.failedPartitions = failedPartitions;
        this.metadataUploadCompleted = metadataUploadCompleted;
        this.metadataUploadFailedExceptionMessage = metadataUploadFailedExceptionMessage;
        this.tierOffsetsUploadCompleted = tierOffsetsUploadCompleted;
        this.tierOffsetsUploadFailedExceptionMessage = tierOffsetsUploadFailedExceptionMessage;
    }

    public TierRecoveryDataUploadJobStatus status() {
        return this.status;
    }

    public String toString() {
        return "TierRecoveryDataUploadResult{identifier=" + this.identifier + ", status=" + (Object)((Object)this.status) + ", failedPartitions= [" + this.failedPartitionsToString() + "], metadataUploadCompleted=" + this.metadataUploadCompleted + ", metadataUploadFailedExceptionMessage=" + this.metadataUploadFailedExceptionMessage + ", tierOffsetsUploadCompleted=" + this.tierOffsetsUploadCompleted + ", tierOffsetsUploadFailedExceptionMessage=" + this.tierOffsetsUploadFailedExceptionMessage + "}";
    }

    private String failedPartitionsToString() {
        return this.failedPartitions.entrySet().stream().map(entry -> String.format("tp=%s -> ex=%s", ((TopicIdPartition)entry.getKey()).toString(), entry.getValue())).collect(Collectors.joining(", "));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TierRecoveryDataUploadResult that = (TierRecoveryDataUploadResult)obj;
        return Objects.equals(this.identifier, that.identifier) && this.status == that.status && Objects.equals(this.failedPartitions, that.failedPartitions) && this.metadataUploadCompleted == that.metadataUploadCompleted && Objects.equals(this.metadataUploadFailedExceptionMessage, that.metadataUploadFailedExceptionMessage) && this.tierOffsetsUploadCompleted == that.tierOffsetsUploadCompleted && Objects.equals(this.tierOffsetsUploadFailedExceptionMessage, that.tierOffsetsUploadFailedExceptionMessage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.status, this.failedPartitions, this.metadataUploadCompleted, this.metadataUploadFailedExceptionMessage, this.tierOffsetsUploadCompleted, this.tierOffsetsUploadFailedExceptionMessage});
    }

    public static enum TierRecoveryDataUploadJobStatus {
        UNKNOWN,
        NOT_RUNNING,
        RUNNING,
        DATA_UPLOAD_COMPLETED,
        COMPLETED;

    }
}

