/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Histogram;
import io.confluent.kafka.replication.push.PushManager;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.Executor;
import kafka.api.PartitionLinkState;
import kafka.availability.BrokerHealthManager;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.ClusterLinkState;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.server.ReplicaManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicLinkState$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public final class Partition$
implements Logging {
    public static final Partition$ MODULE$ = new Partition$();
    private static final KafkaMetricsGroup kafka$cluster$Partition$$metricsGroup = new KafkaMetricsGroup(Partition.class);
    private static final Histogram firstFetchFromLeaderHist = MODULE$.kafka$cluster$Partition$$metricsGroup().newHistogram("FirstFetchFromLeader");
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Option<Executor> $lessinit$greater$default$14() {
        return None$.MODULE$;
    }

    public boolean $lessinit$greater$default$17() {
        return false;
    }

    public Option<BrokerHealthManager> $lessinit$greater$default$18() {
        return None$.MODULE$;
    }

    public Option<PushManager> $lessinit$greater$default$19() {
        return None$.MODULE$;
    }

    public Option<Uuid> $lessinit$greater$default$20() {
        return None$.MODULE$;
    }

    public KafkaMetricsGroup kafka$cluster$Partition$$metricsGroup() {
        return kafka$cluster$Partition$$metricsGroup;
    }

    public Partition apply(TopicIdPartition topicIdPartition, Time time, ReplicaManager replicaManager, Option<OffsetAndEpoch> metadataOffsetAndEpoch) {
        return this.apply(topicIdPartition.topicPartition(), (Option<Uuid>)Option$.MODULE$.apply((Object)topicIdPartition.topicId()), time, replicaManager, metadataOffsetAndEpoch);
    }

    public Partition apply(TopicPartition topicPartition, Option<Uuid> topicId, Time time, ReplicaManager replicaManager, Option<OffsetAndEpoch> metadataOffsetAndEpoch) {
        AlterPartitionListener alterPartitionListener = new AlterPartitionListener(replicaManager){
            private final ReplicaManager replicaManager$1;

            public void markIsrExpand() {
                this.replicaManager$1.isrExpandRate().mark();
            }

            public void markIsrShrink() {
                this.replicaManager$1.isrShrinkRate().mark();
            }

            public void markFailed() {
                this.replicaManager$1.failedIsrUpdatesRate().mark();
            }

            public void markFollowerStateUpdated(Partition partition) {
                this.replicaManager$1.clusterLinkManager().foreach((Function1 & Serializable)manager -> {
                    anon.1.$anonfun$markFollowerStateUpdated$1(partition, manager);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$markFollowerStateUpdated$1(Partition partition$1, ClusterLinkFactory.LinkManager manager) {
                manager.maybeNotifyReadyForFetch(partition$1);
            }
            {
                this.replicaManager$1 = replicaManager$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$markFollowerStateUpdated$1$adapted(kafka.cluster.Partition kafka.server.link.ClusterLinkFactory$LinkManager )}, serializedLambda);
            }
        };
        DelayedOperations delayedOperations = new DelayedOperations(topicPartition, replicaManager.delayedProducePurgatory(), replicaManager.delayedFetchPurgatory(), replicaManager.delayedDeleteRecordsPurgatory());
        return new Partition(topicPartition, Predef$.MODULE$.Long2long(replicaManager.config().replicaLagTimeMaxMs()), replicaManager.config().interBrokerProtocolVersion(), replicaManager.config().interBrokerListenerName(), replicaManager.config().brokerId(), replicaManager.brokerEpochSupplier(), time, alterPartitionListener, delayedOperations, replicaManager.metadataCache(), replicaManager.logManager(), replicaManager.tierReplicaComponents().replicaManagerOpt(), replicaManager.tierReplicaComponents().stateFetcherOpt(), (Option<Executor>)new Some((Object)replicaManager.executor()), replicaManager.alterPartitionManager(), metadataOffsetAndEpoch, replicaManager.deferIsrShrinkEnable(), replicaManager.brokerHealthManager(), replicaManager.pushReplicationManager(), topicId);
    }

    public void removeMetrics(TopicPartition topicPartition) {
        java.util.Map tags = CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)topicPartition.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)Integer.toString(topicPartition.partition()))}))).asJava();
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("UnderReplicated", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("UnderMinIsr", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("InSyncReplicasCount", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("ReplicasCount", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("LastStableOffsetLag", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("AtMinIsr", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("CaughtUpReplicasCount", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("DeferredUnderMinIsr", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("IsNotCaughtUp", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("ObserverReplicasCount", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("ObserversInIsrCount", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("MirrorReplicasCount", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("UnderReplicatedMirror", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("UnderMinIsrMirror", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("AtMinIsrMirror", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("BlockedOnMirrorSource", tags);
    }

    public Option<ClusterLinkState> clusterLinkState(LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState) {
        return Option$.MODULE$.apply((Object)partitionState.clusterLinkId()).map((Function1 & Serializable)id -> CoreUtils$.MODULE$.toKafkaUuidFromJavaUUIDString((String)id)).flatMap((Function1 & Serializable)linkId -> Option$.MODULE$.apply((Object)partitionState.clusterLinkTopicState()).map((Function1 & Serializable)state -> {
            TopicLinkState topicState;
            TopicLinkState topicLinkState;
            try {
                topicLinkState = TopicLinkState$.MODULE$.fromString((String)state);
            }
            catch (IllegalArgumentException e) {
                Partition$ error_this = MODULE$;
                if (error_this.logger().underlying().isErrorEnabled()) {
                    String msgWithLogIdent_msg = Partition$.$anonfun$clusterLinkState$4(state);
                    Object var10_5 = null;
                    error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg), (Throwable)e);
                }
                Object var9_4 = null;
                topicLinkState = TopicLinkFailedMirror$.MODULE$;
            }
            TopicLinkState topicLinkState2 = topicState = topicLinkState;
            TopicLinkFailedMirror$ topicLinkFailedMirror$ = TopicLinkFailedMirror$.MODULE$;
            boolean failed = topicLinkState2 != null && topicLinkState2.equals(topicLinkFailedMirror$);
            MirrorTopicError mirrorTopicError = MirrorTopicError.forCode((short)partitionState.mirrorTopicError(), (boolean)failed);
            PartitionLinkState linkedPartitionState = new PartitionLinkState(partitionState.linkedLeaderEpoch(), failed, mirrorTopicError);
            return new ClusterLinkState((Uuid)linkId, topicState, linkedPartitionState);
        }));
    }

    public boolean isActiveLinkDestination(LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState) {
        return this.clusterLinkState(partitionState).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isActiveLinkDestination()));
    }

    public Histogram firstFetchFromLeaderHist() {
        return firstFetchFromLeaderHist;
    }

    public static final /* synthetic */ String $anonfun$clusterLinkState$4(String state$1) {
        return new StringBuilder(46).append("Unknown cluster link state ").append(state$1).append(", disable mirroring").toString();
    }

    public static final /* synthetic */ IllegalArgumentException $anonfun$clusterLinkState$5(IllegalArgumentException e$1) {
        return e$1;
    }

    private Partition$() {
    }
}

