/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.QuotaValue$;
import kafka.internals.generated.ComputedQuotaKey;
import kafka.internals.generated.ComputedQuotaValue;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.Record;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class QuotaStateManager$ {
    public static final QuotaStateManager$ MODULE$ = new QuotaStateManager$();
    private static final String MetricsGroup = "quota-coordinator-metrics";
    private static final String LoadTimeSensor = "QuotaPartitionLoadTime";
    private static final String LoadFailureSensor = "QuotaPartitionLoadFailure";
    private static final int DefaultMinElasticCKULimit = 1;
    private static final int DefaultMaxElasticCKULimit = 5;

    public String MetricsGroup() {
        return MetricsGroup;
    }

    public String LoadTimeSensor() {
        return LoadTimeSensor;
    }

    public String LoadFailureSensor() {
        return LoadFailureSensor;
    }

    public int DefaultMinElasticCKULimit() {
        return DefaultMinElasticCKULimit;
    }

    public int DefaultMaxElasticCKULimit() {
        return DefaultMaxElasticCKULimit;
    }

    public QuotaEntity readMessageKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        if (version >= 0 && version <= 0) {
            ComputedQuotaKey key = new ComputedQuotaKey((Readable)new ByteBufferAccessor(buffer), version);
            return new QuotaEntity((Map<String, String>)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(key.quotaEntity()).asScala().map((Function1 & Serializable)entityData -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entityData.entityType()), (Object)entityData.entityName()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
        throw new IllegalStateException(new StringBuilder(31).append("Unknown quota message version: ").append(version).toString());
    }

    public Option<QuotaEntry> readMessageValue(QuotaEntity quotaEntity, ByteBuffer buffer) {
        if (buffer == null) {
            return None$.MODULE$;
        }
        short version = buffer.getShort();
        if (version >= 0 && version <= 0) {
            ComputedQuotaValue value = new ComputedQuotaValue((Readable)new ByteBufferAccessor(buffer), version);
            QuotaEntry quotaEntry = new QuotaEntry(quotaEntity, value.lastUpdatedTimestamp());
            CollectionConverters$.MODULE$.ListHasAsScala(value.computedBrokerQuotas()).asScala().foreach((Function1 & Serializable)computedBrokerQuota -> {
                QuotaStateManager$.$anonfun$readMessageValue$1(quotaEntry, computedBrokerQuota);
                return BoxedUnit.UNIT;
            });
            return new Some((Object)quotaEntry);
        }
        throw new UnsupportedVersionException(new StringBuilder(31).append("Unknown quota message version: ").append(version).toString());
    }

    public byte[] quotaEntryKey(QuotaEntity quotaEntity) {
        return MessageUtil.toVersionPrefixedBytes((short)0, (Message)new ComputedQuotaKey().setQuotaEntity(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)quotaEntity.entityTypes().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String entityType = (String)x0$1._1();
                String entityName = (String)x0$1._2();
                if (entityType != null && entityName != null) {
                    return new ComputedQuotaKey.EntityData().setEntityType(entityType).setEntityName(entityName);
                }
            }
            throw new MatchError(x0$1);
        })).toList()).asJava()));
    }

    public byte[] quotaEntryValue(QuotaEntry quotaEntry) {
        return MessageUtil.toVersionPrefixedBytes((short)0, (Message)new ComputedQuotaValue().setComputedBrokerQuotas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)quotaEntry.computedQuotas().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int brokerId = x0$1._1$mcI$sp();
                scala.collection.mutable.Map computedQuotas = (scala.collection.mutable.Map)x0$1._2();
                return new ComputedQuotaValue.ComputedBrokerQuota().setBrokerId(brokerId).setComputedQuotas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)computedQuotas.map((Function1 & Serializable)computedQuota -> new ComputedQuotaValue.ComputedQuota().setQuotaType((String)computedQuota._1()).setQuota(((QuotaValue)computedQuota._2()).quota()).setUsage(((QuotaValue)computedQuota._2()).usage()).setThrottled(((QuotaValue)computedQuota._2()).throttled()).setLastUsageReportTimestamp(((QuotaValue)computedQuota._2()).lastUsageReportTimestamp()))).toList()).asJava());
            }
            throw new MatchError(null);
        })).toList()).asJava()).setLastUpdatedTimestamp(quotaEntry.lastUpdatedTimestamp()));
    }

    public Tuple2<Option<String>, Option<String>> formatRecordKeyAndValue(Record record) {
        String string;
        QuotaEntity quotaEntity = this.readMessageKey(record.key());
        String keyString = new StringBuilder(26).append("quota_entity::entityTypes=").append(quotaEntity.entityTypes()).toString();
        Option<QuotaEntry> option = this.readMessageValue(quotaEntity, record.value());
        if (None$.MODULE$.equals(option)) {
            string = "<DELETE>";
        } else if (option instanceof Some) {
            QuotaEntry quotaEntry = (QuotaEntry)((Some)option).value();
            string = new StringBuilder(37).append("computedQuotas:").append(quotaEntry.computedQuotasString()).append(",").append("lastUpdatedTimestamp:").append(quotaEntry.lastUpdatedTimestamp()).toString();
        } else {
            throw new MatchError(option);
        }
        String valueString = string;
        return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
    }

    public static final /* synthetic */ void $anonfun$readMessageValue$1(QuotaEntry quotaEntry$1, ComputedQuotaValue.ComputedBrokerQuota computedBrokerQuota) {
        CollectionConverters$.MODULE$.ListHasAsScala(computedBrokerQuota.computedQuotas()).asScala().foreach((Function1 & Serializable)computedQuota -> {
            quotaEntry$1.putQuotaValue(computedBrokerQuota.brokerId(), computedQuota.quotaType(), QuotaValue$.MODULE$.loadValue(computedQuota.usage(), computedQuota.throttled(), computedQuota.quota(), computedQuota.lastUsageReportTimestamp()));
            return BoxedUnit.UNIT;
        });
    }

    private QuotaStateManager$() {
    }
}

