/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.ProducerIdManager$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.ProducerIdsBlock;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001B\u000b\u0017\u0001uA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011\u0015i\u0005\u0001\"\u0001O\u0011!!\u0006\u00011A\u0005\u0002Y)\u0006\u0002C4\u0001\u0001\u0004%\tA\u00065\t\r9\u0004\u0001\u0015)\u0003W\u0011!y\u0007A1A\u0005\u0002Y)\u0006B\u00029\u0001A\u0003%a\u000bC\u0004r\u0001\t\u0007I\u0011\u0002:\t\rY\u0004\u0001\u0015!\u0003t\u0011\u001d9\bA1A\u0005\naDa\u0001 \u0001!\u0002\u0013I\b\"B?\u0001\t\u0003r\bbBA\u0003\u0001\u0011\u0005\u0013q\u0001\u0005\t\u0003'\u0001A\u0011\u0001\f\u0002\u0016!A\u0011q\u0003\u0001\u0005\u0002Y\t)\u0002\u0003\u0005\u0002\u001a\u0001!\tAFA\u000e\u0011\u001d\ti\u0003\u0001C\u0005\u0003+\u0011AC\u0015)D!J|G-^2fe&#W*\u00198bO\u0016\u0014(BA\f\u0019\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005eQ\u0012aC2p_J$\u0017N\\1u_JT\u0011aG\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001a\u0004\n\u0015\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g!\t)c%D\u0001\u0017\u0013\t9cCA\tQe>$WoY3s\u0013\u0012l\u0015M\\1hKJ\u0004\"!\u000b\u0017\u000e\u0003)R!a\u000b\u000e\u0002\u000bU$\u0018\u000e\\:\n\u00055R#a\u0002'pO\u001eLgnZ\u0001\tEJ|7.\u001a:JIB\u0011q\u0004M\u0005\u0003c\u0001\u00121!\u00138u\u0003\u0011!\u0018.\\3\u0011\u0005QjT\"A\u001b\u000b\u0005-2$BA\u001c9\u0003\u0019\u0019w.\\7p]*\u00111$\u000f\u0006\u0003um\na!\u00199bG\",'\"\u0001\u001f\u0002\u0007=\u0014x-\u0003\u0002?k\t!A+[7f\u0003M\u0011'o\\6fe\u0016\u0003xn\u00195TkB\u0004H.[3s!\ry\u0012iQ\u0005\u0003\u0005\u0002\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005}!\u0015BA#!\u0005\u0011auN\\4\u0002#\r|g\u000e\u001e:pY2,'o\u00115b]:,G\u000e\u0005\u0002I\u00176\t\u0011J\u0003\u0002Kq\u000511/\u001a:wKJL!\u0001T%\u0003=9{G-\u001a+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0003P!F\u00136\u000b\u0005\u0002&\u0001!)a&\u0002a\u0001_!)!'\u0002a\u0001g!)q(\u0002a\u0001\u0001\")a)\u0002a\u0001\u000f\u0006\u0019b.\u001a=u!J|G-^2fe&#'\t\\8dWV\ta\u000bE\u0002XA\nl\u0011\u0001\u0017\u0006\u00033j\u000ba!\u0019;p[&\u001c'BA.]\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003;z\u000bA!\u001e;jY*\tq,\u0001\u0003kCZ\f\u0017BA1Y\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007CA2f\u001b\u0005!'BA\u001cJ\u0013\t1GM\u0001\tQe>$WoY3s\u0013\u0012\u001c(\t\\8dW\u00069b.\u001a=u!J|G-^2fe&#'\t\\8dW~#S-\u001d\u000b\u0003S2\u0004\"a\b6\n\u0005-\u0004#\u0001B+oSRDq!\\\u0004\u0002\u0002\u0003\u0007a+A\u0002yIE\nAC\\3yiB\u0013x\u000eZ;dKJLEM\u00117pG.\u0004\u0013AF2veJ,g\u000e\u001e)s_\u0012,8-\u001a:JI\ncwnY6\u0002/\r,(O]3oiB\u0013x\u000eZ;dKJLEM\u00117pG.\u0004\u0013a\u0004:fcV,7\u000f^%o\r2Lw\r\u001b;\u0016\u0003M\u0004\"a\u0016;\n\u0005UD&!D!u_6L7MQ8pY\u0016\fg.\u0001\tsKF,Xm\u001d;J]\u001ac\u0017n\u001a5uA\u0005\t\"-Y2l_\u001a4G)Z1eY&tW-T:\u0016\u0003e\u0004\"a\u0016>\n\u0005mD&AC!u_6L7\rT8oO\u0006\u0011\"-Y2l_\u001a4G)Z1eY&tW-T:!\u00035A\u0017m\u001d,bY&$'\t\\8dWV\tq\u0010E\u0002 \u0003\u0003I1!a\u0001!\u0005\u001d\u0011un\u001c7fC:\f!cZ3oKJ\fG/\u001a)s_\u0012,8-\u001a:JIR\u0011\u0011\u0011\u0002\t\u0006\u0003\u0017\tyaQ\u0007\u0003\u0003\u001bQ!!\u0018\u0011\n\t\u0005E\u0011Q\u0002\u0002\u0004)JL\u0018!F7bs\n,'+Z9vKN$h*\u001a=u\u00052|7m\u001b\u000b\u0002S\u0006Y1/\u001a8e%\u0016\fX/Z:u\u0003\u0005B\u0017M\u001c3mK\u0006cGn\\2bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\nZ:SKN\u0004xN\\:f)\rI\u0017Q\u0004\u0005\b\u0003?\u0019\u0002\u0019AA\u0011\u0003!\u0011Xm\u001d9p]N,\u0007\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001db'\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\tY#!\n\u00037\u0005cGn\\2bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\nZ:SKN\u0004xN\\:f\u00035A\u0017M\u001c3mKRKW.Z8vi\u0002")
public class RPCProducerIdManager
implements ProducerIdManager,
Logging {
    private final int brokerId;
    private final Time time;
    private final Function0<Object> brokerEpochSupplier;
    private final NodeToControllerChannelManager controllerChannel;
    private AtomicReference<ProducerIdsBlock> nextProducerIdBlock;
    private final AtomicReference<ProducerIdsBlock> currentProducerIdBlock;
    private final AtomicBoolean requestInFlight;
    private final AtomicLong backoffDeadlineMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void shutdown() {
        ProducerIdManager.shutdown$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AtomicReference<ProducerIdsBlock> nextProducerIdBlock() {
        return this.nextProducerIdBlock;
    }

    public void nextProducerIdBlock_$eq(AtomicReference<ProducerIdsBlock> x$1) {
        this.nextProducerIdBlock = x$1;
    }

    public AtomicReference<ProducerIdsBlock> currentProducerIdBlock() {
        return this.currentProducerIdBlock;
    }

    private AtomicBoolean requestInFlight() {
        return this.requestInFlight;
    }

    private AtomicLong backoffDeadlineMs() {
        return this.backoffDeadlineMs;
    }

    @Override
    public boolean hasValidBlock() {
        return this.nextProducerIdBlock().get() != null;
    }

    @Override
    public Try<Object> generateProducerId() {
        Failure result = null;
        int iteration = 0;
        while (result == null) {
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.currentProducerIdBlock().get().claimNextId()));
            if (None$.MODULE$.equals(option)) {
                ProducerIdsBlock block = this.nextProducerIdBlock().getAndSet(null);
                if (block == null) {
                    this.maybeRequestNextBlock();
                    result = new Failure((Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception("Producer ID block is full. Waiting for next block"));
                } else {
                    this.currentProducerIdBlock().set(block);
                    this.requestInFlight().set(false);
                    ++iteration;
                }
            } else if (option instanceof Some) {
                long prefetchTarget;
                Long nextProducerId = (Long)((Some)option).value();
                if (BoxesRunTime.equalsNumObject((Number)nextProducerId, (Object)BoxesRunTime.boxToLong((long)(prefetchTarget = this.currentProducerIdBlock().get().firstProducerId() + (long)((double)this.currentProducerIdBlock().get().size() * ProducerIdManager$.MODULE$.PidPrefetchThreshold()))))) {
                    this.maybeRequestNextBlock();
                }
                result = new Success((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(nextProducerId)));
            } else {
                throw new MatchError((Object)option);
            }
            if (iteration != ProducerIdManager$.MODULE$.IterationLimit()) continue;
            result = new Failure((Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception("Producer ID block is full. Waiting for next block"));
        }
        return result;
    }

    public void maybeRequestNextBlock() {
        long retryTimestamp = this.backoffDeadlineMs().get();
        if (retryTimestamp == ProducerIdManager$.MODULE$.NoRetry() || this.time.milliseconds() >= retryTimestamp) {
            if (this.nextProducerIdBlock().get() == null && this.requestInFlight().compareAndSet(false, true)) {
                this.sendRequest();
                this.backoffDeadlineMs().set(ProducerIdManager$.MODULE$.NoRetry());
                return;
            }
            return;
        }
    }

    public void sendRequest() {
        AllocateProducerIdsRequestData message = new AllocateProducerIdsRequestData().setBrokerEpoch(this.brokerEpochSupplier.apply$mcJ$sp()).setBrokerId(this.brokerId);
        AllocateProducerIdsRequest.Builder request = new AllocateProducerIdsRequest.Builder(message);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Requesting next Producer ID block");
        this.controllerChannel.sendRequest((AbstractRequest.Builder)request, new ControllerRequestCompletionHandler(this){
            private final /* synthetic */ RPCProducerIdManager $outer;

            public void onComplete(ClientResponse response) {
                AllocateProducerIdsResponse message = (AllocateProducerIdsResponse)response.responseBody();
                this.$outer.handleAllocateProducerIdsResponse(message);
            }

            public void onTimeout() {
                this.$outer.kafka$coordinator$transaction$RPCProducerIdManager$$handleTimeout();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void handleAllocateProducerIdsResponse(AllocateProducerIdsResponse response) {
        AllocateProducerIdsResponseData data = response.data();
        boolean successfulResponse = false;
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.NONE.equals(errors)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Got next producer ID block from controller ").append(data).toString());
            if (data.producerIdStart() < this.currentProducerIdBlock().get().lastProducerId()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("Producer ID block is not monotonic with current block: current=").append(this.currentProducerIdBlock()).append(" response=").append(data).toString());
            } else if (data.producerIdStart() < 0L || data.producerIdLen() < 0 || data.producerIdStart() > Long.MAX_VALUE - (long)data.producerIdLen()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Producer ID block includes invalid ID range: ").append(data).toString());
            } else {
                this.nextProducerIdBlock().set(new ProducerIdsBlock(this.brokerId, data.producerIdStart(), data.producerIdLen()));
                successfulResponse = true;
            }
        } else if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Our broker currentBlockCount was stale, trying again.");
        } else if (Errors.BROKER_ID_NOT_REGISTERED.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Our broker ID is not yet known by the controller, trying again.");
        } else if (errors != null) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Received an unexpected error code from the controller: ").append(errors).toString());
        } else {
            throw new MatchError(null);
        }
        if (!successfulResponse) {
            this.backoffDeadlineMs().set(this.time.milliseconds() + (long)ProducerIdManager$.MODULE$.RetryBackoffMs());
            this.requestInFlight().set(false);
            return;
        }
    }

    public void kafka$coordinator$transaction$RPCProducerIdManager$$handleTimeout() {
        this.warn((Function0<String>)(Function0 & Serializable)() -> "Timed out when requesting AllocateProducerIds from the controller.");
        this.requestInFlight().set(false);
    }

    public RPCProducerIdManager(int brokerId, Time time, Function0<Object> brokerEpochSupplier, NodeToControllerChannelManager controllerChannel) {
        this.brokerId = brokerId;
        this.time = time;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.controllerChannel = controllerChannel;
        this.logIdent_$eq(new StringBuilder(27).append("[RPC ProducerId Manager ").append(brokerId).append("]: ").toString());
        this.nextProducerIdBlock = new AtomicReference<Object>(null);
        this.currentProducerIdBlock = new AtomicReference<ProducerIdsBlock>(ProducerIdsBlock.EMPTY);
        this.requestInFlight = new AtomicBoolean(false);
        this.backoffDeadlineMs = new AtomicLong(ProducerIdManager$.MODULE$.NoRetry());
    }
}

