/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit.manager;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.job.AbstractAuditJob;
import kafka.durability.audit.request.AuditManagerRequest;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.DurabilityDB$;
import kafka.durability.materialization.AbstractDurabilityEventsMaterialize;
import kafka.durability.topic.DurabilityTopicConfig;
import kafka.durability.topic.DurabilityTopicManager;
import kafka.server.InternalAdmin;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.Enumeration;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t\re!B\u001d;\u0003\u0003\u0019\u0005\u0002C,\u0001\u0005\u000b\u0007I\u0011\u0001-\t\u0011u\u0003!\u0011!Q\u0001\neC\u0001B\u0018\u0001\u0003\u0006\u0004%\ta\u0018\u0005\tO\u0002\u0011\t\u0011)A\u0005A\")\u0001\u000e\u0001C\u0001S\"9a\u000e\u0001b\u0001\n\u0013y\u0007BB<\u0001A\u0003%\u0001\u000fC\u0005y\u0001\u0001\u0007\t\u0019!C\u0001s\"IQ\u0010\u0001a\u0001\u0002\u0004%\tA \u0005\u000b\u0003\u001f\u0001\u0001\u0019!A!B\u0013Q\b\"CA\t\u0001\u0001\u0007I\u0011AA\n\u0011%\tY\u0002\u0001a\u0001\n\u0003\ti\u0002\u0003\u0005\u0002\"\u0001\u0001\u000b\u0015BA\u000b\u0011%\t\u0019\u0003\u0001a\u0001\n\u0003\t)\u0003C\u0005\u00026\u0001\u0001\r\u0011\"\u0001\u00028!A\u00111\b\u0001!B\u0013\t9\u0003C\u0005\u0002>\u0001\u0011\r\u0011\"\u0001\u0002@!A\u00111\u000b\u0001!\u0002\u0013\t\t\u0005C\u0005\u0002V\u0001\u0001\r\u0011\"\u0003\u0002X!I\u0011q\f\u0001A\u0002\u0013%\u0011\u0011\r\u0005\t\u0003K\u0002\u0001\u0015)\u0003\u0002Z!I\u0011q\u000e\u0001C\u0002\u0013E\u0011\u0011\u000f\u0005\t\u0003w\u0002\u0001\u0015!\u0003\u0002t!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004\"CAD\u0001\t\u0007I\u0011AA@\u0011!\ti\t\u0001Q\u0001\n\u0005\u0005\u0005\"CAH\u0001\t\u0007I\u0011AAI\u0011!\tY\n\u0001Q\u0001\n\u0005M\u0005\"CAO\u0001\t\u0007I\u0011AAP\u0011!\t9\u000b\u0001Q\u0001\n\u0005\u0005\u0006\"CAU\u0001\t\u0007i\u0011AAV\u0011)\tI\f\u0001b\u0001\n\u0003a\u00141\u0018\u0005\t\u0003\u0013\u0004\u0001\u0015!\u0003\u0002>\"I\u00111\u001a\u0001C\u0002\u0013\u0005A\b\u0017\u0005\b\u0003\u001b\u0004\u0001\u0015!\u0003Z\u0011%\ty\r\u0001a\u0001\n\u0003\t\t\u000eC\u0005\u0002~\u0002\u0001\r\u0011\"\u0001\u0002\u0000\"A!1\u0001\u0001!B\u0013\t\u0019\u000eC\u0005\u0003\u0006\u0001\u0001\r\u0011\"\u0001\u0003\b!I!\u0011\u0004\u0001A\u0002\u0013\u0005!1\u0004\u0005\t\u0005?\u0001\u0001\u0015)\u0003\u0003\n!I!\u0011\u0005\u0001A\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0005G\u0001\u0001\u0019!C\u0001\u0005KA\u0001B!\u000b\u0001A\u0003&\u0011\u0011\f\u0005\b\u0005W\u0001A\u0011\u0001B\u0017\u0011)\u0011)\u0004\u0001b\u0001\u000e\u0003a$Q\u0006\u0005\b\u0005o\u0001A\u0011\tB\u001d\u0011\u001d\u0011Y\u0004\u0001D\u0001\u0005sA\u0001B!\u0010\u0001\r\u0003a$q\b\u0005\t\u0005\u001b\u0002a\u0011\u0001\u001f\u0003P!Q!1\f\u0001\u0012\u0002\u0013\u0005AH!\u0018\t\u0011\tM\u0004\u0001\"\u0001=\u0005\u007fAqA!\u001e\u0001\t\u0013\u00119\b\u0003\u0005\u0003|\u0001!\t\u0001\u0010B?\u0011!\u0011y\b\u0001C\u0001y\te\u0002\u0002\u0003BA\u0001\u0011\u0005AH! \u0003)\u0005\u00137\u000f\u001e:bGR\fU\u000fZ5u\u001b\u0006t\u0017mZ3s\u0015\tYD(A\u0004nC:\fw-\u001a:\u000b\u0005ur\u0014!B1vI&$(BA A\u0003)!WO]1cS2LG/\u001f\u0006\u0002\u0003\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001E#B\u0011QiT\u0007\u0002\r*\u0011q\tS\u0001\u0005kRLGN\u0003\u0002J\u0015\u000611/\u001a:wKJT!!Q&\u000b\u00051k\u0015AB1qC\u000eDWMC\u0001O\u0003\ry'oZ\u0005\u0003!\u001a\u0013!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bIB\u0011!+V\u0007\u0002'*\u0011A\u000bQ\u0001\u0006kRLGn]\u0005\u0003-N\u0013q\u0001T8hO&tw-\u0001\u0004d_:4\u0017nZ\u000b\u00023B\u0011!lW\u0007\u0002y%\u0011A\f\u0010\u0002\u0016\tV\u0014\u0018MY5mSRL\u0018)\u001e3ji\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\nA\u0001^5nKV\t\u0001\r\u0005\u0002bK6\t!M\u0003\u0002UG*\u0011AMS\u0001\u0007G>lWn\u001c8\n\u0005\u0019\u0014'\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\na\u0001P5oSRtDc\u00016m[B\u00111\u000eA\u0007\u0002u!)q+\u0002a\u00013\")a,\u0002a\u0001A\u0006a1\u000f^1si&s7\u000f^1oiV\t\u0001\u000f\u0005\u0002rk6\t!O\u0003\u0002_g*\tA/\u0001\u0003kCZ\f\u0017B\u0001<s\u0005\u001dIen\u001d;b]R\fQb\u001d;beRLen\u001d;b]R\u0004\u0013AD1vI&$(j\u001c2UQJ,\u0017\rZ\u000b\u0002uB\u0011\u0011m_\u0005\u0003y\n\u00141bS1gW\u0006$\u0006N]3bI\u0006\u0011\u0012-\u001e3ji*{'\r\u00165sK\u0006$w\fJ3r)\ry\u00181\u0002\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0011\u0011QA\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003\u0013\t\u0019A\u0001\u0003V]&$\b\u0002CA\u0007\u0013\u0005\u0005\t\u0019\u0001>\u0002\u0007a$\u0013'A\bbk\u0012LGOS8c)\"\u0014X-\u00193!\u00031\u0019WO\u001d:f]RTuNY%e+\t\t)\u0002\u0005\u0003\u0002\u0002\u0005]\u0011\u0002BA\r\u0003\u0007\u00111!\u00138u\u0003A\u0019WO\u001d:f]RTuNY%e?\u0012*\u0017\u000fF\u0002\u0000\u0003?A\u0011\"!\u0004\r\u0003\u0003\u0005\r!!\u0006\u0002\u001b\r,(O]3oi*{'-\u00133!\u0003Y\tW\u000fZ5u\u0015>\u00147i\\;oi\u0012|wO\u001c'bi\u000eDWCAA\u0014!\u0011\tI#!\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\t!bY8oGV\u0014(/\u001a8u\u0015\t95/\u0003\u0003\u00024\u0005-\"AD\"pk:$Hi\\<o\u0019\u0006$8\r[\u0001\u001bCV$\u0017\u000e\u001e&pE\u000e{WO\u001c;e_^tG*\u0019;dQ~#S-\u001d\u000b\u0004\u007f\u0006e\u0002\"CA\u0007\u001f\u0005\u0005\t\u0019AA\u0014\u0003]\tW\u000fZ5u\u0015>\u00147i\\;oi\u0012|wO\u001c'bi\u000eD\u0007%\u0001\nbk\u0012LGOU3rk\u0016\u001cHo])vKV,WCAA!!\u0019\tI#a\u0011\u0002H%!\u0011QIA\u0016\u0005Ma\u0015N\\6fI\ncwnY6j]\u001e\fV/Z;f!\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'y\u00059!/Z9vKN$\u0018\u0002BA)\u0003\u0017\u00121#Q;eSRl\u0015M\\1hKJ\u0014V-];fgR\f1#Y;eSR\u0014V-];fgR\u001c\u0018+^3vK\u0002\n1\u0003\\1ti\"+\u0017\r\u001c;i\u0007\",7m\u001b+j[\u0016,\"!!\u0017\u0011\t\u0005\u0005\u00111L\u0005\u0005\u0003;\n\u0019A\u0001\u0003M_:<\u0017a\u00067bgRDU-\u00197uQ\u000eCWmY6US6,w\fJ3r)\ry\u00181\r\u0005\n\u0003\u001b!\u0012\u0011!a\u0001\u00033\nA\u0003\\1ti\"+\u0017\r\u001c;i\u0007\",7m\u001b+j[\u0016\u0004\u0003fA\u000b\u0002jA!\u0011\u0011AA6\u0013\u0011\ti'a\u0001\u0003\u0011Y|G.\u0019;jY\u0016\fA\u0003[3bYRD7\t[3dWB\u000b'\u000f^5uS>tWCAA:!\u0011\t)(a\u001e\u000e\u0003\rL1!!\u001fd\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.A\u000biK\u0006dG\u000f[\"iK\u000e\\\u0007+\u0019:uSRLwN\u001c\u0011\u0002\u000b\u001d,G\u000f\u0012\"\u0016\u0005\u0005\u0005\u0005\u0003BAB\u0003\u0013k!!!\"\u000b\u0007\u0005\u001de(\u0001\u0002eE&!\u00111RAC\u00051!UO]1cS2LG/\u001f#C\u0003\r!'\rI\u0001\u000f[\u0016$(/[2t\u001b\u0006t\u0017mZ3s+\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006]U\"\u0001 \n\u0007\u0005eeH\u0001\rEkJ\f'-\u001b7jiflU\r\u001e:jGNl\u0015M\\1hKJ\fq\"\\3ue&\u001c7/T1oC\u001e,'\u000fI\u0001\te\u0016\u0004xN\u001d;feV\u0011\u0011\u0011\u0015\t\u00045\u0006\r\u0016bAASy\ti\u0011)\u001e3jiJ+\u0007o\u001c:uKJ\f\u0011B]3q_J$XM\u001d\u0011\u0002\u00175\fG/\u001a:jC2L'0Z\u000b\u0003\u0003[\u0003B!a,\u000266\u0011\u0011\u0011\u0017\u0006\u0004\u0003gs\u0014aD7bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\n\t\u0005]\u0016\u0011\u0017\u0002$\u0003\n\u001cHO]1di\u0012+(/\u00192jY&$\u00180\u0012<f]R\u001cX*\u0019;fe&\fG.\u001b>f\u0003-!x\u000e]5d\u0007>tg-[4\u0016\u0005\u0005u\u0006\u0003BA`\u0003\u000bl!!!1\u000b\u0007\u0005\rg(A\u0003u_BL7-\u0003\u0003\u0002H\u0006\u0005'!\u0006#ve\u0006\u0014\u0017\u000e\\5usR{\u0007/[2D_:4\u0017nZ\u0001\ri>\u0004\u0018nY\"p]\u001aLw\rI\u0001\fCV$\u0017\u000e^\"p]\u001aLw-\u0001\u0007bk\u0012LGoQ8oM&<\u0007%A\u0006bk\u0012LG/\u0012<f]R\u001cXCAAj!\u0019\t).a9\u0002j:!\u0011q[Ap!\u0011\tI.a\u0001\u000e\u0005\u0005m'bAAo\u0005\u00061AH]8pizJA!!9\u0002\u0004\u00051\u0001K]3eK\u001aLA!!:\u0002h\n\u00191+\u001a;\u000b\t\u0005\u0005\u00181\u0001\t\u0005\u0003W\f9P\u0004\u0003\u0002n\u0006MXBAAx\u0015\r\t\tPP\u0001\u0007KZ,g\u000e^:\n\t\u0005U\u0018q^\u0001\u0014\tV\u0014\u0018MY5mSRLXI^3oiRK\b/Z\u0005\u0005\u0003s\fYPA\nEkJ\f'-\u001b7jif,e/\u001a8u)f\u0004XM\u0003\u0003\u0002v\u0006=\u0018aD1vI&$XI^3oiN|F%Z9\u0015\u0007}\u0014\t\u0001C\u0005\u0002\u000e\u0015\n\t\u00111\u0001\u0002T\u0006a\u0011-\u001e3ji\u00163XM\u001c;tA\u0005Y\u0011-\u001e3ji\u000eCWmY6t+\t\u0011I\u0001\u0005\u0004\u0002V\u0006\r(1\u0002\t\u0005\u0005\u001b\u0011\u0019BD\u0002l\u0005\u001fI1A!\u0005;\u0003Q!UO]1cS2LG/_!vI&$8\t[3dW&!!Q\u0003B\f\u0005Q!UO]1cS2LG/_!vI&$8\t[3dW*\u0019!\u0011\u0003\u001e\u0002\u001f\u0005,H-\u001b;DQ\u0016\u001c7n]0%KF$2a B\u000f\u0011%\ti\u0001KA\u0001\u0002\u0004\u0011I!\u0001\u0007bk\u0012LGo\u00115fG.\u001c\b%\u0001\fj_J+\u0017/^3ti\nKH/\u001a)feN+7m\u001c8e\u0003iIwNU3rk\u0016\u001cHOQ=uKB+'oU3d_:$w\fJ3r)\ry(q\u0005\u0005\n\u0003\u001bY\u0013\u0011!a\u0001\u00033\nq#[8SKF,Xm\u001d;CsR,\u0007+\u001a:TK\u000e|g\u000e\u001a\u0011\u0002\u001f\u001d,G\u000fV8qS\u000el\u0015M\\1hKJ,\"Aa\f\u0011\t\u0005}&\u0011G\u0005\u0005\u0005g\t\tM\u0001\fEkJ\f'-\u001b7jif$v\u000e]5d\u001b\u0006t\u0017mZ3s\u00031!x\u000e]5d\u001b\u0006t\u0017mZ3s\u0003\r\u0011XO\u001c\u000b\u0002\u007f\u00061Am\\,pe.\fab\u0019:fCR,\u0017)\u001e3ji*{'\r\u0006\u0002\u0003BA!!1\tB%\u001b\t\u0011)EC\u0002\u0003Hq\n1A[8c\u0013\u0011\u0011YE!\u0012\u0003!\u0005\u00137\u000f\u001e:bGR\fU\u000fZ5u\u0015>\u0014\u0017!\u00054mkND'+Z2pe\u0012\u001c\u0018+^3vKR\u0019qP!\u0015\t\u0013\tM#\u0007%AA\u0002\tU\u0013aC;tK2{7-\u00197M_\u001e\u0004B!!\u0001\u0003X%!!\u0011LA\u0002\u0005\u001d\u0011un\u001c7fC:\f1D\u001a7vg\"\u0014VmY8sIN\fV/Z;fI\u0011,g-Y;mi\u0012\nTC\u0001B0U\u0011\u0011)F!\u0019,\u0005\t\r\u0004\u0003\u0002B3\u0005_j!Aa\u001a\u000b\t\t%$1N\u0001\nk:\u001c\u0007.Z2lK\u0012TAA!\u001c\u0002\u0004\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tE$q\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aE:dQ\u0016$W\u000f\\3OK^\fU\u000fZ5u\u0015>\u0014\u0017\u0001E5oSRL\u0017\r\u001c#fY\u0006LHi\u001c8f)\u0011\u0011)F!\u001f\t\u000by+\u0004\u0019\u00011\u00023MDw.\u001e7e'\u000eDW\rZ;mK:+w/Q;eSRTuN\u0019\u000b\u0003\u0005+\nAc\u001d;pa\u0016C\u0018n\u001d;j]\u001e\fU\u000fZ5u\u0015>\u0014\u0017\u0001F:f]\u0012,e/\u001a8u\u0011\u0016\fG\u000e\u001e5DQ\u0016\u001c7\u000e")
public abstract class AbstractAuditManager
extends ShutdownableThread
implements Logging {
    private final DurabilityAuditConfig config;
    private final Time time;
    private final Instant startInstant;
    private KafkaThread auditJobThread;
    private int currentJobId;
    private CountDownLatch auditJobCountdownLatch;
    private final LinkedBlockingQueue<AuditManagerRequest> auditRequestsQueue;
    private volatile long lastHealthCheckTime;
    private final TopicIdPartition healthCheckPartition;
    private final DurabilityDB db;
    private final DurabilityMetricsManager metricsManager;
    private final AuditReporter reporter;
    private final DurabilityTopicConfig topicConfig;
    private final DurabilityAuditConfig auditConfig;
    private Set<Enumeration.Value> auditEvents;
    private Set<Enumeration.Value> auditChecks;
    private long ioRequestBytePerSecond;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DurabilityAuditConfig config() {
        return this.config;
    }

    public Time time() {
        return this.time;
    }

    private Instant startInstant() {
        return this.startInstant;
    }

    public KafkaThread auditJobThread() {
        return this.auditJobThread;
    }

    public void auditJobThread_$eq(KafkaThread x$1) {
        this.auditJobThread = x$1;
    }

    public int currentJobId() {
        return this.currentJobId;
    }

    public void currentJobId_$eq(int x$1) {
        this.currentJobId = x$1;
    }

    public CountDownLatch auditJobCountdownLatch() {
        return this.auditJobCountdownLatch;
    }

    public void auditJobCountdownLatch_$eq(CountDownLatch x$1) {
        this.auditJobCountdownLatch = x$1;
    }

    public LinkedBlockingQueue<AuditManagerRequest> auditRequestsQueue() {
        return this.auditRequestsQueue;
    }

    private long lastHealthCheckTime() {
        return this.lastHealthCheckTime;
    }

    private void lastHealthCheckTime_$eq(long x$1) {
        this.lastHealthCheckTime = x$1;
    }

    public TopicIdPartition healthCheckPartition() {
        return this.healthCheckPartition;
    }

    public DurabilityDB getDB() {
        return DurabilityDB$.MODULE$.apply(this.config().dbPath());
    }

    public DurabilityDB db() {
        return this.db;
    }

    public DurabilityMetricsManager metricsManager() {
        return this.metricsManager;
    }

    public AuditReporter reporter() {
        return this.reporter;
    }

    public abstract AbstractDurabilityEventsMaterialize materialize();

    public DurabilityTopicConfig topicConfig() {
        return this.topicConfig;
    }

    public DurabilityAuditConfig auditConfig() {
        return this.auditConfig;
    }

    public Set<Enumeration.Value> auditEvents() {
        return this.auditEvents;
    }

    public void auditEvents_$eq(Set<Enumeration.Value> x$1) {
        this.auditEvents = x$1;
    }

    public Set<Enumeration.Value> auditChecks() {
        return this.auditChecks;
    }

    public void auditChecks_$eq(Set<Enumeration.Value> x$1) {
        this.auditChecks = x$1;
    }

    public long ioRequestBytePerSecond() {
        return this.ioRequestBytePerSecond;
    }

    public void ioRequestBytePerSecond_$eq(long x$1) {
        this.ioRequestBytePerSecond = x$1;
    }

    public DurabilityTopicManager getTopicManager() {
        DurabilityTopicConfig x$1 = this.topicConfig();
        DurabilityDB x$2 = this.db();
        AbstractDurabilityEventsMaterialize x$3 = this.materialize();
        Supplier<InternalAdmin> x$4 = this.config().internalAdminSupplier();
        boolean x$5 = this.config().isRunningOnBroker();
        Time x$6 = Time.SYSTEM;
        return new DurabilityTopicManager(x$1, x$2, x$3, x$4, x$6, x$5);
    }

    public abstract DurabilityTopicManager topicManager();

    public void run() {
        this.topicManager().start();
        super.run();
    }

    public abstract void doWork();

    public abstract AbstractAuditJob createAuditJob();

    public abstract void flushRecordsQueue(boolean var1);

    public boolean flushRecordsQueue$default$1() {
        return true;
    }

    public AbstractAuditJob scheduleNewAuditJob() {
        this.stopExistingAuditJob();
        int newJobId = Utils$.MODULE$.getDayOfYear(this.time());
        int oldJobId = this.reporter().resetJob(newJobId);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Going to schedule new AuditJob, (").append(oldJobId).append(" -> ").append(newJobId).append(")").toString());
        this.currentJobId_$eq(newJobId);
        this.auditJobCountdownLatch_$eq(new CountDownLatch(1));
        AbstractAuditJob auditJob = this.createAuditJob();
        String nonDaemon_name = new StringBuilder(9).append("AuditJob-").append(this.currentJobId()).toString();
        Object var4_4 = null;
        this.auditJobThread_$eq(new KafkaThread(nonDaemon_name, (Runnable)auditJob, false));
        this.auditJobThread().start();
        return auditJob;
    }

    private boolean initialDelayDone(Time time) {
        Instant now = Instant.ofEpochMilli(time.milliseconds());
        return Duration.between(this.startInstant(), now).toMillis() > this.config().initialAuditJobDelayMs() && this.db().getTopicPartitionsForAudit().nonEmpty();
    }

    public boolean shouldScheduleNewAuditJob() {
        Option option = Option$.MODULE$.apply((Object)this.auditJobThread());
        if (option instanceof Some && ((KafkaThread)((Some)option).value()).isAlive()) {
            return false;
        }
        int currDay = Utils$.MODULE$.getDayOfYear(this.time());
        return this.auditJobCountdownLatch().getCount() == 0L && currDay != this.currentJobId() && this.initialDelayDone(this.time());
    }

    public void stopExistingAuditJob() {
        if (this.auditJobThread() != null && this.auditJobThread().isAlive()) {
            this.auditJobCountdownLatch().countDown();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("AuditManager cancelled AuditJob with jobId: ").append(this.currentJobId()).toString());
            return;
        }
    }

    public boolean sendEventHealthCheck() {
        long currentTimeMs = this.time().milliseconds();
        if (currentTimeMs - this.lastHealthCheckTime() >= DurabilityAuditConstants$.MODULE$.HEALTH_CHECK_UPDATE_TIME_MS()) {
            this.lastHealthCheckTime_$eq(currentTimeMs);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public AbstractAuditManager(DurabilityAuditConfig config, Time time) {
        void apply_controllerMode;
        void apply_reportingDelayMs;
        void apply_metrics;
        this.config = config;
        this.time = time;
        super("AuditManager", true);
        this.startInstant = Instant.ofEpochMilli(time.milliseconds());
        this.currentJobId = 0;
        this.auditJobCountdownLatch = new CountDownLatch(0);
        this.auditRequestsQueue = new LinkedBlockingQueue(DurabilityAuditConstants$.MODULE$.DURABILITY_RECORD_MAX_QUEUE_SIZE());
        this.lastHealthCheckTime = 0L;
        this.healthCheckPartition = new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("durability-health-check", 0));
        this.db = this.getDB();
        boolean bl = !config.isRunningOnBroker();
        long l = config.reportingBatchMs();
        Metrics metrics = config.metrics();
        String apply_nodeId = Integer.toString(config.nodeId());
        Object var3_6 = null;
        metrics = null;
        this.metricsManager = new DurabilityMetricsManager(apply_nodeId, (Metrics)apply_metrics, time, (long)apply_reportingDelayMs, (boolean)apply_controllerMode);
        DurabilityMetricsManager apply_metricManager = this.metricsManager();
        Object var8_7 = null;
        this.reporter = new AuditReporter(apply_metricManager);
        this.topicConfig = new DurabilityTopicConfig(config.interBrokerClientConfigs(), DurabilityAuditConstants$.MODULE$.TOPIC_NAME(), config.topicPartitionCount(), config.topicReplicationFactor(), config.brokerId(), config.clusterId(), DurabilityAuditConstants$.MODULE$.DURABILITY_CONSUMER_POLL_DURATION_MS(), Predef$.MODULE$.int2Integer(DurabilityAuditConstants$.MODULE$.DURABILITY_PRODUCER_REQUEST_TIMEOUT_MS()), DurabilityAuditConstants$.MODULE$.DURABILITY_TOPIC_RETENTION_MS(), DurabilityAuditConstants$.MODULE$.DURABILITY_TOPIC_MAX_LOOK_BACK_IN_MS(), config.idempotentProducer(), (Option<Set<Object>>)None$.MODULE$);
        this.auditConfig = config;
        this.auditEvents = config.allowedEvents();
        this.auditChecks = config.auditChecks();
        this.ioRequestBytePerSecond = config.ioRequestBytePerSecond();
    }
}

