/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.utils;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import kafka.durability.exception.MemoryLimitExceededException;
import kafka.durability.utils.OffsetInfo;
import kafka.durability.utils.OffsetMapEntry;
import kafka.durability.utils.OffsetMapEntryRecord;
import kafka.durability.utils.OffsetMapFile;
import kafka.log.CleanedTransactionMetadata;
import kafka.tier.TopicIdPartition;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.SortedMap;
import scala.collection.mutable.SortedMap$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;

public final class DurabilityOffsetMapUtils$
implements Logging {
    public static final DurabilityOffsetMapUtils$ MODULE$ = new DurabilityOffsetMapUtils$();
    private static final BufferSupplier decompressionBufferSupplier = BufferSupplier.create();
    private static final MessageDigest digest = MessageDigest.getInstance("MD5");
    private static final int hashSize = MODULE$.digest().getDigestLength();
    private static final byte[] hashBuffer = new byte[MODULE$.hashSize()];
    private static final int OFFSET_MAP_MEMORY_USAGE_PER_ENTRY = 152;
    private static final long OFFSET_MAP_ENTRY_COUNT_LIMIT = 0x100000L;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return decompressionBufferSupplier;
    }

    private MessageDigest digest() {
        return digest;
    }

    private int hashSize() {
        return hashSize;
    }

    private byte[] hashBuffer() {
        return hashBuffer;
    }

    public ByteBuffer getHashedBuffer(ByteBuffer key) {
        key.mark();
        this.digest().reset();
        this.digest().update(key);
        int len = this.digest().digest(this.hashBuffer(), 0, this.hashSize());
        byte[] hashedKey = new byte[len];
        Array$.MODULE$.copy((Object)this.hashBuffer(), 0, (Object)hashedKey, 0, len);
        return ByteBuffer.wrap(hashedKey);
    }

    private int OFFSET_MAP_MEMORY_USAGE_PER_ENTRY() {
        return OFFSET_MAP_MEMORY_USAGE_PER_ENTRY;
    }

    private long OFFSET_MAP_ENTRY_COUNT_LIMIT() {
        return OFFSET_MAP_ENTRY_COUNT_LIMIT;
    }

    private void mayThrowMemoryLimitExceededException(long limit, long actual) {
        if (actual > limit) {
            throw new MemoryLimitExceededException("DA for compaction offset map generator", limit * (long)this.OFFSET_MAP_MEMORY_USAGE_PER_ENTRY(), actual * (long)this.OFFSET_MAP_MEMORY_USAGE_PER_ENTRY());
        }
    }

    public SortedMap<ByteBuffer, OffsetInfo> filterKeysAndOffset(Throttler throttler, InputStream inputStream, ByteBuffer readByteBuffer, CleanedTransactionMetadata transactionMetadata, long firstCleanOffset, long lastCleanOffset, long offsetMapEntryCountLimit) {
        SortedMap offsetMap = (SortedMap)SortedMap$.MODULE$.apply((Seq)Nil$.MODULE$, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        readByteBuffer.clear();
        try {
            Utils.readFully((InputStream)inputStream, (ByteBuffer)readByteBuffer, (boolean)false);
            while (readByteBuffer.position() != 0) {
                readByteBuffer.flip();
                MemoryRecords records = new MemoryRecords(readByteBuffer);
                throttler.maybeThrottle(records.sizeInBytes());
                for (MutableRecordBatch batch : records.batches()) {
                    if (batch.isControlBatch()) {
                        transactionMetadata.onControlBatchRead((RecordBatch)batch);
                        continue;
                    }
                    if (transactionMetadata.onBatchRead((RecordBatch)batch)) continue;
                    try (CloseableIterator recordsIterator = batch.streamingIterator(this.decompressionBufferSupplier());){
                        CollectionConverters$.MODULE$.IteratorHasAsScala((java.util.Iterator)recordsIterator).asScala().foreach((Function1 & Serializable)record -> {
                            DurabilityOffsetMapUtils$.$anonfun$filterKeysAndOffset$1(lastCleanOffset, firstCleanOffset, offsetMap, offsetMapEntryCountLimit, record);
                            return BoxedUnit.UNIT;
                        });
                    }
                }
                int bytesRead = records.validBytes();
                readByteBuffer.position(bytesRead);
                readByteBuffer.compact();
                Utils.readFully((InputStream)inputStream, (ByteBuffer)readByteBuffer, (boolean)false);
            }
        }
        catch (MemoryLimitExceededException memoryLimitExceededException) {
            throw memoryLimitExceededException;
        }
        catch (Exception e) {
            if (this.logger().underlying().isErrorEnabled()) {
                String msgWithLogIdent_msg = DurabilityOffsetMapUtils$.$anonfun$filterKeysAndOffset$2(e);
                Object var19_16 = null;
                this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            throw new IOException("Error reading input stream");
        }
        return offsetMap;
    }

    public long filterKeysAndOffset$default$7() {
        return this.OFFSET_MAP_ENTRY_COUNT_LIMIT();
    }

    public void storeOffsetMapInFile(scala.collection.SortedMap<ByteBuffer, OffsetInfo> offsetMap, File path, boolean exists) {
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = DurabilityOffsetMapUtils$.$anonfun$storeOffsetMapInFile$1(path);
            Object var5_4 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        OffsetMapFile offsetMapFile = new OffsetMapFile(path, exists);
        offsetMap.foreach((Function1 & Serializable)x0$1 -> {
            DurabilityOffsetMapUtils$.$anonfun$storeOffsetMapInFile$2(offsetMapFile, x0$1);
            return BoxedUnit.UNIT;
        });
        offsetMapFile.flush();
        offsetMapFile.close();
    }

    public scala.collection.SortedMap<ByteBuffer, OffsetInfo> retrieveOffsetMapInFile(File path, String name) {
        SortedMap offsetMap = (SortedMap)SortedMap$.MODULE$.apply((Seq)Nil$.MODULE$, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        Iterator<Option<OffsetMapEntryRecord>> fileIterate = new OffsetMapFile(new File(path, name), true).iterator();
        Option fileEntry = (Option)fileIterate.next();
        while (fileEntry.nonEmpty()) {
            offsetMap.put((Object)ByteBuffer.wrap(((OffsetMapEntryRecord)fileEntry.get()).entry().hashedKey()), (Object)new OffsetInfo(((OffsetMapEntryRecord)fileEntry.get()).entry().offsetValue(), ((OffsetMapEntryRecord)fileEntry.get()).entry().isTombStone()));
            fileEntry = (Option)fileIterate.next();
        }
        return offsetMap;
    }

    public void mergeOffsetMapFile(File newerFile, File olderFile, File destination) {
        OffsetMapFile newerFileOffsetMap = new OffsetMapFile(newerFile, true);
        OffsetMapFile olderFileOffsetMap = new OffsetMapFile(olderFile, true);
        OffsetMapFile destinationOffsetMap = new OffsetMapFile(destination, false);
        try {
            try {
                Iterator<Option<OffsetMapEntryRecord>> newerFileIterate = newerFileOffsetMap.iterator();
                Iterator<Option<OffsetMapEntryRecord>> olderFileIterate = olderFileOffsetMap.iterator();
                Option newerFileEntry = (Option)newerFileIterate.next();
                Option olderFileEntry = (Option)olderFileIterate.next();
                while (newerFileEntry.nonEmpty() || olderFileEntry.nonEmpty()) {
                    if (newerFileEntry.nonEmpty() && olderFileEntry.nonEmpty()) {
                        int value = ByteBuffer.wrap(((OffsetMapEntryRecord)newerFileEntry.get()).entry().hashedKey()).compareTo(ByteBuffer.wrap(((OffsetMapEntryRecord)olderFileEntry.get()).entry().hashedKey()));
                        if (value == 0) {
                            if (((OffsetMapEntryRecord)newerFileEntry.get()).entry().offsetValue() > ((OffsetMapEntryRecord)olderFileEntry.get()).entry().offsetValue()) {
                                destinationOffsetMap.append(((OffsetMapEntryRecord)newerFileEntry.get()).entry());
                            } else {
                                destinationOffsetMap.append(((OffsetMapEntryRecord)olderFileEntry.get()).entry());
                            }
                            newerFileEntry = (Option)newerFileIterate.next();
                            olderFileEntry = (Option)olderFileIterate.next();
                        }
                        if (value < 0) {
                            destinationOffsetMap.append(((OffsetMapEntryRecord)newerFileEntry.get()).entry());
                            newerFileEntry = (Option)newerFileIterate.next();
                        }
                        if (value <= 0) continue;
                        destinationOffsetMap.append(((OffsetMapEntryRecord)olderFileEntry.get()).entry());
                        olderFileEntry = (Option)olderFileIterate.next();
                        continue;
                    }
                    if (newerFileEntry.nonEmpty()) {
                        destinationOffsetMap.append(((OffsetMapEntryRecord)newerFileEntry.get()).entry());
                        newerFileEntry = (Option)newerFileIterate.next();
                    }
                    if (!olderFileEntry.nonEmpty()) continue;
                    destinationOffsetMap.append(((OffsetMapEntryRecord)olderFileEntry.get()).entry());
                    olderFileEntry = (Option)olderFileIterate.next();
                }
                destinationOffsetMap.flush();
            }
            catch (Exception e) {
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = DurabilityOffsetMapUtils$.$anonfun$mergeOffsetMapFile$1(e);
                    Object var14_13 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                throw e;
            }
        }
        finally {
            destinationOffsetMap.close();
            newerFileOffsetMap.close();
            olderFileOffsetMap.close();
        }
    }

    public int checkCongruentOffsetMapFile(TopicIdPartition topicIdPartition, File sourceFile, File destinationFile) {
        OffsetMapFile sourceFileOffsetMap = new OffsetMapFile(sourceFile, true);
        OffsetMapFile destinationFileOffsetMap = new OffsetMapFile(destinationFile, true);
        IntRef mismatches = IntRef.create((int)0);
        try {
            Iterator<Option<OffsetMapEntryRecord>> sourceFileIterate = sourceFileOffsetMap.iterator();
            Iterator<Option<OffsetMapEntryRecord>> destinationFileIterate = destinationFileOffsetMap.iterator();
            ObjectRef sourceMessageEntry = ObjectRef.create((Object)((Option)sourceFileIterate.next()));
            ObjectRef destinationMessageEntry = ObjectRef.create((Object)((Option)destinationFileIterate.next()));
            while (((Option)sourceMessageEntry.elem).nonEmpty() || ((Option)destinationMessageEntry.elem).nonEmpty()) {
                Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    if (MODULE$.isTombStone((Option<OffsetMapEntryRecord>)((Option)sourceMessageEntry$1.elem))) {
                        if (MODULE$.isTombStone((Option<OffsetMapEntryRecord>)((Option)destinationMessageEntry$1.elem)) && MODULE$.isHashedKeyEqual((Option<OffsetMapEntryRecord>)((Option)sourceMessageEntry$1.elem), (Option<OffsetMapEntryRecord>)((Option)destinationMessageEntry$1.elem))) {
                            destinationMessageEntry$1.elem = (Option)destinationFileIterate.next();
                        }
                        sourceMessageEntry$1.elem = (Option)sourceFileIterate.next();
                        throw Breaks$.MODULE$.break();
                    }
                    if (((Option)sourceMessageEntry$1.elem).nonEmpty() && ((Option)destinationMessageEntry$1.elem).nonEmpty()) {
                        boolean isKeyEqual = MODULE$.isHashedKeyEqual((Option<OffsetMapEntryRecord>)((Option)sourceMessageEntry$1.elem), (Option<OffsetMapEntryRecord>)((Option)destinationMessageEntry$1.elem));
                        if (!isKeyEqual || ((OffsetMapEntryRecord)((Option)sourceMessageEntry$1.elem).get()).entry().offsetValue() != ((OffsetMapEntryRecord)((Option)destinationMessageEntry$1.elem).get()).entry().offsetValue()) {
                            DurabilityOffsetMapUtils$ error_this = MODULE$;
                            if (error_this.logger().underlying().isErrorEnabled()) {
                                String msgWithLogIdent_msg = new StringBuilder(50).append("KeyPair Mismatch, ").append(topicIdPartition).append(" ").append("source key: ").append(((Option)sourceMessageEntry$1.elem).get()).append("  destination key: ").append(((Option)destinationMessageEntry$1.elem).get()).toString();
                                Object var10_8 = null;
                                error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg));
                            }
                            Object var7_7 = null;
                            ++mismatches$1.elem;
                        }
                        if (!isKeyEqual) {
                            if (ByteBuffer.wrap(((OffsetMapEntryRecord)((Option)sourceMessageEntry$1.elem).get()).entry().hashedKey()).compareTo(ByteBuffer.wrap(((OffsetMapEntryRecord)((Option)destinationMessageEntry$1.elem).get()).entry().hashedKey())) < 0) {
                                sourceMessageEntry$1.elem = (Option)sourceFileIterate.next();
                                return;
                            }
                            destinationMessageEntry$1.elem = (Option)destinationFileIterate.next();
                            return;
                        }
                        sourceMessageEntry$1.elem = (Option)sourceFileIterate.next();
                        destinationMessageEntry$1.elem = (Option)destinationFileIterate.next();
                        return;
                    }
                    if (((Option)sourceMessageEntry$1.elem).nonEmpty()) {
                        DurabilityOffsetMapUtils$ error_this = MODULE$;
                        if (error_this.logger().underlying().isErrorEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(58).append("Key missing in destination offset map for ").append(topicIdPartition).append(" for source key ").append(((Option)sourceMessageEntry$1.elem).get()).toString();
                            Object var11_10 = null;
                            error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg));
                        }
                        Object var8_9 = null;
                        sourceMessageEntry$1.elem = (Option)sourceFileIterate.next();
                        ++mismatches$1.elem;
                    }
                    if (((Option)destinationMessageEntry$1.elem).nonEmpty()) {
                        DurabilityOffsetMapUtils$ error_this = MODULE$;
                        if (error_this.logger().underlying().isErrorEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(58).append("Key missing in source offset map for ").append(topicIdPartition).append(" for destination key ").append(((Option)destinationMessageEntry$1.elem).get()).toString();
                            Object var12_12 = null;
                            error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg));
                        }
                        Object var9_11 = null;
                        destinationMessageEntry$1.elem = (Option)destinationFileIterate.next();
                        ++mismatches$1.elem;
                        return;
                    }
                });
            }
        }
        catch (Exception e) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = DurabilityOffsetMapUtils$.$anonfun$checkCongruentOffsetMapFile$5(topicIdPartition, e);
                Object var12_12 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            throw e;
        }
        return mismatches.elem;
    }

    private boolean isTombStone(Option<OffsetMapEntryRecord> messageEntry) {
        return messageEntry.nonEmpty() && ((OffsetMapEntryRecord)messageEntry.get()).entry().isTombStone();
    }

    private boolean isHashedKeyEqual(Option<OffsetMapEntryRecord> sourceMessageEntry, Option<OffsetMapEntryRecord> destinationMessageEntry) {
        return Predef$.MODULE$.wrapByteArray(((OffsetMapEntryRecord)sourceMessageEntry.get()).entry().hashedKey()).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(((OffsetMapEntryRecord)destinationMessageEntry.get()).entry().hashedKey()));
    }

    public static final /* synthetic */ void $anonfun$filterKeysAndOffset$1(long lastCleanOffset$1, long firstCleanOffset$1, SortedMap offsetMap$1, long offsetMapEntryCountLimit$1, Record record) {
        if (record.hasKey() && record.offset() <= lastCleanOffset$1 && record.offset() >= firstCleanOffset$1) {
            offsetMap$1.put((Object)MODULE$.getHashedBuffer(record.key()), (Object)new OffsetInfo(record.offset(), !record.hasValue()));
        }
        MODULE$.mayThrowMemoryLimitExceededException(offsetMapEntryCountLimit$1, offsetMap$1.size());
    }

    public static final /* synthetic */ String $anonfun$filterKeysAndOffset$2(Exception e$1) {
        return new StringBuilder(46).append("Ran into the exception while reading the data ").append(e$1).toString();
    }

    public static final /* synthetic */ String $anonfun$storeOffsetMapInFile$1(File path$1) {
        return new StringBuilder(26).append("Creating offsetMapFile in ").append(path$1).toString();
    }

    public static final /* synthetic */ void $anonfun$storeOffsetMapInFile$2(OffsetMapFile offsetMapFile$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ByteBuffer k = (ByteBuffer)x0$1._1();
            OffsetInfo v = (OffsetInfo)x0$1._2();
            offsetMapFile$1.append(new OffsetMapEntry(v.isTombstone(), v.offset(), k.array()));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ String $anonfun$mergeOffsetMapFile$1(Exception e$2) {
        return new StringBuilder(47).append("Ran into exception to while merging the files. ").append(e$2).toString();
    }

    public static final /* synthetic */ String $anonfun$checkCongruentOffsetMapFile$2(TopicIdPartition topicIdPartition$1, ObjectRef sourceMessageEntry$1, ObjectRef destinationMessageEntry$1) {
        return new StringBuilder(50).append("KeyPair Mismatch, ").append(topicIdPartition$1).append(" ").append("source key: ").append(((Option)sourceMessageEntry$1.elem).get()).append("  destination key: ").append(((Option)destinationMessageEntry$1.elem).get()).toString();
    }

    public static final /* synthetic */ String $anonfun$checkCongruentOffsetMapFile$3(TopicIdPartition topicIdPartition$1, ObjectRef sourceMessageEntry$1) {
        return new StringBuilder(58).append("Key missing in destination offset map for ").append(topicIdPartition$1).append(" for source key ").append(((Option)sourceMessageEntry$1.elem).get()).toString();
    }

    public static final /* synthetic */ String $anonfun$checkCongruentOffsetMapFile$4(TopicIdPartition topicIdPartition$1, ObjectRef destinationMessageEntry$1) {
        return new StringBuilder(58).append("Key missing in source offset map for ").append(topicIdPartition$1).append(" for destination key ").append(((Option)destinationMessageEntry$1.elem).get()).toString();
    }

    public static final /* synthetic */ String $anonfun$checkCongruentOffsetMapFile$5(TopicIdPartition topicIdPartition$1, Exception e$3) {
        return new StringBuilder(51).append("Ran into exception to while merging the files for ").append(topicIdPartition$1).append(" ").append(e$3).toString();
    }

    private DurabilityOffsetMapUtils$() {
    }
}

