/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.availability.FilesWrapper;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kafka.log.LocalLog$;
import kafka.log.MergedLog$;
import kafka.log.SplitSegmentResult;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegmentOffsetOverflowException;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tMa\u0001\u0002\u0010 \u0001\u0011B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0011!I\u0006A!A!\u0002\u0013Q\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u0011\r\u0004!\u0011!Q\u0001\n\u0011D\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\tW\u0002\u0011\t\u0011)A\u0005Y\"Aq\u000e\u0001B\u0001B\u0003%A\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003r\u0011!a\bA!A!\u0002\u0013i\bBCA\u0001\u0001\t\u0005\t\u0015!\u0003\u0002\u0004!Q\u00111\u0006\u0001\u0003\u0002\u0003\u0006I!!\f\t\u0013\u0005\r\u0003A!A!\u0002\u0013!\u0007bBA#\u0001\u0011\u0005\u0011q\t\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\t)\b\u0001C\u0005\u0003oBq!!\"\u0001\t\u0013\t9\tC\u0004\u0002,\u0002!I!!,\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\"A\u00111\u0019\u0001\u0005\u0002}\t)\rC\u0004\u0002N\u0002!I!a4\t\u000f\u0005\u001d\b\u0001\"\u0003\u0002j\u001eI\u0011Q^\u0010\u0002\u0002#\u0005\u0011q\u001e\u0004\t=}\t\t\u0011#\u0001\u0002r\"9\u0011Q\t\u000e\u0005\u0002\u0005M\b\"CA{5E\u0005I\u0011AA|\u0011%\u0011iAGI\u0001\n\u0003\u0011yAA\u0005M_\u001edu.\u00193fe*\u0011\u0001%I\u0001\u0004Y><'\"\u0001\u0012\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001!J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g!\tas&D\u0001.\u0015\tq\u0013%A\u0003vi&d7/\u0003\u00021[\t9Aj\\4hS:<\u0017a\u00013jeB\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0003S>T\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:i\t!a)\u001b7f\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"\u0001\u0010#\u000e\u0003uR!AP \u0002\r\r|W.\\8o\u0015\t\u0011\u0003I\u0003\u0002B\u0005\u00061\u0011\r]1dQ\u0016T\u0011aQ\u0001\u0004_J<\u0017BA#>\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\faaY8oM&<\u0007C\u0001%O\u001b\u0005I%B\u0001\u0011K\u0015\tYE*A\u0005j]R,'O\\1mg*\u0011QjP\u0001\bgR|'/Y4f\u0013\ty\u0015JA\u0005M_\u001e\u001cuN\u001c4jO\u0006I1o\u00195fIVdWM\u001d\t\u0003%^k\u0011a\u0015\u0006\u0003)V\u000bA!\u001e;jY*\u0011akP\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005a\u001b&!C*dQ\u0016$W\u000f\\3s\u0003\u0011!\u0018.\\3\u0011\u0005mkV\"\u0001/\u000b\u00059j\u0014B\u00010]\u0005\u0011!\u0016.\\3\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m!\tA\u0015-\u0003\u0002c\u0013\n!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\f\u0001\u0003[1e\u00072,\u0017M\\*ikR$wn\u001e8\u0011\u0005\u0019*\u0017B\u00014(\u0005\u001d\u0011un\u001c7fC:\f\u0001b]3h[\u0016tGo\u001d\t\u0003\u0011&L!A[%\u0003\u00171{wmU3h[\u0016tGo]\u0001\u0019Y><7\u000b^1si>3gm]3u\u0007\",7m\u001b9pS:$\bC\u0001\u0014n\u0013\tqwE\u0001\u0003M_:<\u0017a\u0006:fG>4XM]=Q_&tGo\u00115fG.\u0004x.\u001b8u\u0003AaW-\u00193fe\u0016\u0003xn\u00195DC\u000eDW\rE\u0002siZl\u0011a\u001d\u0006\u0003)ZJ!!^:\u0003\u0011=\u0003H/[8oC2\u0004\"a\u001e>\u000e\u0003aT!!\u001f&\u0002\u000b\u0015\u0004xn\u00195\n\u0005mD(\u0001\u0006'fC\u0012,'/\u00129pG\"4\u0015\u000e\\3DC\u000eDW-\u0001\u000bqe>$WoY3s'R\fG/Z'b]\u0006<WM\u001d\t\u0003\u0011zL!a`%\u0003)A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0003QqW/\u001c*f[\u0006Lg.\u001b8h'\u0016<W.\u001a8ugBA\u0011QAA\u0006\u0003\u001f\t)#\u0004\u0002\u0002\b)\u0019\u0011\u0011B:\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\u000e\u0005\u001d!!D\"p]\u000e,(O]3oi6\u000b\u0007\u000f\u0005\u0003\u0002\u0012\u0005}a\u0002BA\n\u00037\u00012!!\u0006(\u001b\t\t9BC\u0002\u0002\u001a\r\na\u0001\u0010:p_Rt\u0014bAA\u000fO\u00051\u0001K]3eK\u001aLA!!\t\u0002$\t11\u000b\u001e:j]\u001eT1!!\b(!\r1\u0013qE\u0005\u0004\u0003S9#aA%oi\u0006q1\r[3dWN,X\u000eU1sC6\u001c\b\u0003BA\u0018\u0003\u007fi!!!\r\u000b\t\u0005M\u0012QG\u0001\tG\",7m[:v[*\u0019Q*a\u000e\u000b\u0007\t\nID\u0003\u0003\u0002<\u0005u\u0012!C2p]\u001adW/\u001a8u\u0015\u0005)\u0014\u0002BA!\u0003c\u0011ab\u00115fG.\u001cX/\u001c)be\u0006l7/\u0001\njgJ+Wn\u001c;f\u0019><WI\\1cY\u0016$\u0017A\u0002\u001fj]&$h\b\u0006\u0011\u0002J\u00055\u0013qJA)\u0003'\n)&a\u0016\u0002Z\u0005m\u0013QLA0\u0003C\n\u0019'!\u001a\u0002h\u0005%\u0004cAA&\u00015\tq\u0004C\u00032!\u0001\u0007!\u0007C\u0003;!\u0001\u00071\bC\u0003G!\u0001\u0007q\tC\u0003Q!\u0001\u0007\u0011\u000bC\u0003Z!\u0001\u0007!\fC\u0003`!\u0001\u0007\u0001\rC\u0003d!\u0001\u0007A\rC\u0003h!\u0001\u0007\u0001\u000eC\u0003l!\u0001\u0007A\u000eC\u0003p!\u0001\u0007A\u000eC\u0003q!\u0001\u0007\u0011\u000fC\u0003}!\u0001\u0007Q\u0010C\u0005\u0002\u0002A\u0001\n\u00111\u0001\u0002\u0004!9\u00111\u0006\tA\u0002\u00055\u0002\u0002CA\"!A\u0005\t\u0019\u00013\u0002\t1|\u0017\r\u001a\u000b\u0003\u0003_\u00022\u0001SA9\u0013\r\t\u0019(\u0013\u0002\u0011\u0019>\fG-\u001a3M_\u001e|eMZ:fiN\f!E]3n_Z,G+Z7q\r&dWm]!oI\u000e{G\u000e\\3diN;\u0018\r\u001d$jY\u0016\u001cHCAA=!\u0015\tY(!!3\u001b\t\tiHC\u0002\u0002\u0000\u001d\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019)! \u0003\u0007M+G/A\u000bsKR\u0014\u0018p\u00148PM\u001a\u001cX\r^(wKJ4Gn\\<\u0016\t\u0005%\u0015q\u0012\u000b\u0005\u0003\u0017\u000b\t\u000b\u0005\u0003\u0002\u000e\u0006=E\u0002\u0001\u0003\b\u0003#\u001b\"\u0019AAJ\u0005\u0005!\u0016\u0003BAK\u00037\u00032AJAL\u0013\r\tIj\n\u0002\b\u001d>$\b.\u001b8h!\r1\u0013QT\u0005\u0004\u0003?;#aA!os\"9\u00111U\nA\u0002\u0005\u0015\u0016A\u00014o!\u00151\u0013qUAF\u0013\r\tIk\n\u0002\n\rVt7\r^5p]B\n\u0001\u0003\\8bIN+w-\\3oi\u001aKG.Z:\u0015\u0005\u0005=\u0006c\u0001\u0014\u00022&\u0019\u00111W\u0014\u0003\tUs\u0017\u000e^\u0001\u000fe\u0016\u001cwN^3s'\u0016<W.\u001a8u)\u0011\t)#!/\t\u000f\u0005mV\u00031\u0001\u0002>\u000691/Z4nK:$\bc\u0001%\u0002@&\u0019\u0011\u0011Y%\u0003\u00151{wmU3h[\u0016tG/\u0001\u0006sK\u000e|g/\u001a:M_\u001e$\"!a2\u0011\u000b\u0019\nI\r\u001c7\n\u0007\u0005-wE\u0001\u0004UkBdWMM\u0001\u001de\u0016lwN^3B]\u0012$U\r\\3uKN+w-\\3oiN\f5/\u001f8d)\u0011\ty+!5\t\u000f\u0005Mw\u00031\u0001\u0002V\u0006\u00012/Z4nK:$8\u000fV8EK2,G/\u001a\t\u0007\u0003/\f\t/!0\u000f\t\u0005e\u0017Q\u001c\b\u0005\u0003+\tY.C\u0001)\u0013\r\tynJ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019/!:\u0003\u0011%#XM]1cY\u0016T1!a8(\u0003q!W\r\\3uKB\u0013x\u000eZ;dKJ\u001cf.\u00199tQ>$8/Q:z]\u000e$B!a,\u0002l\"1q\r\u0007a\u0001\u0003+\f\u0011\u0002T8h\u0019>\fG-\u001a:\u0011\u0007\u0005-#d\u0005\u0002\u001bKQ\u0011\u0011q^\u0001\u001dI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00194+\t\tIP\u000b\u0003\u0002\u0004\u0005m8FAA\u007f!\u0011\tyP!\u0003\u000e\u0005\t\u0005!\u0002\u0002B\u0002\u0005\u000b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u001dq%\u0001\u0006b]:|G/\u0019;j_:LAAa\u0003\u0003\u0002\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132kU\u0011!\u0011\u0003\u0016\u0004I\u0006m\b")
public class LogLoader
implements Logging {
    private final File dir;
    private final TopicPartition topicPartition;
    private final LogConfig config;
    private final Scheduler scheduler;
    private final Time time;
    private final LogDirFailureChannel logDirFailureChannel;
    private final boolean hadCleanShutdown;
    private final LogSegments segments;
    private final long logStartOffsetCheckpoint;
    private final long recoveryPointCheckpoint;
    private final Optional<LeaderEpochFileCache> leaderEpochCache;
    private final ProducerStateManager producerStateManager;
    private final ConcurrentMap<String, Object> numRemainingSegments;
    private final ChecksumParams checksumParams;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$15() {
        return false;
    }

    public static ConcurrentMap<String, Object> $lessinit$greater$default$13() {
        return new ConcurrentHashMap<String, Object>();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public LoadedLogOffsets load() {
        long l;
        long l2;
        Object var12_7;
        LogSegments logSegments;
        File file2;
        TopicPartition topicPartition;
        LogConfig logConfig;
        Scheduler scheduler;
        LogDirFailureChannel logDirFailureChannel;
        String string;
        Set<File> swapFiles = this.removeTempFilesAndCollectSwapFiles();
        LongRef minSwapFileOffset = LongRef.create((long)Long.MAX_VALUE);
        LongRef maxSwapFileOffset = LongRef.create((long)Long.MIN_VALUE);
        ((IterableOnceOps)swapFiles.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$load$1(f)))).foreach((Function1 & Serializable)f -> {
            LogLoader.$anonfun$load$2(this, minSwapFileOffset, maxSwapFileOffset, f);
            return BoxedUnit.UNIT;
        });
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            Object object;
            block6: {
                try {
                    if (!file.getName().endsWith(MergedLog$.MODULE$.SwapFileSuffix())) {
                        long offset = Predef$.MODULE$.Long2long(LogFileUtils.offsetFromFile((File)file));
                        if (offset >= minSwapFileOffset$1.elem && offset < maxSwapFileOffset$1.elem) {
                            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Deleting segment files ").append(file.getName()).append(" that is compacted but has not been deleted yet.").toString());
                            object = BoxesRunTime.boxToBoolean((boolean)file.delete());
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        break block6;
                    }
                    return BoxedUnit.UNIT;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return BoxedUnit.UNIT;
                }
                catch (NumberFormatException numberFormatException) {
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        });
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            if (file.getName().endsWith(MergedLog$.MODULE$.SwapFileSuffix())) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Recovering file ").append(file.getName()).append(" by renaming from ").append(MergedLog$.MODULE$.SwapFileSuffix()).append(" files.").toString());
                return BoxesRunTime.boxToBoolean((boolean)file.renameTo(new File(Utils.replaceSuffix((String)file.getPath(), (String)MergedLog$.MODULE$.SwapFileSuffix(), (String)""))));
            }
            return BoxedUnit.UNIT;
        });
        while (true) {
            try {
                LogLoader.$anonfun$load$10(this);
            }
            catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                void retryOnOffsetOverflow_splitOverflowedSegment_logPrefix;
                void retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel;
                void retryOnOffsetOverflow_splitOverflowedSegment_scheduler;
                void retryOnOffsetOverflow_splitOverflowedSegment_config;
                void retryOnOffsetOverflow_splitOverflowedSegment_topicPartition;
                void retryOnOffsetOverflow_splitOverflowedSegment_dir;
                void retryOnOffsetOverflow_splitOverflowedSegment_existingSegments;
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                string = this.logIdent();
                logDirFailureChannel = this.logDirFailureChannel;
                scheduler = this.scheduler;
                logConfig = this.config;
                topicPartition = this.topicPartition;
                file2 = this.dir;
                logSegments = this.segments;
                LogSegment retryOnOffsetOverflow_splitOverflowedSegment_segment = retryOnOffsetOverflow_e.segment;
                var12_7 = null;
                logSegments = null;
                file2 = null;
                topicPartition = null;
                logConfig = null;
                scheduler = null;
                logDirFailureChannel = null;
                string = null;
                SplitSegmentResult retryOnOffsetOverflow_result = LocalLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_splitOverflowedSegment_segment, (LogSegments)retryOnOffsetOverflow_splitOverflowedSegment_existingSegments, (File)retryOnOffsetOverflow_splitOverflowedSegment_dir, (TopicPartition)retryOnOffsetOverflow_splitOverflowedSegment_topicPartition, (LogConfig)retryOnOffsetOverflow_splitOverflowedSegment_config, (Scheduler)retryOnOffsetOverflow_splitOverflowedSegment_scheduler, (LogDirFailureChannel)retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel, (String)retryOnOffsetOverflow_splitOverflowedSegment_logPrefix);
                this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments());
                continue;
            }
            break;
        }
        Object var10_5 = null;
        Object var11_6 = null;
        var12_7 = null;
        logSegments = null;
        file2 = null;
        topicPartition = null;
        logConfig = null;
        scheduler = null;
        logDirFailureChannel = null;
        string = null;
        if (!this.dir.getAbsolutePath().endsWith(MergedLog$.MODULE$.DeleteDirSuffix())) {
            void var7_28;
            void var5_27;
            Object var22_18;
            LogSegments logSegments2;
            File file3;
            TopicPartition topicPartition2;
            LogConfig logConfig2;
            Scheduler scheduler2;
            LogDirFailureChannel logDirFailureChannel2;
            String string2;
            Tuple2<Object, Object> tuple2;
            while (true) {
                try {
                    tuple2 = this.recoverLog();
                }
                catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                    void retryOnOffsetOverflow_splitOverflowedSegment_logPrefix;
                    void retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel;
                    void retryOnOffsetOverflow_splitOverflowedSegment_scheduler;
                    void retryOnOffsetOverflow_splitOverflowedSegment_config;
                    void retryOnOffsetOverflow_splitOverflowedSegment_topicPartition;
                    void retryOnOffsetOverflow_splitOverflowedSegment_dir;
                    void retryOnOffsetOverflow_splitOverflowedSegment_existingSegments;
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                    string2 = this.logIdent();
                    logDirFailureChannel2 = this.logDirFailureChannel;
                    scheduler2 = this.scheduler;
                    logConfig2 = this.config;
                    topicPartition2 = this.topicPartition;
                    file3 = this.dir;
                    logSegments2 = this.segments;
                    LogSegment retryOnOffsetOverflow_splitOverflowedSegment_segment = retryOnOffsetOverflow_e.segment;
                    var22_18 = null;
                    logSegments2 = null;
                    file3 = null;
                    topicPartition2 = null;
                    logConfig2 = null;
                    scheduler2 = null;
                    logDirFailureChannel2 = null;
                    string2 = null;
                    SplitSegmentResult retryOnOffsetOverflow_result = LocalLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_splitOverflowedSegment_segment, (LogSegments)retryOnOffsetOverflow_splitOverflowedSegment_existingSegments, (File)retryOnOffsetOverflow_splitOverflowedSegment_dir, (TopicPartition)retryOnOffsetOverflow_splitOverflowedSegment_topicPartition, (LogConfig)retryOnOffsetOverflow_splitOverflowedSegment_config, (Scheduler)retryOnOffsetOverflow_splitOverflowedSegment_scheduler, (LogDirFailureChannel)retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel, (String)retryOnOffsetOverflow_splitOverflowedSegment_logPrefix);
                    this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments());
                    continue;
                }
                break;
            }
            Object var20_16 = null;
            Object var21_17 = null;
            var22_18 = null;
            logSegments2 = null;
            file3 = null;
            topicPartition2 = null;
            logConfig2 = null;
            scheduler2 = null;
            logDirFailureChannel2 = null;
            string2 = null;
            Tuple2<Object, Object> tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            long newRecoveryPoint = tuple22._1$mcJ$sp();
            long nextOffset = tuple22._2$mcJ$sp();
            ((LogSegment)this.segments.lastSegment().get()).resizeIndexes(this.config.maxIndexSize);
            l2 = var5_27;
            l = var7_28;
        } else {
            if (this.segments.isEmpty()) {
                void open_checksumParams;
                void open_preallocate;
                ChecksumParams checksumParams = this.checksumParams;
                boolean bl = false;
                int open_initFileSize = this.config.initFileSize();
                checksumParams = null;
                this.segments.add(LogSegment.open((File)this.dir, (long)0L, (LogConfig)this.config, (Time)this.time, (boolean)false, (int)open_initFileSize, (boolean)open_preallocate, (String)"", (ChecksumParams)open_checksumParams));
            }
            l2 = 0L;
            l = 0L;
        }
        long l3 = l;
        long l4 = l2;
        this.leaderEpochCache.ifPresent(x$3 -> x$3.truncateFromEnd(l3));
        this.leaderEpochCache.ifPresent(x$4 -> x$4.truncateFromStart($this.logStartOffsetCheckpoint, true));
        this.producerStateManager.removeStraySnapshots(this.segments.baseOffsets());
        LogSegment activeSegment = (LogSegment)this.segments.lastSegment().get();
        return new LoadedLogOffsets(l4, new LogOffsetMetadata(l3, activeSegment.baseOffset(), activeSegment.size()));
    }

    /*
     * WARNING - void declaration
     */
    private Set<File> removeTempFilesAndCollectSwapFiles() {
        void var6_6;
        void var5_5;
        scala.collection.mutable.Set swapFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set cleanedFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        LongRef minCleanedFileOffset = LongRef.create((long)Long.MAX_VALUE);
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            if (!file.canRead()) {
                throw new IOException(new StringBuilder(20).append("Could not read file ").append(file).toString());
            }
            String filename = file.getName();
            if (filename.endsWith(".deleted") && !filename.endsWith(Snapshots.DELETE_SUFFIX)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Deleting stray temporary file ").append(file.getAbsolutePath()).toString());
                return BoxesRunTime.boxToBoolean((boolean)FilesWrapper.deleteIfExists((Path)file.toPath()));
            }
            if (filename.endsWith(LocalLog$.MODULE$.CleanedFileSuffix())) {
                minCleanedFileOffset$1.elem = Math.min(Predef$.MODULE$.Long2long(LogFileUtils.offsetFromFile((File)file)), minCleanedFileOffset$1.elem);
                return cleanedFiles.$plus$eq(file);
            }
            if (filename.endsWith(LocalLog$.MODULE$.TierCleanedFileSuffix())) {
                return cleanedFiles.$plus$eq(file);
            }
            if (filename.endsWith(MergedLog$.MODULE$.SwapFileSuffix())) {
                return swapFiles.$plus$eq(file);
            }
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = swapFiles.partition((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$4(minCleanedFileOffset, file)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Set invalidSwapFiles = (scala.collection.mutable.Set)tuple2._1();
        scala.collection.mutable.Set validSwapFiles = (scala.collection.mutable.Set)tuple2._2();
        var5_5.foreach((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$5(this, minCleanedFileOffset, file)));
        cleanedFiles.foreach((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$7(this, file)));
        return var6_6;
    }

    /*
     * WARNING - void declaration
     */
    private <T> T retryOnOffsetOverflow(Function0<T> fn) {
        while (true) {
            try {
                return (T)fn.apply();
            }
            catch (LogSegmentOffsetOverflowException e) {
                void splitOverflowedSegment_logPrefix;
                void splitOverflowedSegment_logDirFailureChannel;
                void splitOverflowedSegment_scheduler;
                void splitOverflowedSegment_config;
                void splitOverflowedSegment_topicPartition;
                void splitOverflowedSegment_dir;
                void splitOverflowedSegment_existingSegments;
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                String string = this.logIdent();
                LogDirFailureChannel logDirFailureChannel = this.logDirFailureChannel;
                Scheduler scheduler = this.scheduler;
                LogConfig logConfig = this.config;
                TopicPartition topicPartition = this.topicPartition;
                File file = this.dir;
                LogSegments logSegments = this.segments;
                LogSegment splitOverflowedSegment_segment = e.segment;
                Object var4_4 = null;
                logSegments = null;
                file = null;
                topicPartition = null;
                logConfig = null;
                scheduler = null;
                logDirFailureChannel = null;
                string = null;
                SplitSegmentResult result = LocalLog$.MODULE$.splitOverflowedSegment(splitOverflowedSegment_segment, (LogSegments)splitOverflowedSegment_existingSegments, (File)splitOverflowedSegment_dir, (TopicPartition)splitOverflowedSegment_topicPartition, (LogConfig)splitOverflowedSegment_config, (Scheduler)splitOverflowedSegment_scheduler, (LogDirFailureChannel)splitOverflowedSegment_logDirFailureChannel, (String)splitOverflowedSegment_logPrefix);
                this.deleteProducerSnapshotsAsync(result.deletedSegments());
                continue;
            }
            break;
        }
    }

    private void loadSegmentFiles() {
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles()), (Function1 & Serializable)x$6 -> x$6.getName(), (Ordering)Ordering.String$.MODULE$)), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            if (LocalLog$.MODULE$.isIndexFile((File)file)) {
                long offset = Predef$.MODULE$.Long2long(LogFileUtils.offsetFromFile((File)file));
                if (!LogFileUtils.logFile((File)$this.dir, (long)offset, (String)"").exists()) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Found an orphaned index file ").append(file.getAbsolutePath()).append(", with no corresponding log file.").toString());
                    return BoxesRunTime.boxToBoolean((boolean)FilesWrapper.deleteIfExists((Path)file.toPath()));
                }
                return BoxedUnit.UNIT;
            }
            if (LocalLog$.MODULE$.isLogFile((File)file)) {
                long baseOffset = Predef$.MODULE$.Long2long(LogFileUtils.offsetFromFile((File)file));
                boolean timeIndexFileNewlyCreated = !LogFileUtils.timeIndexFile((File)$this.dir, (long)baseOffset, (String)"").exists();
                LogSegment segment = LogSegment.open((File)$this.dir, (long)baseOffset, (LogConfig)$this.config, (Time)$this.time, (boolean)true, (int)0, (boolean)false, (String)"", (ChecksumParams)$this.checksumParams);
                try {
                    segment.sanityCheck(timeIndexFileNewlyCreated);
                }
                catch (NoSuchFileException noSuchFileException) {
                    if ($this.hadCleanShutdown || segment.baseOffset() < $this.recoveryPointCheckpoint) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(109).append("Could not find offset index file corresponding to log file").append(" ").append(segment.log().file().getAbsolutePath()).append(", recovering segment and rebuilding index files...").toString());
                    }
                    this.recoverSegment(segment);
                }
                catch (CorruptIndexException e) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(114).append("Found a corrupted index file corresponding to log file").append(" ").append(segment.log().file().getAbsolutePath()).append(" due to ").append(e.getMessage()).append("}, recovering segment and").append(" rebuilding index files...").toString());
                    this.recoverSegment(segment);
                }
                return $this.segments.add(segment);
            }
            return BoxedUnit.UNIT;
        });
    }

    private int recoverSegment(LogSegment segment) {
        ProducerStateManager producerStateManager = new ProducerStateManager(this.topicPartition, this.dir, this.producerStateManager.maxTransactionTimeoutMs(), this.producerStateManager.producerStateManagerConfig(), this.time, Optional.empty(), this.checksumParams);
        MergedLog$.MODULE$.rebuildProducerState(producerStateManager, this.segments, this.logStartOffsetCheckpoint, segment.baseOffset(), this.config.recordVersion(), this.time, false, this.logIdent());
        int bytesTruncated = segment.recover(producerStateManager, this.leaderEpochCache);
        producerStateManager.takeSnapshot();
        return bytesTruncated;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Object, Object> recoverLog() {
        boolean bl;
        if (!this.hadCleanShutdown) {
            Collection unflushed = this.segments.values(this.recoveryPointCheckpoint, Long.MAX_VALUE);
            int numUnflushed = unflushed.size();
            Iterator<LogSegment> unflushedIter = unflushed.iterator();
            boolean truncated = false;
            IntRef numFlushed = IntRef.create((int)0);
            String threadName = Thread.currentThread().getName();
            this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)numUnflushed));
            while (unflushedIter.hasNext() && !truncated) {
                int n;
                LogSegment segment = (LogSegment)unflushedIter.next();
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Recovering unflushed segment ").append(segment.baseOffset()).append(". ").append(numFlushed$1.elem).append("/").append(numUnflushed).append(" recovered for ").append($this.topicPartition).append(".").toString());
                try {
                    n = this.recoverSegment(segment);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    long startOffset = segment.baseOffset();
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(114).append("Found invalid offset during recovery. Deleting the").append(" corrupt segment and creating an empty one with starting offset ").append(startOffset).toString());
                    n = segment.truncateTo(startOffset);
                }
                if (n > 0) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Corruption found in segment ").append(segment.baseOffset()).append(",").append(" truncating to offset ").append(segment.readNextOffset()).toString());
                    ArrayBuffer unflushedRemaining = new ArrayBuffer();
                    unflushedIter.forEachRemaining(s -> unflushedRemaining.$plus$eq(s));
                    this.removeAndDeleteSegmentsAsync((Iterable<LogSegment>)unflushedRemaining);
                    truncated = true;
                    this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)0));
                    continue;
                }
                ++numFlushed.elem;
                this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)(numUnflushed - numFlushed.elem)));
            }
        }
        Option logEndOffsetOption = this.deleteSegmentsIfLogStartGreaterThanLogEnd$1();
        if (this.segments.isEmpty()) {
            void open_checksumParams;
            void open_preallocate;
            void open_initFileSize;
            void open_time;
            void open_config;
            void open_baseOffset;
            ChecksumParams checksumParams = this.checksumParams;
            boolean bl2 = this.config.preallocate;
            int n = this.config.initFileSize();
            Time time = this.time;
            LogConfig logConfig = this.config;
            long l = this.logStartOffsetCheckpoint;
            File open_dir = this.dir;
            Object var18_17 = null;
            logConfig = null;
            time = null;
            checksumParams = null;
            LogSegment segment = LogSegment.open((File)open_dir, (long)open_baseOffset, (LogConfig)open_config, (Time)open_time, (boolean)false, (int)open_initFileSize, (boolean)open_preallocate, (String)"", (ChecksumParams)open_checksumParams);
            this.segments.add(segment);
        }
        if ((bl = this.hadCleanShutdown) && logEndOffsetOption instanceof Some) {
            long logEndOffset = BoxesRunTime.unboxToLong((Object)((Some)logEndOffsetOption).value());
            return new Tuple2.mcJJ.sp(logEndOffset, logEndOffset);
        }
        long logEndOffset = BoxesRunTime.unboxToLong((Object)logEndOffsetOption.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> ((LogSegment)$this.segments.lastSegment().get()).readNextOffset()));
        return new Tuple2.mcJJ.sp(Math.min(this.recoveryPointCheckpoint, logEndOffset), logEndOffset);
    }

    /*
     * WARNING - void declaration
     */
    private void removeAndDeleteSegmentsAsync(Iterable<LogSegment> segmentsToDelete) {
        if (segmentsToDelete.nonEmpty()) {
            void deleteSegmentFiles_logPrefix;
            void deleteSegmentFiles_logDirFailureChannel;
            void deleteSegmentFiles_scheduler;
            void deleteSegmentFiles_config;
            void deleteSegmentFiles_topicPartition;
            void deleteSegmentFiles_dir;
            List toDelete = segmentsToDelete.toList();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Deleting segments as part of log recovery: ").append(toDelete.mkString(",")).toString());
            toDelete.foreach((Function1 & Serializable)segment -> {
                this.segments.remove(segment.baseOffset());
                return BoxedUnit.UNIT;
            });
            String string = this.logIdent();
            LogDirFailureChannel logDirFailureChannel = this.logDirFailureChannel;
            Scheduler scheduler = this.scheduler;
            LogConfig logConfig = this.config;
            TopicPartition topicPartition = this.topicPartition;
            File file = this.dir;
            boolean deleteSegmentFiles_asyncDelete = true;
            LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable<LogSegment>)toDelete, deleteSegmentFiles_asyncDelete, (File)deleteSegmentFiles_dir, (TopicPartition)deleteSegmentFiles_topicPartition, (LogConfig)deleteSegmentFiles_config, (Scheduler)deleteSegmentFiles_scheduler, (LogDirFailureChannel)deleteSegmentFiles_logDirFailureChannel, (String)deleteSegmentFiles_logPrefix);
            file = null;
            topicPartition = null;
            logConfig = null;
            scheduler = null;
            logDirFailureChannel = null;
            string = null;
            this.deleteProducerSnapshotsAsync(segmentsToDelete);
            return;
        }
    }

    private void deleteProducerSnapshotsAsync(Iterable<LogSegment> segments) {
        MergedLog$.MODULE$.deleteProducerSnapshots(segments, this.producerStateManager, true, this.scheduler, this.config, this.logDirFailureChannel, this.dir.getParent(), this.topicPartition, this.checksumParams.checksumStoreOpt());
    }

    public static final /* synthetic */ boolean $anonfun$load$1(File f) {
        File isLogFile_file = new File(Utils.replaceSuffix((String)f.getPath(), (String)MergedLog$.MODULE$.SwapFileSuffix(), (String)""));
        return LocalLog$.MODULE$.isLogFile(isLogFile_file);
    }

    public static final /* synthetic */ void $anonfun$load$2(LogLoader $this, LongRef minSwapFileOffset$1, LongRef maxSwapFileOffset$1, File f) {
        long baseOffset = Predef$.MODULE$.Long2long(LogFileUtils.offsetFromFile((File)f));
        LogSegment segment = LogSegment.open((File)f.getParentFile(), (long)baseOffset, (LogConfig)$this.config, (Time)$this.time, (boolean)true, (int)0, (boolean)false, (String)MergedLog$.MODULE$.SwapFileSuffix(), (ChecksumParams)$this.checksumParams);
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(94).append("Found log file ").append(f.getPath()).append(" from interrupted swap operation, which is recoverable from ").append(MergedLog$.MODULE$.SwapFileSuffix()).append(" files by renaming.").toString());
        minSwapFileOffset$1.elem = Math.min(segment.baseOffset(), minSwapFileOffset$1.elem);
        maxSwapFileOffset$1.elem = Math.max(segment.readNextOffset(), maxSwapFileOffset$1.elem);
    }

    public static final /* synthetic */ void $anonfun$load$10(LogLoader $this) {
        $this.segments.close();
        $this.segments.clear();
        $this.loadSegmentFiles();
    }

    public static final /* synthetic */ Tuple2 $anonfun$load$11(LogLoader $this) {
        return $this.recoverLog();
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$4(LongRef minCleanedFileOffset$1, File file) {
        return Predef$.MODULE$.Long2long(LogFileUtils.offsetFromFile((File)file)) >= minCleanedFileOffset$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$5(LogLoader $this, LongRef minCleanedFileOffset$1, File file) {
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Deleting invalid swap file ").append(file.getAbsoluteFile()).append(" minCleanedFileOffset: ").append(minCleanedFileOffset$1.elem).toString());
        return FilesWrapper.deleteIfExists((Path)file.toPath());
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$7(LogLoader $this, File file) {
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Deleting stray .clean file ").append(file.getAbsolutePath()).toString());
        return FilesWrapper.deleteIfExists((Path)file.toPath());
    }

    private final Option deleteSegmentsIfLogStartGreaterThanLogEnd$1() {
        if (this.segments.nonEmpty()) {
            long logEndOffset = ((LogSegment)this.segments.lastSegment().get()).readNextOffset();
            if (logEndOffset >= this.logStartOffsetCheckpoint) {
                return new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
            }
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(148).append("Deleting all segments because logEndOffset (").append(logEndOffset).append(") ").append("is smaller than logStartOffset ").append($this.logStartOffsetCheckpoint).append(". ").append("This could happen if segment files were deleted from the file system.").toString());
            this.removeAndDeleteSegmentsAsync((Iterable<LogSegment>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.segments.values()).asScala());
            this.leaderEpochCache.ifPresent(x$7 -> x$7.clearAndFlush());
            this.producerStateManager.truncateFullyAndStartAt(this.logStartOffsetCheckpoint);
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public LogLoader(File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, Time time, LogDirFailureChannel logDirFailureChannel, boolean hadCleanShutdown, LogSegments segments, long logStartOffsetCheckpoint, long recoveryPointCheckpoint, Optional<LeaderEpochFileCache> leaderEpochCache, ProducerStateManager producerStateManager, ConcurrentMap<String, Object> numRemainingSegments, ChecksumParams checksumParams, boolean isRemoteLogEnabled) {
        this.dir = dir;
        this.topicPartition = topicPartition;
        this.config = config;
        this.scheduler = scheduler;
        this.time = time;
        this.logDirFailureChannel = logDirFailureChannel;
        this.hadCleanShutdown = hadCleanShutdown;
        this.segments = segments;
        this.logStartOffsetCheckpoint = logStartOffsetCheckpoint;
        this.recoveryPointCheckpoint = recoveryPointCheckpoint;
        this.leaderEpochCache = leaderEpochCache;
        this.producerStateManager = producerStateManager;
        this.numRemainingSegments = numRemainingSegments;
        this.checksumParams = checksumParams;
        this.logIdent_$eq(new StringBuilder(29).append("[LogLoader partition=").append(topicPartition).append(", dir=").append(dir.getParent()).append("] ").toString());
    }
}

