/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import kafka.metrics.LinuxIoMetricsCollector$;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005%c\u0001\u0002\u0010 \u0001\u0011B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\to\u0001\u0011)\u0019!C\u0001q!Aa\t\u0001B\u0001B\u0003%\u0011\b\u0003\u0005H\u0001\t\u0015\r\u0011\"\u0001I\u0011!y\u0005A!A!\u0002\u0013I\u0005\"\u0002)\u0001\t\u0003\t\u0006bB,\u0001\u0001\u0004%\t\u0001\u0017\u0005\b9\u0002\u0001\r\u0011\"\u0001^\u0011\u0019\u0019\u0007\u0001)Q\u00053\"9A\r\u0001a\u0001\n\u0003A\u0006bB3\u0001\u0001\u0004%\tA\u001a\u0005\u0007Q\u0002\u0001\u000b\u0015B-\t\u000f%\u0004\u0001\u0019!C\u00011\"9!\u000e\u0001a\u0001\n\u0003Y\u0007BB7\u0001A\u0003&\u0011\fC\u0004o\u0001\t\u0007I\u0011A8\t\ri\u0004\u0001\u0015!\u0003q\u0011\u0015Y\b\u0001\"\u0001}\u0011\u0015i\b\u0001\"\u0001}\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bAq!a\u0004\u0001\t\u0003\t\tbB\u0004\u0002.}A\t!a\f\u0007\ryy\u0002\u0012AA\u0019\u0011\u0019\u0001\u0006\u0004\"\u0001\u00024!I\u0011Q\u0007\rC\u0002\u0013\u0005\u0011q\u0007\u0005\t\u0003\u0007B\u0002\u0015!\u0003\u0002:!I\u0011Q\t\rC\u0002\u0013\u0005\u0011q\u0007\u0005\t\u0003\u000fB\u0002\u0015!\u0003\u0002:\t9B*\u001b8vq&{W*\u001a;sS\u000e\u001c8i\u001c7mK\u000e$xN\u001d\u0006\u0003A\u0005\nq!\\3ue&\u001c7OC\u0001#\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g\u0003!\u0001(o\\2S_>$\bCA\u00175\u001d\tq#\u0007\u0005\u00020O5\t\u0001G\u0003\u00022G\u00051AH]8pizJ!aM\u0014\u0002\rA\u0013X\rZ3g\u0013\t)dG\u0001\u0004TiJLgn\u001a\u0006\u0003g\u001d\nA\u0001^5nKV\t\u0011\b\u0005\u0002;\t6\t1H\u0003\u0002={\u0005)Q\u000f^5mg*\u0011ahP\u0001\u0007G>lWn\u001c8\u000b\u0005\t\u0002%BA!C\u0003\u0019\t\u0007/Y2iK*\t1)A\u0002pe\u001eL!!R\u001e\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\u0007Y><w-\u001a:\u0016\u0003%\u0003\"AS'\u000e\u0003-S!\u0001\u0014\"\u0002\u000bMdg\r\u000e6\n\u00059[%A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\rqJg.\u001b;?)\u0011\u0011F+\u0016,\u0011\u0005M\u0003Q\"A\u0010\t\u000b-2\u0001\u0019\u0001\u0017\t\u000b]2\u0001\u0019A\u001d\t\u000b\u001d3\u0001\u0019A%\u0002\u00191\f7\u000f^+qI\u0006$X-T:\u0016\u0003e\u0003\"A\n.\n\u0005m;#\u0001\u0002'p]\u001e\f\u0001\u0003\\1tiV\u0003H-\u0019;f\u001bN|F%Z9\u0015\u0005y\u000b\u0007C\u0001\u0014`\u0013\t\u0001wE\u0001\u0003V]&$\bb\u00022\t\u0003\u0003\u0005\r!W\u0001\u0004q\u0012\n\u0014!\u00047bgR,\u0006\u000fZ1uK6\u001b\b%A\bdC\u000eDW\r\u001a*fC\u0012\u0014\u0015\u0010^3t\u0003M\u0019\u0017m\u00195fIJ+\u0017\r\u001a\"zi\u0016\u001cx\fJ3r)\tqv\rC\u0004c\u0017\u0005\u0005\t\u0019A-\u0002!\r\f7\r[3e%\u0016\fGMQ=uKN\u0004\u0013\u0001E2bG\",Gm\u0016:ji\u0016\u0014\u0015\u0010^3t\u0003Q\u0019\u0017m\u00195fI^\u0013\u0018\u000e^3CsR,7o\u0018\u0013fcR\u0011a\f\u001c\u0005\bE:\t\t\u00111\u0001Z\u0003E\u0019\u0017m\u00195fI^\u0013\u0018\u000e^3CsR,7\u000fI\u0001\u0005a\u0006$\b.F\u0001q!\t\t\b0D\u0001s\u0015\t\u0019H/\u0001\u0003gS2,'BA;w\u0003\rq\u0017n\u001c\u0006\u0002o\u0006!!.\u0019<b\u0013\tI(O\u0001\u0003QCRD\u0017!\u00029bi\"\u0004\u0013!\u0003:fC\u0012\u0014\u0015\u0010^3t)\u0005I\u0016AC<sSR,')\u001f;fg\u0006aQ\u000f\u001d3bi\u00164\u0016\r\\;fgR!\u0011\u0011AA\u0004!\r1\u00131A\u0005\u0004\u0003\u000b9#a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003\u0013!\u0002\u0019A-\u0002\u00079|w/\u0001\u0004vg\u0006\u0014G.\u001a\u000b\u0003\u0003\u0003\tA#\\1zE\u0016\u0014VmZ5ti\u0016\u0014X*\u001a;sS\u000e\u001cHc\u00010\u0002\u0014!9\u0011Q\u0003\fA\u0002\u0005]\u0011\u0001\u0003:fO&\u001cHO]=\u0011\t\u0005e\u0011\u0011F\u0007\u0003\u00037QA!!\b\u0002 \u0005!1m\u001c:f\u0015\r\u0001\u0013\u0011\u0005\u0006\u0005\u0003G\t)#\u0001\u0004zC6lWM\u001d\u0006\u0003\u0003O\t1aY8n\u0013\u0011\tY#a\u0007\u0003\u001f5+GO]5dgJ+w-[:uef\fq\u0003T5okbLu.T3ue&\u001c7oQ8mY\u0016\u001cGo\u001c:\u0011\u0005MC2C\u0001\r&)\t\ty#A\tS\u000b\u0006#uLQ-U\u000bN{\u0006KU#G\u0013b+\"!!\u000f\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010w\u0003\u0011a\u0017M\\4\n\u0007U\ni$\u0001\nS\u000b\u0006#uLQ-U\u000bN{\u0006KU#G\u0013b\u0003\u0013AE,S\u0013R+uLQ-U\u000bN{\u0006KU#G\u0013b\u000b1c\u0016*J)\u0016{&)\u0017+F'~\u0003&+\u0012$J1\u0002\u0002")
public class LinuxIoMetricsCollector {
    private final Time time;
    private final Logger logger;
    private long lastUpdateMs;
    private long cachedReadBytes;
    private long cachedWriteBytes;
    private final Path path;

    public static String WRITE_BYTES_PREFIX() {
        return LinuxIoMetricsCollector$.MODULE$.WRITE_BYTES_PREFIX();
    }

    public static String READ_BYTES_PREFIX() {
        return LinuxIoMetricsCollector$.MODULE$.READ_BYTES_PREFIX();
    }

    public Time time() {
        return this.time;
    }

    public Logger logger() {
        return this.logger;
    }

    public long lastUpdateMs() {
        return this.lastUpdateMs;
    }

    public void lastUpdateMs_$eq(long x$1) {
        this.lastUpdateMs = x$1;
    }

    public long cachedReadBytes() {
        return this.cachedReadBytes;
    }

    public void cachedReadBytes_$eq(long x$1) {
        this.cachedReadBytes = x$1;
    }

    public long cachedWriteBytes() {
        return this.cachedWriteBytes;
    }

    public void cachedWriteBytes_$eq(long x$1) {
        this.cachedWriteBytes = x$1;
    }

    public Path path() {
        return this.path;
    }

    public synchronized long readBytes() {
        long curMs = this.time().milliseconds();
        if (curMs != this.lastUpdateMs()) {
            this.updateValues(curMs);
        }
        return this.cachedReadBytes();
    }

    public synchronized long writeBytes() {
        long curMs = this.time().milliseconds();
        if (curMs != this.lastUpdateMs()) {
            this.updateValues(curMs);
        }
        return this.cachedWriteBytes();
    }

    public synchronized boolean updateValues(long now) {
        try {
            this.cachedReadBytes_$eq(-1L);
            this.cachedWriteBytes_$eq(-1L);
            CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(this.path(), StandardCharsets.UTF_8)).asScala().foreach((Function1 & Serializable)line -> {
                LinuxIoMetricsCollector.$anonfun$updateValues$1(this, line);
                return BoxedUnit.UNIT;
            });
            this.lastUpdateMs_$eq(now);
            return true;
        }
        catch (Throwable t) {
            this.logger().warn("Unable to update IO metrics", t);
            return false;
        }
    }

    public boolean usable() {
        if (this.path().toFile().exists()) {
            return this.updateValues(this.time().milliseconds());
        }
        this.logger().debug(new StringBuilder(56).append("disabling IO metrics collection because ").append(this.path()).append(" does not exist.").toString());
        return false;
    }

    public void maybeRegisterMetrics(MetricsRegistry registry) {
        if (this.usable()) {
            LinuxIoMetricsCollector.registerGauge$1("linux-disk-read-bytes", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxIoMetricsCollector $outer;

                public final long value() {
                    LinuxIoMetricsCollector linuxIoMetricsCollector = this.$outer;
                    if (linuxIoMetricsCollector == null) {
                        throw null;
                    }
                    return linuxIoMetricsCollector.readBytes();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxIoMetricsCollector.registerGauge$1("linux-disk-write-bytes", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxIoMetricsCollector $outer;

                public final long value() {
                    LinuxIoMetricsCollector linuxIoMetricsCollector = this.$outer;
                    if (linuxIoMetricsCollector == null) {
                        throw null;
                    }
                    return linuxIoMetricsCollector.writeBytes();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateValues$1(LinuxIoMetricsCollector $this, String line) {
        if (line.startsWith(LinuxIoMetricsCollector$.MODULE$.READ_BYTES_PREFIX())) {
            $this.cachedReadBytes_$eq(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(line.substring(StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(LinuxIoMetricsCollector$.MODULE$.READ_BYTES_PREFIX()))))));
            return;
        }
        if (line.startsWith(LinuxIoMetricsCollector$.MODULE$.WRITE_BYTES_PREFIX())) {
            $this.cachedWriteBytes_$eq(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(line.substring(StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(LinuxIoMetricsCollector$.MODULE$.WRITE_BYTES_PREFIX()))))));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void registerGauge$1(String name, Gauge gauge2, MetricsRegistry registry$1) {
        void getMetricName_typeName;
        String string = "KafkaServer";
        String getMetricName_group = "kafka.server";
        Object var4_4 = null;
        string = null;
        MetricName metricName = KafkaYammerMetrics.getMetricName((String)getMetricName_group, (String)getMetricName_typeName, (String)name, null);
        registry$1.newGauge(metricName, gauge2);
    }

    public final /* synthetic */ long kafka$metrics$LinuxIoMetricsCollector$$$anonfun$maybeRegisterMetrics$1() {
        return this.readBytes();
    }

    public final /* synthetic */ long kafka$metrics$LinuxIoMetricsCollector$$$anonfun$maybeRegisterMetrics$3() {
        return this.writeBytes();
    }

    public LinuxIoMetricsCollector(String procRoot, Time time, Logger logger) {
        this.time = time;
        this.logger = logger;
        this.lastUpdateMs = -1L;
        this.cachedReadBytes = 0L;
        this.cachedWriteBytes = 0L;
        this.path = Paths.get(procRoot, "self", "io");
    }
}

