/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.util.Map;
import kafka.network.Processor;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.ProcessorQueueSizePercentiles;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAutoTuningQuota {
    protected final Logger logger;
    private volatile double max = Double.MAX_VALUE;
    private volatile double currentLimit = Double.MAX_VALUE;
    private volatile double floor = Double.MAX_VALUE;
    private volatile double lastCorrection = 0.0;
    private volatile double adjustment = 0.0;
    private volatile double connectionRateThrottleEnableThreshold = 0.0;
    private static final String PROCESSOR_QUEUE_SIZE_PERCENTILE = "p99";
    private final Sensor connectionRateThrottleSensor;
    private final Sensor connectionRateLimitSensor;

    AbstractAutoTuningQuota(Sensor connectionRateThrottleSensor, Sensor connectionRateLimitSensor) {
        this.connectionRateThrottleSensor = connectionRateThrottleSensor;
        this.connectionRateLimitSensor = connectionRateLimitSensor;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    protected void configure(String listenerName, Map<String, ?> configs) {
        this.configure(this.quotaName(listenerName), this.nextMax(configs), this.nextFloor(configs), this.nextStep(configs));
        this.connectionRateThrottleEnableThreshold = this.connectionRateThrottleEnableThreshold(configs);
    }

    protected void validate(Map<String, ?> configs) {
        double threshold = this.connectionRateThrottleEnableThreshold(configs);
        if (threshold < 0.0 || threshold > 1.0) {
            throw new ConfigException(String.format("Invalid ConnectionRateThrottleEnableThreshold %s", threshold));
        }
    }

    abstract String quotaName(String var1);

    abstract double nextMax(Map<String, ?> var1);

    abstract double nextFloor(Map<String, ?> var1);

    abstract double nextStep(Map<String, ?> var1);

    protected double connectionRateThrottleEnableThreshold(Map<String, ?> configs) {
        return 0.0;
    }

    void configure(String name, double nextMax, double nextFloor, double nextAdjustment) {
        this.logger.info("Quota {} configured - (max: {}, floor: {}, adjustment: {})", new Object[]{name, nextMax, nextFloor, nextAdjustment});
        if (nextMax > 0.0 && nextFloor >= 0.0 && nextAdjustment > 0.0) {
            this.adjustment = nextAdjustment;
            this.floor = Math.min(nextFloor, nextMax);
            double maxCorrection = nextMax != this.max ? 0.0 : Math.max(0.0, nextMax - this.floor);
            this.lastCorrection = Math.min(maxCorrection, this.lastCorrection);
            this.max = nextMax;
            this.currentLimit = Math.max(this.floor, this.max - this.lastCorrection);
        } else {
            this.max = Double.MAX_VALUE;
            this.currentLimit = Double.MAX_VALUE;
            this.floor = Double.MAX_VALUE;
            this.lastCorrection = 0.0;
        }
    }

    public double current() {
        return this.currentLimit;
    }

    protected double connectionRateThrottleEnableThreshold() {
        return this.connectionRateThrottleEnableThreshold;
    }

    protected Sensor connectionRateThrottleSensor() {
        return this.connectionRateThrottleSensor;
    }

    protected Sensor connectionRateLimitSensor() {
        return this.connectionRateLimitSensor;
    }

    protected boolean maybeAdjustConnectionRateQuota(ListenerName listener, Metrics metrics) {
        if (this.floor < this.max) {
            double backpressureThreshold;
            double queueSize = ProcessorQueueSizePercentiles.dataPlaneQueueSize(metrics, PROCESSOR_QUEUE_SIZE_PERCENTILE, Processor.ListenerMetricTag(), listener.value());
            double nextConnectionRateLimitCorrection = queueSize >= (backpressureThreshold = BrokerBackpressureConfig.DefaultMaxResourceUtilization() * (double)Processor.ConnectionQueueSize()) ? Math.min(Math.max(this.max - this.floor, 0.0), this.lastCorrection + this.adjustment) : Math.max(0.0, this.lastCorrection - this.adjustment);
            this.logger.debug("queueSize({})={}, lastConnectionRateLimitCorrection={}", new Object[]{PROCESSOR_QUEUE_SIZE_PERCENTILE, queueSize, nextConnectionRateLimitCorrection});
            if (nextConnectionRateLimitCorrection != this.lastCorrection) {
                this.lastCorrection = nextConnectionRateLimitCorrection;
                this.currentLimit = Math.max(this.max - nextConnectionRateLimitCorrection, this.floor);
                return true;
            }
        }
        return false;
    }
}

