/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.SimpleDateFormat;
import java.util.Date;
import kafka.restore.statemachine.api.State;

public class StateTransitionLog {
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @JsonProperty(value="time")
    String time;
    @JsonProperty(value="from")
    State from;
    @JsonProperty(value="to")
    State to;

    @JsonCreator
    public StateTransitionLog(@JsonProperty(value="from", required=true) State from, @JsonProperty(value="to", required=true) State to) {
        long timestamp = System.currentTimeMillis();
        Date date = new Date(timestamp);
        this.time = DATE_FORMAT.format(date) + " (" + timestamp + ")";
        this.from = from;
        this.to = to;
    }

    public String toString() {
        return this.time + ": " + this.from.toString() + " -> " + this.to.toString();
    }
}

