/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.transitions;

import java.util.Map;
import java.util.UUID;
import kafka.restore.MessageEmitter;
import kafka.restore.messages.RestoreFtpsResponse;
import kafka.restore.messages.RestoreObjectsInStoreRequest;
import kafka.restore.operators.SegmentStateAndPath;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.restore.statemachine.transitions.AbstractTransition;

public class FtpsFetchedToFtpsRepairedTransition
extends AbstractTransition {
    public FtpsFetchedToFtpsRepairedTransition(MessageEmitter messageEmitter) {
        super(messageEmitter);
    }

    @Override
    public State getSourceState() {
        return State.FTPS_FETCHED;
    }

    @Override
    public State getTargetState() {
        return State.FTPS_REPAIRED;
    }

    public boolean handleEvent(FiniteStateMachine fsm, Event event) {
        Object responseObject = event.getData("message_response");
        if (!(responseObject instanceof RestoreFtpsResponse)) {
            return false;
        }
        RestoreFtpsResponse response = (RestoreFtpsResponse)event.getData("message_response");
        Map<UUID, SegmentStateAndPath> segmentAndPathMap = response.getSegmentAndPathMap();
        fsm.addMetadata("restore_segment_map", segmentAndPathMap);
        fsm.addMetadata("restore_segment_map_size", segmentAndPathMap.size());
        RestoreObjectsInStoreRequest request = null;
        if (segmentAndPathMap == null || segmentAndPathMap.size() == 0) {
            return false;
        }
        request = new RestoreObjectsInStoreRequest(0, response.getTopic(), response.getPartition(), segmentAndPathMap);
        LOGGER.debug(String.format("[%s-%d]: %s handled the event, %s in queue", response.getTopic(), response.getPartition(), this.getName(), request.name()));
        this.messageEmitter.submitRequest(request);
        return true;
    }
}

