/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ActiveTenantsManager;
import kafka.server.AllRequests$;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.BrokerBackpressureMetrics$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientRequestQuotaManager$;
import kafka.server.ClientSensors;
import kafka.server.ExemptRequest$;
import kafka.server.NonExemptRequest$;
import kafka.server.QueueSizePercentiles;
import kafka.server.QuotaType$Request$;
import kafka.server.RequestQueueSizePercentiles$;
import kafka.server.RequestType;
import kafka.server.ThreadUsageMetrics$;
import kafka.server.ThreadUsageSensors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\rr!B\u00181\u0011\u0003)d!B\u001c1\u0011\u0003A\u0004\"B \u0002\t\u0003\u0001\u0005bB!\u0002\u0005\u0004%\tA\u0011\u0005\u0007\r\u0006\u0001\u000b\u0011B\"\t\u000f\u001d\u000b!\u0019!C\u0001\u0011\"1A*\u0001Q\u0001\n%Cq!T\u0001C\u0002\u0013%a\n\u0003\u0004X\u0003\u0001\u0006Ia\u0014\u0005\u00071\u0006!\t\u0001M-\u0007\t]\u0002\u0004\u0001\u0018\u0005\tA*\u0011)\u0019!C\u0005C\"AQM\u0003B\u0001B\u0003%!\r\u0003\u0005g\u0015\t\u0015\r\u0011\"\u0003h\u0011!!(B!A!\u0002\u0013A\u0007\"C;\u000b\u0005\u0003\u0005\u000b\u0011\u0002<}\u0011!i(B!b\u0001\n\u0013q\b\"CA\n\u0015\t\u0005\t\u0015!\u0003\u0000\u0011)\t)B\u0003BC\u0002\u0013%\u0011q\u0003\u0005\u000b\u0003[Q!\u0011!Q\u0001\n\u0005e\u0001BCA\u0018\u0015\t\u0005\t\u0015!\u0003\u00022!1qH\u0003C\u0001\u0003sA\u0011\"!\u0013\u000b\u0005\u0004%I!a\u0013\t\u0011\u0005M#\u0002)A\u0005\u0003\u001bB\u0001\"!\u0016\u000b\u0001\u0004%IA\u0011\u0005\n\u0003/R\u0001\u0019!C\u0005\u00033Bq!!\u001a\u000bA\u0003&1\tC\u0005\u0002h)\u0011\r\u0011\"\u0003\u0002j!A\u00111\u000f\u0006!\u0002\u0013\tY\u0007C\u0005\u0002v)\u0011\r\u0011\"\u0001\u0002x!A\u0011q\u0010\u0006!\u0002\u0013\tI\bC\u0004\u0002\u0002*!\t!a\u001e\t\u000f\u0005\r%\u0002\"\u0003\u0002\u0006\"9\u00111\u0013\u0006\u0005\n\u0005U\u0005bBAN\u0015\u0011\u0005\u0011Q\u0014\u0005\b\u0003CSA\u0011AAR\u0011\u001d\t9K\u0003C\u0001\u0003SCq!a3\u000b\t\u0003\ti\rC\u0004\u0002R*!\t%a5\t\u000f\u0005m'\u0002\"\u0011\u0002^\"1\u0011\u0011\u001e\u0006\u0005B\tCq!a;\u000b\t\u0013\ti\u000fC\u0004\u0002~*!I!a@\t\u0011\t%!\u0002\"\u00151\u0005\u0017AqAa\u0004\u000b\t\u0003\u0011\t\u0002C\u0004\u0003\u001c)!\tE!\b\t\u001b\t}!\u0002%A\u0002\u0002\u0003%IA!\t}\u0003e\u0019E.[3oiJ+\u0017/^3tiF+x\u000e^1NC:\fw-\u001a:\u000b\u0005E\u0012\u0014AB:feZ,'OC\u00014\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AN\u0001\u000e\u0003A\u0012\u0011d\u00117jK:$(+Z9vKN$\u0018+^8uC6\u000bg.Y4feN\u0011\u0011!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005)\u0014A\u0007(b]>\u001cHk\u001c)fe\u000e,g\u000e^1hKB+'oU3d_:$W#A\"\u0011\u0005i\"\u0015BA#<\u0005\u0019!u.\u001e2mK\u0006Yb*\u00198pgR{\u0007+\u001a:dK:$\u0018mZ3QKJ\u001cVmY8oI\u0002\n\u0001\u0007R3gCVdG/\u00138bGRLg/Z#yK6\u0004HoU3og>\u0014X\t\u001f9je\u0006$\u0018n\u001c8US6,7+Z2p]\u0012\u001cX#A%\u0011\u0005iR\u0015BA&<\u0005\u0011auN\\4\u0002c\u0011+g-Y;mi&s\u0017m\u0019;jm\u0016,\u00050Z7qiN+gn]8s\u000bb\u0004\u0018N]1uS>tG+[7f'\u0016\u001cwN\u001c3tA\u0005\u0001R\t_3naR\u001cVM\\:pe:\u000bW.Z\u000b\u0002\u001fB\u0011\u0001+V\u0007\u0002#*\u0011!kU\u0001\u0005Y\u0006twMC\u0001U\u0003\u0011Q\u0017M^1\n\u0005Y\u000b&AB*ue&tw-A\tFq\u0016l\u0007\u000f^*f]N|'OT1nK\u0002\n\u0011C\\1o_N$v\u000eU3sG\u0016tG/Y4f)\t\u0019%\fC\u0003\\\u0013\u0001\u0007\u0011*A\u0003oC:|7o\u0005\u0002\u000b;B\u0011aGX\u0005\u0003?B\u0012!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\u000611m\u001c8gS\u001e,\u0012A\u0019\t\u0003m\rL!\u0001\u001a\u0019\u00031\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u000f5,GO]5dgV\t\u0001\u000e\u0005\u0002je6\t!N\u0003\u0002gW*\u0011A.\\\u0001\u0007G>lWn\u001c8\u000b\u0005Mr'BA8q\u0003\u0019\t\u0007/Y2iK*\t\u0011/A\u0002pe\u001eL!a\u001d6\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0003uS6,\u0007CA<{\u001b\u0005A(BA=l\u0003\u0015)H/\u001b7t\u0013\tY\bP\u0001\u0003US6,\u0017BA;_\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u00070F\u0001\u0000!\u0011\t\t!a\u0004\u000f\t\u0005\r\u00111\u0002\t\u0004\u0003\u000bYTBAA\u0004\u0015\r\tI\u0001N\u0001\u0007yI|w\u000e\u001e \n\u0007\u000551(\u0001\u0004Qe\u0016$WMZ\u0005\u0004-\u0006E!bAA\u0007w\u0005\tB\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u0011\u0002'\rd\u0017.\u001a8u#V|G/Y\"bY2\u0014\u0017mY6\u0016\u0005\u0005e\u0001#\u0002\u001e\u0002\u001c\u0005}\u0011bAA\u000fw\t1q\n\u001d;j_:\u0004B!!\t\u0002*5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0003rk>$\u0018M\u0003\u00022[&!\u00111FA\u0012\u0005M\u0019E.[3oiF+x\u000e^1DC2d'-Y2l\u0003Q\u0019G.[3oiF+x\u000e^1DC2d'-Y2lA\u0005!\u0012m\u0019;jm\u0016$VM\\1oiNl\u0015M\\1hKJ\u0004RAOA\u000e\u0003g\u00012ANA\u001b\u0013\r\t9\u0004\r\u0002\u0015\u0003\u000e$\u0018N^3UK:\fg\u000e^:NC:\fw-\u001a:\u0015\u001d\u0005m\u0012QHA \u0003\u0003\n\u0019%!\u0012\u0002HA\u0011aG\u0003\u0005\u0006AV\u0001\rA\u0019\u0005\u0006MV\u0001\r\u0001\u001b\u0005\u0006kV\u0001\rA\u001e\u0005\u0006{V\u0001\ra \u0005\b\u0003+)\u0002\u0019AA\r\u0011\u001d\ty#\u0006a\u0001\u0003c\t!\u0003\u001e5sK\u0006$Wk]1hKN+gn]8sgV\u0011\u0011Q\n\t\u0004m\u0005=\u0013bAA)a\t\u0011B\u000b\u001b:fC\u0012,6/Y4f'\u0016t7o\u001c:t\u0003M!\bN]3bIV\u001b\u0018mZ3TK:\u001cxN]:!\u0003Ma\u0017m\u001d;MS6LGoQ8se\u0016\u001cG/[8o\u0003]a\u0017m\u001d;MS6LGoQ8se\u0016\u001cG/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002\\\u0005\u0005\u0004c\u0001\u001e\u0002^%\u0019\u0011qL\u001e\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003GJ\u0012\u0011!a\u0001\u0007\u0006\u0019\u0001\u0010J\u0019\u0002)1\f7\u000f\u001e'j[&$8i\u001c:sK\u000e$\u0018n\u001c8!\u0003A)\u00070Z7qi6+GO]5d\u001d\u0006lW-\u0006\u0002\u0002lA!\u0011QNA8\u001b\u0005Y\u0017bAA9W\nQQ*\u001a;sS\u000et\u0015-\\3\u0002#\u0015DX-\u001c9u\u001b\u0016$(/[2OC6,\u0007%\u0001\u0007fq\u0016l\u0007\u000f^*f]N|'/\u0006\u0002\u0002zA\u0019\u0011.a\u001f\n\u0007\u0005u$N\u0001\u0004TK:\u001cxN]\u0001\u000eKb,W\u000e\u001d;TK:\u001cxN\u001d\u0011\u0002/9|g.\u0012=f[B$8)\u00199bG&$\u0018pU3og>\u0014\u0018!\u0007:fG>\u0014H-\u0012=f[B$h*\u001a;x_J\\G\u000b\u001b:fC\u0012$\u0002\"a\u0017\u0002\b\u0006-\u0015q\u0012\u0005\u0007\u0003\u0013\u0003\u0003\u0019A\"\u0002\u000bY\fG.^3\t\r\u00055\u0005\u00051\u0001\u0000\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f\u0011\u0019\t\t\n\ta\u0001\u0013\u00061A/[7f\u001bN\fAC]3d_J$W\t_3naRLu\u000e\u00165sK\u0006$GCBA.\u0003/\u000bI\n\u0003\u0004\u0002\n\u0006\u0002\ra\u0011\u0005\u0007\u0003#\u000b\u0003\u0019A%\u0002%\u0005$G\rT5ti\u0016tWM]'fiJL7m\u001d\u000b\u0005\u00037\ny\n\u0003\u0004\u0002\u000e\n\u0002\ra`\u0001\u0016e\u0016lwN^3MSN$XM\\3s\u001b\u0016$(/[2t)\u0011\tY&!*\t\r\u000555\u00051\u0001\u0000\u0003}i\u0017-\u001f2f%\u0016\u001cwN\u001d3B]\u0012<U\r\u001e+ie>$H\u000f\\3US6,Wj\u001d\u000b\u0007\u0003W\u000b\t,!3\u0011\u0007i\ni+C\u0002\u00020n\u00121!\u00138u\u0011\u001d\t\u0019\f\na\u0001\u0003k\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0003\u00028\u0006\rg\u0002BA]\u0003\u007fk!!a/\u000b\u0007\u0005u&'A\u0004oKR<xN]6\n\t\u0005\u0005\u00171X\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\t)-a2\u0003\u000fI+\u0017/^3ti*!\u0011\u0011YA^\u0011\u0019\t\t\n\na\u0001\u0013\u0006\tR.Y=cKJ+7m\u001c:e\u000bb,W\u000e\u001d;\u0015\t\u0005m\u0013q\u001a\u0005\b\u0003g+\u0003\u0019AA[\u0003M\u0011\u0017mY6qe\u0016\u001c8/\u001e:f\u000b:\f'\r\\3e+\t\t)\u000eE\u0002;\u0003/L1!!7<\u0005\u001d\u0011un\u001c7fC:\fAc\u00197jK:$(+\u0019;f\u001b\u0016$(/[2OC6,G\u0003BA6\u0003?Dq!!9(\u0001\u0004\t\u0019/A\brk>$\u0018-T3ue&\u001cG+Y4t!\u0019\t\t!!:\u0000\u007f&!\u0011q]A\t\u0005\ri\u0015\r]\u0001\u0014O\u0016$(I]8lKJ\fVo\u001c;b\u0019&l\u0017\u000e^\u0001\u0014e\u0016\u001cwN\u001d3J_RC'/Z1e+N\fw-\u001a\u000b\t\u00037\ny/!=\u0002|\"1\u0011\u0011R\u0015A\u0002\rCq!a=*\u0001\u0004\t)0A\u0006sKF,Xm\u001d;UsB,\u0007c\u0001\u001c\u0002x&\u0019\u0011\u0011 \u0019\u0003\u0017I+\u0017/^3tiRK\b/\u001a\u0005\u0007\u0003#K\u0003\u0019A%\u0002%I,7m\u001c:e\u001d\u0016$xo\u001c:l+N\fw-\u001a\u000b\u000b\u00037\u0012\tAa\u0001\u0003\u0006\t\u001d\u0001BBAEU\u0001\u00071\t\u0003\u0004\u0002\u000e*\u0002\ra \u0005\b\u0003gT\u0003\u0019AA{\u0011\u0019\t\tJ\u000ba\u0001\u0013\u00061R\u000f\u001d3bi\u0016\u0014%o\\6feF+x\u000e^1MS6LG\u000f\u0006\u0003\u0002\\\t5\u0001BBAIW\u0001\u0007\u0011*\u0001\fva\u0012\fG/Z!eUV\u001cH/\u001a3DCB\f7-\u001b;z)\u0015\u0019%1\u0003B\f\u0011\u0019\u0011)\u0002\fa\u0001\u0007\u0006\u0011\"M]8lKJ\u0014V-];fgRd\u0015.\\5u\u0011\u0019\u0011I\u0002\fa\u0001\u0007\u0006Ibn\u001c8Fq\u0016l\u0007\u000f\u001e+pi\u0006dG\u000b\u001b:fC\u0012d\u0015.\\5u\u0003!\u0019\b.\u001e;e_^tGCAA.\u0003)\u0019X\u000f]3sIQLW.Z\u000b\u0002m\u0002")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> clientQuotaCallback;
    private final ThreadUsageSensors threadUsageSensors;
    private double lastLimitCorrection;
    private final MetricName exemptMetricName;
    private final Sensor exemptSensor;

    public static long DefaultInactiveExemptSensorExpirationTimeSeconds() {
        return ClientRequestQuotaManager$.MODULE$.DefaultInactiveExemptSensorExpirationTimeSeconds();
    }

    public static double NanosToPercentagePerSecond() {
        return ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond();
    }

    private /* synthetic */ Time super$time() {
        return super.time();
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> clientQuotaCallback() {
        return this.clientQuotaCallback;
    }

    private ThreadUsageSensors threadUsageSensors() {
        return this.threadUsageSensors;
    }

    private double lastLimitCorrection() {
        return this.lastLimitCorrection;
    }

    private void lastLimitCorrection_$eq(double x$1) {
        this.lastLimitCorrection = x$1;
    }

    private MetricName exemptMetricName() {
        return this.exemptMetricName;
    }

    public Sensor exemptSensor() {
        return this.exemptSensor;
    }

    public Sensor nonExemptCapacitySensor() {
        return this.getOrCreateValueSensor("non-exempt-capacity", BrokerBackpressureMetrics$.MODULE$.nonExemptRequestCapacityMetricName(this.metrics()));
    }

    private void recordExemptNetworkThread(double value, String listenerName, long timeMs) {
        this.exemptSensor().record(value, timeMs, false);
        this.recordNetworkUsage(value, listenerName, ExemptRequest$.MODULE$, timeMs);
    }

    private void recordExemptIoThread(double value, long timeMs) {
        this.exemptSensor().record(value, timeMs, false);
        this.recordIoThreadUsage(value, ExemptRequest$.MODULE$, timeMs);
    }

    public void addListenerMetrics(String listenerName) {
        this.threadUsageSensors().addListenerMetrics(listenerName);
    }

    public void removeListenerMetrics(String listenerName) {
        this.threadUsageSensors().removeListenerMetrics(listenerName);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request, long timeMs) {
        double reqIoThreadPercentage = (double)request.requestThreadTimeNanos() * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
        String listenerName = request.context().listenerName.value();
        this.recordIoThreadUsage(reqIoThreadPercentage, NonExemptRequest$.MODULE$, timeMs);
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(request.session(), request.header().clientId());
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> {
                long timeMs = this.super$time().milliseconds();
                this.recordNoThrottle(clientSensors, (double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), timeMs);
                this.recordNetworkUsage((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), listenerName, NonExemptRequest$.MODULE$, timeMs);
            }));
            return this.recordAndGetThrottleTimeMs(clientSensors, reqIoThreadPercentage, timeMs);
        }
        request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> this.recordNetworkUsage((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), listenerName, NonExemptRequest$.MODULE$, this.super$time().milliseconds())));
        return 0;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        long currentTimeMs = super.time().milliseconds();
        double reqIoThreadPercentage = (double)request.requestThreadTimeNanos() * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
        String listenerName = request.context().listenerName.value();
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> this.recordExemptNetworkThread((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), listenerName, this.super$time().milliseconds())));
            this.recordExemptIoThread(reqIoThreadPercentage, currentTimeMs);
            return;
        }
        request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> this.recordNetworkUsage((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), listenerName, ExemptRequest$.MODULE$, this.super$time().milliseconds())));
        this.recordIoThreadUsage(reqIoThreadPercentage, ExemptRequest$.MODULE$, currentTimeMs);
    }

    @Override
    public boolean backpressureEnabled() {
        return this.dynamicBackpressureConfig().backpressureEnabledInConfig() && this.dynamicBackpressureConfig().tenantEndpointListenerNames().nonEmpty();
    }

    @Override
    public MetricName clientRateMetricName(scala.collection.immutable.Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", "Request", "Tracking request-time per user/client-id", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    @Override
    public double getBrokerQuotaLimit() {
        Option metricOpt = Option$.MODULE$.apply((Object)this.metrics().metric(BrokerBackpressureMetrics$.MODULE$.nonExemptRequestCapacityMetricName(this.metrics())));
        if (metricOpt instanceof Some) {
            return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((Some)metricOpt).value()).metricValue());
        }
        return Double.MAX_VALUE;
    }

    private void recordIoThreadUsage(double value, RequestType requestType, long timeMs) {
        if (this.quotasEnabled()) {
            this.threadUsageSensors().recordIoThreadUsage(value, timeMs, requestType);
            return;
        }
        this.threadUsageSensors().recordIoThreadUsage(value, timeMs, AllRequests$.MODULE$);
    }

    private void recordNetworkUsage(double value, String listenerName, RequestType requestType, long timeMs) {
        if (this.quotasEnabled()) {
            this.threadUsageSensors().recordNetworkThreadUsage(value, timeMs, listenerName, requestType);
            return;
        }
        this.threadUsageSensors().recordNetworkThreadUsage(value, timeMs, listenerName, AllRequests$.MODULE$);
    }

    @Override
    public void updateBrokerQuotaLimit(long timeMs) {
        Seq<String> tenantEndpointsListenerNames = this.dynamicBackpressureConfig().tenantEndpointListenerNames();
        if (this.quotasEnabled() && tenantEndpointsListenerNames.nonEmpty()) {
            double nonExemptIoThreadUsage = ThreadUsageMetrics$.MODULE$.ioThreadsUsage(this.metrics(), NonExemptRequest$.MODULE$);
            double ioThreadUsage = ThreadUsageMetrics$.MODULE$.ioThreadsUsage(this.metrics(), AllRequests$.MODULE$);
            double nonExemptNetworkThreadUsage = ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), tenantEndpointsListenerNames, NonExemptRequest$.MODULE$);
            double networkThreadUsage = ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), tenantEndpointsListenerNames, AllRequests$.MODULE$);
            double nonExemptIoThreadLimit = ClientRequestQuotaManager.nonExemptThreadUsageLimit$1(nonExemptIoThreadUsage, ioThreadUsage, ThreadUsageMetrics$.MODULE$.ioThreadsCapacity(this.metrics()));
            double nonExemptNetworkThreadLimit = ClientRequestQuotaManager.nonExemptThreadUsageLimit$1(nonExemptNetworkThreadUsage, networkThreadUsage, ThreadUsageMetrics$.MODULE$.networkThreadsCapacity(this.metrics(), tenantEndpointsListenerNames));
            double nonExemptTotalThreadLimit = nonExemptIoThreadLimit + nonExemptNetworkThreadLimit;
            double brokerRequestQuotaLimit = ioThreadUsage >= nonExemptIoThreadLimit && networkThreadUsage >= nonExemptNetworkThreadLimit || ioThreadUsage < nonExemptIoThreadLimit && networkThreadUsage < nonExemptNetworkThreadLimit ? nonExemptTotalThreadLimit : package$.MODULE$.min(networkThreadUsage, nonExemptNetworkThreadLimit) + package$.MODULE$.min(ioThreadUsage, nonExemptIoThreadLimit);
            double correctedLimit = this.updateAdjustedCapacity(brokerRequestQuotaLimit, nonExemptTotalThreadLimit);
            this.nonExemptCapacitySensor().record(correctedLimit);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public double updateAdjustedCapacity(double brokerRequestLimit, double nonExemptTotalThreadLimit) {
        double d;
        void dataPlaneQueueSize_tags;
        void dataPlaneQueueSize_percentileSuffix;
        void dataPlaneQueueSize_metrics;
        Map map = (Map)Map$.MODULE$.empty();
        String string = this.dynamicBackpressureConfig().queueSizePercentile();
        Metrics metrics = this.metrics();
        RequestQueueSizePercentiles$ dataPlaneQueueSize_this = RequestQueueSizePercentiles$.MODULE$;
        Object var17_6 = null;
        metrics = null;
        string = null;
        map = null;
        double queueSize = QueueSizePercentiles.dataPlaneQueueSize$(dataPlaneQueueSize_this, (Metrics)dataPlaneQueueSize_metrics, (String)dataPlaneQueueSize_percentileSuffix, (Map)dataPlaneQueueSize_tags);
        double minAdjustment = BrokerBackpressureConfig$.MODULE$.RequestQuotaMinAdjustment();
        double increaseAdjustment = package$.MODULE$.max(minAdjustment, nonExemptTotalThreadLimit * BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaIncreasePercentFactor());
        double decreaseAdjustment = package$.MODULE$.max(minAdjustment, nonExemptTotalThreadLimit * BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaDecreasePercentFactor());
        double minCap = this.dynamicBackpressureConfig().minBrokerRequestQuota();
        if (queueSize >= this.dynamicBackpressureConfig().queueSizeCap()) {
            double maxAdjustmentLimit = package$.MODULE$.max(brokerRequestLimit - minCap, 0.0);
            d = package$.MODULE$.min(maxAdjustmentLimit, this.lastLimitCorrection() + decreaseAdjustment);
        } else {
            d = package$.MODULE$.max(0.0, this.lastLimitCorrection() - increaseAdjustment);
        }
        this.lastLimitCorrection_$eq(d);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("queueSize(p95)=").append(queueSize).append(",  lastLimitCorrection=").append(this.lastLimitCorrection()).toString());
        return package$.MODULE$.max(brokerRequestLimit - this.lastLimitCorrection(), minCap);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.threadUsageSensors().close();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$exemptSensor$1(ClientRequestQuotaManager $this, Sensor sensor) {
        void add_stat;
        void add_metricName;
        Rate rate = new Rate();
        MetricName metricName = $this.exemptMetricName();
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }

    private static final double nonExemptThreadUsageLimit$1(double nonExemptUsage, double totalUsage, double totalCapacity) {
        double exemptUsage = totalUsage - nonExemptUsage;
        double nonExemptCapacity = totalCapacity * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization() - exemptUsage;
        double minNonExemptCapacity = totalCapacity * BrokerBackpressureConfig$.MODULE$.DefaultMinNonExemptRequestUtilization();
        return package$.MODULE$.max(nonExemptCapacity, minNonExemptCapacity);
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> clientQuotaCallback, Option<ActiveTenantsManager> activeTenantsManager) {
        this.config = config;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.clientQuotaCallback = clientQuotaCallback;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix, clientQuotaCallback, activeTenantsManager);
        this.threadUsageSensors = new ThreadUsageSensors(metrics);
        this.lastLimitCorrection = 0.0;
        super.updateClientQuotaMaxThrottleTimeMs(TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds()));
        this.exemptMetricName = metrics.metricName("exempt-request-time", "Request", "Tracking exempt-request-time utilization percentage");
        this.exemptSensor = this.getOrCreateSensor(ClientRequestQuotaManager$.MODULE$.kafka$server$ClientRequestQuotaManager$$ExemptSensorName(), ClientRequestQuotaManager$.MODULE$.DefaultInactiveExemptSensorExpirationTimeSeconds(), (Function1<Sensor, BoxedUnit>)(Function1 & Serializable)sensor -> {
            ClientRequestQuotaManager.$anonfun$exemptSensor$1(this, sensor);
            return BoxedUnit.UNIT;
        });
    }
}

