/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.TierLogSegment;
import kafka.server.Fetching$;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaState;
import kafka.server.TierMaterializationRequirements;
import kafka.server.TierState;
import kafka.server.TierStateMachine;
import kafka.tier.exceptions.TierPartitionStateClosedException;
import kafka.utils.CoreUtils$;
import kafka.utils.DelayedItem;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.utils.ExponentialBackoff;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rec\u0001B&M\u0001EC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tQ\u0002\u0011\t\u0011)A\u0005S\"AA\u000e\u0001B\u0001B\u0003%Q\u000eC\u0003z\u0001\u0011\u0005!\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011\u0001\u0005\b\u0003\u0013\u0002A\u0011IA&\u0011!\ty\u0006\u0001C\u0001\u0019\u0006\u0005\u0004\u0002CAG\u0001\u0011\u0005A*a$\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"911\u0007\u0001\u0005\n\rU\u0002\u0002CB \u0001\u0011\u0005Aj!\u0011\t\u0011\rE\u0003\u0001\"\u0001M\u0007':q!!1M\u0011\u0003\t\u0019M\u0002\u0004L\u0019\"\u0005\u0011Q\u0019\u0005\u0007s:!\t!!4\u0007\r\u0005=g\u0002QAi\u0011)\t\t\u0010\u0005BK\u0002\u0013\u0005\u00111\u001f\u0005\u000b\u0003k\u0004\"\u0011#Q\u0001\n\u0005\r\u0004BCA|!\tU\r\u0011\"\u0001\u0002z\"Q\u00111 \t\u0003\u0012\u0003\u0006I!!!\t\u0015\u0005u\bC!f\u0001\n\u0003\ty\u0010\u0003\u0006\u0003\u0002A\u0011\t\u0012)A\u0005\u0003'Da!\u001f\t\u0005\u0002\t\r\u0001\"\u0003B\b!\u0005\u0005I\u0011\u0001B\t\u0011%\u0011I\u0002EI\u0001\n\u0003\u0011Y\u0002C\u0005\u00032A\t\n\u0011\"\u0001\u00034!I!q\u0007\t\u0012\u0002\u0013\u0005!\u0011\b\u0005\n\u0005{\u0001\u0012\u0011!C!\u0005\u007fA\u0011Ba\u0012\u0011\u0003\u0003%\tA!\u0013\t\u0013\t-\u0003#!A\u0005\u0002\t5\u0003\"\u0003B-!\u0005\u0005I\u0011\tB.\u0011%\u0011I\u0007EA\u0001\n\u0003\u0011Y\u0007C\u0005\u0003vA\t\t\u0011\"\u0011\u0003x!I!1\u0010\t\u0002\u0002\u0013\u0005#Q\u0010\u0005\n\u0005\u007f\u0002\u0012\u0011!C!\u0005\u0003C\u0011Ba!\u0011\u0003\u0003%\tE!\"\b\u0013\t%e\"!A\t\u0002\t-e!CAh\u001d\u0005\u0005\t\u0012\u0001BG\u0011\u0019Ih\u0005\"\u0001\u0003&\"I!q\u0010\u0014\u0002\u0002\u0013\u0015#\u0011\u0011\u0005\n\u0005O3\u0013\u0011!CA\u0005SC\u0011B!-'\u0003\u0003%\tIa-\t\u0013\t\u0015g%!A\u0005\n\t\u001dgA\u0002Bf\u001d\u0001\u0013i\r\u0003\u0006\u0002r2\u0012)\u001a!C\u0001\u0005\u001fD!\"!>-\u0005#\u0005\u000b\u0011\u0002Bi\u0011)\u0011I\u000e\fBK\u0002\u0013\u0005!1\u001c\u0005\u000b\u0005;d#\u0011#Q\u0001\n\u0005=\u0004BCA|Y\tU\r\u0011\"\u0001\u0002z\"Q\u00111 \u0017\u0003\u0012\u0003\u0006I!!!\t\u0015\u0005uHF!f\u0001\n\u0003\ty\u0010\u0003\u0006\u0003\u00021\u0012\t\u0012)A\u0005\u0003'Da!\u001f\u0017\u0005\u0002\t}\u0007\"\u0003B\bY\u0005\u0005I\u0011\u0001Bv\u0011%\u0011I\u0002LI\u0001\n\u0003\u0011)\u0010C\u0005\u000321\n\n\u0011\"\u0001\u0003z\"I!q\u0007\u0017\u0012\u0002\u0013\u0005!1\u0007\u0005\n\u0005{d\u0013\u0013!C\u0001\u0005sA\u0011B!\u0010-\u0003\u0003%\tEa\u0010\t\u0013\t\u001dC&!A\u0005\u0002\t%\u0003\"\u0003B&Y\u0005\u0005I\u0011\u0001B\u0000\u0011%\u0011I\u0006LA\u0001\n\u0003\u0012Y\u0006C\u0005\u0003j1\n\t\u0011\"\u0001\u0004\u0004!I!Q\u000f\u0017\u0002\u0002\u0013\u00053q\u0001\u0005\n\u0005wb\u0013\u0011!C!\u0005{B\u0011Ba -\u0003\u0003%\tE!!\t\u0013\t\rE&!A\u0005B\r-q!CB\b\u001d\u0005\u0005\t\u0012AB\t\r%\u0011YMDA\u0001\u0012\u0003\u0019\u0019\u0002\u0003\u0004z\u000b\u0012\u000511\u0004\u0005\n\u0005\u007f*\u0015\u0011!C#\u0005\u0003C\u0011Ba*F\u0003\u0003%\ti!\b\t\u0013\tEV)!A\u0005\u0002\u000e\u001d\u0002\"\u0003Bc\u000b\u0006\u0005I\u0011\u0002Bd\u0005\u001d\u001auN\u001c4mk\u0016tGOU3qY&\u001c\u0017MR3uG\",'\u000fV5feN#\u0018\r^3NC\u000eD\u0017N\\3\u000b\u00055s\u0015AB:feZ,'OC\u0001P\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001*[=B\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\u0005Y\u0006twMC\u0001X\u0003\u0011Q\u0017M^1\n\u0005e#&AB(cU\u0016\u001cG\u000f\u0005\u0002\\96\tA*\u0003\u0002^\u0019\n\u0001B+[3s'R\fG/Z'bG\"Lg.\u001a\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C:\u000bQ!\u001e;jYNL!a\u00191\u0003\u000f1{wmZ5oO\u00061A.Z1eKJ\u0004\"a\u00174\n\u0005\u001dd%A\u0004'fC\u0012,'/\u00128e!>Lg\u000e^\u0001\u000be\u0016\u0004H.[2b\u001b\u001e\u0014\bCA.k\u0013\tYGJ\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002%\u0015D\bo\u001c8f]RL\u0017\r\u001c\"bG.|gM\u001a\t\u0003]^l\u0011a\u001c\u0006\u0003CBT!!\u001d:\u0002\r\r|W.\\8o\u0015\ty5O\u0003\u0002uk\u00061\u0011\r]1dQ\u0016T\u0011A^\u0001\u0004_J<\u0017B\u0001=p\u0005I)\u0005\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4\u0002\rqJg.\u001b;?)\u0011YH0 @\u0011\u0005m\u0003\u0001\"\u00023\u0005\u0001\u0004)\u0007\"\u00025\u0005\u0001\u0004I\u0007\"\u00027\u0005\u0001\u0004i\u0017!B:uCJ$H\u0003CA\u0002\u0003\u0013\t)\"!\u0007\u0011\u0007m\u000b)!C\u0002\u0002\b1\u00131\u0003U1si&$\u0018n\u001c8GKR\u001c\u0007n\u0015;bi\u0016Dq!a\u0003\u0006\u0001\u0004\ti!\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005=\u0011\u0011C\u0007\u0002a&\u0019\u00111\u00039\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011qC\u0003A\u0002\u0005\r\u0011!E2veJ,g\u000e\u001e$fi\u000eD7\u000b^1uK\"9\u00111D\u0003A\u0002\u0005u\u0011A\u00054fi\u000eD\u0007+\u0019:uSRLwN\u001c#bi\u0006\u0004B!a\b\u0002D9!\u0011\u0011EA\u001f\u001d\u0011\t\u0019#!\u000f\u000f\t\u0005\u0015\u0012q\u0007\b\u0005\u0003O\t)D\u0004\u0003\u0002*\u0005Mb\u0002BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=\u0002+\u0001\u0004=e>|GOP\u0005\u0002m&\u0011A/^\u0005\u0003\u001fNL!!\u001d:\n\u0007\u0005m\u0002/A\u0004nKN\u001c\u0018mZ3\n\t\u0005}\u0012\u0011I\u0001\u0012\r\u0016$8\r\u001b*fgB|gn]3ECR\f'bAA\u001ea&!\u0011QIA$\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*!\u0011qHA!\u0003Ei\u0017-\u001f2f\u0003\u00124\u0018M\\2f'R\fG/\u001a\u000b\u0007\u0003\u001b\nI&!\u0018\u0011\r\u0005=\u0013QKA\u0002\u001b\t\t\tFC\u0002\u0002TY\u000bA!\u001e;jY&!\u0011qKA)\u0005!y\u0005\u000f^5p]\u0006d\u0007bBA.\r\u0001\u0007\u0011QB\u0001\u0003iBDq!a\u0006\u0007\u0001\u0004\t\u0019!A\u0010nCR,'/[1mSj,G+[3s'R\fG/Z+oi&dwJ\u001a4tKR$b!a\u0019\u0002|\u0005u\u0004CBA3\u0003W\ny'\u0004\u0002\u0002h)!\u0011\u0011NA)\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003[\n9G\u0001\u0004GkR,(/\u001a\t\u0005\u0003c\n9(\u0004\u0002\u0002t)\u0019\u0011Q\u000f(\u0002\u00071|w-\u0003\u0003\u0002z\u0005M$A\u0004+jKJdunZ*fO6,g\u000e\u001e\u0005\b\u0003\u00179\u0001\u0019AA\u0007\u0011\u001d\tyh\u0002a\u0001\u0003\u0003\u000bA\u0002^1sO\u0016$xJ\u001a4tKR\u0004B!a!\u0002\n6\u0011\u0011Q\u0011\u0006\u0003\u0003\u000f\u000bQa]2bY\u0006LA!a#\u0002\u0006\n!Aj\u001c8h\u0003\u0005j\u0017\r^3sS\u0006d\u0017N_3US\u0016\u00148\u000b^1uKVsG/\u001b7PE*,7\r^%e))\t\u0019'!%\u0002\u0014\u0006U\u0015q\u0014\u0005\b\u0003\u0017A\u0001\u0019AA\u0007\u0011\u001d\ty\b\u0003a\u0001\u0003\u0003Cq!a&\t\u0001\u0004\tI*\u0001\buCJ<W\r^(cU\u0016\u001cG/\u00133\u0011\t\u0005=\u00131T\u0005\u0005\u0003;\u000b\tF\u0001\u0003V+&#\u0005bBAQ\u0011\u0001\u0007\u00111U\u0001\u0013i\u0006\u0014x-\u001a;SKN$xN]3Fa>\u001c\u0007\u000e\u0005\u0003\u0002\u0004\u0006\u0015\u0016\u0002BAT\u0003\u000b\u00131!\u00138u\u0003m!(/\u00198tSRLwN\u001c$fi\u000eD\u0017N\\4US\u0016\u00148\u000b^1uKRA\u00111AAW\u0003_\u000b\t\fC\u0004\u0002\f%\u0001\r!!\u0004\t\u000f\u0005]\u0011\u00021\u0001\u0002\u0004!9\u00111W\u0005A\u0002\u0005U\u0016!\u0003;jKJ\u001cF/\u0019;f!\r\t9\f\f\b\u0004\u0003ska\u0002BA^\u0003\u007fsA!a\u000b\u0002>&\tq*\u0003\u0002N\u001d\u000693i\u001c8gYV,g\u000e\u001e*fa2L7-\u0019$fi\u000eDWM\u001d+jKJ\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f!\tYfbE\u0002\u000f\u0003\u000f\u0004B!a!\u0002J&!\u00111ZAC\u0005\u0019\te.\u001f*fMR\u0011\u00111\u0019\u0002\u001a\u001b\u0006$XM]5bY&T\u0018N\\4US\u0016\u0014X*\u001a;bI\u0006$\u0018mE\u0005\u0011\u0003\u000f\f\u0019.!7\u0002`B\u00191,!6\n\u0007\u0005]GJ\u0001\u0007SKBd\u0017nY1Ti\u0006$X\r\u0005\u0003\u0002\u0004\u0006m\u0017\u0002BAo\u0003\u000b\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002b\u0006-h\u0002BAr\u0003OtA!a\u000b\u0002f&\u0011\u0011qQ\u0005\u0005\u0003S\f))A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0018q\u001e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0005\u0003S\f))\u0001\td_6\u0004H.\u001a;j_:\u001cF/\u0019;vgV\u0011\u00111M\u0001\u0012G>l\u0007\u000f\\3uS>t7\u000b^1ukN\u0004\u0013!\u00057fC\u0012,'o\u0015;beR|eMZ:fiV\u0011\u0011\u0011Q\u0001\u0013Y\u0016\fG-\u001a:Ti\u0006\u0014Ho\u00144gg\u0016$\b%A\u0007qe\u00164\u0018n\\;t'R\fG/Z\u000b\u0003\u0003'\fa\u0002\u001d:fm&|Wo]*uCR,\u0007\u0005\u0006\u0005\u0003\u0006\t%!1\u0002B\u0007!\r\u00119\u0001E\u0007\u0002\u001d!9\u0011\u0011_\fA\u0002\u0005\r\u0004bBA|/\u0001\u0007\u0011\u0011\u0011\u0005\b\u0003{<\u0002\u0019AAj\u0003\u0011\u0019w\u000e]=\u0015\u0011\t\u0015!1\u0003B\u000b\u0005/A\u0011\"!=\u0019!\u0003\u0005\r!a\u0019\t\u0013\u0005]\b\u0004%AA\u0002\u0005\u0005\u0005\"CA\u007f1A\u0005\t\u0019AAj\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\b+\t\u0005\r$qD\u0016\u0003\u0005C\u0001BAa\t\u0003.5\u0011!Q\u0005\u0006\u0005\u0005O\u0011I#A\u0005v]\u000eDWmY6fI*!!1FAC\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005_\u0011)CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u00036)\"\u0011\u0011\u0011B\u0010\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"Aa\u000f+\t\u0005M'qD\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t\u0005\u0003cA*\u0003D%\u0019!Q\t+\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\u0019+\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t=#Q\u000b\t\u0005\u0003\u0007\u0013\t&\u0003\u0003\u0003T\u0005\u0015%aA!os\"I!q\u000b\u0010\u0002\u0002\u0003\u0007\u00111U\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tu\u0003C\u0002B0\u0005K\u0012y%\u0004\u0002\u0003b)!!1MAC\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005O\u0012\tG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B7\u0005g\u0002B!a!\u0003p%!!\u0011OAC\u0005\u001d\u0011un\u001c7fC:D\u0011Ba\u0016!\u0003\u0003\u0005\rAa\u0014\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005\u0003\u0012I\bC\u0005\u0003X\u0005\n\t\u00111\u0001\u0002$\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002$\u0006AAo\\*ue&tw\r\u0006\u0002\u0003B\u00051Q-];bYN$BA!\u001c\u0003\b\"I!q\u000b\u0013\u0002\u0002\u0003\u0007!qJ\u0001\u001a\u001b\u0006$XM]5bY&T\u0018N\\4US\u0016\u0014X*\u001a;bI\u0006$\u0018\rE\u0002\u0003\b\u0019\u001aRA\nBH\u00057\u0003BB!%\u0003\u0018\u0006\r\u0014\u0011QAj\u0005\u000bi!Aa%\u000b\t\tU\u0015QQ\u0001\beVtG/[7f\u0013\u0011\u0011IJa%\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0003\u001e\n\rVB\u0001BP\u0015\r\u0011\tKV\u0001\u0003S>LA!!<\u0003 R\u0011!1R\u0001\u0006CB\u0004H.\u001f\u000b\t\u0005\u000b\u0011YK!,\u00030\"9\u0011\u0011_\u0015A\u0002\u0005\r\u0004bBA|S\u0001\u0007\u0011\u0011\u0011\u0005\b\u0003{L\u0003\u0019AAj\u0003\u001d)h.\u00199qYf$BA!.\u0003BB1\u00111\u0011B\\\u0005wKAA!/\u0002\u0006\n1q\n\u001d;j_:\u0004\"\"a!\u0003>\u0006\r\u0014\u0011QAj\u0013\u0011\u0011y,!\"\u0003\rQ+\b\u000f\\34\u0011%\u0011\u0019MKA\u0001\u0002\u0004\u0011)!A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!3\u0011\u0005MC&!\u0005$fi\u000eD\u0017N\\4US\u0016\u00148\u000b^1uKNIA&a2\u0002T\u0006e\u0017q\\\u000b\u0003\u0005#\u0004b!!\u001a\u0002l\tM\u0007cA.\u0003V&\u0019!q\u001b'\u0003\u0013QKWM]*uCR,\u0017a\u0003;jKJ\u001cVmZ7f]R,\"!a\u001c\u0002\u0019QLWM]*fO6,g\u000e\u001e\u0011\u0015\u0015\t\u0005(1\u001dBs\u0005O\u0014I\u000fE\u0002\u0003\b1Bq!!=6\u0001\u0004\u0011\t\u000eC\u0004\u0003ZV\u0002\r!a\u001c\t\u000f\u0005]X\u00071\u0001\u0002\u0002\"9\u0011Q`\u001bA\u0002\u0005MGC\u0003Bq\u0005[\u0014yO!=\u0003t\"I\u0011\u0011\u001f\u001c\u0011\u0002\u0003\u0007!\u0011\u001b\u0005\n\u000534\u0004\u0013!a\u0001\u0003_B\u0011\"a>7!\u0003\u0005\r!!!\t\u0013\u0005uh\u0007%AA\u0002\u0005MWC\u0001B|U\u0011\u0011\tNa\b\u0016\u0005\tm(\u0006BA8\u0005?\tabY8qs\u0012\"WMZ1vYR$C\u0007\u0006\u0003\u0003P\r\u0005\u0001\"\u0003B,{\u0005\u0005\t\u0019AAR)\u0011\u0011ig!\u0002\t\u0013\t]s(!AA\u0002\t=C\u0003\u0002B!\u0007\u0013A\u0011Ba\u0016A\u0003\u0003\u0005\r!a)\u0015\t\t54Q\u0002\u0005\n\u0005/\u001a\u0015\u0011!a\u0001\u0005\u001f\n\u0011CR3uG\"Lgn\u001a+jKJ\u001cF/\u0019;f!\r\u00119!R\n\u0006\u000b\u000eU!1\u0014\t\u000f\u0005#\u001b9B!5\u0002p\u0005\u0005\u00151\u001bBq\u0013\u0011\u0019IBa%\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0004\u0012QQ!\u0011]B\u0010\u0007C\u0019\u0019c!\n\t\u000f\u0005E\b\n1\u0001\u0003R\"9!\u0011\u001c%A\u0002\u0005=\u0004bBA|\u0011\u0002\u0007\u0011\u0011\u0011\u0005\b\u0003{D\u0005\u0019AAj)\u0011\u0019Ic!\r\u0011\r\u0005\r%qWB\u0016!1\t\u0019i!\f\u0003R\u0006=\u0014\u0011QAj\u0013\u0011\u0019y#!\"\u0003\rQ+\b\u000f\\35\u0011%\u0011\u0019-SA\u0001\u0002\u0004\u0011\t/A\u0012ue\u0006t7/\u001b;j_:l\u0015\r^3sS\u0006d\u0017N_5oORKWM]'fi\u0006$\u0017\r^1\u0015\u0011\u0005\r1qGB\u001d\u0007wAq!a\u0003\u000b\u0001\u0004\ti\u0001C\u0004\u0002\u0018)\u0001\r!a\u0001\t\u000f\u0005M&\u00021\u0001\u0004>A\u0019\u0011q\u0017\t\u0002%=t'+Z:u_J,G+[3s'R\fG/\u001a\u000b\t\u0007\u0007\u001aIea\u0013\u0004PA!\u00111QB#\u0013\u0011\u00199%!\"\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0017Y\u0001\u0019AA\u0007\u0011\u001d\u0019ie\u0003a\u0001\u0003\u0003\u000bQ\u0003\u001d:pa>\u001cX\r\u001a'pG\u0006dGj\\4Ti\u0006\u0014H\u000fC\u0004\u00024.\u0001\rAa5\u0002\u001d\u0019,Go\u00195US\u0016\u00148\u000b^1uKR1!\u0011[B+\u0007/Bq!a\u0003\r\u0001\u0004\ti\u0001C\u0004\u0003Z2\u0001\r!a\u001c")
public class ConfluentReplicaFetcherTierStateMachine
implements TierStateMachine,
Logging {
    private final LeaderEndPoint leader;
    private final ReplicaManager replicaMgr;
    private final ExponentialBackoff exponentialBackoff;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public PartitionFetchState start(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchResponseData.PartitionData fetchPartitionData) {
        block3: {
            block2: {
                var4_4 = this.leader.fetchTierMaterializationTarget(topicPartition, currentFetchState.currentLeaderEpoch());
                if (var4_4 == null) break block2;
                leaderStartOffset = var4_4.localLogStartOffset();
                var7_6 = var4_4.tierRestorePoint();
                if (!(var7_6 instanceof Some) || (var8_7 = (TierMaterializationRequirements)((Some)var7_6).value()) == null) break block2;
                objectId = var8_7.objectId();
                restoreEpoch = var8_7.restoreEpoch();
                status = this.materializeTierStateUntilObjectId(topicPartition, leaderStartOffset, objectId, restoreEpoch);
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$start$1(org.apache.kafka.common.TopicPartition java.util.UUID ), ()Ljava/lang/String;)((TopicPartition)topicPartition, (UUID)objectId));
                v0 = status;
                v1 = leaderStartOffset;
                break block3;
            }
            if (var4_4 == null) ** GOTO lbl-1000
            leaderStartOffset = var4_4.localLogStartOffset();
            var14_12 = var4_4.tierRestorePoint();
            if (None$.MODULE$.equals(var14_12)) {
                status = this.materializeTierStateUntilOffset(topicPartition, leaderStartOffset - 1L);
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$start$2(org.apache.kafka.common.TopicPartition long ), ()Ljava/lang/String;)((TopicPartition)topicPartition, (long)leaderStartOffset));
                v0 = status;
                v1 = leaderStartOffset;
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var4_4);
            }
        }
        var27_14 = v1;
        completionStatus = v0;
        x$1 = new MaterializingTierMetadata((Future<TierLogSegment>)var16_15, var27_14, currentFetchState.state());
        x$2 = currentFetchState.copy$default$1();
        x$3 = currentFetchState.copy$default$2();
        x$4 = currentFetchState.copy$default$3();
        x$5 = currentFetchState.copy$default$4();
        x$6 = currentFetchState.copy$default$5();
        x$7 = currentFetchState.copy$default$7();
        x$8 = currentFetchState.copy$default$8();
        x$9 = currentFetchState.copy$default$9();
        return currentFetchState.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7, x$8, x$9);
    }

    @Override
    public Optional<PartitionFetchState> maybeAdvanceState(TopicPartition tp, PartitionFetchState currentFetchState) {
        MaterializingTierMetadata materializingTierMetadata;
        FetchingTierState fetchingTierState;
        ReplicaState replicaState = currentFetchState.state();
        if (replicaState instanceof FetchingTierState && (fetchingTierState = (FetchingTierState)replicaState).completionStatus().isDone()) {
            return Optional.of(this.transitionFetchingTierState(tp, currentFetchState, fetchingTierState));
        }
        if (replicaState instanceof MaterializingTierMetadata && (materializingTierMetadata = (MaterializingTierMetadata)replicaState).completionStatus().isDone()) {
            return Optional.of(this.transitionMaterializingTierMetadata(tp, currentFetchState, materializingTierMetadata));
        }
        return Optional.empty();
    }

    public Future<TierLogSegment> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
        return this.replicaMgr.localLogOrException(topicPartition).materializeTierStateUntilOffset(targetOffset);
    }

    public Future<TierLogSegment> materializeTierStateUntilObjectId(TopicPartition topicPartition, long targetOffset, UUID targetObjectId, int targetRestoreEpoch) {
        return this.replicaMgr.localLogOrException(topicPartition).materializeTierStateUntilObjectId(targetOffset, targetObjectId, targetRestoreEpoch);
    }

    private PartitionFetchState transitionFetchingTierState(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchingTierState tierState) {
        try {
            long leaderStartOffset = tierState.leaderStartOffset();
            long proposedLocalLogStart = tierState.tierSegment().endOffset() + 1L;
            long replicationOffset = package$.MODULE$.max(leaderStartOffset, proposedLocalLogStart);
            this.onRestoreTierState(topicPartition, replicationOffset, tierState.completionStatus().get());
            if (leaderStartOffset > proposedLocalLogStart) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(81).append("Tier state ").append(tierState.tierSegment()).append(" restored. Resuming replicating from leader's local log ").append("start offset ").append(leaderStartOffset).append(".").toString());
            } else {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("Tier state ").append(tierState.tierSegment()).append(" restored.").append(" Resuming replicating from one offset past the materialized end offset ").append(proposedLocalLogStart).toString());
            }
            return new PartitionFetchState(currentFetchState.topicId(), replicationOffset, currentFetchState.lag(), currentFetchState.currentLeaderEpoch(), currentFetchState.delay(), Fetching$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)tierState.tierSegment().metadata().tierEpoch())), currentFetchState.replicationSessionId(), currentFetchState.failedAttempts());
        }
        catch (ExecutionException ee) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Exception fetching tier state.", (Function0<Throwable>)(Function0 & Serializable)() -> ee.getCause());
            return new PartitionFetchState(currentFetchState.topicId(), currentFetchState.fetchOffset(), currentFetchState.lag(), currentFetchState.currentLeaderEpoch(), (Option<DelayedItem>)new Some((Object)new DelayedItem(this.exponentialBackoff.backoff((long)currentFetchState.failedAttempts()))), Fetching$.MODULE$, currentFetchState.lastFetchedEpoch(), currentFetchState.replicationSessionId(), currentFetchState.failedAttempts() + 1);
        }
    }

    private PartitionFetchState transitionMaterializingTierMetadata(TopicPartition topicPartition, PartitionFetchState currentFetchState, MaterializingTierMetadata tierState) {
        try {
            TierLogSegment tierSegment = tierState.completionStatus().get();
            long leaderStartOffset = tierState.leaderStartOffset();
            Future<TierState> completionStatus = this.fetchTierState(topicPartition, tierSegment);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Restoring tiered state corresponding to ").append(tierSegment).append(" for partition ").append(topicPartition).toString());
            FetchingTierState x$1 = new FetchingTierState(completionStatus, tierSegment, leaderStartOffset, currentFetchState.state());
            Option<Uuid> x$2 = currentFetchState.copy$default$1();
            long x$3 = currentFetchState.copy$default$2();
            Option<Object> x$4 = currentFetchState.copy$default$3();
            int x$5 = currentFetchState.copy$default$4();
            Option<DelayedItem> x$6 = currentFetchState.copy$default$5();
            Option<Object> x$7 = currentFetchState.copy$default$7();
            Option<Object> x$8 = currentFetchState.copy$default$8();
            int x$9 = currentFetchState.copy$default$9();
            return currentFetchState.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7, x$8, x$9);
        }
        catch (ExecutionException ee) {
            if (ee.getCause() != null && ee.getCause() instanceof TierPartitionStateClosedException) {
                this.info((Function0<String>)(Function0 & Serializable)() -> "Exception completing tier materialization. Retrying initial fetch.", (Function0<Throwable>)(Function0 & Serializable)() -> ee.getCause());
            } else {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Exception completing tier materialization. Retrying initial fetch.", (Function0<Throwable>)(Function0 & Serializable)() -> ee.getCause());
            }
            return new PartitionFetchState(currentFetchState.topicId(), currentFetchState.fetchOffset(), currentFetchState.lag(), currentFetchState.currentLeaderEpoch(), (Option<DelayedItem>)new Some((Object)new DelayedItem(this.exponentialBackoff.backoff((long)currentFetchState.failedAttempts()))), Fetching$.MODULE$, currentFetchState.lastFetchedEpoch(), currentFetchState.replicationSessionId(), currentFetchState.failedAttempts() + 1);
        }
    }

    public void onRestoreTierState(TopicPartition topicPartition, long proposedLocalLogStart, TierState tierState) {
        AbstractLog log = this.replicaMgr.localLogOrException(topicPartition);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Restoring tier state ").append(topicPartition).append(": ").append(tierState).toString());
        log.truncateAndRestoreTierState(proposedLocalLogStart, tierState);
    }

    public Future<TierState> fetchTierState(TopicPartition topicPartition, TierLogSegment tierSegment) {
        return ((Partition)this.replicaMgr.onlinePartition(topicPartition).get()).fetchTierState(tierSegment);
    }

    public static final /* synthetic */ String $anonfun$start$1(TopicPartition topicPartition$1, UUID objectId$1) {
        return new StringBuilder(106).append("Processed OFFSET_TIERED exception for ").append(topicPartition$1).append(". Waiting until tier partition state is ").append("materialized until objectId ").append(CoreUtils$.MODULE$.uuidToBase64(objectId$1)).toString();
    }

    public static final /* synthetic */ String $anonfun$start$2(TopicPartition topicPartition$1, long leaderStartOffset$1) {
        return new StringBuilder(97).append("Processed OFFSET_TIERED exception for ").append(topicPartition$1).append(". Waiting until tier partition state is ").append("materialized until ").append(leaderStartOffset$1 - 1L).toString();
    }

    public ConfluentReplicaFetcherTierStateMachine(LeaderEndPoint leader, ReplicaManager replicaMgr, ExponentialBackoff exponentialBackoff) {
        this.leader = leader;
        this.replicaMgr = replicaMgr;
        this.exponentialBackoff = exponentialBackoff;
    }

    public static class FetchingTierState
    implements ReplicaState,
    Product,
    Serializable {
        private final Future<TierState> completionStatus;
        private final TierLogSegment tierSegment;
        private final long leaderStartOffset;
        private final ReplicaState previousState;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Future<TierState> completionStatus() {
            return this.completionStatus;
        }

        public TierLogSegment tierSegment() {
            return this.tierSegment;
        }

        public long leaderStartOffset() {
            return this.leaderStartOffset;
        }

        public ReplicaState previousState() {
            return this.previousState;
        }

        public FetchingTierState copy(Future<TierState> completionStatus, TierLogSegment tierSegment, long leaderStartOffset, ReplicaState previousState) {
            return new FetchingTierState(completionStatus, tierSegment, leaderStartOffset, previousState);
        }

        public Future<TierState> copy$default$1() {
            return this.completionStatus();
        }

        public TierLogSegment copy$default$2() {
            return this.tierSegment();
        }

        public long copy$default$3() {
            return this.leaderStartOffset();
        }

        public ReplicaState copy$default$4() {
            return this.previousState();
        }

        public String productPrefix() {
            return "FetchingTierState";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.completionStatus();
                }
                case 1: {
                    return this.tierSegment();
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.leaderStartOffset());
                }
                case 3: {
                    return this.previousState();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchingTierState;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "completionStatus";
                }
                case 1: {
                    return "tierSegment";
                }
                case 2: {
                    return "leaderStartOffset";
                }
                case 3: {
                    return "previousState";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash(this.completionStatus())), (int)Statics.anyHash((Object)this.tierSegment())), (int)Statics.longHash((long)this.leaderStartOffset())), (int)Statics.anyHash((Object)this.previousState())), (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof FetchingTierState)) break block3;
                    FetchingTierState fetchingTierState = (FetchingTierState)x$1;
                    if (this.leaderStartOffset() != fetchingTierState.leaderStartOffset()) break block3;
                    Future<TierState> future = this.completionStatus();
                    Future<TierState> future2 = fetchingTierState.completionStatus();
                    if (future != null ? !future.equals(future2) : future2 != null) break block3;
                    TierLogSegment tierLogSegment = this.tierSegment();
                    TierLogSegment tierLogSegment2 = fetchingTierState.tierSegment();
                    if (tierLogSegment != null ? !((Object)tierLogSegment).equals(tierLogSegment2) : tierLogSegment2 != null) break block3;
                    ReplicaState replicaState = this.previousState();
                    ReplicaState replicaState2 = fetchingTierState.previousState();
                    if ((replicaState != null ? !replicaState.equals(replicaState2) : replicaState2 != null) || !fetchingTierState.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public FetchingTierState(Future<TierState> completionStatus, TierLogSegment tierSegment, long leaderStartOffset, ReplicaState previousState) {
            this.completionStatus = completionStatus;
            this.tierSegment = tierSegment;
            this.leaderStartOffset = leaderStartOffset;
            this.previousState = previousState;
            Product.$init$((Product)this);
        }
    }

    public static class MaterializingTierMetadata
    implements ReplicaState,
    Product,
    Serializable {
        private final Future<TierLogSegment> completionStatus;
        private final long leaderStartOffset;
        private final ReplicaState previousState;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Future<TierLogSegment> completionStatus() {
            return this.completionStatus;
        }

        public long leaderStartOffset() {
            return this.leaderStartOffset;
        }

        public ReplicaState previousState() {
            return this.previousState;
        }

        public MaterializingTierMetadata copy(Future<TierLogSegment> completionStatus, long leaderStartOffset, ReplicaState previousState) {
            return new MaterializingTierMetadata(completionStatus, leaderStartOffset, previousState);
        }

        public Future<TierLogSegment> copy$default$1() {
            return this.completionStatus();
        }

        public long copy$default$2() {
            return this.leaderStartOffset();
        }

        public ReplicaState copy$default$3() {
            return this.previousState();
        }

        public String productPrefix() {
            return "MaterializingTierMetadata";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.completionStatus();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.leaderStartOffset());
                }
                case 2: {
                    return this.previousState();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MaterializingTierMetadata;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "completionStatus";
                }
                case 1: {
                    return "leaderStartOffset";
                }
                case 2: {
                    return "previousState";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash(this.completionStatus())), (int)Statics.longHash((long)this.leaderStartOffset())), (int)Statics.anyHash((Object)this.previousState())), (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof MaterializingTierMetadata)) break block3;
                    MaterializingTierMetadata materializingTierMetadata = (MaterializingTierMetadata)x$1;
                    if (this.leaderStartOffset() != materializingTierMetadata.leaderStartOffset()) break block3;
                    Future<TierLogSegment> future = this.completionStatus();
                    Future<TierLogSegment> future2 = materializingTierMetadata.completionStatus();
                    if (future != null ? !future.equals(future2) : future2 != null) break block3;
                    ReplicaState replicaState = this.previousState();
                    ReplicaState replicaState2 = materializingTierMetadata.previousState();
                    if ((replicaState != null ? !replicaState.equals(replicaState2) : replicaState2 != null) || !materializingTierMetadata.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public MaterializingTierMetadata(Future<TierLogSegment> completionStatus, long leaderStartOffset, ReplicaState previousState) {
            this.completionStatus = completionStatus;
            this.leaderStartOffset = leaderStartOffset;
            this.previousState = previousState;
            Product.$init$((Product)this);
        }
    }
}

