/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.server.ActiveTenantsManager;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientSensors;
import kafka.server.ControllerMutationQuota;
import kafka.server.PermissiveControllerMutationQuota;
import kafka.server.QuotaType$ControllerMutation$;
import kafka.server.StrictControllerMutationQuota;
import kafka.server.UnboundedControllerMutationQuota$;
import kafka.utils.QuotaUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001du!\u0002\r\u001a\u0011\u0003qb!\u0002\u0011\u001a\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003Ic\u0001\u0002\u0011\u001a\u0001)B\u0001BL\u0002\u0003\u0006\u0004%Ia\f\u0005\tg\r\u0011\t\u0011)A\u0005a!AAg\u0001BC\u0002\u0013%Q\u0007\u0003\u0005C\u0007\t\u0005\t\u0015!\u00037\u0011!\u00195A!b\u0001\n#\"\u0005\"C&\u0004\u0005\u0003\u0005\u000b\u0011B#M\u0011!i5A!b\u0001\n\u0013q\u0005\u0002\u0003.\u0004\u0005\u0003\u0005\u000b\u0011B(\t\u0011m\u001b!Q1A\u0005\nqC\u0001bZ\u0002\u0003\u0002\u0003\u0006I!\u0018\u0005\u0006Q\r!\t\u0001\u001b\u0005\u0006_\u000e!\t\u0005\u001d\u0005\u0006u\u000e!\te\u001f\u0005\u0007\u007f\u000e!\t%!\u0001\t\u000f\u0005}2\u0001\"\u0001\u0002B!9\u0011QJ\u0002\u0005\u0002\u0005=\u0003bBA'\u0007\u0011\u0005\u00111\f\u0005\b\u0003W\u001aA\u0011AA7\u0011\u001d\tYg\u0001C\u0001\u0003gBq!a\u001e\u0004\t\u0003\tI(\u0001\u0010D_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uC6\u000bg.Y4fe*\u0011!dG\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003q\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002 \u00035\t\u0011D\u0001\u0010D_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uC6\u000bg.Y4feN\u0011\u0011A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005q2CA\u0002,!\tyB&\u0003\u0002.3\t\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003\u0019\u0019wN\u001c4jOV\t\u0001\u0007\u0005\u0002 c%\u0011!'\u0007\u0002\u0019\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'oQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\b[\u0016$(/[2t+\u00051\u0004CA\u001cA\u001b\u0005A$B\u0001\u001b:\u0015\tQ4(\u0001\u0004d_6lwN\u001c\u0006\u00039qR!!\u0010 \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0014aA8sO&\u0011\u0011\t\u000f\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u0002;j[\u0016,\u0012!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011f\nQ!\u001e;jYNL!AS$\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0005\u0003\u00072\n\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0016\u0003=\u0003\"\u0001U,\u000f\u0005E+\u0006C\u0001*%\u001b\u0005\u0019&B\u0001+\u001e\u0003\u0019a$o\\8u}%\u0011a\u000bJ\u0001\u0007!J,G-\u001a4\n\u0005aK&AB*ue&twM\u0003\u0002WI\u0005\tB\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u0011\u0002'\rd\u0017.\u001a8u#V|G/Y\"bY2\u0014\u0017mY6\u0016\u0003u\u00032a\t0a\u0013\tyFE\u0001\u0004PaRLwN\u001c\t\u0003C\u0016l\u0011A\u0019\u0006\u0003G\u0012\fQ!];pi\u0006T!AG\u001e\n\u0005\u0019\u0014'aE\"mS\u0016tG/U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0017\u0001F2mS\u0016tG/U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0005\u0006\u0004jU.dWN\u001c\t\u0003?\rAQA\f\bA\u0002ABQ\u0001\u000e\bA\u0002YBQa\u0011\bA\u0002\u0015CQ!\u0014\bA\u0002=CQa\u0017\bA\u0002u\u000bAc\u00197jK:$(+\u0019;f\u001b\u0016$(/[2OC6,GCA9v!\t\u00118/D\u0001:\u0013\t!\u0018H\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016DQA^\bA\u0002]\fq\"];pi\u0006lU\r\u001e:jGR\u000bwm\u001d\t\u0005!b|u*\u0003\u0002z3\n\u0019Q*\u00199\u0002'\t\f7m\u001b9sKN\u001cXO]3F]\u0006\u0014G.\u001a3\u0016\u0003q\u0004\"aI?\n\u0005y$#a\u0002\"p_2,\u0017M\\\u0001\u001be\u0016\u001cwN\u001d3B]\u0012<U\r\u001e+ie>$H\u000f\\3US6,Wj\u001d\u000b\u000b\u0003\u0007\tI!a\n\u0002,\u0005U\u0002cA\u0012\u0002\u0006%\u0019\u0011q\u0001\u0013\u0003\u0007%sG\u000fC\u0004\u0002\fE\u0001\r!!\u0004\u0002\u000fM,7o]5p]B!\u0011qBA\u0011\u001d\u0011\t\t\"a\u0007\u000f\t\u0005M\u0011q\u0003\b\u0004%\u0006U\u0011\"\u0001\u000f\n\u0007\u0005e1$A\u0004oKR<xN]6\n\t\u0005u\u0011qD\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0015\r\tIbG\u0005\u0005\u0003G\t)CA\u0004TKN\u001c\u0018n\u001c8\u000b\t\u0005u\u0011q\u0004\u0005\u0007\u0003S\t\u0002\u0019A(\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012Dq!!\f\u0012\u0001\u0004\ty#A\u0003wC2,X\rE\u0002$\u0003cI1!a\r%\u0005\u0019!u.\u001e2mK\"9\u0011qG\tA\u0002\u0005e\u0012A\u0002;j[\u0016l5\u000fE\u0002$\u0003wI1!!\u0010%\u0005\u0011auN\\4\u0002\u001dQD'o\u001c;uY\u0016$\u0016.\\3NgR!\u0011\u0011HA\"\u0011\u001d\t)E\u0005a\u0001\u0003\u000f\n\u0011!\u001a\t\u0004o\u0005%\u0013bAA&q\t9\u0012+^8uCZKw\u000e\\1uS>tW\t_2faRLwN\\\u0001\u0012]\u0016<8\u000b\u001e:jGR\fVo\u001c;b\r>\u0014HCBA)\u0003/\nI\u0006E\u0002 \u0003'J1!!\u0016\u001a\u0005]\u0019uN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018\rC\u0004\u0002\fM\u0001\r!!\u0004\t\r\u0005%2\u00031\u0001P)\u0011\t\t&!\u0018\t\u000f\u0005}C\u00031\u0001\u0002b\u00059!/Z9vKN$\b\u0003BA2\u0003OrA!!\u001a\u0002\u001c5\u0011\u0011qD\u0005\u0005\u0003S\n)CA\u0004SKF,Xm\u001d;\u0002+9,w\u000fU3s[&\u001c8/\u001b<f#V|G/\u0019$peR1\u0011\u0011KA8\u0003cBq!a\u0003\u0016\u0001\u0004\ti\u0001\u0003\u0004\u0002*U\u0001\ra\u0014\u000b\u0005\u0003#\n)\bC\u0004\u0002`Y\u0001\r!!\u0019\u0002\u00179,w/U;pi\u00064uN\u001d\u000b\u0007\u0003#\nY(! \t\u000f\u0005}s\u00031\u0001\u0002b!9\u0011qP\fA\u0002\u0005\u0005\u0015AE:ue&\u001cGoU5oG\u00164VM]:j_:\u00042aIAB\u0013\r\t)\t\n\u0002\u0006'\"|'\u000f\u001e")
public class ControllerMutationQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> clientQuotaCallback;

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    @Override
    public Time time() {
        return super.time();
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> clientQuotaCallback() {
        return this.clientQuotaCallback;
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("mutation-rate", "ControllerMutation", "Tracking mutation-rate per user/client-id", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    @Override
    public boolean backpressureEnabled() {
        return false;
    }

    @Override
    public int recordAndGetThrottleTimeMs(RequestChannel.Session session, String clientId, double value, long timeMs) {
        Sensor quotaSensor = this.getOrCreateQuotaSensors(session, clientId).quotaSensor();
        try {
            synchronized (quotaSensor) {
                quotaSensor.checkQuotas(timeMs);
                quotaSensor.record(value, timeMs, false);
            }
            return 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)this.throttleTimeMs(e);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Quota violated for sensor (").append(quotaSensor.name()).append("). Delay time: (").append(throttleTimeMs).append(")").toString());
            return throttleTimeMs;
        }
    }

    public long throttleTimeMs(QuotaViolationException e) {
        long boundedTokenBucketThrottleTime_maxThrottleTime = this.quotaMaxThrottleTimeMs();
        return QuotaUtils$.MODULE$.boundedTokenBucketThrottleTime(e, 0L, boundedTokenBucketThrottleTime_maxThrottleTime);
    }

    public ControllerMutationQuota newStrictQuotaFor(RequestChannel.Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new StrictControllerMutationQuota(this.time(), clientSensors.quotaSensor(), this);
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newStrictQuotaFor(RequestChannel.Request request) {
        return this.newStrictQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newPermissiveQuotaFor(RequestChannel.Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new PermissiveControllerMutationQuota(this.time(), clientSensors.quotaSensor(), this);
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newPermissiveQuotaFor(RequestChannel.Request request) {
        return this.newPermissiveQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newQuotaFor(RequestChannel.Request request, short strictSinceVersion) {
        if (request.header().apiVersion() >= strictSinceVersion) {
            return this.newStrictQuotaFor(request);
        }
        return this.newPermissiveQuotaFor(request);
    }

    public ControllerMutationQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> clientQuotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.clientQuotaCallback = clientQuotaCallback;
        super(config, metrics, QuotaType$ControllerMutation$.MODULE$, time, threadNamePrefix, clientQuotaCallback, (Option<ActiveTenantsManager>)None$.MODULE$);
    }
}

