/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.server.AlterPartitionItem;
import kafka.server.AlterPartitionManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.Scheduler;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001\u0002\u000e\u001c\u0001\u0001B\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\t{\u0001\u0011\t\u0011)A\u0005g!Aa\b\u0001BC\u0002\u0013\u0005q\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003A\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u0011E\u0003!Q1A\u0005\u0002IC\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t/\u0002\u0011)\u0019!C\u00011\"Aq\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005a\u0001\t\u0015\r\u0011\"\u0001b\u0011!A\u0007A!A!\u0002\u0013\u0011\u0007\"B5\u0001\t\u0003Q\u0007\u0002\u0003:\u0001\u0005\u0004%\taG:\t\u000f\u0005\u0015\u0001\u0001)A\u0005i\"I\u0011q\u0001\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\f!9\u0011Q\u0004\u0001\u0005B\u0005}\u0001bBA\u0014\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011!\ti\u0006\u0001C\u00017\u0005}\u0001\u0002CA0\u0001\u0011\u00051$a\b\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d!9\u0011\u0011\u0011\u0001\u0005\n\u0005\r\u0005bBAe\u0001\u0011\u0005\u00111\u001a\u0002\u001d\t\u00164\u0017-\u001e7u\u00032$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3s\u0015\taR$\u0001\u0004tKJ4XM\u001d\u0006\u0002=\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\"O-\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015*\u001b\u0005Y\u0012B\u0001\u0016\u001c\u0005U\tE\u000e^3s!\u0006\u0014H/\u001b;j_:l\u0015M\\1hKJ\u0004\"\u0001L\u0018\u000e\u00035R!AL\u000f\u0002\u000bU$\u0018\u000e\\:\n\u0005Aj#a\u0002'pO\u001eLgnZ\u0001\u0019G>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014X#A\u001a\u0011\u0005QZT\"A\u001b\u000b\u0005q1$B\u0001\u00108\u0015\tA\u0014(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002u\u0005\u0019qN]4\n\u0005q*$A\b(pI\u0016$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003e\u0019wN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r+\u0014\u0001B;uS2L!!\u0012\"\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005!A/[7f+\u0005I\u0005C\u0001&O\u001b\u0005Y%B\u0001\u0018M\u0015\tie'\u0001\u0004d_6lwN\\\u0005\u0003\u001f.\u0013A\u0001V5nK\u0006)A/[7fA\u0005A!M]8lKJLE-F\u0001T!\t\u0011C+\u0003\u0002VG\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013a\u00052s_.,'/\u00129pG\"\u001cV\u000f\u001d9mS\u0016\u0014X#A-\u0011\u0007\tRF,\u0003\u0002\\G\tIa)\u001e8di&|g\u000e\r\t\u0003EuK!AX\u0012\u0003\t1{gnZ\u0001\u0015EJ|7.\u001a:Fa>\u001c\u0007nU;qa2LWM\u001d\u0011\u0002/5,G/\u00193bi\u00064VM]:j_:\u001cV\u000f\u001d9mS\u0016\u0014X#\u00012\u0011\u0007\tR6\r\u0005\u0002eM6\tQM\u0003\u0002Nk%\u0011q-\u001a\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u0006AR.\u001a;bI\u0006$\u0018MV3sg&|gnU;qa2LWM\u001d\u0011\u0002\rqJg.\u001b;?)\u001dYG.\u001c8paF\u0004\"\u0001\u000b\u0001\t\u000bEj\u0001\u0019A\u001a\t\u000byj\u0001\u0019\u0001!\t\u000b\u001dk\u0001\u0019A%\t\u000bEk\u0001\u0019A*\t\u000b]k\u0001\u0019A-\t\u000b\u0001l\u0001\u0019\u00012\u0002!Ut7/\u001a8u\u0013N\u0014X\u000b\u001d3bi\u0016\u001cX#\u0001;\u0011\tUL8p`\u0007\u0002m*\u00111i\u001e\u0006\u0002q\u0006!!.\u0019<b\u0013\tQhOA\u0002NCB\u0004\"\u0001`?\u000e\u00031K!A '\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0019\u0001&!\u0001\n\u0007\u0005\r1D\u0001\nBYR,'\u000fU1si&$\u0018n\u001c8Ji\u0016l\u0017!E;og\u0016tG/S:s+B$\u0017\r^3tA\u0005y\u0011N\u001c4mS\u001eDGOU3rk\u0016\u001cH/\u0006\u0002\u0002\fA!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011AB1u_6L7MC\u0002\u0002\u0016Y\f!bY8oGV\u0014(/\u001a8u\u0013\u0011\tI\"a\u0004\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003AIgN\u001a7jO\"$(+Z9vKN$\b%A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002\"A\u0019!%a\t\n\u0007\u0005\u00152E\u0001\u0003V]&$\u0018\u0001C:ikR$wn\u001e8\u0002\rM,(-\\5u))\ti#!\u0011\u0002L\u0005=\u00131\u000b\t\u0007\u0003_\t\t$!\u000e\u000e\u0005\u0005M\u0011\u0002BA\u001a\u0003'\u0011\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001e;\u0005\u0019\u0011\r]5\n\t\u0005}\u0012\u0011\b\u0002\r\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d\u0005\b\u0003\u0007\"\u0002\u0019AA#\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eE\u0002}\u0003\u000fJ1!!\u0013M\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002NQ\u0001\r!!\u000e\u0002\u00191,\u0017\rZ3s\u0003:$\u0017j\u001d:\t\r\u0005EC\u00031\u0001T\u0003=\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007bBA+)\u0001\u0007\u0011qK\u0001\u0015aJ|\u0007/Y4bi\u0016LU.\\3eS\u0006$X\r\\=\u0011\u0007\t\nI&C\u0002\u0002\\\r\u0012qAQ8pY\u0016\fg.\u0001\rnCf\u0014W\r\u0015:pa\u0006<\u0017\r^3JgJ\u001c\u0005.\u00198hKN\fAc\u00197fCJLeN\u00127jO\"$(+Z9vKN$\u0018aC:f]\u0012\u0014V-];fgR$B!!\t\u0002f!9\u0011qM\fA\u0002\u0005%\u0014aG5oM2Lw\r\u001b;BYR,'\u000fU1si&$\u0018n\u001c8Ji\u0016l7\u000fE\u0003\u0002l\u0005mtP\u0004\u0003\u0002n\u0005]d\u0002BA8\u0003kj!!!\u001d\u000b\u0007\u0005Mt$\u0001\u0004=e>|GOP\u0005\u0002I%\u0019\u0011\u0011P\u0012\u0002\u000fA\f7m[1hK&!\u0011QPA@\u0005\r\u0019V-\u001d\u0006\u0004\u0003s\u001a\u0013\u0001\u00042vS2$'+Z9vKN$HCBAC\u0003\u0007\f)\rE\u0004#\u0003\u000f\u000bY)a(\n\u0007\u0005%5E\u0001\u0004UkBdWM\r\t\u0005\u0003\u001b\u000bIJ\u0004\u0003\u0002\u0010\u0006UUBAAI\u0015\r\t\u0019\nT\u0001\te\u0016\fX/Z:ug&!\u0011qSAI\u0003U\tE\u000e^3s!\u0006\u0014H/\u001b;j_:\u0014V-];fgRLA!a'\u0002\u001e\n9!)^5mI\u0016\u0014(\u0002BAL\u0003#\u0003\u0002\"!)\u0002,\u00065\u00161W\u0007\u0003\u0003GSA!!*\u0002(\u00069Q.\u001e;bE2,'bAAUG\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007i\f\u0019\u000bE\u0002}\u0003_K1!!-M\u0005\u0011)V/\u001b3\u0011\t\u0005U\u0016Q\u0018\b\u0005\u0003o\u000bI\fE\u0002\u0002p\rJ1!a/$\u0003\u0019\u0001&/\u001a3fM&!\u0011qXAa\u0005\u0019\u0019FO]5oO*\u0019\u00111X\u0012\t\u000f\u0005\u001d\u0004\u00041\u0001\u0002j!1\u0011q\u0019\rA\u0002q\u000b1B\u0019:pW\u0016\u0014X\t]8dQ\u0006a\u0002.\u00198eY\u0016\fE\u000e^3s!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,G\u0003DAg\u00033\f\u0019/!<\u0002r\u0006M\b\u0003BAh\u0003+l!!!5\u000b\u0007\u0005MG*\u0001\u0005qe>$xnY8m\u0013\u0011\t9.!5\u0003\r\u0015\u0013(o\u001c:t\u0011\u001d\tY.\u0007a\u0001\u0003;\fQB]3rk\u0016\u001cH\u000fS3bI\u0016\u0014\b\u0003BAH\u0003?LA!!9\u0002\u0012\ni!+Z9vKN$\b*Z1eKJDq!!:\u001a\u0001\u0004\t9/\u0001\nbYR,'\u000fU1si&$\u0018n\u001c8SKN\u0004\b\u0003BAH\u0003SLA!a;\u0002\u0012\n1\u0012\t\u001c;feB\u000b'\u000f^5uS>t'+Z:q_:\u001cX\r\u0003\u0004\u0002pf\u0001\r\u0001X\u0001\u0010g\u0016tGO\u0011:pW\u0016\u0014X\t]8dQ\"9\u0011qM\rA\u0002\u0005%\u0004bBA{3\u0001\u0007\u0011qT\u0001\u0010i>\u0004\u0018n\u0019(b[\u0016\u001c()_%eg\u0002")
public class DefaultAlterPartitionManager
implements AlterPartitionManager,
Logging {
    private final NodeToControllerChannelManager controllerChannelManager;
    private final Scheduler scheduler;
    private final Time time;
    private final int brokerId;
    private final Function0<Object> brokerEpochSupplier;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final Map<TopicPartition, AlterPartitionItem> unsentIsrUpdates;
    private final AtomicBoolean inflightRequest;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public NodeToControllerChannelManager controllerChannelManager() {
        return this.controllerChannelManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Time time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Function0<Object> brokerEpochSupplier() {
        return this.brokerEpochSupplier;
    }

    public Function0<MetadataVersion> metadataVersionSupplier() {
        return this.metadataVersionSupplier;
    }

    public Map<TopicPartition, AlterPartitionItem> unsentIsrUpdates() {
        return this.unsentIsrUpdates;
    }

    private AtomicBoolean inflightRequest() {
        return this.inflightRequest;
    }

    @Override
    public void start() {
        this.controllerChannelManager().start();
    }

    @Override
    public void shutdown() {
        this.controllerChannelManager().shutdown();
    }

    @Override
    public CompletableFuture<LeaderAndIsr> submit(TopicIdPartition topicIdPartition, LeaderAndIsr leaderAndIsr, int controllerEpoch, boolean propagateImmediately) {
        CompletableFuture<LeaderAndIsr> future = new CompletableFuture<LeaderAndIsr>();
        AlterPartitionItem alterPartitionItem = new AlterPartitionItem(topicIdPartition, leaderAndIsr, future, controllerEpoch);
        if (this.unsentIsrUpdates().putIfAbsent(alterPartitionItem.topicIdPartition().topicPartition(), alterPartitionItem) == null) {
            this.maybePropagateIsrChanges();
        } else {
            future.completeExceptionally((Throwable)new OperationNotAttemptedException(new StringBuilder(50).append("Failed to enqueue ISR change state ").append(leaderAndIsr).append(" for partition ").append(topicIdPartition).toString()));
        }
        return future;
    }

    public void maybePropagateIsrChanges() {
        if (!this.unsentIsrUpdates().isEmpty() && this.inflightRequest().compareAndSet(false, true)) {
            ListBuffer inflightAlterPartitionItems = new ListBuffer();
            this.unsentIsrUpdates().values().forEach(item -> inflightAlterPartitionItems.append(item));
            this.sendRequest((Seq<AlterPartitionItem>)inflightAlterPartitionItems.toSeq());
            return;
        }
    }

    public void clearInFlightRequest() {
        if (!this.inflightRequest().compareAndSet(true, false)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Attempting to clear AlterPartition in-flight flag when no apparent request is in-flight");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendRequest(Seq<AlterPartitionItem> inflightAlterPartitionItems) {
        void var6_5;
        void var5_4;
        long brokerEpoch = this.brokerEpochSupplier().apply$mcJ$sp();
        Tuple2<AlterPartitionRequest.Builder, scala.collection.mutable.Map<Uuid, String>> tuple2 = this.buildRequest(inflightAlterPartitionItems, brokerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AlterPartitionRequest.Builder request = (AlterPartitionRequest.Builder)tuple2._1();
        scala.collection.mutable.Map topicNamesByIds = (scala.collection.mutable.Map)tuple2._2();
        this.debug((Function0<String>)((Function0 & Serializable)() -> DefaultAlterPartitionManager.$anonfun$sendRequest$1((AlterPartitionRequest.Builder)var5_4)));
        this.controllerChannelManager().sendRequest((AbstractRequest.Builder)var5_4, new ControllerRequestCompletionHandler(this, brokerEpoch, inflightAlterPartitionItems, (scala.collection.mutable.Map)var6_5){
            private final /* synthetic */ DefaultAlterPartitionManager $outer;
            private final long brokerEpoch$1;
            private final Seq inflightAlterPartitionItems$2;
            private final scala.collection.mutable.Map topicNamesByIds$1;

            public void onComplete(ClientResponse response) {
                Errors errors;
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Received AlterPartition response ").append(response).toString());
                try {
                    if (response.authenticationException() != null) {
                        errors = Errors.NETWORK_EXCEPTION;
                    } else if (response.versionMismatch() != null) {
                        errors = Errors.UNSUPPORTED_VERSION;
                    } else {
                        AlterPartitionResponse body = (AlterPartitionResponse)response.responseBody();
                        errors = this.$outer.handleAlterPartitionResponse(response.requestHeader(), body, this.brokerEpoch$1, (Seq<AlterPartitionItem>)this.inflightAlterPartitionItems$2, (scala.collection.mutable.Map<Uuid, String>)this.topicNamesByIds$1);
                    }
                }
                finally {
                    this.$outer.clearInFlightRequest();
                }
                Errors error = errors;
                if (Errors.NONE.equals(error)) {
                    this.$outer.maybePropagateIsrChanges();
                    return;
                }
                this.$outer.scheduler().scheduleOnce("send-alter-partition", () -> $this.$outer.maybePropagateIsrChanges(), 50L);
            }

            public void onTimeout() {
                throw new IllegalStateException("Encountered unexpected timeout when sending AlterPartition to the controller");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerEpoch$1 = brokerEpoch$1;
                this.inflightAlterPartitionItems$2 = inflightAlterPartitionItems$2;
                this.topicNamesByIds$1 = topicNamesByIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.kafka.clients.ClientResponse )}, serializedLambda);
            }
        });
    }

    private Tuple2<AlterPartitionRequest.Builder, scala.collection.mutable.Map<Uuid, String>> buildRequest(Seq<AlterPartitionItem> inflightAlterPartitionItems, long brokerEpoch) {
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionSupplier().apply();
        HashMap topicNamesByIds = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef canUseTopicIds = BooleanRef.create((boolean)metadataVersion.isTopicIdsSupported());
        AlterPartitionRequestData message = new AlterPartitionRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(brokerEpoch);
        inflightAlterPartitionItems.groupBy((Function1 & Serializable)x$2 -> x$2.topicIdPartition().topic()).foreach((Function1 & Serializable)x0$1 -> {
            DefaultAlterPartitionManager.$anonfun$buildRequest$2(canUseTopicIds, topicNamesByIds, message, metadataVersion, x0$1);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)new AlterPartitionRequest.Builder(message, canUseTopicIds.elem), (Object)topicNamesByIds);
    }

    public Errors handleAlterPartitionResponse(RequestHeader requestHeader, AlterPartitionResponse alterPartitionResp, long sentBrokerEpoch, Seq<AlterPartitionItem> inflightAlterPartitionItems, scala.collection.mutable.Map<Uuid, String> topicNamesByIds) {
        AlterPartitionResponseData data = alterPartitionResp.data();
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Broker had a stale broker epoch (").append(sentBrokerEpoch).append("), retrying.").toString());
        } else if (Errors.CLUSTER_AUTHORIZATION_FAILED.equals(errors)) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Broker is not authorized to send AlterPartition to controller", (Function0<Throwable>)(Function0 & Serializable)() -> Errors.CLUSTER_AUTHORIZATION_FAILED.exception("Broker is not authorized to send AlterPartition to controller"));
        } else if (Errors.NONE.equals(errors)) {
            HashMap partitionResponses = HashMap$.MODULE$.empty();
            data.topics().forEach(topic -> {
                String topicName;
                String string = topicName = requestHeader.apiVersion() > 1 ? (String)topicNamesByIds.get((Object)topic.topicId()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()) : topic.topicName();
                if (topicName == null || topicName.isEmpty()) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Received an unexpected topic ").append(topic).append(" in the alter partition response, ignoring it.").toString());
                    return;
                }
                topic.partitions().forEach(partition -> {
                    TopicPartition tp = new TopicPartition(topicName, partition.partitionIndex());
                    partitionResponses.update((Object)tp, partition);
                });
            });
            inflightAlterPartitionItems.foreach((Function1 & Serializable)inflightAlterPartition -> {
                Option option = partitionResponses.get((Object)inflightAlterPartition.topicIdPartition().topicPartition());
                if (option instanceof Some) {
                    AlterPartitionResponseData.PartitionData response = (AlterPartitionResponseData.PartitionData)((Some)option).value();
                    this.unsentIsrUpdates().remove(inflightAlterPartition.topicIdPartition().topicPartition());
                    Errors error = Errors.forCode((short)response.errorCode());
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Controller response returned for AlterIsr request for ").append(inflightAlterPartition.topicIdPartition()).append(": ").append(response).toString());
                    Errors errors = error;
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                        return BoxesRunTime.boxToBoolean((boolean)inflightAlterPartition.future().complete(LeaderAndIsr$.MODULE$.apply(response.leaderId(), response.leaderEpoch(), (List<Object>)CollectionConverters$.MODULE$.ListHasAsScala(response.isr()).asScala().toList().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3))), inflightAlterPartition.leaderAndIsr().leaderRecoveryState(), response.partitionEpoch(), inflightAlterPartition.leaderAndIsr().clusterLinkState())));
                    }
                    return BoxesRunTime.boxToBoolean((boolean)inflightAlterPartition.future().completeExceptionally(error.exception()));
                }
                if (None$.MODULE$.equals(option)) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Partition ").append(inflightAlterPartition.topicIdPartition()).append(" was sent but not included in the response").toString());
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            });
        } else {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(88).append("Controller returned an unexpected top-level error when handling AlterPartition request: ").append(errors).toString());
        }
        return Errors.forCode((short)data.errorCode());
    }

    public static final /* synthetic */ String $anonfun$sendRequest$1(AlterPartitionRequest.Builder request$1) {
        return new StringBuilder(37).append("Sending AlterPartition to controller ").append(request$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$buildRequest$3(MetadataVersion metadataVersion$1, AlterPartitionRequestData.TopicData topicData$1, AlterPartitionItem item) {
        LeaderRecoveryState leaderRecoveryState = item.leaderAndIsr().leaderRecoveryState();
        LeaderRecoveryState leaderRecoveryState2 = LeaderRecoveryState.RECOVERING;
        AlterPartitionRequestData.PartitionData partitionData = new AlterPartitionRequestData.PartitionData().setPartitionIndex(item.topicIdPartition().partition()).setLeaderEpoch(item.leaderAndIsr().leaderEpoch()).setNewIsrWithEpochs(CollectionConverters$.MODULE$.SeqHasAsJava(item.leaderAndIsr().isrWithBrokerEpoch()).asJava()).setPartitionEpoch(item.leaderAndIsr().partitionEpoch()).setIsUnclean(!(leaderRecoveryState != null ? !leaderRecoveryState.equals(leaderRecoveryState2) : leaderRecoveryState2 != null));
        if (metadataVersion$1.isLeaderRecoverySupported()) {
            partitionData.setLeaderRecoveryState(item.leaderAndIsr().leaderRecoveryState().value());
        }
        item.leaderAndIsr().clusterLinkState().foreach((Function1 & Serializable)linkState -> {
            partitionData.setClusterLinkState(new AlterPartitionRequestData.ClusterLinkState().setLinkedLeaderEpoch(linkState.linkedLeaderEpoch()).setLinkFailed(linkState.linkFailed()));
            if (linkState.linkFailed()) {
                return partitionData.setMirrorTopicError(linkState.error().code());
            }
            return BoxedUnit.UNIT;
        });
        return topicData$1.partitions().add(partitionData);
    }

    public static final /* synthetic */ void $anonfun$buildRequest$2(BooleanRef canUseTopicIds$1, HashMap topicNamesByIds$2, AlterPartitionRequestData message$1, MetadataVersion metadataVersion$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topicName = (String)x0$1._1();
            Seq items = (Seq)x0$1._2();
            Uuid topicId = ((AlterPartitionItem)items.head()).topicIdPartition().topicId();
            Uuid uuid = topicId;
            Uuid uuid2 = Uuid.ZERO_UUID;
            canUseTopicIds$1.elem = canUseTopicIds$1.elem & (uuid == null ? uuid2 != null : !uuid.equals(uuid2));
            topicNamesByIds$2.update((Object)topicId, (Object)topicName);
            AlterPartitionRequestData.TopicData topicData = new AlterPartitionRequestData.TopicData().setTopicName(topicName).setTopicId(topicId);
            message$1.topics().add(topicData);
            items.foreach((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)DefaultAlterPartitionManager.$anonfun$buildRequest$3(metadataVersion$1, topicData, item)));
            return;
        }
        throw new MatchError(null);
    }

    public DefaultAlterPartitionManager(NodeToControllerChannelManager controllerChannelManager, Scheduler scheduler, Time time, int brokerId, Function0<Object> brokerEpochSupplier, Function0<MetadataVersion> metadataVersionSupplier) {
        this.controllerChannelManager = controllerChannelManager;
        this.scheduler = scheduler;
        this.time = time;
        this.brokerId = brokerId;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.metadataVersionSupplier = metadataVersionSupplier;
        this.unsentIsrUpdates = new ConcurrentHashMap<TopicPartition, AlterPartitionItem>();
        this.inflightRequest = new AtomicBoolean(false);
    }
}

