/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import java.io.Serializable;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicLong;
import kafka.server.DiskThrottleListenerManager;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.DiskUsageBasedThrottler$;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.QuotaType;
import kafka.server.QuotaType$ClusterLinkReplication$;
import kafka.server.QuotaType$FollowerReplication$;
import kafka.server.QuotaType$Produce$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\rfaB\u0014)!\u0003\r\t!\f\u0005\u0006u\u0001!\ta\u000f\u0005\u0006\u007f\u00011\t\u0002\u0011\u0005\b\u000b\u0002\u0001\r\u0011\"\u0003A\u0011\u001dQ\u0005\u00011A\u0005\n-CQA\u0014\u0001\u0007\u0012=Cq\u0001\u0018\u0001C\u0002\u0013%Q\fC\u0004k\u0001\t\u0007I\u0011B6\t\u000bM\u0004A\u0011\u0003;\t\u0011\u0005\u001d\u0001\u00011A\u0005\nQD\u0011\"a\u0003\u0001\u0001\u0004%I!!\u0004\t\u0015\u0005E\u0001\u00011A\u0005\u0002!\n\u0019\u0002\u0003\u0006\u0002\u001e\u0001\u0001\r\u0011\"\u0001)\u0003?A\u0011\"a\t\u0001\u0001\u0004%I!a\u0005\t\u0013\u0005\u001d\u0002\u00011A\u0005\n\u0005%\u0002BCA\u0017\u0001\u0001\u0007I\u0011\u0001\u0015\u0002\u0014!Q\u0011\u0011\u0007\u0001A\u0002\u0013\u0005\u0001&a\r\t\u0013\u0005]\u0002A1A\u0005\u0002\u0005e\u0002BBA!\u0001\u0011\u00051\b\u0003\u0004\u0002D\u0001!\ta\u000f\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011!\ti\u0005\u0001C\tQ\u0005=\u0003\u0002CA.\u0001\u0011E\u0001&a\u0005\t\u0011\u0005u\u0003\u0001\"\u0005)\u0003'Aq!a\u0018\u0001\t\u0003\t\t\u0007\u0003\u0004\u0002h\u0001!Ia\u000f\u0005\b\u0003S\u0002A\u0011BA6\u0011\u001d\ti\u0007\u0001C\tQmBq!a\u001c\u0001\t\u0013\t\t\bC\u0004\u0002~\u0001!\t\u0002\u000b!\b\u000f\u0005}\u0004\u0006#\u0001\u0002\u0002\u001a1q\u0005\u000bE\u0001\u0003\u0007Cq!!\" \t\u0003\t9\tC\u0005\u0002\n~\u0011\r\u0011\"\u0001\u0002\f\"A\u0011\u0011T\u0010!\u0002\u0013\ti\tC\u0005\u0002\u001c~\u0011\r\u0011\"\u0001\u0002\f\"A\u0011QT\u0010!\u0002\u0013\ti\tC\u0005\u0002 ~\u0011\r\u0011\"\u0001\u0002\f\"A\u0011\u0011U\u0010!\u0002\u0013\tiIA\fESN\\Wk]1hK\n\u000b7/\u001a3UQJ|G\u000f\u001e7fe*\u0011\u0011FK\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003-\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001]Q\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u001b9\u001b\u00051$BA\u001c+\u0003\u0015)H/\u001b7t\u0013\tIdGA\u0004M_\u001e<\u0017N\\4\u0002\r\u0011Jg.\u001b;%)\u0005a\u0004CA\u0018>\u0013\tq\u0004G\u0001\u0003V]&$\u0018\u0001\u00063jg.$\u0006N]8ui2LgnZ\"p]\u001aLw-F\u0001B!\t\u00115)D\u0001)\u0013\t!\u0005F\u0001\u0010ESN\\Wk]1hK\n\u000b7/\u001a3UQJ|G\u000f\u001e7j]\u001e\u001cuN\u001c4jO\u0006YB-\u001f8b[&\u001cG)[:l)\"\u0014x\u000e\u001e;mS:<7i\u001c8gS\u001eD#aA$\u0011\u0005=B\u0015BA%1\u0005!1x\u000e\\1uS2,\u0017a\b3z]\u0006l\u0017n\u0019#jg.$\u0006N]8ui2LgnZ\"p]\u001aLwm\u0018\u0013fcR\u0011A\b\u0014\u0005\b\u001b\u0012\t\t\u00111\u0001B\u0003\rAH%M\u0001\u0005i&lW-F\u0001Q!\t\t&,D\u0001S\u0015\t94K\u0003\u0002U+\u000611m\\7n_:T!a\u000b,\u000b\u0005]C\u0016AB1qC\u000eDWMC\u0001Z\u0003\ry'oZ\u0005\u00037J\u0013A\u0001V5nK\u0006yA.Y:u\u0007\",7m[3e)&lW-F\u0001_!\ty\u0006.D\u0001a\u0015\t\t'-\u0001\u0004bi>l\u0017n\u0019\u0006\u0003G\u0012\f!bY8oGV\u0014(/\u001a8u\u0015\t)g-\u0001\u0003vi&d'\"A4\u0002\t)\fg/Y\u0005\u0003S\u0002\u0014!\"\u0011;p[&\u001cGj\u001c8h\u00031iW\r\u001e:jGN<%o\\;q+\u0005a\u0007CA7r\u001b\u0005q'BA8q\u0003\u001diW\r\u001e:jGNT!!K+\n\u0005It'!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006iq-\u001a;GS2,7\u000b^8sKN,\u0012!\u001e\t\u0004mf\\X\"A<\u000b\u0005a\u0004\u0014AC2pY2,7\r^5p]&\u0011!p\u001e\u0002\u0004'\u0016\f\bc\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u0006!a-\u001b7f\u0015\r\t\tAZ\u0001\u0004]&|\u0017bAA\u0003{\nIa)\u001b7f'R|'/Z\u0001\u000bM&dWm\u0015;pe\u0016\u001c\bFA\u0005H\u000391\u0017\u000e\\3Ti>\u0014Xm]0%KF$2\u0001PA\b\u0011\u001di%\"!AA\u0002U\fA\u0003\u001d:pIV\u001cWM\u001d+ie>$H\u000f\\3SCR,WCAA\u000b!\ry\u0013qC\u0005\u0004\u00033\u0001$\u0001\u0002'p]\u001eD#aC$\u00021A\u0014x\u000eZ;dKJ$\u0006N]8ui2,'+\u0019;f?\u0012*\u0017\u000fF\u0002=\u0003CA\u0001\"\u0014\u0007\u0002\u0002\u0003\u0007\u0011QC\u0001\u0018G2,8\u000f^3s\u0019&t7\u000e\u00165s_R$H.\u001a*bi\u0016D#!D$\u00027\rdWo\u001d;fe2Kgn\u001b+ie>$H\u000f\\3SCR,w\fJ3r)\ra\u00141\u0006\u0005\t\u001b:\t\t\u00111\u0001\u0002\u0016\u0005!bm\u001c7m_^,'\u000f\u00165s_R$H.\u001a*bi\u0016D#aD$\u00021\u0019|G\u000e\\8xKJ$\u0006N]8ui2,'+\u0019;f?\u0012*\u0017\u000fF\u0002=\u0003kA\u0001\"\u0014\t\u0002\u0002\u0003\u0007\u0011QC\u0001\u0010Y&\u001cH/\u001a8fe6\u000bg.Y4feV\u0011\u00111\b\t\u0004\u0005\u0006u\u0012bAA Q\tYB)[:l)\"\u0014x\u000e\u001e;mK2K7\u000f^3oKJl\u0015M\\1hKJ\f!d\u0019:fCR,G)[:l)\"\u0014x\u000e\u001e;mKJlU\r\u001e:jGN\f!D]3n_Z,G)[:l)\"\u0014x\u000e\u001e;mKJlU\r\u001e:jGN\f!$\u001e9eCR,G)[:l)\"\u0014x\u000e\u001e;mS:<7i\u001c8gS\u001e$2\u0001PA%\u0011\u0019\tY\u0005\u0006a\u0001\u0003\u0006Ia.Z<D_:4\u0017nZ\u0001\u001eI&\u001c8\u000e\u00165s_R$H.\u001b8h\u000b:\f'\r\\3e\u0013:\u001cuN\u001c4jOR!\u0011\u0011KA,!\ry\u00131K\u0005\u0004\u0003+\u0002$a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u00033*\u0002\u0019A!\u0002\r\r|gNZ5h\u0003Ei\u0017N\u001c#jg.$v\u000e^1m\u0005f$Xm]\u0001\u0013[&tG)[:l+N\f'\r\\3CsR,7/\u0001\u0010dQ\u0016\u001c7.\u00118e+B$\u0017\r^3Rk>$\u0018m\u00148ESN\\Wk]1hKR\u0019A(a\u0019\t\u000f\u0005\u0015\u0004\u00041\u0001\u0002\u0016\u00051A/[7f\u001bN\f\u0011\u0004Z8DQ\u0016\u001c7.\u00118e+B$\u0017\r^3UQJ|G\u000f\u001e7fg\u0006\u0011R.Y=cKN+GOR5mKN#xN]3t)\t\t\t&A\u0007j]&$H\u000b\u001b:piRdWM]\u0001\u0010kB$\u0017\r^3MSN$XM\\3sgR\u0019A(a\u001d\t\u000f\u0005UD\u00041\u0001\u0002x\u0005i\u0011/^8uC2KW.\u001b;PaR\u0004RaLA=\u0003+I1!a\u001f1\u0005\u0019y\u0005\u000f^5p]\u0006qr-\u001a;DkJ\u0014XM\u001c;ESN\\G\u000b\u001b:piRd\u0017N\\4D_:4\u0017nZ\u0001\u0018\t&\u001c8.V:bO\u0016\u0014\u0015m]3e)\"\u0014x\u000e\u001e;mKJ\u0004\"AQ\u0010\u0014\t}q\u00131H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005\u0005\u0015A\b)s_\u0012,8-\u001a:ESN\\G\u000b\u001b:piRdW-T3ue&\u001cg*Y7f+\t\ti\t\u0005\u0003\u0002\u0010\u0006UUBAAI\u0015\r\t\u0019JZ\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0018\u0006E%AB*ue&tw-A\u0010Qe>$WoY3s\t&\u001c8\u000e\u00165s_R$H.Z'fiJL7MT1nK\u0002\nQEU3qY&\u001c\u0017\r^5p]\u001a{G\u000e\\8xKJ$\u0006N]8ui2,W*\u001a;sS\u000et\u0015-\\3\u0002MI+\u0007\u000f\\5dCRLwN\u001c$pY2|w/\u001a:UQJ|G\u000f\u001e7f\u001b\u0016$(/[2OC6,\u0007%A\u0011DYV\u001cH/\u001a:MS:\\G)[:l)\"\u0014x\u000e\u001e;mK6+GO]5d\u001d\u0006lW-\u0001\u0012DYV\u001cH/\u001a:MS:\\G)[:l)\"\u0014x\u000e\u001e;mK6+GO]5d\u001d\u0006lW\r\t")
public interface DiskUsageBasedThrottler
extends Logging {
    public static String ClusterLinkDiskThrottleMetricName() {
        return DiskUsageBasedThrottler$.MODULE$.ClusterLinkDiskThrottleMetricName();
    }

    public static String ReplicationFollowerThrottleMetricName() {
        return DiskUsageBasedThrottler$.MODULE$.ReplicationFollowerThrottleMetricName();
    }

    public static String ProducerDiskThrottleMetricName() {
        return DiskUsageBasedThrottler$.MODULE$.ProducerDiskThrottleMetricName();
    }

    public void kafka$server$DiskUsageBasedThrottler$_setter_$kafka$server$DiskUsageBasedThrottler$$lastCheckedTime_$eq(AtomicLong var1);

    public void kafka$server$DiskUsageBasedThrottler$_setter_$kafka$server$DiskUsageBasedThrottler$$metricsGroup_$eq(KafkaMetricsGroup var1);

    public void kafka$server$DiskUsageBasedThrottler$_setter_$listenerManager_$eq(DiskThrottleListenerManager var1);

    public DiskUsageBasedThrottlingConfig diskThrottlingConfig();

    public DiskUsageBasedThrottlingConfig kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig();

    public void kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig_$eq(DiskUsageBasedThrottlingConfig var1);

    public Time time();

    public AtomicLong kafka$server$DiskUsageBasedThrottler$$lastCheckedTime();

    public KafkaMetricsGroup kafka$server$DiskUsageBasedThrottler$$metricsGroup();

    public static /* synthetic */ Seq getFileStores$(DiskUsageBasedThrottler $this) {
        return $this.getFileStores();
    }

    default public Seq<FileStore> getFileStores() {
        try {
            return (Seq)this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().logDirs().map((Function1 & Serializable)logDir -> Files.getFileStore(Paths.get(logDir, new String[0])));
        }
        catch (Exception e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(111).append("Couldn't create file-stores for logDirs: ").append(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().logDirs()).append(", ").append("however, this is normal at startup with non-existent log directories").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return (Seq)Seq$.MODULE$.empty();
        }
    }

    public Seq<FileStore> kafka$server$DiskUsageBasedThrottler$$fileStores();

    public void kafka$server$DiskUsageBasedThrottler$$fileStores_$eq(Seq<FileStore> var1);

    public long producerThrottleRate();

    public void producerThrottleRate_$eq(long var1);

    public long kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate();

    public void kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate_$eq(long var1);

    public long followerThrottleRate();

    public void followerThrottleRate_$eq(long var1);

    public DiskThrottleListenerManager listenerManager();

    public static /* synthetic */ void createDiskThrottlerMetrics$(DiskUsageBasedThrottler $this) {
        $this.createDiskThrottlerMetrics();
    }

    default public void createDiskThrottlerMetrics() {
        this.kafka$server$DiskUsageBasedThrottler$$metricsGroup().newGauge(DiskUsageBasedThrottler$.MODULE$.ProducerDiskThrottleMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ DiskUsageBasedThrottler $outer;

            public final long value() {
                DiskUsageBasedThrottler diskUsageBasedThrottler = this.$outer;
                if (diskUsageBasedThrottler == null) {
                    throw null;
                }
                return diskUsageBasedThrottler.producerThrottleRate();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$server$DiskUsageBasedThrottler$$metricsGroup().newGauge(DiskUsageBasedThrottler$.MODULE$.ReplicationFollowerThrottleMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ DiskUsageBasedThrottler $outer;

            public final long value() {
                DiskUsageBasedThrottler diskUsageBasedThrottler = this.$outer;
                if (diskUsageBasedThrottler == null) {
                    throw null;
                }
                return diskUsageBasedThrottler.followerThrottleRate();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$server$DiskUsageBasedThrottler$$metricsGroup().newGauge(DiskUsageBasedThrottler$.MODULE$.ClusterLinkDiskThrottleMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ DiskUsageBasedThrottler $outer;

            public final long value() {
                DiskUsageBasedThrottler diskUsageBasedThrottler = this.$outer;
                if (diskUsageBasedThrottler == null) {
                    throw null;
                }
                return diskUsageBasedThrottler.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static /* synthetic */ void removeDiskThrottlerMetrics$(DiskUsageBasedThrottler $this) {
        $this.removeDiskThrottlerMetrics();
    }

    default public void removeDiskThrottlerMetrics() {
        this.kafka$server$DiskUsageBasedThrottler$$metricsGroup().removeMetric(DiskUsageBasedThrottler$.MODULE$.ProducerDiskThrottleMetricName());
        this.kafka$server$DiskUsageBasedThrottler$$metricsGroup().removeMetric(DiskUsageBasedThrottler$.MODULE$.ReplicationFollowerThrottleMetricName());
        this.kafka$server$DiskUsageBasedThrottler$$metricsGroup().removeMetric(DiskUsageBasedThrottler$.MODULE$.ClusterLinkDiskThrottleMetricName());
    }

    public static /* synthetic */ void updateDiskThrottlingConfig$(DiskUsageBasedThrottler $this, DiskUsageBasedThrottlingConfig newConfig) {
        $this.updateDiskThrottlingConfig(newConfig);
    }

    default public void updateDiskThrottlingConfig(DiskUsageBasedThrottlingConfig newConfig) {
        if (this.diskThrottlingEnabledInConfig(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig()) && !this.diskThrottlingEnabledInConfig(newConfig)) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Disabling disk based throttling based on new config: {}", (Object)newConfig);
            }
            this.updateListeners((Option<Object>)None$.MODULE$);
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Updating disk throttling config from: {} to {}", new Object[]{this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig(), newConfig});
        }
        this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig_$eq(newConfig);
        this.checkAndUpdateQuotaOnDiskUsage(this.time().milliseconds());
    }

    public static /* synthetic */ boolean diskThrottlingEnabledInConfig$(DiskUsageBasedThrottler $this, DiskUsageBasedThrottlingConfig config) {
        return $this.diskThrottlingEnabledInConfig(config);
    }

    default public boolean diskThrottlingEnabledInConfig(DiskUsageBasedThrottlingConfig config) {
        return config.enableDiskBasedThrottling() && config.logDirs().nonEmpty();
    }

    public static /* synthetic */ long minDiskTotalBytes$(DiskUsageBasedThrottler $this) {
        return $this.minDiskTotalBytes();
    }

    default public long minDiskTotalBytes() {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.kafka$server$DiskUsageBasedThrottler$$fileStores().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getTotalSpace()))).min((Ordering)Ordering.Long$.MODULE$));
    }

    public static /* synthetic */ long minDiskUsableBytes$(DiskUsageBasedThrottler $this) {
        return $this.minDiskUsableBytes();
    }

    default public long minDiskUsableBytes() {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.kafka$server$DiskUsageBasedThrottler$$fileStores().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.getUsableSpace()))).min((Ordering)Ordering.Long$.MODULE$));
    }

    public static /* synthetic */ void checkAndUpdateQuotaOnDiskUsage$(DiskUsageBasedThrottler $this, long timeMs) {
        $this.checkAndUpdateQuotaOnDiskUsage(timeMs);
    }

    default public void checkAndUpdateQuotaOnDiskUsage(long timeMs) {
        if (!this.diskThrottlingEnabledInConfig(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig())) {
            return;
        }
        long lastCheck = this.kafka$server$DiskUsageBasedThrottler$$lastCheckedTime().get();
        if (lastCheck + this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().diskCheckFrequencyMs() > timeMs) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Current time: {} still early for next check at: {}", new Object[]{BoxesRunTime.boxToLong((long)timeMs), BoxesRunTime.boxToLong((long)(lastCheck + this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().diskCheckFrequencyMs()))});
            }
            return;
        }
        if (this.kafka$server$DiskUsageBasedThrottler$$lastCheckedTime().compareAndSet(lastCheck, timeMs)) {
            this.doCheckAndUpdateThrottles();
            return;
        }
    }

    private void doCheckAndUpdateThrottles() {
        if (this.kafka$server$DiskUsageBasedThrottler$$fileStores().nonEmpty() || this.maybeSetFileStores()) {
            if (this.minDiskUsableBytes() < this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytes()) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Disk with the lowest free space: {}B available < threshold: {}B, will apply throttle!", new Object[]{BoxesRunTime.boxToLong((long)this.minDiskUsableBytes()), BoxesRunTime.boxToLong((long)this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytes())});
                }
                this.updateListeners((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().throttledProduceThroughput())));
                return;
            }
            if (this.listenerManager().anyListenerIsThrottled() && (double)this.minDiskUsableBytes() >= this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytesRecoveryFactor() * (double)this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytes()) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Disk with the lowest free space: {}B available >= {} x threshold: {}B, will remove low disk space throttle", new Object[]{BoxesRunTime.boxToLong((long)this.minDiskUsableBytes()), BoxesRunTime.boxToDouble((double)this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytesRecoveryFactor()), BoxesRunTime.boxToLong((long)this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytes())});
                }
                this.updateListeners((Option<Object>)None$.MODULE$);
                return;
            }
            return;
        }
    }

    private boolean maybeSetFileStores() {
        Seq<FileStore> seq = this.getFileStores();
        if (seq.nonEmpty()) {
            this.kafka$server$DiskUsageBasedThrottler$$fileStores_$eq(seq);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Created file-stores for logDirs: ").append(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().logDirs()).toString());
            return true;
        }
        return false;
    }

    public static /* synthetic */ void initThrottler$(DiskUsageBasedThrottler $this) {
        $this.initThrottler();
    }

    default public void initThrottler() {
        this.createDiskThrottlerMetrics();
        if (this.diskThrottlingEnabledInConfig(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig())) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Initializing low disk space throttle with config: {}", (Object)this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig());
            }
            this.kafka$server$DiskUsageBasedThrottler$$lastCheckedTime().set(this.time().milliseconds());
            this.doCheckAndUpdateThrottles();
            return;
        }
    }

    private void updateListeners(Option<Object> quotaLimitOpt) {
        this.listenerManager().getListeners().foreach((Function1 & Serializable)listener -> {
            DiskUsageBasedThrottler.$anonfun$updateListeners$1(this, quotaLimitOpt, listener);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ DiskUsageBasedThrottlingConfig getCurrentDiskThrottlingConfig$(DiskUsageBasedThrottler $this) {
        return $this.getCurrentDiskThrottlingConfig();
    }

    default public DiskUsageBasedThrottlingConfig getCurrentDiskThrottlingConfig() {
        return this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig();
    }

    public static /* synthetic */ long kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$1$(DiskUsageBasedThrottler $this) {
        return $this.kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$1();
    }

    default public /* synthetic */ long kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$1() {
        return this.producerThrottleRate();
    }

    public static /* synthetic */ long kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$3$(DiskUsageBasedThrottler $this) {
        return $this.kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$3();
    }

    default public /* synthetic */ long kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$3() {
        return this.followerThrottleRate();
    }

    public static /* synthetic */ long kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$5$(DiskUsageBasedThrottler $this) {
        return $this.kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$5();
    }

    default public /* synthetic */ long kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$5() {
        return this.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate();
    }

    public static /* synthetic */ void $anonfun$updateListeners$1(DiskUsageBasedThrottler $this, Option quotaLimitOpt$1, DiskUsageBasedThrottleListener listener) {
        Option<Object> option = listener.lastSignalledQuotaOptRef().getAndSet((Option<Object>)quotaLimitOpt$1);
        if (option == null ? quotaLimitOpt$1 != null : !option.equals((Object)quotaLimitOpt$1)) {
            if (quotaLimitOpt$1 instanceof Some) {
                long quotaLimit = BoxesRunTime.unboxToLong((Object)((Some)quotaLimitOpt$1).value());
                QuotaType quotaType = listener.quotaType();
                if (QuotaType$Produce$.MODULE$.equals(quotaType)) {
                    listener.handleDiskSpaceLow(quotaLimit);
                    $this.producerThrottleRate_$eq(quotaLimit);
                    return;
                }
                if (QuotaType$ClusterLinkReplication$.MODULE$.equals(quotaType)) {
                    listener.handleDiskSpaceLow(quotaLimit);
                    $this.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate_$eq(quotaLimit);
                    return;
                }
                if (QuotaType$FollowerReplication$.MODULE$.equals(quotaType)) {
                    int multiplier = $this.diskThrottlingConfig().clusterLinkEnabled() ? 4 : 2;
                    listener.handleDiskSpaceLow((long)multiplier * quotaLimit);
                    $this.followerThrottleRate_$eq((long)multiplier * quotaLimit);
                    return;
                }
                return;
            }
            if (None$.MODULE$.equals(quotaLimitOpt$1)) {
                listener.handleDiskSpaceRecovered();
                QuotaType quotaType = listener.quotaType();
                if (QuotaType$Produce$.MODULE$.equals(quotaType)) {
                    $this.producerThrottleRate_$eq(0L);
                    return;
                }
                if (QuotaType$FollowerReplication$.MODULE$.equals(quotaType)) {
                    $this.followerThrottleRate_$eq(0L);
                    return;
                }
                if (QuotaType$ClusterLinkReplication$.MODULE$.equals(quotaType)) {
                    $this.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate_$eq(0L);
                    return;
                }
                return;
            }
            throw new MatchError((Object)quotaLimitOpt$1);
        }
    }

    public static void $init$(DiskUsageBasedThrottler $this) {
        $this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig_$eq($this.diskThrottlingConfig());
        $this.kafka$server$DiskUsageBasedThrottler$_setter_$kafka$server$DiskUsageBasedThrottler$$lastCheckedTime_$eq(new AtomicLong($this.time().milliseconds()));
        $this.kafka$server$DiskUsageBasedThrottler$_setter_$kafka$server$DiskUsageBasedThrottler$$metricsGroup_$eq(new KafkaMetricsGroup($this.getClass()));
        $this.kafka$server$DiskUsageBasedThrottler$$fileStores_$eq($this.getFileStores());
        $this.producerThrottleRate_$eq(0L);
        $this.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate_$eq(0L);
        $this.followerThrottleRate_$eq(0L);
        $this.kafka$server$DiskUsageBasedThrottler$_setter_$listenerManager_$eq(DiskUsageBasedThrottler$.MODULE$);
    }
}

