/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.http.server.KafkaHttpServerBinder;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import kafka.common.TenantHelpers;
import kafka.raft.KafkaRaftManager;
import kafka.server.DynamicBrokerConfig;
import kafka.server.FaultHandlerFactory;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.Server$;
import kafka.server.metadata.BrokerServerMetrics;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.MetadataLoader;
import org.apache.kafka.image.loader.metrics.MetadataLoaderMetrics;
import org.apache.kafka.image.publisher.SnapshotEmitter;
import org.apache.kafka.image.publisher.SnapshotGenerator;
import org.apache.kafka.image.publisher.metrics.SnapshotEmitterMetrics;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.metrics.ClientMetricsReceiverPlugin;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\ruh\u0001B0a\u0001\u0015D\u0001B\u001d\u0001\u0003\u0006\u0004%\ta\u001d\u0005\tq\u0002\u0011\t\u0011)A\u0005i\"A\u0011\u0010\u0001BC\u0002\u0013\u0005!\u0010C\u0005\u0002\u0012\u0001\u0011\t\u0011)A\u0005w\"Q\u00111\u0003\u0001\u0003\u0006\u0004%\t!!\u0006\t\u0015\u0005\u0015\u0002A!A!\u0002\u0013\t9\u0002\u0003\u0006\u0002(\u0001\u0011)\u0019!C\u0005\u0003SA!\"a\u000e\u0001\u0005\u0003\u0005\u000b\u0011BA\u0016\u0011)\tI\u0004\u0001BC\u0002\u0013\u0005\u00111\b\u0005\u000b\u0003\u001b\u0003!\u0011!Q\u0001\n\u0005u\u0002BCAH\u0001\t\u0015\r\u0011\"\u0001\u0002\u0012\"Q\u0011\u0011\u0014\u0001\u0003\u0002\u0003\u0006I!a%\t\u0015\u0005m\u0005A!b\u0001\n\u0003\ti\n\u0003\u0006\u00024\u0002\u0011\t\u0011)A\u0005\u0003?C!\"!.\u0001\u0005\u000b\u0007I\u0011AA\\\u0011)\t\t\r\u0001B\u0001B\u0003%\u0011\u0011\u0018\u0005\u000b\u0003\u0007\u0004!Q1A\u0005\u0002\u0005\u0015\u0007BCAf\u0001\t\u0005\t\u0015!\u0003\u0002H\"9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0007\"CAs\u0001\t\u0007I\u0011BAt\u0011!\ty\u000f\u0001Q\u0001\n\u0005%\b\"CAy\u0001\u0001\u0007I\u0011BAz\u0011%\tY\u0010\u0001a\u0001\n\u0013\ti\u0010\u0003\u0005\u0003\n\u0001\u0001\u000b\u0015BA{\u0011%\u0011Y\u0001\u0001a\u0001\n\u0013\t\u0019\u0010C\u0005\u0003\u000e\u0001\u0001\r\u0011\"\u0003\u0003\u0010!A!1\u0003\u0001!B\u0013\t)\u0010C\u0005\u0003\u0016\u0001\u0001\r\u0011\"\u0003\u0002t\"I!q\u0003\u0001A\u0002\u0013%!\u0011\u0004\u0005\t\u0005;\u0001\u0001\u0015)\u0003\u0002v\"A!q\u0004\u0001C\u0002\u0013\u00051\u000fC\u0004\u0003\"\u0001\u0001\u000b\u0011\u0002;\t\u0011\t\r\u0002\u00011A\u0005\u0002MD\u0011B!\n\u0001\u0001\u0004%\tAa\n\t\u000f\t-\u0002\u0001)Q\u0005i\"I!Q\u0006\u0001C\u0002\u0013\u0005!q\u0006\u0005\t\u0005o\u0001\u0001\u0015!\u0003\u00032!I\u0011\u0011\u0007\u0001A\u0002\u0013\u0005\u0011\u0011\u0006\u0005\n\u0005s\u0001\u0001\u0019!C\u0001\u0005wA\u0001Ba\u0010\u0001A\u0003&\u00111\u0006\u0005\f\u0005\u0013\u0002\u0001\u0019!a\u0001\n\u0003\u0011Y\u0005C\u0006\u0003b\u0001\u0001\r\u00111A\u0005\u0002\t\r\u0004b\u0003B4\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u001bB1Ba\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003n!Y!\u0011\u0010\u0001A\u0002\u0003\u0007I\u0011\u0001B>\u0011-\u0011y\b\u0001a\u0001\u0002\u0003\u0006KAa\u001c\t\u0017\t\r\u0005\u00011AA\u0002\u0013\u0005!Q\u0011\u0005\f\u0005+\u0003\u0001\u0019!a\u0001\n\u0003\u00119\nC\u0006\u0003\u001c\u0002\u0001\r\u0011!Q!\n\t\u001d\u0005b\u0003BP\u0001\u0001\u0007\t\u0019!C\u0001\u0005CC1B!-\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00034\"Y!q\u0017\u0001A\u0002\u0003\u0005\u000b\u0015\u0002BR\u0011%\u0011Y\f\u0001b\u0001\n\u0003\u0011i\f\u0003\u0005\u0003\\\u0002\u0001\u000b\u0011\u0002B`\u0011-\u0011i\u000e\u0001a\u0001\u0002\u0004%\tAa8\t\u0017\t5\b\u00011AA\u0002\u0013\u0005!q\u001e\u0005\f\u0005g\u0004\u0001\u0019!A!B\u0013\u0011\t\u000fC\u0006\u0003x\u0002\u0001\r\u00111A\u0005\u0002\te\bbCB\u0001\u0001\u0001\u0007\t\u0019!C\u0001\u0007\u0007A1ba\u0002\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003|\"Y11\u0002\u0001A\u0002\u0003\u0007I\u0011AB\u0007\u0011-\u0019I\u0002\u0001a\u0001\u0002\u0004%\taa\u0007\t\u0017\r}\u0001\u00011A\u0001B\u0003&1q\u0002\u0005\f\u0007G\u0001\u0001\u0019!a\u0001\n\u0003\u0019)\u0003C\u0006\u0004>\u0001\u0001\r\u00111A\u0005\u0002\r}\u0002bCB\"\u0001\u0001\u0007\t\u0011)Q\u0005\u0007OA1b!\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0004H!Y1\u0011\r\u0001A\u0002\u0003\u0007I\u0011AB2\u0011-\u00199\u0007\u0001a\u0001\u0002\u0003\u0006Ka!\u0013\t\u000f\r%\u0004\u0001\"\u0003\u0004l!91\u0011\u000f\u0001\u0005\u0002\rM\u0004bBB;\u0001\u0011\u00051q\u000f\u0005\b\u0007\u007f\u0002A\u0011ABA\u0011\u001d\u0019\u0019\t\u0001C\u0001\u0007\u000bCqa!(\u0001\t\u0003\u0019y\nC\u0004\u0004$\u0002!\ta!*\t\u000f\r\u001d\u0006\u0001\"\u0001\u0004&\"91\u0011\u0016\u0001\u0005\u0002\r-\u0006bBB]\u0001\u0011\u000511\u0016\u0005\b\u0007w\u0003A\u0011ABV\u0011\u001d\u0019i\f\u0001C\u0001\u0007WCqaa0\u0001\t\u0003\u0019Y\u000bC\u0004\u0004B\u0002!\taa+\t\u000f\r\r\u0007\u0001\"\u0001\u0004,\"91Q\u0019\u0001\u0005\n\r\u001d\u0007bBBf\u0001\u0011\u00051Q\u0015\u0005\b\u0007\u001b\u0004A\u0011BBS\u0011\u001d\u0019y\r\u0001C\u0001\u0007KCqa!5\u0001\t\u0013\u0019\u0019\u000eC\u0004\u0004X\u0002!\ta!7\b\u0013\ru\u0007-!A\t\u0002\r}g\u0001C0a\u0003\u0003E\ta!9\t\u000f\u00055G\f\"\u0001\u0004d\"I1Q\u001d/\u0012\u0002\u0013\u00051q\u001d\u0002\r'\"\f'/\u001a3TKJ4XM\u001d\u0006\u0003C\n\faa]3sm\u0016\u0014(\"A2\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\u001a7\u0011\u0005\u001dTW\"\u00015\u000b\u0003%\fQa]2bY\u0006L!a\u001b5\u0003\r\u0005s\u0017PU3g!\ti\u0007/D\u0001o\u0015\ty'-A\u0003vi&d7/\u0003\u0002r]\n9Aj\\4hS:<\u0017AE:iCJ,GmU3sm\u0016\u00148i\u001c8gS\u001e,\u0012\u0001\u001e\t\u0003kZl\u0011\u0001Y\u0005\u0003o\u0002\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006\u00192\u000f[1sK\u0012\u001cVM\u001d<fe\u000e{gNZ5hA\u0005\tR.\u001a;b!J|\u0007o]#og\u0016l'\r\\3\u0016\u0003m\u00042\u0001`A\u0007\u001b\u0005i(B\u0001@\u0000\u0003)\u0001(o\u001c9feRLWm\u001d\u0006\u0005\u0003\u0003\t\u0019!\u0001\u0005nKR\fG-\u0019;b\u0015\r\u0019\u0017Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0017\t1a\u001c:h\u0013\r\ty! \u0002\u0017\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t\u000b:\u001cX-\u001c2mK\u0006\u0011R.\u001a;b!J|\u0007o]#og\u0016l'\r\\3!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005]\u0001\u0003BA\r\u0003Ci!!a\u0007\u000b\u0007=\fiB\u0003\u0003\u0002 \u0005\r\u0011AB2p[6|g.\u0003\u0003\u0002$\u0005m!\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\n\u0001bX7fiJL7m]\u000b\u0003\u0003W\u0001B!!\f\u000245\u0011\u0011q\u0006\u0006\u0005\u0003c\ti\"A\u0004nKR\u0014\u0018nY:\n\t\u0005U\u0012q\u0006\u0002\b\u001b\u0016$(/[2t\u0003%yV.\u001a;sS\u000e\u001c\b%\u0001\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3\u0016\u0005\u0005u\u0002CBA \u0003\u001b\n\t&\u0004\u0002\u0002B)!\u00111IA#\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003\u000f\nI%\u0001\u0003vi&d'BAA&\u0003\u0011Q\u0017M^1\n\t\u0005=\u0013\u0011\t\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003CA*\u0003+\nI&!\u001a\u000e\u0005\u0005\u0015\u0013\u0002BA,\u0003\u000b\u00121!T1q!\u0011\tY&!\u0019\u000e\u0005\u0005u#\u0002BA0\u0003\u0013\nA\u0001\\1oO&!\u00111MA/\u0005\u001dIe\u000e^3hKJ\u0004B!a\u001a\u0002\b:!\u0011\u0011NAA\u001d\u0011\tY'! \u000f\t\u00055\u00141\u0010\b\u0005\u0003_\nIH\u0004\u0003\u0002r\u0005]TBAA:\u0015\r\t)\bZ\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005-\u0011\u0002BA\u0004\u0003\u0013I1aYA\u0003\u0013\u0011\ty(a\u0001\u0002\tI\fg\r^\u0005\u0005\u0003\u0007\u000b))\u0001\u0006SC\u001a$8i\u001c8gS\u001eTA!a \u0002\u0004%!\u0011\u0011RAF\u0005-\tE\r\u001a:fgN\u001c\u0006/Z2\u000b\t\u0005\r\u0015QQ\u0001\u001eG>tGO]8mY\u0016\u0014\u0018+^8sk64v\u000e^3sg\u001a+H/\u001e:fA\u0005\u0019b-Y;mi\"\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ssV\u0011\u00111\u0013\t\u0004k\u0006U\u0015bAALA\n\u0019b)Y;mi\"\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ss\u0006!b-Y;mi\"\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ss\u0002\n1#\\;mi&$VM\\1oi6+G/\u00193bi\u0006,\"!a(\u0011\u000b\u001d\f\t+!*\n\u0007\u0005\r\u0006N\u0001\u0004PaRLwN\u001c\t\u0005\u0003O\u000by+\u0004\u0002\u0002**!\u00111VAW\u0003-iW\u000f\u001c;ji\u0016t\u0017M\u001c;\u000b\u0007\u0005\f\u0019!\u0003\u0003\u00022\u0006%&aE'vYRLG+\u001a8b]RlU\r^1eCR\f\u0017\u0001F7vYRLG+\u001a8b]RlU\r^1eCR\f\u0007%\u0001\u0007d_:4\u0017nZ*dQ\u0016l\u0017-\u0006\u0002\u0002:B!\u00111XA_\u001b\u0005y\u0018bAA`\u007f\n\t2*\u00194lC\u000e{gNZ5h'\u000eDW-\\1\u0002\u001b\r|gNZ5h'\u000eDW-\\1!\u0003UIg\u000e^3s\u0005J|7.\u001a:Q_J$h)\u001e;ve\u0016,\"!a2\u0011\u000b\u001d\f\t+!3\u0011\r\u0005}\u0012QJA-\u0003YIg\u000e^3s\u0005J|7.\u001a:Q_J$h)\u001e;ve\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u000b\u0002R\u0006M\u0017Q[Al\u00033\fY.!8\u0002`\u0006\u0005\u00181\u001d\t\u0003k\u0002AQA]\nA\u0002QDQ!_\nA\u0002mDq!a\u0005\u0014\u0001\u0004\t9\u0002C\u0004\u0002(M\u0001\r!a\u000b\t\u000f\u0005e2\u00031\u0001\u0002>!9\u0011qR\nA\u0002\u0005M\u0005bBAN'\u0001\u0007\u0011q\u0014\u0005\b\u0003k\u001b\u0002\u0019AA]\u0011%\t\u0019m\u0005I\u0001\u0002\u0004\t9-\u0001\u0006m_\u001e\u001cuN\u001c;fqR,\"!!;\u0011\t\u0005e\u00111^\u0005\u0005\u0003[\fYB\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f1\u0002\\8h\u0007>tG/\u001a=uA\u000591\u000f^1si\u0016$WCAA{!\r9\u0017q_\u0005\u0004\u0003sD'a\u0002\"p_2,\u0017M\\\u0001\fgR\f'\u000f^3e?\u0012*\u0017\u000f\u0006\u0003\u0002\u0000\n\u0015\u0001cA4\u0003\u0002%\u0019!1\u00015\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005\u000f9\u0012\u0011!a\u0001\u0003k\f1\u0001\u001f\u00132\u0003!\u0019H/\u0019:uK\u0012\u0004\u0013\u0001D;tK\u0012\u0014\u0015P\u0011:pW\u0016\u0014\u0018\u0001E;tK\u0012\u0014\u0015P\u0011:pW\u0016\u0014x\fJ3r)\u0011\tyP!\u0005\t\u0013\t\u001d!$!AA\u0002\u0005U\u0018!D;tK\u0012\u0014\u0015P\u0011:pW\u0016\u0014\b%\u0001\tvg\u0016$')_\"p]R\u0014x\u000e\u001c7fe\u0006!Ro]3e\u0005f\u001cuN\u001c;s_2dWM]0%KF$B!a@\u0003\u001c!I!qA\u000f\u0002\u0002\u0003\u0007\u0011Q_\u0001\u0012kN,GMQ=D_:$(o\u001c7mKJ\u0004\u0013\u0001\u00042s_.,'oQ8oM&<\u0017!\u00042s_.,'oQ8oM&<\u0007%\u0001\td_:$(o\u001c7mKJ\u001cuN\u001c4jO\u0006!2m\u001c8ue>dG.\u001a:D_:4\u0017nZ0%KF$B!a@\u0003*!A!q\u0001\u0012\u0002\u0002\u0003\u0007A/A\td_:$(o\u001c7mKJ\u001cuN\u001c4jO\u0002\n\u0001$\\3uC\u0012\fG/Y#oGJL\b\u000f^8s\r\u0006\u001cGo\u001c:z+\t\u0011\t\u0004\u0005\u0003\u0002<\nM\u0012b\u0001B\u001b\u007f\nAR*\u001a;bI\u0006$\u0018-\u00128def\u0004Ho\u001c:GC\u000e$xN]=\u000235,G/\u00193bi\u0006,en\u0019:zaR|'OR1di>\u0014\u0018\u0010I\u0001\f[\u0016$(/[2t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0000\nu\u0002\"\u0003B\u0004O\u0005\u0005\t\u0019AA\u0016\u0003!iW\r\u001e:jGN\u0004\u0003f\u0001\u0015\u0003DA\u0019qM!\u0012\n\u0007\t\u001d\u0003N\u0001\u0005w_2\fG/\u001b7f\u0003-\u0011\u0018M\u001a;NC:\fw-\u001a:\u0016\u0005\t5\u0003C\u0002B(\u0005'\u00129&\u0004\u0002\u0003R)\u0019\u0011q\u00102\n\t\tU#\u0011\u000b\u0002\u0011\u0017\u000647.\u0019*bMRl\u0015M\\1hKJ\u0004BA!\u0017\u0003^5\u0011!1\f\u0006\u0005\u0003?\ti+\u0003\u0003\u0003`\tm#\u0001F!qS6+7o]1hK\u0006sGMV3sg&|g.A\bsC\u001a$X*\u00198bO\u0016\u0014x\fJ3r)\u0011\tyP!\u001a\t\u0013\t\u001d!&!AA\u0002\t5\u0013\u0001\u0004:bMRl\u0015M\\1hKJ\u0004\u0003fA\u0016\u0003D\u0005i!M]8lKJlU\r\u001e:jGN,\"Aa\u001c\u0011\t\tE$QO\u0007\u0003\u0005gR1!!\u0001a\u0013\u0011\u00119Ha\u001d\u0003'\t\u0013xn[3s'\u0016\u0014h/\u001a:NKR\u0014\u0018nY:\u0002#\t\u0014xn[3s\u001b\u0016$(/[2t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0000\nu\u0004\"\u0003B\u0004[\u0005\u0005\t\u0019\u0001B8\u00039\u0011'o\\6fe6+GO]5dg\u0002B3A\fB\"\u0003]\u0019wN\u001c;s_2dWM]*feZ,'/T3ue&\u001c7/\u0006\u0002\u0003\bB!!\u0011\u0012BI\u001b\t\u0011YI\u0003\u0003\u00022\t5%\u0002\u0002BH\u0003\u0007\t!bY8oiJ|G\u000e\\3s\u0013\u0011\u0011\u0019Ja#\u00033\r{g\u000e\u001e:pY2,'/T3uC\u0012\fG/Y'fiJL7m]\u0001\u001cG>tGO]8mY\u0016\u00148+\u001a:wKJlU\r\u001e:jGN|F%Z9\u0015\t\u0005}(\u0011\u0014\u0005\n\u0005\u000f\u0001\u0014\u0011!a\u0001\u0005\u000f\u000b\u0001dY8oiJ|G\u000e\\3s'\u0016\u0014h/\u001a:NKR\u0014\u0018nY:!Q\r\t$1I\u0001\u0007Y>\fG-\u001a:\u0016\u0005\t\r\u0006\u0003\u0002BS\u0005[k!Aa*\u000b\t\t}%\u0011\u0016\u0006\u0005\u0005W\u000b\u0019!A\u0003j[\u0006<W-\u0003\u0003\u00030\n\u001d&AD'fi\u0006$\u0017\r^1M_\u0006$WM]\u0001\u000bY>\fG-\u001a:`I\u0015\fH\u0003BA\u0000\u0005kC\u0011Ba\u00024\u0003\u0003\u0005\rAa)\u0002\u000f1|\u0017\rZ3sA!\u001aAGa\u0011\u0002/Mt\u0017\r]:i_R\u001cH)[:bE2,GMU3bg>tWC\u0001B`!\u0019\u0011\tMa2\u0003L6\u0011!1\u0019\u0006\u0005\u0005\u000b\f\t%\u0001\u0004bi>l\u0017nY\u0005\u0005\u0005\u0013\u0014\u0019MA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\u0011\u0011iM!6\u000f\t\t='\u0011\u001b\t\u0004\u0003cB\u0017b\u0001BjQ\u00061\u0001K]3eK\u001aLAAa6\u0003Z\n11\u000b\u001e:j]\u001eT1Aa5i\u0003a\u0019h.\u00199tQ>$8\u000fR5tC\ndW\r\u001a*fCN|g\u000eI\u0001\u0010g:\f\u0007o\u001d5pi\u0016k\u0017\u000e\u001e;feV\u0011!\u0011\u001d\t\u0005\u0005G\u0014I/\u0004\u0002\u0003f*!!q\u001dBU\u0003%\u0001XO\u00197jg\",'/\u0003\u0003\u0003l\n\u0015(aD*oCB\u001c\bn\u001c;F[&$H/\u001a:\u0002'Mt\u0017\r]:i_R,U.\u001b;uKJ|F%Z9\u0015\t\u0005}(\u0011\u001f\u0005\n\u0005\u000fA\u0014\u0011!a\u0001\u0005C\f\u0001c\u001d8baNDw\u000e^#nSR$XM\u001d\u0011)\u0007e\u0012\u0019%A\tt]\u0006\u00048\u000f[8u\u000f\u0016tWM]1u_J,\"Aa?\u0011\t\t\r(Q`\u0005\u0005\u0005\u007f\u0014)OA\tT]\u0006\u00048\u000f[8u\u000f\u0016tWM]1u_J\fQc\u001d8baNDw\u000e^$f]\u0016\u0014\u0018\r^8s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0000\u000e\u0015\u0001\"\u0003B\u0004w\u0005\u0005\t\u0019\u0001B~\u0003I\u0019h.\u00199tQ>$x)\u001a8fe\u0006$xN\u001d\u0011)\u0007q\u0012\u0019%A\u000bnKR\fG-\u0019;b\u0019>\fG-\u001a:NKR\u0014\u0018nY:\u0016\u0005\r=\u0001\u0003BB\t\u0007+i!aa\u0005\u000b\t\u0005E\"qU\u0005\u0005\u0007/\u0019\u0019BA\u000bNKR\fG-\u0019;b\u0019>\fG-\u001a:NKR\u0014\u0018nY:\u000235,G/\u00193bi\u0006du.\u00193fe6+GO]5dg~#S-\u001d\u000b\u0005\u0003\u007f\u001ci\u0002C\u0005\u0003\by\n\t\u00111\u0001\u0004\u0010\u00051R.\u001a;bI\u0006$\u0018\rT8bI\u0016\u0014X*\u001a;sS\u000e\u001c\b\u0005K\u0002@\u0005\u0007\n!\u0003^5fe>\u0013'.Z2u'R|'/Z(qiV\u00111q\u0005\t\u0007\u0003'\u001aIc!\f\n\t\r-\u0012Q\t\u0002\t\u001fB$\u0018n\u001c8bYB!1qFB\u001d\u001b\t\u0019\tD\u0003\u0003\u00044\rU\u0012!B:u_J,'bAB\u001cE\u0006!A/[3s\u0013\u0011\u0019Yd!\r\u0003\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016\fa\u0003^5fe>\u0013'.Z2u'R|'/Z(qi~#S-\u001d\u000b\u0005\u0003\u007f\u001c\t\u0005C\u0005\u0003\b\u0005\u000b\t\u00111\u0001\u0004(\u0005\u0019B/[3s\u001f\nTWm\u0019;Ti>\u0014Xm\u00149uA\u0005\u0001\u0002\u000e\u001e;q'\u0016\u0014h/\u001a:CS:$WM]\u000b\u0003\u0007\u0013\u0002Baa\u0013\u0004^5\u00111Q\n\u0006\u0004C\u000e=#\u0002BB)\u0007'\nA\u0001\u001b;ua*\u00191m!\u0016\u000b\t\r]3\u0011L\u0001\nG>tg\r\\;f]RT!aa\u0017\u0002\u0005%|\u0017\u0002BB0\u0007\u001b\u0012QcS1gW\u0006DE\u000f\u001e9TKJ4XM\u001d\"j]\u0012,'/\u0001\u000biiR\u00048+\u001a:wKJ\u0014\u0015N\u001c3fe~#S-\u001d\u000b\u0005\u0003\u007f\u001c)\u0007C\u0005\u0003\b\u0011\u000b\t\u00111\u0001\u0004J\u0005\t\u0002\u000e\u001e;q'\u0016\u0014h/\u001a:CS:$WM\u001d\u0011\u0002\u0015\r|\u0007/_\"p]\u001aLw\rF\u0002u\u0007[Baaa\u001cG\u0001\u0004!\u0018AB2p]\u001aLw-A\u0005dYV\u001cH/\u001a:JIV\u0011!1Z\u0001\u0007]>$W-\u00133\u0016\u0005\re\u0004cA4\u0004|%\u00191Q\u00105\u0003\u0007%sG/\u0001\u0004jgV\u001bX\r\u001a\u000b\u0003\u0003k\fab\u001d;beR4uN\u001d\"s_.,'\u000f\u0006\u0003\u0002\u0000\u000e\u001d\u0005bBBE\u0015\u0002\u000711R\u0001\u0011G\",7m[:v[N#xN]3PaR\u0004b!a\u0015\u0004*\r5\u0005\u0003BBH\u00073k!a!%\u000b\t\rM5QS\u0001\tG\",7m[:v[*!1qSB*\u0003\u001d\u0019Ho\u001c:bO\u0016LAaa'\u0004\u0012\n\u0001RIM#DQ\u0016\u001c7n];n'R|'/Z\u0001\u0013gR\f'\u000f\u001e$pe\u000e{g\u000e\u001e:pY2,'\u000f\u0006\u0003\u0002\u0000\u000e\u0005\u0006bBBE\u0017\u0002\u000711R\u0001\u000egR|\u0007OR8s\u0005J|7.\u001a:\u0015\u0005\u0005}\u0018!E:u_B4uN]\"p]R\u0014x\u000e\u001c7fe\u00069\"/\u00194u\u001b\u0006t\u0017mZ3s\r\u0006,H\u000e\u001e%b]\u0012dWM]\u000b\u0003\u0007[\u0003Baa,\u000466\u00111\u0011\u0017\u0006\u0005\u0007g\u000bi+A\u0003gCVdG/\u0003\u0003\u00048\u000eE&\u0001\u0004$bk2$\b*\u00198eY\u0016\u0014\u0018AG7fi\u0006$\u0017\r^1M_\u0006$WM\u001d$bk2$\b*\u00198eY\u0016\u0014\u0018!H2p]R\u0014x\u000e\u001c7feN#\u0018M\u001d;va\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0002K%t\u0017\u000e^5bY\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uC2{\u0017\r\u001a$bk2$\b*\u00198eY\u0016\u0014\u0018!\t4bi\u0006d\u0017+^8sk6\u001cuN\u001c;s_2dWM\u001d$bk2$\b*\u00198eY\u0016\u0014\u0018\u0001\n8p]\u001a\u000bG/\u00197Rk>\u0014X/\\\"p]R\u0014x\u000e\u001c7fe\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0002=5,G/\u00193bi\u0006\u0004VO\u00197jg\"Lgn\u001a$bk2$\b*\u00198eY\u0016\u0014\u0018!B:uCJ$H\u0003BA\u0000\u0007\u0013Dqa!#V\u0001\u0004\u0019Y)A\nf]N,(/\u001a(piJ\u000bg\r\u001e'fC\u0012,'/\u0001\u0003ti>\u0004\u0018\u0001F5oSRDE\u000f\u001e9TKJ4XM\u001d\"j]\u0012,'/A\rj]&$\u0018.\u00197ju\u0016$\u0016.\u001a:PE*,7\r^*u_J,G\u0003BB\u0014\u0007+Dqa!#Z\u0001\u0004\u0019Y)A\fj]R,'O\u0011:pW\u0016\u00148\t\\5f]R\u001cuN\u001c4jOR\u001111\u001c\t\b\u0003'\n)Fa3g\u00031\u0019\u0006.\u0019:fIN+'O^3s!\t)Hl\u0005\u0002]MR\u00111q\\\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\r%(\u0006BAd\u0007W\\#a!<\u0011\t\r=8\u0011`\u0007\u0003\u0007cTAaa=\u0004v\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007oD\u0017AC1o]>$\u0018\r^5p]&!11`By\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class SharedServer
implements Logging {
    private final KafkaConfig sharedServerConfig;
    private final MetaPropertiesEnsemble metaPropsEnsemble;
    private final Time time;
    private final Metrics _metrics;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final FaultHandlerFactory faultHandlerFactory;
    private final Option<MultiTenantMetadata> multiTenantMetadata;
    private final KafkaConfigSchema configSchema;
    private final Option<CompletableFuture<Integer>> interBrokerPortFuture;
    private final LogContext logContext;
    private boolean started;
    private boolean usedByBroker;
    private boolean usedByController;
    private final KafkaConfig brokerConfig;
    private KafkaConfig controllerConfig;
    private final MetadataEncryptorFactory metadataEncryptorFactory;
    private volatile Metrics metrics;
    private volatile KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private volatile BrokerServerMetrics brokerMetrics;
    private volatile ControllerMetadataMetrics controllerServerMetrics;
    private volatile MetadataLoader loader;
    private final AtomicReference<String> snapshotsDisabledReason;
    private volatile SnapshotEmitter snapshotEmitter;
    private volatile SnapshotGenerator snapshotGenerator;
    private volatile MetadataLoaderMetrics metadataLoaderMetrics;
    private Optional<TierObjectStore> tierObjectStoreOpt;
    private KafkaHttpServerBinder httpServerBinder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<CompletableFuture<Integer>> $lessinit$greater$default$9() {
        return None$.MODULE$;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig sharedServerConfig() {
        return this.sharedServerConfig;
    }

    public MetaPropertiesEnsemble metaPropsEnsemble() {
        return this.metaPropsEnsemble;
    }

    public Time time() {
        return this.time;
    }

    private Metrics _metrics() {
        return this._metrics;
    }

    public CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public FaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    public Option<MultiTenantMetadata> multiTenantMetadata() {
        return this.multiTenantMetadata;
    }

    public KafkaConfigSchema configSchema() {
        return this.configSchema;
    }

    public Option<CompletableFuture<Integer>> interBrokerPortFuture() {
        return this.interBrokerPortFuture;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    private boolean usedByBroker() {
        return this.usedByBroker;
    }

    private void usedByBroker_$eq(boolean x$1) {
        this.usedByBroker = x$1;
    }

    private boolean usedByController() {
        return this.usedByController;
    }

    private void usedByController_$eq(boolean x$1) {
        this.usedByController = x$1;
    }

    public KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public KafkaConfig controllerConfig() {
        return this.controllerConfig;
    }

    public void controllerConfig_$eq(KafkaConfig x$1) {
        this.controllerConfig = x$1;
    }

    public MetadataEncryptorFactory metadataEncryptorFactory() {
        return this.metadataEncryptorFactory;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public void raftManager_$eq(KafkaRaftManager<ApiMessageAndVersion> x$1) {
        this.raftManager = x$1;
    }

    public BrokerServerMetrics brokerMetrics() {
        return this.brokerMetrics;
    }

    public void brokerMetrics_$eq(BrokerServerMetrics x$1) {
        this.brokerMetrics = x$1;
    }

    public ControllerMetadataMetrics controllerServerMetrics() {
        return this.controllerServerMetrics;
    }

    public void controllerServerMetrics_$eq(ControllerMetadataMetrics x$1) {
        this.controllerServerMetrics = x$1;
    }

    public MetadataLoader loader() {
        return this.loader;
    }

    public void loader_$eq(MetadataLoader x$1) {
        this.loader = x$1;
    }

    public AtomicReference<String> snapshotsDisabledReason() {
        return this.snapshotsDisabledReason;
    }

    public SnapshotEmitter snapshotEmitter() {
        return this.snapshotEmitter;
    }

    public void snapshotEmitter_$eq(SnapshotEmitter x$1) {
        this.snapshotEmitter = x$1;
    }

    public SnapshotGenerator snapshotGenerator() {
        return this.snapshotGenerator;
    }

    public void snapshotGenerator_$eq(SnapshotGenerator x$1) {
        this.snapshotGenerator = x$1;
    }

    public MetadataLoaderMetrics metadataLoaderMetrics() {
        return this.metadataLoaderMetrics;
    }

    public void metadataLoaderMetrics_$eq(MetadataLoaderMetrics x$1) {
        this.metadataLoaderMetrics = x$1;
    }

    public Optional<TierObjectStore> tierObjectStoreOpt() {
        return this.tierObjectStoreOpt;
    }

    public void tierObjectStoreOpt_$eq(Optional<TierObjectStore> x$1) {
        this.tierObjectStoreOpt = x$1;
    }

    public KafkaHttpServerBinder httpServerBinder() {
        return this.httpServerBinder;
    }

    public void httpServerBinder_$eq(KafkaHttpServerBinder x$1) {
        this.httpServerBinder = x$1;
    }

    private KafkaConfig copyConfig(KafkaConfig config) {
        return new KafkaConfig(config.props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$, (Option<String>)new Some((Object)config.brokerSessionUuid()));
    }

    public String clusterId() {
        return (String)this.metaPropsEnsemble().clusterId().get();
    }

    public int nodeId() {
        return this.metaPropsEnsemble().nodeId().getAsInt();
    }

    public synchronized boolean isUsed() {
        return this.usedByController() || this.usedByBroker();
    }

    public synchronized void startForBroker(Optional<E2EChecksumStore> checksumStoreOpt) {
        if (!this.isUsed()) {
            this.start(checksumStoreOpt);
        }
        this.usedByBroker_$eq(true);
    }

    public synchronized void startForController(Optional<E2EChecksumStore> checksumStoreOpt) {
        if (!this.isUsed()) {
            this.start(checksumStoreOpt);
        }
        this.usedByController_$eq(true);
    }

    public synchronized void stopForBroker() {
        if (this.usedByBroker()) {
            this.usedByBroker_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
            return;
        }
    }

    public synchronized void stopForController() {
        if (this.usedByController()) {
            this.usedByController_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
            return;
        }
    }

    public FaultHandler raftManagerFaultHandler() {
        return this.faultHandlerFactory().build("raft manager", true, () -> {});
    }

    public FaultHandler metadataLoaderFaultHandler() {
        return this.faultHandlerFactory().build("metadata loading", this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$), () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataLoaderFaultHandler$2(x$10)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$11 -> {
                    x$11.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler controllerStartupFaultHandler() {
        return this.faultHandlerFactory().build("controller startup", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$12 -> {
                    x$12.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "controller startup fault");
                return;
            }
        });
    }

    public FaultHandler initialBrokerMetadataLoadFaultHandler() {
        return this.faultHandlerFactory().build("initial broker metadata loading", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$initialBrokerMetadataLoadFaultHandler$2(x$13)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$14 -> {
                    x$14.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "initial broker metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler fatalQuorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$15 -> {
                    x$15.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "quorum controller fatal fault");
                return;
            }
        });
    }

    public FaultHandler nonFatalQuorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$16 -> {
                    x$16.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    public FaultHandler metadataPublishingFaultHandler() {
        return this.faultHandlerFactory().build("metadata publishing", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataPublishingFaultHandler$2(x$17)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$18 -> {
                    x$18.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void start(Optional<E2EChecksumStore> checksumStoreOpt) {
        if (this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "SharedServer has already been started.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting SharedServer");
        try {
            if (this.metrics() == null) {
                this.metrics_$eq(new Metrics());
            }
            this.sharedServerConfig().dynamicConfig().initialize((Option<KafkaZkClient>)None$.MODULE$, (Option<ClientMetricsReceiverPlugin>)None$.MODULE$);
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$)) {
                void apply_time;
                Time time = this.time();
                Metrics apply_metrics = this.metrics();
                Object var7_3 = null;
                time = null;
                this.brokerMetrics_$eq(new BrokerServerMetrics(apply_metrics, (Time)apply_time));
            }
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$)) {
                this.controllerServerMetrics_$eq(new ControllerMetadataMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry())));
            }
            this.tierObjectStoreOpt_$eq(this.initializeTierObjectStore(checksumStoreOpt));
            KafkaRaftManager _raftManager = (KafkaRaftManager)Option$.MODULE$.apply(this.raftManager()).getOrElse((Function0 & Serializable)() -> new KafkaRaftManager(this.clusterId(), this.sharedServerConfig(), new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.time(), this.metrics(), (Option<String>)new Some((Object)new StringBuilder(11).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-raft").toString()), this.controllerQuorumVotersFuture(), this.raftManagerFaultHandler(), this.tierObjectStoreOpt()));
            this.raftManager_$eq(_raftManager);
            _raftManager.startup();
            Function<String, String> nameToTenantCallback = this.multiTenantMetadata().isDefined() ? TenantHelpers.NAME_TO_TENANT_CALLBACK : TenantHelpers.NAME_TO_NULL_CALLBACK;
            this.metadataLoaderMetrics_$eq(this.brokerMetrics() != null ? new MetadataLoaderMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), elapsedNs -> this.brokerMetrics().updateBatchProcessingTime(Predef$.MODULE$.Long2long(elapsedNs)), batchSize -> this.brokerMetrics().updateBatchSize(Predef$.MODULE$.Integer2int(batchSize)), this.brokerMetrics().lastAppliedImageProvenance()) : new MetadataLoaderMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), x$19 -> {}, x$20 -> {}, new AtomicReference<MetadataProvenance>(MetadataProvenance.EMPTY)));
            MetadataLoader.Builder loaderBuilder = new MetadataLoader.Builder().setNodeId(this.nodeId()).setTime(this.time()).setThreadNamePrefix(new StringBuilder(7).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-").toString()).setFaultHandler(this.metadataLoaderFaultHandler()).setHighWaterMarkAccessor(() -> _raftManager.client().highWatermark()).setMetrics(this.metadataLoaderMetrics()).setMetadataEncryptorFactory(this.metadataEncryptorFactory()).setNameToTenantCallback(nameToTenantCallback);
            this.loader_$eq(loaderBuilder.build());
            this.snapshotEmitter_$eq(new SnapshotEmitter.Builder().setNodeId(this.nodeId()).setRaftClient(_raftManager.client()).setConfigSchema(this.configSchema()).setMetrics(new SnapshotEmitterMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), this.time())).build());
            this.snapshotGenerator_$eq(new SnapshotGenerator.Builder((SnapshotGenerator.Emitter)this.snapshotEmitter()).setNodeId(this.nodeId()).setTime(this.time()).setFaultHandler(this.metadataPublishingFaultHandler()).setMaxBytesSinceLastSnapshot(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxNewRecordBytes())).setMaxTimeSinceLastSnapshotNs(TimeUnit.MILLISECONDS.toNanos(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxIntervalMs()))).setDisabledReason(this.snapshotsDisabledReason()).setThreadNamePrefix(new StringBuilder(7).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-").toString()).build());
            try {
                this.loader().installPublishers(Arrays.asList(this.snapshotGenerator())).get();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Unable to install metadata publishers", (Function0<Throwable>)(Function0 & Serializable)() -> t);
                throw new RuntimeException("Unable to install metadata publishers.", t);
            }
            _raftManager.register(this.loader());
            this.initHttpServerBinder();
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Completed SharedServer startup.");
            this.started_$eq(true);
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Got exception while starting SharedServer", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.stop();
            throw e;
        }
    }

    public synchronized void ensureNotRaftLeader() {
        Option$.MODULE$.apply(this.raftManager()).foreach((Function1 & Serializable)_raftManager -> {
            SharedServer.$anonfun$ensureNotRaftLeader$1(this, _raftManager);
            return BoxedUnit.UNIT;
        });
    }

    private synchronized void stop() {
        if (!this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "SharedServer is not running.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Stopping SharedServer");
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loader().beginShutdown(), this, Level.WARN);
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.snapshotGenerator().beginShutdown(), this, Level.WARN);
        }
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loader().close(), this, Level.WARN);
            this.loader_$eq(null);
        }
        if (this.metadataLoaderMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.metadataLoaderMetrics().close(), this, Level.WARN);
            this.metadataLoaderMetrics_$eq(null);
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.snapshotGenerator().close(), this, Level.WARN);
            this.snapshotGenerator_$eq(null);
        }
        if (this.raftManager() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.raftManager().shutdown(), this, Level.WARN);
            this.raftManager_$eq(null);
        }
        if (this.tierObjectStoreOpt().isPresent()) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.tierObjectStoreOpt().get().close(), this, Level.WARN);
        }
        if (this.controllerServerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.controllerServerMetrics().close(), this, Level.WARN);
            this.controllerServerMetrics_$eq(null);
        }
        if (this.brokerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.brokerMetrics().close(), this, Level.WARN);
            this.brokerMetrics_$eq(null);
        }
        if (this.metrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.metrics().close(), this, Level.WARN);
            this.metrics_$eq(null);
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.sharedServerConfig().nodeId()), (Metrics)this.metrics()), this, Level.WARN);
        this.httpServerBinder_$eq(null);
        this.started_$eq(false);
    }

    public synchronized void initHttpServerBinder() {
        if (this.httpServerBinder() == null) {
            this.httpServerBinder_$eq(new KafkaHttpServerBinder());
            return;
        }
    }

    private Optional<TierObjectStore> initializeTierObjectStore(Optional<E2EChecksumStore> checksumStoreOpt) {
        if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$) || !this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$) && Predef$.MODULE$.Boolean2boolean(this.sharedServerConfig().confluentConfig().clusterMetadataSnapshotTierUploadEnableFlag())) {
            return TierObjectStoreUtils.maybeCreateTierObjectStore(this.copyConfig(this.sharedServerConfig()), this.clusterId(), this.metrics(), this.time(), checksumStoreOpt);
        }
        return Optional.empty();
    }

    public Map<String, Object> interBrokerClientConfig() {
        Map result = ConfluentConfigs.clientConfigsForEndpoint(this.sharedServerConfig().originals(), this.sharedServerConfig().values(), (ListenerName)this.sharedServerConfig().interBrokerListenerName(), (SecurityProtocol)this.sharedServerConfig().interBrokerSecurityProtocol());
        this.interBrokerPortFuture().foreach((Function1 & Serializable)future -> {
            try {
                Integer port = (Integer)future.get(10L, TimeUnit.MINUTES);
                String hostName = Utils.formatAddress((String)this.sharedServerConfig().interBrokerHostNameFromAdvertisedListeners(), (Integer)port);
                this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Using %s as %s for inter broker client config."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{hostName, "bootstrap.servers"})));
                return result.put("bootstrap.servers", hostName);
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to determine the inter-broker port used by the co-located broker.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw new RuntimeException("Failed to determine the inter-broker port used by the co-located broker.", e);
            }
        });
        return Collections.unmodifiableMap(result);
    }

    public static final /* synthetic */ long $anonfun$metadataLoaderFaultHandler$2(BrokerServerMetrics x$10) {
        return x$10.metadataLoadErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$initialBrokerMetadataLoadFaultHandler$2(BrokerServerMetrics x$13) {
        return x$13.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$metadataPublishingFaultHandler$2(BrokerServerMetrics x$17) {
        return x$17.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ void $anonfun$ensureNotRaftLeader$1(SharedServer $this, KafkaRaftManager _raftManager) {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> _raftManager.shutdown(), $this, Level.WARN);
        $this.raftManager_$eq(null);
    }

    public SharedServer(KafkaConfig sharedServerConfig, MetaPropertiesEnsemble metaPropsEnsemble, Time time, Metrics _metrics, CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, FaultHandlerFactory faultHandlerFactory, Option<MultiTenantMetadata> multiTenantMetadata, KafkaConfigSchema configSchema, Option<CompletableFuture<Integer>> interBrokerPortFuture) {
        this.sharedServerConfig = sharedServerConfig;
        this.metaPropsEnsemble = metaPropsEnsemble;
        this.time = time;
        this._metrics = _metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.faultHandlerFactory = faultHandlerFactory;
        this.multiTenantMetadata = multiTenantMetadata;
        this.configSchema = configSchema;
        this.interBrokerPortFuture = interBrokerPortFuture;
        this.logContext = new LogContext(new StringBuilder(19).append("[SharedServer id=").append(sharedServerConfig.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.started = false;
        this.usedByBroker = false;
        this.usedByController = false;
        this.brokerConfig = this.copyConfig(sharedServerConfig);
        this.controllerConfig = this.copyConfig(sharedServerConfig);
        this.metadataEncryptorFactory = new MetadataEncryptorFactory(sharedServerConfig.originals());
        this.metrics = _metrics;
        this.snapshotsDisabledReason = new AtomicReference<Object>(null);
    }
}

