/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthenticationTaskErrorCode$;
import kafka.server.link.BrokerAuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkAutoCreateMirror$;
import kafka.server.link.ClusterLinkAutoMirroringTaskType$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.InvalidTopicTaskErrorCode$;
import kafka.server.link.MisconfigurationTaskErrorCode$;
import kafka.server.link.NotConfiguredTaskState$;
import kafka.server.link.PolicyViolationTaskErrorCode$;
import kafka.server.link.SourceCluster$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicExistsTaskErrorCode$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.ListMirrorsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\rUa\u0001\u0002 @\u0001\u0019C\u0001b\u0014\u0001\u0003\u0006\u0004%\t\u0001\u0015\u0005\t)\u0002\u0011\t\u0011)A\u0005#\"AQ\u000b\u0001BC\u0002\u0013\u0005a\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003X\u0011!Y\u0006A!A!\u0002\u0013a\u0006\u0002\u00032\u0001\u0005\u000b\u0007I\u0011A2\t\u0011]\u0004!\u0011!Q\u0001\n\u0011D\u0001\u0002\u001f\u0001\u0003\u0002\u0003\u0006I!\u001f\u0005\u000by\u0002\u0011\t\u0011)A\u0005{\u0006-\u0001\u0002DA\u0007\u0001\t\u0005\t\u0015!\u0003\u0002\u0010\u0005]\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\n\u0003[\u0001\u0001\u0019!C\u0005\u0003_A\u0011\"a\u000e\u0001\u0001\u0004%I!!\u000f\t\u0011\u0005\u0015\u0003\u0001)Q\u0005\u0003cA\u0011\"a\u0012\u0001\u0005\u0004%I!!\u0013\t\u0011\u0005E\u0004\u0001)A\u0005\u0003\u0017B\u0011\"a\u001d\u0001\u0005\u0004%I!!\u0013\t\u0011\u0005U\u0004\u0001)A\u0005\u0003\u0017B\u0011\"a\u001e\u0001\u0001\u0004%I!!\u001f\t\u0013\u0005\u0005\u0005\u00011A\u0005\n\u0005\r\u0005\u0002CAD\u0001\u0001\u0006K!a\u001f\t\u0013\u0005%\u0005A1A\u0005\n\u0005-\u0005bBAG\u0001\u0001\u0006IA\u001b\u0005\n\u0003\u001f\u0003\u0001\u0019!C\u0005\u0003#C\u0011\"!'\u0001\u0001\u0004%I!a'\t\u0011\u0005}\u0005\u0001)Q\u0005\u0003'C1\"!)\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0012\"Y\u00111\u0015\u0001A\u0002\u0003\u0007I\u0011BAS\u0011-\tI\u000b\u0001a\u0001\u0002\u0003\u0006K!a%\t\u0013\u0005-\u0006\u00011A\u0005\n\u00055\u0006\"CA^\u0001\u0001\u0007I\u0011BA_\u0011!\t\t\r\u0001Q!\n\u0005=\u0006bBAf\u0001\u0011E\u0013Q\u001a\u0005\b\u0003G\u0004A\u0011BAg\u0011\u001d\t)\u000f\u0001C\u0005\u0003ODq!a=\u0001\t\u0013\t)\u0010C\u0004\u0003\u0004\u0001!IA!\u0002\t\u000f\t5\u0002\u0001\"\u0003\u00030!9!q\u0007\u0001\u0005\n\te\u0002b\u0002B!\u0001\u0011%!1\t\u0005\b\u0005\u000f\u0002A\u0011\u0002B%\u0011\u001d\u0011y\u0005\u0001C\u0005\u0005#BqAa\u0016\u0001\t\u0013\u0011I\u0006C\u0004\u0003\u0014\u0002!IA!&\t\u000f\t\u001d\u0006\u0001\"\u0003\u0003*\"9!1\u0016\u0001\u0005\n\t5\u0006\u0002\u0003BX\u0001\u0011\u0005q(!\u0013\t\u0011\tE\u0006\u0001\"\u0001@\u0003\u0013B\u0001Ba-\u0001\t\u0003y\u0014\u0011\u0013\u0005\b\u0005k\u0003A\u0011\u000bB\\\u0011\u001d\u0011\t\r\u0001C!\u0005\u0007<qA!2@\u0011\u0003\u00119M\u0002\u0004?\u007f!\u0005!\u0011\u001a\u0005\b\u00033)D\u0011\u0001Bi\u0011%\u0011\u0019.\u000eb\u0001\n\u0003\u0011)\u000e\u0003\u0005\u0003fV\u0002\u000b\u0011\u0002Bl\u0011%\u00119/\u000eb\u0001\n\u0003\u0011I\u000f\u0003\u0005\u0003xV\u0002\u000b\u0011\u0002Bv\u0011\u001d\u0011I0\u000eC\u0001\u0005wD\u0011b!\u00056\u0005\u0004%\t!!\u001f\t\u0011\rMQ\u0007)A\u0005\u0003w\u00121d\u00117vgR,'\u000fT5oW\u0006+Ho\\\"sK\u0006$X-T5se>\u0014(B\u0001!B\u0003\u0011a\u0017N\\6\u000b\u0005\t\u001b\u0015AB:feZ,'OC\u0001E\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A$\u0011\u0005!ceBA%K\u001b\u0005y\u0014BA&@\u0003Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe&\u0011QJ\u0014\u0002\r!\u0016\u0014\u0018n\u001c3jGR\u000b7o\u001b\u0006\u0003\u0017~\nQb\u00197jK:$X*\u00198bO\u0016\u0014X#A)\u0011\u0005%\u0013\u0016BA*@\u0005q\u0019E.^:uKJd\u0015N\\6EKN$8\t\\5f]Rl\u0015M\\1hKJ\fab\u00197jK:$X*\u00198bO\u0016\u0014\b%A\bnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s+\u00059\u0006CA%Y\u0013\tIvH\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\tnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3sA\u0005AA.\u001b8l\t\u0006$\u0018\r\u0005\u0002^A6\taL\u0003\u0002`\u0007\u0006\u0011!p[\u0005\u0003Cz\u0013qb\u00117vgR,'\u000fT5oW\u0012\u000bG/Y\u0001\u0011I\u0016\u001cH/\u00113nS:4\u0015m\u0019;pef,\u0012\u0001\u001a\t\u0004K\"TW\"\u00014\u000b\u0003\u001d\fQa]2bY\u0006L!!\u001b4\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004CA6v\u001b\u0005a'BA7o\u0003\u0015\tG-\\5o\u0015\ty\u0007/A\u0004dY&,g\u000e^:\u000b\u0005\u0011\u000b(B\u0001:t\u0003\u0019\t\u0007/Y2iK*\tA/A\u0002pe\u001eL!A\u001e7\u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\u0006\tB-Z:u\u0003\u0012l\u0017N\u001c$bGR|'/\u001f\u0011\u0002\u000f5,GO]5dgB\u0011\u0011J_\u0005\u0003w~\u0012!c\u00117vgR,'\u000fT5oW6+GO]5dg\u0006!A/[7f!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u0015)H/\u001b7t\u0015\r\t)\u0001]\u0001\u0007G>lWn\u001c8\n\u0007\u0005%qP\u0001\u0003US6,\u0017B\u0001?M\u0003\u0015\tXo\u001c;b!\u0011\t\t\"a\u0005\u000e\u0003\u0005K1!!\u0006B\u0005]\u0019E.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018-C\u0002\u0002\u000e1\u000ba\u0001P5oSRtD\u0003EA\u000f\u0003?\t\t#a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016!\tI\u0005\u0001C\u0003P\u0017\u0001\u0007\u0011\u000bC\u0003V\u0017\u0001\u0007q\u000bC\u0003\\\u0017\u0001\u0007A\fC\u0003c\u0017\u0001\u0007A\rC\u0003y\u0017\u0001\u0007\u0011\u0010C\u0003}\u0017\u0001\u0007Q\u0010C\u0004\u0002\u000e-\u0001\r!a\u0004\u0002\r\r|gNZ5h+\t\t\t\u0004E\u0002J\u0003gI1!!\u000e@\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017nZ\u0001\u000bG>tg-[4`I\u0015\fH\u0003BA\u001e\u0003\u0003\u00022!ZA\u001f\u0013\r\tyD\u001a\u0002\u0005+:LG\u000fC\u0005\u0002D5\t\t\u00111\u0001\u00022\u0005\u0019\u0001\u0010J\u0019\u0002\u000f\r|gNZ5hA\u0005aQ.\u001b:s_J$v\u000e]5dgV\u0011\u00111\n\t\u0007\u0003\u001b\n9&a\u0017\u000e\u0005\u0005=#\u0002BA)\u0003'\nq!\\;uC\ndWMC\u0002\u0002V\u0019\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI&a\u0014\u0003\u0007M+G\u000f\u0005\u0003\u0002^\u0005-d\u0002BA0\u0003O\u00022!!\u0019g\u001b\t\t\u0019GC\u0002\u0002f\u0015\u000ba\u0001\u0010:p_Rt\u0014bAA5M\u00061\u0001K]3eK\u001aLA!!\u001c\u0002p\t11\u000b\u001e:j]\u001eT1!!\u001bg\u00035i\u0017N\u001d:peR{\u0007/[2tA\u0005)2m\u001c8gY&\u001cG/\u001b8h\t\u0016\u001cH\u000fV8qS\u000e\u001c\u0018AF2p]\u001ad\u0017n\u0019;j]\u001e$Um\u001d;U_BL7m\u001d\u0011\u0002!Q\f7o[:PkR\u001cH/\u00198eS:<WCAA>!\r)\u0017QP\u0005\u0004\u0003\u007f2'aA%oi\u0006!B/Y:lg>+Ho\u001d;b]\u0012LgnZ0%KF$B!a\u000f\u0002\u0006\"I\u00111\t\u000b\u0002\u0002\u0003\u0007\u00111P\u0001\u0012i\u0006\u001c8n](viN$\u0018M\u001c3j]\u001e\u0004\u0013!\u00033fgR\fE-\\5o+\u0005Q\u0017A\u00033fgR\fE-\\5oA\u0005Y\u0011N\\5uS\u0006d\u0017N_3e+\t\t\u0019\nE\u0002f\u0003+K1!a&g\u0005\u001d\u0011un\u001c7fC:\fq\"\u001b8ji&\fG.\u001b>fI~#S-\u001d\u000b\u0005\u0003w\ti\nC\u0005\u0002De\t\t\u00111\u0001\u0002\u0014\u0006a\u0011N\\5uS\u0006d\u0017N_3eA\u0005A2\u000f[8vY\u00124\u0015\u000e\u001c;fe6K'O]8s)>\u0004\u0018nY:\u00029MDw.\u001e7e\r&dG/\u001a:NSJ\u0014xN\u001d+pa&\u001c7o\u0018\u0013fcR!\u00111HAT\u0011%\t\u0019\u0005HA\u0001\u0002\u0004\t\u0019*A\rtQ>,H\u000e\u001a$jYR,'/T5se>\u0014Hk\u001c9jGN\u0004\u0013\u0001\u0003;bg.$Um]2\u0016\u0005\u0005=\u0006#B3\u00022\u0006U\u0016bAAZM\n1q\n\u001d;j_:\u00042!SA\\\u0013\r\tIl\u0010\u0002\u0010)\u0006\u001c8\u000eR3tGJL\u0007\u000f^5p]\u0006aA/Y:l\t\u0016\u001c8m\u0018\u0013fcR!\u00111HA`\u0011%\t\u0019eHA\u0001\u0002\u0004\ty+A\u0005uCN\\G)Z:dA!\u001a\u0001%!2\u0011\u0007\u0015\f9-C\u0002\u0002J\u001a\u0014\u0001B^8mCRLG.Z\u0001\u0004eVtGCAAh!\u0011\t\t.a8\u000f\u0007\u0005M'J\u0004\u0003\u0002V\u0006ug\u0002BAl\u00037tA!!\u0019\u0002Z&\tA)\u0003\u0002C\u0007&\u0011\u0001)Q\u0005\u0004\u0003Ct%A\u0003+bg.\u0014Vm];mi\u00069\u0012N\\5uS\u0006d\u0017N_3B]\u0012\fU\u000f^8NSJ\u0014xN]\u0001\u000bCV$x.T5se>\u0014H\u0003BAh\u0003SDq!a;$\u0001\u0004\ti/A\u0006uCN\\7i\u001c8uKb$\b\u0003BAi\u0003_L1!!=O\u0005-!\u0016m]6D_:$X\r\u001f;\u0002-!\fg\u000e\u001a7f\u0019&\u001cHoU8ve\u000e,Gk\u001c9jGN$b!a4\u0002x\u0006e\bbBAvI\u0001\u0007\u0011Q\u001e\u0005\b\u0003w$\u0003\u0019AA\u007f\u0003\u0019\u0011Xm];miB\u00191.a@\n\u0007\t\u0005AN\u0001\tMSN$Hk\u001c9jGN\u0014Vm];mi\u0006a\u0002.\u00198eY\u0016d\u0015n\u001d;T_V\u00148-Z'jeJ|'\u000fV8qS\u000e\u001cH\u0003CAh\u0005\u000f\u0011IA!\u0005\t\u000f\u0005-X\u00051\u0001\u0002n\"9!1B\u0013A\u0002\t5\u0011A\u0002;pa&\u001c7\u000f\u0005\u0004\u0002^\t=\u00111L\u0005\u0005\u00033\ny\u0007C\u0004\u0003\u0014\u0015\u0002\rA!\u0006\u0002#1L7\u000f^'jeJ|'o\u001d$viV\u0014X\r\u0005\u0004\u0003\u0018\te!QD\u0007\u0003\u0003\u0007IAAa\u0007\u0002\u0004\tY1*\u00194lC\u001a+H/\u001e:f!\u0019\u0011yB!\u000b\u0002\\5\u0011!\u0011\u0005\u0006\u0005\u0005G\u0011)#\u0001\u0003vi&d'B\u0001B\u0014\u0003\u0011Q\u0017M^1\n\t\t-\"\u0011\u0005\u0002\u000b\u0007>dG.Z2uS>t\u0017\u0001\u00065b]\u0012dWMR5mi\u0016\u0014X\r\u001a+pa&\u001c7\u000f\u0006\u0004\u0002P\nE\"1\u0007\u0005\b\u0003W4\u0003\u0019AAw\u0011\u001d\u0011)D\na\u0001\u0005\u001b\taBZ5mi\u0016\u0014X\r\u001a+pa&\u001c7/\u0001\u000biC:$G.\u001a'jgR$Um\u001d;U_BL7m\u001d\u000b\t\u0003\u001f\u0014YD!\u0010\u0003@!9\u00111^\u0014A\u0002\u00055\bbBA~O\u0001\u0007\u0011Q \u0005\b\u0005k9\u0003\u0019\u0001B\u0007\u000311\u0017\u000e\u001c;feR{\u0007/[2t)\u0011\u0011iA!\u0012\t\u000f\t-\u0001\u00061\u0001\u0003\u000e\u0005a1M]3bi\u0016$v\u000e]5dgR1\u0011q\u001aB&\u0005\u001bBq!a;*\u0001\u0004\ti\u000fC\u0004\u0003\f%\u0002\rA!\u0004\u00021I,Wn\u001c<f'>,(oY3NSJ\u0014xN\u001d+pa&\u001c7\u000f\u0006\u0004\u0003\u000e\tM#Q\u000b\u0005\b\u0005\u0017Q\u0003\u0019\u0001B\u0007\u0011\u001d\t9E\u000ba\u0001\u0005\u001b\tq\u0003[1oI2,')\u0019;dQ\u000e\u0013X-\u0019;f)>\u0004\u0018nY:\u0015\u0011\u0005='1\fB/\u0005kBq!a;,\u0001\u0004\ti\u000fC\u0004\u0003`-\u0002\rA!\u0019\u0002\u001bQ|\u0007/[2MSN$\u0018N\\4t!!\u0011yBa\u0019\u0002\\\t\u001d\u0014\u0002\u0002B3\u0005C\u00111!T1q!\u0019\u00119B!\u0007\u0003jA!!1\u000eB9\u001b\t\u0011iG\u0003\u0003\u0003p\t\u0015\u0012\u0001\u00027b]\u001eLAAa\u001d\u0003n\t!ak\\5e\u0011\u001d\u00119h\u000ba\u0001\u0005s\n\u0001C]3nC&t\u0017N\\4CCR\u001c\u0007.Z:\u0011\r\tm$Q\u0011BF\u001d\u0011\u0011iH!!\u000f\t\u0005\u0005$qP\u0005\u0002O&\u0019!1\u00114\u0002\u000fA\f7m[1hK&!!q\u0011BE\u0005\r\u0019V-\u001d\u0006\u0004\u0005\u00073\u0007CBA/\u0005\u001f\u0011i\tE\u0002l\u0005\u001fK1A!%m\u0005!qUm\u001e+pa&\u001c\u0017AH1eI6K'O]8sK\u0012$v\u000e]5d\u0003:$Gj\\4XCJt\u0017N\\4t)\u0019\u00119Ja(\u0003$B1!1\u0010BC\u00053\u00032!\u0013BN\u0013\r\u0011ij\u0010\u0002\u0014)\u0006\u001c8.\u0012:s_J\u001cu\u000eZ3B]\u0012l5o\u001a\u0005\b\u0005Cc\u0003\u0019AA.\u0003\u0015!x\u000e]5d\u0011\u001d\u0011)\u000b\fa\u0001\u0005O\naAZ;ukJ,\u0017aD1mY2Kgn[3e)>\u0004\u0018nY:\u0015\u0005\t5\u0011a\u000b:fG>\u0014HMR1jY\u0016$\u0007K]3gSb,G-Q;u_6K'O]8s\u0007J,\u0017\r^3NKR\u0014\u0018nY:\u0015\u0005\u0005m\u0012aD4fi6K'O]8s)>\u0004\u0018nY:\u00021\u001d,GoQ8oM2L7\r^5oO\u0012+7\u000f\u001e+pa&\u001c7/\u0001\bhKRLe.\u001b;jC2L'0\u001a3\u0002\u0019=t7i\\7qY\u0016$\u0018n\u001c8\u0015\t\u0005m\"\u0011\u0018\u0005\b\u0003w\u0014\u0004\u0019\u0001B^!\rA%QX\u0005\u0004\u0005\u007fs%aE\"p[BdW\r^3e)\u0006\u001c8NU3tk2$\u0018a\u0004;bg.$Um]2sSB$\u0018n\u001c8\u0015\u0005\u0005=\u0016aG\"mkN$XM\u001d'j].\fU\u000f^8De\u0016\fG/Z'jeJ|'\u000f\u0005\u0002JkM\u0019QGa3\u0011\u0007\u0015\u0014i-C\u0002\u0003P\u001a\u0014a!\u00118z%\u00164GC\u0001Bd\u0003a\tG\rZ5uS>t\u0017\r\\%oi\u0016\u0014h.\u00197U_BL7m]\u000b\u0003\u0005/\u0004bA!7\u0003`\n\u0005XB\u0001Bn\u0015\u0011\u0011i.a\u0015\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BA-\u00057\u0004BAa\u001b\u0003d&!\u0011Q\u000eB7\u0003e\tG\rZ5uS>t\u0017\r\\%oi\u0016\u0014h.\u00197U_BL7m\u001d\u0011\u0002=\u0005$G-\u001b;j_:\fG.\u00138uKJt\u0017\r\u001c+pa&\u001c\u0007+\u0019;uKJtWC\u0001Bv!\u0011\u0011iOa=\u000e\u0005\t=(\u0002\u0002By\u0005C\tQA]3hKbLAA!>\u0003p\n9\u0001+\u0019;uKJt\u0017aH1eI&$\u0018n\u001c8bY&sG/\u001a:oC2$v\u000e]5d!\u0006$H/\u001a:oA\u0005Ya-\u001b7uKJ$v\u000e]5d)!\t\u0019J!@\u0004\f\r=\u0001b\u0002B\u0000w\u0001\u00071\u0011A\u0001\u0010]\u0006lWm\u001d+p\u0019&\u001cH/\u001b8hgBA\u0011QJB\u0002\u00037\u001a)!\u0003\u0003\u0003f\u0005=\u0003cA6\u0004\b%\u00191\u0011\u00027\u0003\u0019Q{\u0007/[2MSN$\u0018N\\4\t\u000f\r51\b1\u0001\u0002|\u0005I\u0001O]3gSbdUM\u001c\u0005\b\u0005C[\u0004\u0019AA.\u0003a\u0019%+R!U\u000b~#v\nU%D'~\u0013\u0015\tV\"I?NK%,R\u0001\u001a\u0007J+\u0015\tV#`)>\u0003\u0016jQ*`\u0005\u0006#6\tS0T\u0013j+\u0005\u0005")
public class ClusterLinkAutoCreateMirror
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkData linkData;
    private final Function0<ConfluentAdmin> destAdminFactory;
    private final ClusterLinkMetrics metrics;
    private ClusterLinkConfig config;
    private final scala.collection.mutable.Set<String> mirrorTopics;
    private final scala.collection.mutable.Set<String> conflictingDestTopics;
    private int tasksOutstanding;
    private final ConfluentAdmin destAdmin;
    private boolean initialized;
    private boolean shouldFilterMirrorTopics;
    private volatile Option<TaskDescription> taskDesc;

    public static int CREATE_TOPICS_BATCH_SIZE() {
        return ClusterLinkAutoCreateMirror$.MODULE$.CREATE_TOPICS_BATCH_SIZE();
    }

    public static boolean filterTopic(scala.collection.mutable.Map<String, TopicListing> namesToListings, int prefixLen, String topic) {
        return ClusterLinkAutoCreateMirror$.MODULE$.filterTopic(namesToListings, prefixLen, topic);
    }

    public static Pattern additionalInternalTopicPattern() {
        return ClusterLinkAutoCreateMirror$.MODULE$.additionalInternalTopicPattern();
    }

    public static scala.collection.immutable.Set<String> additionalInternalTopics() {
        return ClusterLinkAutoCreateMirror$.MODULE$.additionalInternalTopics();
    }

    public ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    public Function0<ConfluentAdmin> destAdminFactory() {
        return this.destAdminFactory;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    private scala.collection.mutable.Set<String> mirrorTopics() {
        return this.mirrorTopics;
    }

    private scala.collection.mutable.Set<String> conflictingDestTopics() {
        return this.conflictingDestTopics;
    }

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    private ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private boolean shouldFilterMirrorTopics() {
        return this.shouldFilterMirrorTopics;
    }

    private void shouldFilterMirrorTopics_$eq(boolean x$1) {
        this.shouldFilterMirrorTopics = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        if (!this.initialized()) {
            return this.initializeAndAutoMirror();
        }
        return this.autoMirror(new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty())));
    }

    private ClusterLinkScheduler.TaskResult initializeAndAutoMirror() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Initializing auto-mirroring ").append($this.linkData.linkId()).toString());
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()));
        if (this.config().clusterLinkPrefix().isEmpty() || ((String)this.config().clusterLinkPrefix().get()).isEmpty()) {
            this.shouldFilterMirrorTopics_$eq(false);
            this.initialized_$eq(true);
            return this.autoMirror(taskContext);
        }
        KafkaFuture listMirrorsFuture = this.clientManager().getAdmin().listMirrors(new ListMirrorsOptions()).result();
        this.scheduleWhenComplete(listMirrorsFuture, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> {
            void var5_5;
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            Tuple2<Object, Option<TaskErrorCodeAndMsg>> tuple2 = SourceCluster$.MODULE$.canContainMirrorTopics($this.metrics, (KafkaFuture<Collection<String>>)listMirrorsFuture);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            boolean shouldFilter = tuple2._1$mcZ$sp();
            Option errOpt = (Option)tuple2._2();
            if (var5_5 instanceof Some) {
                TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)var5_5).value();
                .colon.colon completedTask_errs = new .colon.colon((Object)err, (List)Nil$.MODULE$);
                return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
            }
            if (None$.MODULE$.equals(var5_5)) {
                void var4_4;
                this.shouldFilterMirrorTopics_$eq((boolean)var4_4);
                this.initialized_$eq(true);
                return this.autoMirror((ClusterLinkScheduler.TaskContext)tc);
            }
            throw new MatchError((Object)var5_5);
        }, taskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult autoMirror(ClusterLinkScheduler.TaskContext taskContext) {
        this.mirrorTopics().clear();
        this.config_$eq(this.clientManager().currentConfig());
        if (this.metadataManager().isLinkCoordinator(this.linkData.linkName()) && this.config().autoMirroringEnable()) {
            if (this.tasksOutstanding() != 0) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Number of outstanding tasks was not 0 at the beginning of run. Resetting to 0 and continuing on.");
                this.tasksOutstanding_$eq(0);
            }
            if (this.config().topicFilters().isEmpty()) {
                String errMsg = new StringBuilder(72).append(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()).append(" is true but no topic filters are specified. No topics will be mirrored.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(MisconfigurationTaskErrorCode$.MODULE$, errMsg);
                Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)err, (List)Nil$.MODULE$));
                return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
            }
            this.trace((Function0<String>)(Function0 & Serializable)() -> "Attempting to list topics from source cluster");
            ListTopicsResult listTopicsResult = this.clientManager().getAdmin().listTopics();
            this.scheduleWhenComplete(listTopicsResult.namesToListings(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleListSourceTopics((ClusterLinkScheduler.TaskContext)tc, listTopicsResult), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleListSourceTopics(ClusterLinkScheduler.TaskContext taskContext, ListTopicsResult result) {
        ClusterLinkScheduler.TaskResult taskResult;
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        try {
            ObjectRef filteredTopics = ObjectRef.create((Object)((scala.collection.immutable.Set)this.filterTopics((scala.collection.immutable.Set<String>)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)result.names().get()).asScala().toSet()).$minus$minus(this.allLinkedTopics())));
            Map namesToListings = (Map)result.namesToListings().get();
            int prefixLength = ((String)this.linkData.tenantPrefix().getOrElse((Function0 & Serializable)() -> "")).length() + ((String)this.config().clusterLinkPrefix().getOrElse((Function0 & Serializable)() -> "")).length();
            ((scala.collection.immutable.Set)filteredTopics.elem).foreach((Function1 & Serializable)topicName -> {
                ClusterLinkAutoCreateMirror.$anonfun$handleListSourceTopics$3(this, namesToListings, prefixLength, filteredTopics, topicName);
                return BoxedUnit.UNIT;
            });
            if (this.shouldFilterMirrorTopics()) {
                KafkaFuture listMirrorsFuture = this.clientManager().getAdmin().listMirrors(new ListMirrorsOptions()).result();
                this.scheduleWhenComplete(listMirrorsFuture, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleListSourceMirrorTopics((ClusterLinkScheduler.TaskContext)tc, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)filteredTopics$1.elem), (KafkaFuture<Collection<String>>)listMirrorsFuture), taskContext));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
                return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
            }
            taskResult = this.handleFilteredTopics(taskContext, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)filteredTopics.elem));
        }
        catch (ExecutionException ex) {
            TaskErrorCodeAndMsg taskErrorCodeAndMsg;
            KafkaException kafkaException;
            this.metrics.autoMirrorListTopicsFromSourceFailedSensor().record();
            Throwable throwable = ex.getCause();
            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                String errMsg = "Unable to list topics on the source cluster due to authentication issues.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg);
            } else if (throwable instanceof AuthorizationException) {
                String errMsg = "Unable to list topics on the source cluster. Please enable DESCRIBE ACLs on the source cluster to proceed.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex.getCause()).toString());
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg);
            } else {
                String errMsg = "Unable to list topics on the source cluster due to unexpected execution exception. Topics will not be mirrored.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg);
            }
            TaskErrorCodeAndMsg errorCodeAndMsg = taskErrorCodeAndMsg;
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)errorCodeAndMsg, (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        catch (Throwable ex) {
            String errMsg = "Unable to list topics on the source cluster due to unexpected throwable exception. Topics will not be mirrored.";
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
            this.metrics.autoMirrorListTopicsFromSourceFailedSensor().record();
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
            taskResult = new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        return taskResult;
    }

    private ClusterLinkScheduler.TaskResult handleListSourceMirrorTopics(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> topics, KafkaFuture<Collection<String>> listMirrorsFuture) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        try {
            scala.collection.immutable.Set<String> filteredTopics = this.removeSourceMirrorTopics(topics, (scala.collection.immutable.Set<String>)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)listMirrorsFuture.get()).asScala().toSet());
            return this.handleFilteredTopics(taskContext, filteredTopics);
        }
        catch (ExecutionException ex) {
            TaskErrorCodeAndMsg taskErrorCodeAndMsg;
            KafkaException kafkaException;
            this.metrics.autoMirrorListMirrorsFromSourceFailedSensor().record();
            Throwable throwable = ex.getCause();
            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                String errMsg = "Unable to list mirrors on the source cluster due to authentication issues.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg);
            } else if (throwable instanceof AuthorizationException) {
                String errMsg = "Unable to list mirrors on the source cluster. Please enable Describe:Cluster ACLs on the source cluster to proceed.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex.getCause()).toString());
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg);
            } else {
                String errMsg = "Unable to list mirrors on the source cluster due to unexpected exception. Topics will not be mirrored.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg);
            }
            TaskErrorCodeAndMsg errorCodeAndMsg = taskErrorCodeAndMsg;
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)errorCodeAndMsg, (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        catch (Throwable ex) {
            String errMsg = "Unable to list mirrors on the source cluster due to unexpected exception. Topics will not be mirrored.";
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
            this.metrics.autoMirrorListMirrorsFromSourceFailedSensor().record();
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
    }

    private ClusterLinkScheduler.TaskResult handleFilteredTopics(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> filteredTopics) {
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Will attempt to mirror following topics on destination cluster: ").append(filteredTopics).toString());
        if (this.conflictingDestTopics().intersect(filteredTopics).nonEmpty()) {
            ListTopicsResult listTopicsResult = this.destAdmin().listTopics();
            this.scheduleWhenComplete(listTopicsResult.namesToListings(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleListDestTopics((ClusterLinkScheduler.TaskContext)tc, listTopicsResult, filteredTopics), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        if (this.conflictingDestTopics().nonEmpty()) {
            this.conflictingDestTopics().clear();
        }
        return this.createTopics(taskContext, filteredTopics);
    }

    private ClusterLinkScheduler.TaskResult handleListDestTopics(ClusterLinkScheduler.TaskContext taskContext, ListTopicsResult result, scala.collection.immutable.Set<String> filteredTopics) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        try {
            java.util.Set destTopics = (java.util.Set)result.names().get();
            if (this.conflictingDestTopics().nonEmpty()) {
                this.conflictingDestTopics().clear();
            }
            this.conflictingDestTopics().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(destTopics).asScala().intersect(filteredTopics));
            if (this.conflictingDestTopics().nonEmpty()) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Found following conflicting topics on destination: ").append(this.conflictingDestTopics()).toString());
            }
            this.conflictingDestTopics().foreach((Function1 & Serializable)topic -> {
                ClusterLinkAutoCreateMirror.$anonfun$handleListDestTopics$2(this, topic);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Set topicsToCreate = (scala.collection.immutable.Set)filteredTopics.$minus$minus(this.conflictingDestTopics());
            return this.createTopics(taskContext, (scala.collection.immutable.Set<String>)topicsToCreate);
        }
        catch (Throwable ex) {
            String errMsg = "Unable to list topics on destination cluster to check for conflicting topics.";
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
            this.metrics.autoMirrorListTopicsFromDestinationFailedSensor().record();
            ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$))));
            return this.createTopics(newTaskContext, filteredTopics);
        }
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Set<String> filterTopics(scala.collection.immutable.Set<String> topics) {
        void var3_3;
        void var4_4;
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Filtering source topics ").append(topics).append(" to match topic filters JSON").toString());
        Tuple2<scala.collection.immutable.Set<String>, Seq<ClusterLinkFilterInfo>> tuple2 = ClusterLinkUtils$.MODULE$.doFilterTopics(topics, this.config().topicFilters(), this.linkData.tenantPrefix(), this.config().clusterLinkPrefix());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set filtered = (scala.collection.immutable.Set)tuple2._1();
        Seq unusedFilters = (Seq)tuple2._2();
        var4_4.foreach((Function1 & Serializable)unusedFilter -> {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(197).append("The filter ").append(unusedFilter).append(" does not match any source topic. This filter may not be ").append("required or the topics it referred to may not have the correct DESCRIBE ACL ").append("for the cluster link principal on the source cluster.").toString());
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    private ClusterLinkScheduler.TaskResult createTopics(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> topics) {
        int tenantPrefixLength;
        int clusterLinkPrefixLength = ((String)this.config().clusterLinkPrefix().getOrElse((Function0 & Serializable)() -> "")).length();
        Seq batchedTopics = ((scala.collection.immutable.Set)topics.map(arg_0 -> ClusterLinkAutoCreateMirror.$anonfun$createTopics$3(this, clusterLinkPrefixLength, tenantPrefixLength = ((String)this.linkData.tenantPrefix().getOrElse((Function0 & Serializable)() -> "")).length(), arg_0))).grouped(ClusterLinkAutoCreateMirror$.MODULE$.CREATE_TOPICS_BATCH_SIZE()).toSeq();
        if (batchedTopics.nonEmpty()) {
            scala.collection.immutable.Set firstBatch = (scala.collection.immutable.Set)batchedTopics.apply(0);
            Seq remainingBatches = (Seq)batchedTopics.drop(1);
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Creating following topics on destination cluster: ").append(firstBatch).toString());
            CreateTopicsResult result = this.destAdmin().createTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)firstBatch).asJava());
            this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleBatchCreateTopics((ClusterLinkScheduler.TaskContext)tc, result.values(), (Seq<scala.collection.immutable.Set<NewTopic>>)remainingBatches), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    private scala.collection.immutable.Set<String> removeSourceMirrorTopics(scala.collection.immutable.Set<String> topics, scala.collection.immutable.Set<String> mirrorTopics) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("Mirror topics at source ").append(mirrorTopics).toString());
        scala.collection.immutable.Set filteredTopics = (scala.collection.immutable.Set)topics.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAutoCreateMirror.$anonfun$removeSourceMirrorTopics$2(mirrorTopics, x$4)));
        scala.collection.immutable.Set filteredOutTopics = (scala.collection.immutable.Set)topics.$minus$minus((IterableOnce)filteredTopics);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Filtering out ").append(filteredOutTopics).append(" because they are mirror topics at the source cluster").toString());
        if (filteredOutTopics.nonEmpty()) {
            this.metrics.prefixedAutoMirrorTopicFilteredSensor().record((double)filteredOutTopics.size());
        } else {
            this.metrics.prefixedAutoMirrorTopicFilteredSensor().record(0.0);
        }
        return filteredTopics;
    }

    private ClusterLinkScheduler.TaskResult handleBatchCreateTopics(ClusterLinkScheduler.TaskContext taskContext, Map<String, KafkaFuture<Void>> topicListings, Seq<scala.collection.immutable.Set<NewTopic>> remainingBatches) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        Iterable errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicListings).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                KafkaFuture future = (KafkaFuture)x0$1._2();
                return this.addMirroredTopicAndLogWarnings(topic, (KafkaFuture<Void>)future);
            }
            throw new MatchError(null);
        });
        ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((IterableOnce)errs)));
        if (remainingBatches.isEmpty()) {
            Seq<TaskErrorCodeAndMsg> completedTask_errs = newTaskContext.errs();
            return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
        }
        scala.collection.immutable.Set nextBatch = (scala.collection.immutable.Set)remainingBatches.apply(0);
        Seq nextRemainingBatches = (Seq)remainingBatches.drop(1);
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Creating following topics on destination cluster: ").append(nextBatch).toString());
        CreateTopicsResult result = this.destAdmin().createTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)nextBatch).asJava());
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleBatchCreateTopics((ClusterLinkScheduler.TaskContext)tc, result.values(), (Seq<scala.collection.immutable.Set<NewTopic>>)nextRemainingBatches), newTaskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = newTaskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<TaskErrorCodeAndMsg> addMirroredTopicAndLogWarnings(String topic, KafkaFuture<Void> future) {
        None$ errOpt;
        None$ none$;
        try {
            future.get();
            this.mirrorTopics().$plus$eq((Object)topic);
            this.metrics.autoMirrorCreateSensor().record();
            if (!this.config().clusterLinkPrefix().forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isEmpty()))) {
                this.metrics.prefixedAutoMirrorCreateSensor().record();
            }
            none$ = None$.MODULE$;
        }
        catch (ExecutionException ex) {
            KafkaException kafkaException;
            Throwable throwable = ex.getCause();
            if (throwable instanceof TopicExistsException) {
                this.conflictingDestTopics().add((Object)topic);
                String errMsg = new StringBuilder(75).append("Topic ").append(topic).append(" already exists on destination cluster. Will not mirror source").append(" topic.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(errMsg).append(ex.getCause()).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                none$ = new Some((Object)new TaskErrorCodeAndMsg(TopicExistsTaskErrorCode$.MODULE$, errMsg));
            } else if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                String errMsg = new StringBuilder(53).append("Unable to create topic ").append(topic).append(" due to authentication issues.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                none$ = new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, errMsg));
            } else if (throwable instanceof AuthorizationException) {
                void var13_13;
                String string;
                TaskErrorCode taskErrorCode;
                AuthorizationException authorizationException = (AuthorizationException)throwable;
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                String string2 = authorizationException.getMessage();
                String string3 = ClusterLinkUtils$.MODULE$.MirrorTopicCreationReadAccessErrMsg();
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    String errMsg = new StringBuilder(52).append("Unable to create topic ").append(topic).append(" due to authorization error. ").append(authorizationException.getMessage()).toString();
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(authorizationException.getCause()).toString());
                    taskErrorCode = AuthorizationTaskErrorCode$.MODULE$;
                    string = errMsg;
                } else {
                    String errMsg = new StringBuilder(113).append("Unable to create topic ").append(topic).append(" due to authorization error. Please allow CREATE access on destination cluster to proceed.").toString();
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(authorizationException.getCause()).toString());
                    taskErrorCode = BrokerAuthorizationTaskErrorCode$.MODULE$;
                    string = errMsg;
                }
                String string4 = string;
                TaskErrorCode errCode = taskErrorCode;
                none$ = new Some((Object)new TaskErrorCodeAndMsg((TaskErrorCode)var13_13, string4));
            } else if (throwable instanceof PolicyViolationException) {
                PolicyViolationException policyViolationException = (PolicyViolationException)throwable;
                String errMsg = new StringBuilder(47).append("Unable to create topic ").append(topic).append(" on destination cluster.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append((Object)policyViolationException).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                none$ = new Some((Object)new TaskErrorCodeAndMsg(PolicyViolationTaskErrorCode$.MODULE$, new StringBuilder(43).append("Failed to create ").append(topic).append(" due to policy violation: ").append(policyViolationException.getMessage()).toString()));
            } else if (throwable instanceof InvalidTopicException) {
                InvalidTopicException invalidTopicException = (InvalidTopicException)throwable;
                String errMsg = new StringBuilder(47).append("Unable to create topic ").append(topic).append(" on destination cluster.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(invalidTopicException).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                none$ = new Some((Object)new TaskErrorCodeAndMsg(InvalidTopicTaskErrorCode$.MODULE$, new StringBuilder(53).append("Failed to create ").append(topic).append(" due to an invalid topic exception: ").append(invalidTopicException.getMessage()).toString()));
            } else {
                String errMsg = new StringBuilder(47).append("Unable to create topic ").append(topic).append(" on destination cluster.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                none$ = new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
            }
        }
        catch (Throwable ex) {
            String errMsg = new StringBuilder(47).append("Unable to create topic ").append(topic).append(" on destination cluster.").toString();
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
            this.metrics.autoMirrorCreateFailedSensor().record();
            this.recordFailedPrefixedAutoMirrorCreateMetrics();
            none$ = errOpt = new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
        }
        if (errOpt instanceof Some) {
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)errOpt).value();
            return new .colon.colon((Object)err, (List)Nil$.MODULE$);
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private scala.collection.immutable.Set<String> allLinkedTopics() {
        return this.metadataManager().mirrorTopicStatesFromMetadataCache(this.linkData.linkId()).keySet().toSet();
    }

    private void recordFailedPrefixedAutoMirrorCreateMetrics() {
        if (!this.config().clusterLinkPrefix().forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isEmpty()))) {
            this.metrics.prefixedAutoMirrorCreateFailedSensor().record();
            return;
        }
    }

    public scala.collection.mutable.Set<String> getMirrorTopics() {
        return this.mirrorTopics();
    }

    public scala.collection.mutable.Set<String> getConflictingDestTopics() {
        return this.conflictingDestTopics();
    }

    public boolean getInitialized() {
        return this.initialized();
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        Option<TaskDescription> newTaskDesc = this.metadataManager().isLinkCoordinator(this.linkData.linkName()) ? (this.config().autoMirroringEnable() ? ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkAutoMirroringTaskType$.MODULE$, "run the auto create mirror topic task") : new Some((Object)new TaskDescription(NotConfiguredTaskState$.MODULE$, (Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty())))) : None$.MODULE$;
        this.taskDesc_$eq(newTaskDesc);
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    public static final /* synthetic */ void $anonfun$handleListSourceTopics$3(ClusterLinkAutoCreateMirror $this, Map namesToListings$1, int prefixLength$1, ObjectRef filteredTopics$1, String topicName) {
        if (ClusterLinkAutoCreateMirror$.MODULE$.filterTopic((scala.collection.mutable.Map<String, TopicListing>)CollectionConverters$.MODULE$.MapHasAsScala(namesToListings$1).asScala(), prefixLength$1, topicName)) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Internal or Confluent topic ").append(topicName).append(" will not be mirrored.").toString());
            filteredTopics$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)filteredTopics$1.elem).$minus((Object)topicName);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleListDestTopics$2(ClusterLinkAutoCreateMirror $this, String topic) {
        $this.metrics.autoMirrorCreateFailedSensor().record();
        $this.recordFailedPrefixedAutoMirrorCreateMetrics();
    }

    public static final /* synthetic */ NewTopic $anonfun$createTopics$3(ClusterLinkAutoCreateMirror $this, int clusterLinkPrefixLength$1, int tenantPrefixLength$1, String topic) {
        String mirrorTopicName = clusterLinkPrefixLength$1 > 0 ? new StringBuilder(0).append(topic.substring(0, tenantPrefixLength$1)).append(topic.substring(tenantPrefixLength$1 + clusterLinkPrefixLength$1)).toString() : topic;
        return new NewTopic(topic, Optional.empty(), Optional.empty()).mirror(Optional.of(new NewMirrorTopic($this.linkData.linkName(), mirrorTopicName)));
    }

    public static final /* synthetic */ boolean $anonfun$removeSourceMirrorTopics$2(scala.collection.immutable.Set mirrorTopics$1, String x$4) {
        return !mirrorTopics$1.contains((Object)x$4);
    }

    public ClusterLinkAutoCreateMirror(ClusterLinkDestClientManager clientManager, ClusterLinkMetadataManager metadataManager, ClusterLinkData linkData, Function0<ConfluentAdmin> destAdminFactory, ClusterLinkMetrics metrics, Time time, ClusterLinkRequestQuota quota) {
        this.clientManager = clientManager;
        this.metadataManager = metadataManager;
        this.linkData = linkData;
        this.destAdminFactory = destAdminFactory;
        this.metrics = metrics;
        super(clientManager.scheduler(), "ClusterLinkAutoCreateMirror", (int)Predef$.MODULE$.Long2long(clientManager.currentConfig().metadataMaxAgeMs()), time, quota);
        this.config = clientManager.currentConfig();
        this.mirrorTopics = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        this.conflictingDestTopics = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        this.tasksOutstanding = 0;
        this.destAdmin = (ConfluentAdmin)destAdminFactory.apply();
        this.initialized = false;
        this.taskDesc = None$.MODULE$;
    }
}

