/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkCheckAvailabilityTaskType$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionChecker$;
import kafka.server.link.ClusterLinkConnectionCheckerResult;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.InvalidBootstrapInternalEndpointUnavailableLinkReason;
import kafka.server.link.LinkState;
import kafka.server.link.RemoteLinkState;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.UnauthorizedBootstrapFailedLinkReason$;
import kafka.server.link.UnavailableLinkReason;
import kafka.server.link.UnavailableLinkReason$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeClusterLinksOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\tma\u0001\u0002\u0012$\u0001)B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001B\u0001B\u0003%!\tC\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0013\"A1\n\u0001BC\u0002\u0013\u0005A\nC\u0005Q\u0001\t\u0005\t\u0015!\u0003N#\"A1\u000b\u0001BC\u0002\u0013\u0005A\u000b\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003V\u0011!\t\u0007A!b\u0001\n\u0003\u0011\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u0011I\u0004!\u0011!Q\u0001\n\rD\u0011b\u001d\u0001\u0003\u0002\u0003\u0006I\u0001\u001e?\t\u0015u\u0004!\u0011!Q\u0001\ny\f)\u0001C\u0004\u0002\b\u0001!\t!!\u0003\t\u0013\u0005\u0005\u0002A1A\u0005\n\u0005\r\u0002\u0002CA\u0016\u0001\u0001\u0006I!!\n\t\u0013\u00055\u0002A1A\u0005\n\u0005=\u0002\u0002CA\u001c\u0001\u0001\u0006I!!\r\t\u0013\u0005e\u0002\u00011A\u0005\n\u0005m\u0002\"CA\u001f\u0001\u0001\u0007I\u0011BA \u0011\u001d\tY\u0005\u0001Q!\n\u0019C\u0011\"!\u0014\u0001\u0001\u0004%I!a\u0014\t\u0013\u0005u\u0003\u00011A\u0005\n\u0005}\u0003\u0002CA2\u0001\u0001\u0006K!!\u0015\t\u0011\u00055\u0004\u0001\"\u0015$\u0003_Bq!!\"\u0001\t\u0013\t9\tC\u0004\u0002\u0010\u0002!I!!%\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"9\u0011\u0011\u001b\u0001\u0005R\u0005M\u0007bBAp\u0001\u0011\u0005\u0013\u0011\u001d\u0005\b\u0003G\u0004A\u0011BAs\u0011\u001d\tI\u000f\u0001C\u0005\u0003WDq!!@\u0001\t\u0013\tyP\u0001\u0011DYV\u001cH/\u001a:MS:\\7\t[3dW2Kgn[!wC&d\u0017MY5mSRL(B\u0001\u0013&\u0003\u0011a\u0017N\\6\u000b\u0005\u0019:\u0013AB:feZ,'OC\u0001)\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0016\u0011\u00051\u0002dBA\u0017/\u001b\u0005\u0019\u0013BA\u0018$\u0003Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe&\u0011\u0011G\r\u0002\r!\u0016\u0014\u0018n\u001c3jGR\u000b7o\u001b\u0006\u0003_\r\n!\u0002\\5oW\u000e{gNZ5h!\r)\u0004HO\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\tIa)\u001e8di&|g\u000e\r\t\u0003[mJ!\u0001P\u0012\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw-A\u0004nKR\u0014\u0018nY:\u0011\u00055z\u0014B\u0001!$\u0005I\u0019E.^:uKJd\u0015N\\6NKR\u0014\u0018nY:\u0002%\rdWo\u001d;fe2Kgn['b]\u0006<WM\u001d\t\u0003[\rK!\u0001R\u0012\u0003%\rcWo\u001d;fe2Kgn['b]\u0006<WM]\u0001\u000bS:$XM\u001d<bY6\u001b\bCA\u001bH\u0013\tAeGA\u0002J]RL!A\u0013\u0019\u0002#I,7o\u00195fIVdW\rR3mCfl5/A\u0006dYN\u001b\u0007.\u001a3vY\u0016\u0014X#A'\u0011\u00055r\u0015BA($\u0005Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe\u0006a1\r\\*dQ\u0016$W\u000f\\3sA%\u0011!\u000bM\u0001\ng\u000eDW\rZ;mKJ\f\u0001\u0002\\5oW:\u000bW.Z\u000b\u0002+B\u0011a+\u0018\b\u0003/n\u0003\"\u0001\u0017\u001c\u000e\u0003eS!AW\u0015\u0002\rq\u0012xn\u001c;?\u0013\taf'\u0001\u0004Qe\u0016$WMZ\u0005\u0003=~\u0013aa\u0015;sS:<'B\u0001/7\u0003%a\u0017N\\6OC6,\u0007%\u0001\nsK6|G/Z!e[&tg)Y2u_JLX#A2\u0011\u0007UBD\r\u0005\u0002f_6\taM\u0003\u0002hQ\u0006)\u0011\rZ7j]*\u0011\u0011N[\u0001\bG2LWM\u001c;t\u0015\tA3N\u0003\u0002m[\u00061\u0011\r]1dQ\u0016T\u0011A\\\u0001\u0004_J<\u0017B\u00019g\u00059\u0019uN\u001c4mk\u0016tG/\u00113nS:\f1C]3n_R,\u0017\tZ7j]\u001a\u000b7\r^8ss\u0002\n\u0011\u0003\\8dC2\fE-\\5o\r\u0006\u001cGo\u001c:z\u0003\u0011!\u0018.\\3\u0011\u0005UTX\"\u0001<\u000b\u0005]D\u0018!B;uS2\u001c(BA=k\u0003\u0019\u0019w.\\7p]&\u00111P\u001e\u0002\u0005)&lW-\u0003\u0002ta\u0005)\u0011/^8uCB\u0019q0!\u0001\u000e\u0003\u0015J1!a\u0001&\u0005]\u0019E.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018-\u0003\u0002~a\u00051A(\u001b8jiz\"b#a\u0003\u0002\u000e\u0005=\u0011\u0011CA\n\u0003+\t9\"!\u0007\u0002\u001c\u0005u\u0011q\u0004\t\u0003[\u0001AQa\r\bA\u0002QBQ!\u0010\bA\u0002yBQ!\u0011\bA\u0002\tCQ!\u0012\bA\u0002\u0019CQa\u0013\bA\u00025CQa\u0015\bA\u0002UCQ!\u0019\bA\u0002\rDQA\u001d\bA\u0002\rDQa\u001d\bA\u0002QDQ! \bA\u0002y\fq\u0002\\5ti2Kgn[(qi&|gn]\u000b\u0003\u0003K\u00012!ZA\u0014\u0013\r\tIC\u001a\u0002\u0018\u0019&\u001cHo\u00117vgR,'\u000fT5oWN|\u0005\u000f^5p]N\f\u0001\u0003\\5ti2Kgn[(qi&|gn\u001d\u0011\u0002'\u0011,7o\u0019:jE\u0016d\u0015N\\6PaRLwN\\:\u0016\u0005\u0005E\u0002cA3\u00024%\u0019\u0011Q\u00074\u00037\u0011+7o\u0019:jE\u0016\u001cE.^:uKJd\u0015N\\6t\u001fB$\u0018n\u001c8t\u0003Q!Wm]2sS\n,G*\u001b8l\u001fB$\u0018n\u001c8tA\u0005Ia-Y5m\u0007>,h\u000e^\u000b\u0002\r\u0006ia-Y5m\u0007>,h\u000e^0%KF$B!!\u0011\u0002HA\u0019Q'a\u0011\n\u0007\u0005\u0015cG\u0001\u0003V]&$\b\u0002CA%)\u0005\u0005\t\u0019\u0001$\u0002\u0007a$\u0013'\u0001\u0006gC&d7i\\;oi\u0002\n\u0001\u0002^1tW\u0012+7oY\u000b\u0003\u0003#\u0002R!NA*\u0003/J1!!\u00167\u0005\u0019y\u0005\u000f^5p]B\u0019Q&!\u0017\n\u0007\u0005m3EA\bUCN\\G)Z:de&\u0004H/[8o\u00031!\u0018m]6EKN\u001cw\fJ3r)\u0011\t\t%!\u0019\t\u0013\u0005%s#!AA\u0002\u0005E\u0013!\u0003;bg.$Um]2!Q\rA\u0012q\r\t\u0004k\u0005%\u0014bAA6m\tAao\u001c7bi&dW-A\u0002sk:$\"!!\u001d\u0011\t\u0005M\u0014\u0011\u0011\b\u0004\u0003krc\u0002BA<\u0003\u007frA!!\u001f\u0002~9\u0019\u0001,a\u001f\n\u0003!J!AJ\u0014\n\u0005\u0011*\u0013bAABe\tQA+Y:l%\u0016\u001cX\u000f\u001c;\u00027M\\\u0017\u000e\u001d*f[>$X-\u0011<bS2\f'-\u001b7jif\u001c\u0005.Z2l+\t\tI\tE\u00026\u0003\u0017K1!!$7\u0005\u001d\u0011un\u001c7fC:\f1\u0004[1oI2,G)Z:de&\u0014Wm\u00117vgR,'OU3tk2$HCBA9\u0003'\u000bi\nC\u0004\u0002\u0016n\u0001\r!a&\u0002\u0017Q\f7o[\"p]R,\u0007\u0010\u001e\t\u0005\u0003g\nI*C\u0002\u0002\u001cJ\u00121\u0002V1tW\u000e{g\u000e^3yi\"9\u0011qT\u000eA\u0002\u0005\u0005\u0016aJ7bs\n,7\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg.Z2uS>t7\t[3dW\u0016\u0014(+Z:vYR\u0004R!NA*\u0003G\u00032!LAS\u0013\r\t9k\t\u0002#\u00072,8\u000f^3s\u0019&t7nQ8o]\u0016\u001cG/[8o\u0007\",7m[3s%\u0016\u001cX\u000f\u001c;\u0002K!\fg\u000e\u001a7f\u0019>\u001c\u0017\r\u001c#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:MS:\\7OU3tk2$HCBA9\u0003[\u000by\u000bC\u0004\u0002\u0016r\u0001\r!a&\t\u000f\u0005EF\u00041\u0001\u00024\u0006\u0019B-Z:de&\u0014W\rT5oWN4U\u000f^;sKB1\u0011QWA\\\u0003wk\u0011\u0001_\u0005\u0004\u0003sC(aC&bM.\fg)\u001e;ve\u0016\u0004b!!0\u0002H\u0006-WBAA`\u0015\u0011\t\t-a1\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u000b\fAA[1wC&!\u0011\u0011ZA`\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0004K\u00065\u0017bAAhM\n12\t\\;ti\u0016\u0014H*\u001b8l\t\u0016\u001c8M]5qi&|g.\u0001\u0007p]\u000e{W\u000e\u001d7fi&|g\u000e\u0006\u0003\u0002B\u0005U\u0007bBAl;\u0001\u0007\u0011\u0011\\\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\u00071\nY.C\u0002\u0002^J\u00121cQ8na2,G/\u001a3UCN\\'+Z:vYR\fq\u0002^1tW\u0012+7o\u0019:jaRLwN\u001c\u000b\u0003\u0003#\nQ\u0003\\5tiJ+Wn\u001c;f\u00072,8\u000f^3s\u0019&t7\u000e\u0006\u0003\u0002r\u0005\u001d\bbBAK?\u0001\u0007\u0011qS\u0001\u0015Q\u0006tG\r\\3MSN$H*\u001b8l%\u0016\u001cX\u000f\u001c;\u0015\r\u0005E\u0014Q^Ax\u0011\u001d\t)\n\ta\u0001\u0003/Cq!!=!\u0001\u0004\t\u00190\u0001\u0004gkR,(/\u001a\t\u0007\u0003k\u000b9,!>\u0011\r\u0005u\u0016qYA|!\r)\u0017\u0011`\u0005\u0004\u0003w4'AE\"mkN$XM\u001d'j].d\u0015n\u001d;j]\u001e\fA\u0003\\8h\u0019&t7\u000eR3tGJL'-Z#se>\u0014HCBA!\u0005\u0003\u00119\u0002C\u0004\u0003\u0004\u0005\u0002\rA!\u0002\u0002\u0003\u0015\u0004BAa\u0002\u0003\u00129!!\u0011\u0002B\u0007\u001d\rA&1B\u0005\u0002o%\u0019!q\u0002\u001c\u0002\u000fA\f7m[1hK&!!1\u0003B\u000b\u0005%!\u0006N]8xC\ndWMC\u0002\u0003\u0010YBaA!\u0007\"\u0001\u0004)\u0016\u0001\u00037j].$Um]2")
public class ClusterLinkCheckLinkAvailability
extends ClusterLinkScheduler.PeriodicTask {
    private final Function0<ClusterLinkConfig> linkConfig;
    private final ClusterLinkMetrics metrics;
    private final ClusterLinkManager clusterLinkManager;
    private final String linkName;
    private final Function0<ConfluentAdmin> remoteAdminFactory;
    private final Function0<ConfluentAdmin> localAdminFactory;
    private final ListClusterLinksOptions listLinkOptions;
    private final DescribeClusterLinksOptions describeLinkOptions;
    private int failCount;
    private volatile Option<TaskDescription> taskDesc;

    public ClusterLinkScheduler clScheduler() {
        return super.scheduler();
    }

    public String linkName() {
        return this.linkName;
    }

    public Function0<ConfluentAdmin> remoteAdminFactory() {
        return this.remoteAdminFactory;
    }

    private ListClusterLinksOptions listLinkOptions() {
        return this.listLinkOptions;
    }

    private DescribeClusterLinksOptions describeLinkOptions() {
        return this.describeLinkOptions;
    }

    private int failCount() {
        return this.failCount;
    }

    private void failCount_$eq(int x$1) {
        this.failCount = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()));
        if (this.skipRemoteAvailabilityCheck()) {
            KafkaFuture describeLinksFuture = ((ConfluentAdmin)this.localAdminFactory.apply()).describeClusterLinks(this.describeLinkOptions()).result();
            this.scheduleWhenComplete(describeLinksFuture, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleLocalDescribeClusterLinksResult((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Collection<ClusterLinkDescription>>)describeLinksFuture), new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()))));
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        DescribeClusterResult describeClusterResult = ClusterLinkConnectionChecker$.MODULE$.doBasicDescribeCluster((Admin)this.remoteAdminFactory().apply());
        this.scheduleWhenComplete(describeClusterResult.clusterId(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleDescribeClusterResult((ClusterLinkScheduler.TaskContext)tc, ClusterLinkConnectionChecker$.MODULE$.check(describeClusterResult, (ClusterLinkConfig)((Object)((Object)$this.linkConfig.apply())))), new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()))));
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private boolean skipRemoteAvailabilityCheck() {
        ConfluentConfigs.ClusterLinkAvailabilityCheckMode clusterLinkAvailabilityCheckMode = this.clusterLinkManager.brokerConfig().clusterLinkAvailabilityCheckMode();
        ConfluentConfigs.ClusterLinkAvailabilityCheckMode clusterLinkAvailabilityCheckMode2 = ConfluentConfigs.ClusterLinkAvailabilityCheckMode.LINK_COORDINATOR;
        return !(clusterLinkAvailabilityCheckMode != null ? !clusterLinkAvailabilityCheckMode.equals(clusterLinkAvailabilityCheckMode2) : clusterLinkAvailabilityCheckMode2 != null) && !this.clusterLinkManager.metadataManager().isLinkCoordinator(this.linkName());
    }

    private ClusterLinkScheduler.TaskResult handleDescribeClusterResult(ClusterLinkScheduler.TaskContext taskContext, Option<ClusterLinkConnectionCheckerResult> maybeClusterLinkConnectionCheckerResult) {
        if (Predef$.MODULE$.Boolean2boolean(((ClusterLinkConfig)((Object)this.linkConfig.apply())).clusterLinkPaused())) {
            Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        String linkName = this.metrics.linkName();
        if (None$.MODULE$.equals(maybeClusterLinkConnectionCheckerResult)) {
            this.failCount_$eq(0);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Link ").append(linkName).append(" availability check succeeded").toString());
            this.clusterLinkManager.reportAvailableLink(linkName);
        } else if (maybeClusterLinkConnectionCheckerResult instanceof Some) {
            ClusterLinkConnectionCheckerResult linkUnavailableResult = (ClusterLinkConnectionCheckerResult)((Some)maybeClusterLinkConnectionCheckerResult).value();
            this.failCount_$eq(this.failCount() + 1);
            this.metrics.linkUnavailableSensor().record();
            if (linkUnavailableResult.unavailableLinkReason() instanceof InvalidBootstrapInternalEndpointUnavailableLinkReason) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Link ").append(linkName).append(" availability check failed with authorization error").toString());
                this.clusterLinkManager.failClusterLink(linkName, linkUnavailableResult.throwable(), UnauthorizedBootstrapFailedLinkReason$.MODULE$, (ClusterLinkConfig)((Object)this.linkConfig.apply()));
            } else {
                LinkState linkState;
                if (this.failCount() >= Predef$.MODULE$.Integer2int(((ClusterLinkConfig)((Object)this.linkConfig.apply())).availabilityCheckConsecutiveFailureThreshold())) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Reporting ").append(linkName).append(" as unavailable with exception ").append(linkUnavailableResult.throwable().getCause()).append(" and reason ").append(linkUnavailableResult.unavailableLinkReason()).append(" failCount ").append(this.failCount()).toString());
                    this.clusterLinkManager.reportUnavailableLink(linkName, linkUnavailableResult.unavailableLinkReason());
                }
                LinkState linkState2 = linkState = this.clusterLinkManager.linkState(linkName);
                ActiveClusterLink$ activeClusterLink$ = ActiveClusterLink$.MODULE$;
                if (linkState2 != null && linkState2.equals(activeClusterLink$)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Link ").append(linkName).append(" availability check failed ").append(this.failCount()).append(" times").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> linkUnavailableResult.throwable());
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(81).append("Link ").append(linkName).append(" availability check in state ").append(linkState).append(" failed ").append(this.failCount()).append(" times with exception ").append(linkUnavailableResult.throwable().getCause()).append(" ").append("and reason code ").append(linkUnavailableResult.unavailableLinkReason()).toString());
                }
            }
        } else {
            throw new MatchError(maybeClusterLinkConnectionCheckerResult);
        }
        if (!((ClusterLinkConfig)((Object)this.linkConfig.apply())).remoteIsUnmanaged()) {
            if (this.failCount() == 0) {
                return this.listRemoteClusterLink(taskContext);
            }
            this.clusterLinkManager.updateRemoteLinkState(linkName, new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.UNKNOWN, (Option<String>)new Some((Object)"Failed to obtain remote link state since cluster link is unavailable"), super.time().milliseconds()));
            Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
        }
        Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult handleLocalDescribeClusterLinksResult(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Collection<ClusterLinkDescription>> describeLinksFuture) {
        void var5_6;
        void var4_5;
        if (Predef$.MODULE$.Boolean2boolean(((ClusterLinkConfig)((Object)this.linkConfig.apply())).clusterLinkPaused())) {
            Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        Tuple2 tuple2 = this.liftedTree1$1(describeLinksFuture);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Collection links = (Collection)tuple2._1();
        Option errOpt = (Option)tuple2._2();
        var4_5.forEach(link -> {
            if (!$this.clusterLinkManager.metadataManager().isLinkCoordinator(link.linkName())) {
                RemoteLinkState remoteLinkState = new RemoteLinkState(link.remoteLinkState(), link.remoteLinkError(), (Option<String>)Option$.MODULE$.apply((Object)link.remoteLinkErrorMessage()), link.remoteLinkStateTimeMs());
                ClusterLinkDescription.LinkState linkState = link.linkState();
                if (ClusterLinkDescription.LinkState.ACTIVE.equals(linkState)) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Link ").append(link.linkName()).append("(").append(link.clusterLinkId()).append(") is active").toString());
                    $this.clusterLinkManager.reportAvailableLink(link.linkName());
                } else if (ClusterLinkDescription.LinkState.UNAVAILABLE.equals(linkState)) {
                    UnavailableLinkReason reason = UnavailableLinkReason$.MODULE$.fromError(link.clusterLinkError(), link.linkErrorMessage());
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Link ").append(link.linkName()).append("(").append(link.clusterLinkId()).append(") is unavailable, reason ").append(reason).toString());
                    $this.metrics.linkUnavailableSensor().record();
                    $this.clusterLinkManager.reportUnavailableLink(link.linkName(), reason);
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Link ").append(link.linkName()).append("(").append(link.clusterLinkId()).append(") has state ").append(linkState).append(", ignoring.").toString());
                }
                $this.clusterLinkManager.updateRemoteLinkState(link.linkName(), remoteLinkState);
                return;
            }
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(93).append("Ignoring link state of ").append(link.linkName()).append(" since this broker has already processed the state as link coordinator").toString());
        });
        if (var5_6 instanceof Some) {
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)var5_6).value();
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)err, (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        if (None$.MODULE$.equals(var5_6)) {
            Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
        }
        throw new MatchError((Object)var5_6);
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkCheckAvailabilityTaskType$.MODULE$, "run the availability check task"));
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private ClusterLinkScheduler.TaskResult listRemoteClusterLink(ClusterLinkScheduler.TaskContext taskContext) {
        KafkaFuture listLinkResult = ((ConfluentAdmin)this.remoteAdminFactory().apply()).listClusterLinks(this.listLinkOptions()).result();
        this.scheduleWhenComplete(listLinkResult, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleListLinkResult((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Collection<ClusterLinkListing>>)listLinkResult), taskContext));
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult handleListLinkResult(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Collection<ClusterLinkListing>> future) {
        .colon.colon colon2;
        void var6_6;
        void var7_7;
        block9: {
            Tuple2 tuple2;
            block8: {
                if (Predef$.MODULE$.Boolean2boolean(((ClusterLinkConfig)((Object)this.linkConfig.apply())).clusterLinkPaused())) {
                    Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
                    return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
                }
                long now = super.time().milliseconds();
                tuple2 = this.liftedTree2$1(future, now);
                if (tuple2 == null) break block8;
                Option errOpt = (Option)tuple2._1();
                RemoteLinkState remoteLinkState = (RemoteLinkState)tuple2._2();
                if (errOpt != null && remoteLinkState != null) break block9;
            }
            throw new MatchError((Object)tuple2);
        }
        this.clusterLinkManager.updateRemoteLinkState(this.linkName(), (RemoteLinkState)var7_7);
        if (var6_6 instanceof Some) {
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)var6_6).value();
            colon2 = new .colon.colon((Object)err, (List)Nil$.MODULE$);
        } else if (None$.MODULE$.equals(var6_6)) {
            colon2 = (Seq)package$.MODULE$.Seq().empty();
        } else {
            throw new MatchError((Object)var6_6);
        }
        .colon.colon errs = colon2;
        Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)errs);
        return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    private void logLinkDescribeError(Throwable e, String linkDesc) {
        Throwable cause;
        Throwable throwable = cause = e.getCause() == null ? e : e.getCause();
        if (this.failCount() == 0 && !(cause instanceof RetriableException)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append(linkDesc).append(" link state could not be determined for cluster link ").append(this.linkName()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append(linkDesc).append(" link state could not be determined for cluster link ").append(this.linkName()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(KafkaFuture describeLinksFuture$2) {
        try {
            return new Tuple2(describeLinksFuture$2.get(), (Object)None$.MODULE$);
        }
        catch (Throwable e) {
            this.logLinkDescribeError(e, "Local");
            TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Failed to obtain local link state from the link coordinator.");
            return new Tuple2(Collections.emptySet(), (Object)new Some((Object)err));
        }
    }

    private final /* synthetic */ Tuple2 liftedTree2$1(KafkaFuture future$1, long now$1) {
        Tuple2 tuple2;
        try {
            Collection listing = (Collection)future$1.get();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("handleListLinkResult ").append(this.linkName()).append(": ").append(listing).toString());
            if (!listing.isEmpty()) {
                ClusterLinkListing remoteLink = (ClusterLinkListing)listing.iterator().next();
                return new Tuple2((Object)None$.MODULE$, (Object)new RemoteLinkState(remoteLink.linkState(), remoteLink.clusterLinkError(), (Option<String>)Option$.MODULE$.apply((Object)remoteLink.linkErrorMessage()), now$1));
            }
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Remote link state is empty for cluster link ").append(this.linkName()).toString());
            None$ x$4 = None$.MODULE$;
            Tuple2 tuple22 = new Tuple2((Object)None$.MODULE$, (Object)new RemoteLinkState(ClusterLinkDescription.LinkState.REMOTE_LINK_NOT_FOUND, ClusterLinkError.NO_ERROR, (Option<String>)x$4, now$1));
            tuple2 = tuple22;
        }
        catch (Throwable ex) {
            ApiException e = ClusterLinkUtils$.MODULE$.apiException(ex, new StringBuilder(59).append("Remote link state could not be determined for cluster link ").append(this.linkName()).toString());
            this.logLinkDescribeError(e, "Remote");
            if (e instanceof AuthenticationException) {
                String errMsg = "Failed to obtain remote link state due to authentication failure. This failure may impact functioning of this link until credentials are updated.";
                return new Tuple2((Object)new Some((Object)new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg)), (Object)new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.AUTHENTICATION_ERROR, (Option<String>)new Some((Object)errMsg), now$1));
            }
            if (e instanceof ClusterAuthorizationException) {
                String errMsg = "Failed to obtain remote link state due to Describe:Cluster authorization failure. This failure may impact functioning of this link until appropriate access is granted.";
                return new Tuple2((Object)new Some((Object)new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg)), (Object)new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.AUTHORIZATION_ERROR, (Option<String>)new Some((Object)errMsg), now$1));
            }
            if (e != null) {
                String errMsg = "Failed to obtain remote link state for an unknown reason.";
                return new Tuple2((Object)new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), (Object)new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.UNKNOWN, (Option<String>)new Some((Object)errMsg), now$1));
            }
            throw new MatchError(null);
        }
        return tuple2;
    }

    public ClusterLinkCheckLinkAvailability(Function0<ClusterLinkConfig> linkConfig, ClusterLinkMetrics metrics, ClusterLinkManager clusterLinkManager, int intervalMs, ClusterLinkScheduler clScheduler, String linkName, Function0<ConfluentAdmin> remoteAdminFactory, Function0<ConfluentAdmin> localAdminFactory, Time time, ClusterLinkRequestQuota quota) {
        this.linkConfig = linkConfig;
        this.metrics = metrics;
        this.clusterLinkManager = clusterLinkManager;
        this.linkName = linkName;
        this.remoteAdminFactory = remoteAdminFactory;
        this.localAdminFactory = localAdminFactory;
        super(clScheduler, "ClusterLinkCheckLinkAvailability", intervalMs, time, quota);
        this.listLinkOptions = new ListClusterLinksOptions().linkNames(Optional.of(Collections.singleton(linkName)));
        this.describeLinkOptions = new DescribeClusterLinksOptions().includeTasks(false).linkNames(Collections.singleton(linkName));
        this.failCount = 0;
        this.taskDesc = None$.MODULE$;
    }
}

