/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.KafkaConfig;
import kafka.server.LinkRequestQuotaUsageType$Metadata$;
import kafka.server.link.ClusterLinkClientType;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkDynamicLogger;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetadataThread$;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkSelectorMetricsRegistry;
import kafka.server.link.CoordinatorListener;
import kafka.server.link.FindCoordinatorResponseResult;
import kafka.server.link.MetadataListener;
import kafka.server.link.MetadataRefreshListener;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.message.DescribeClusterLinksResponseData;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeClusterLinksRequest;
import org.apache.kafka.common.requests.DescribeClusterLinksResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0015c\u0001\u0002\u00180\u0001YB\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"Aa\u000b\u0001B\u0001B\u0003%q\u000b\u0003\u0005a\u0001\t\u0015\r\u0011\"\u0001b\u0011!)\u0007A!A!\u0002\u0013\u0011\u0007\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011B4\t\u00119\u0004!\u0011!Q\u0001\n=D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\tm\u0002\u0011\t\u0011)A\u0005o\"A!\u0010\u0001B\u0001B\u0003%1\u0010C\u0004\u0002\u0002\u0001!\t!a\u0001\t\u0013\u0005e\u0001A1A\u0005\n\u0005m\u0001\u0002CA\u0012\u0001\u0001\u0006I!!\b\t\u0015\u0005\u0015\u0002A1A\u0005\u0002=\n9\u0003\u0003\u0005\u00020\u0001\u0001\u000b\u0011BA\u0015\u0011%\t\t\u0004\u0001b\u0001\n\u0013\t\u0019\u0004\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u001b\u0011%\ti\u0004\u0001b\u0001\n\u0013\ty\u0004\u0003\u0005\u0002X\u0001\u0001\u000b\u0011BA!\u0011%\tI\u0006\u0001b\u0001\n\u0013\tY\u0006\u0003\u0005\u0002f\u0001\u0001\u000b\u0011BA/\u0011-\t9\u0007\u0001a\u0001\u0002\u0004%I!!\u001b\t\u0017\u0005M\u0004\u00011AA\u0002\u0013%\u0011Q\u000f\u0005\f\u0003\u0003\u0003\u0001\u0019!A!B\u0013\tY\u0007C\u0006\u0002\f\u0002\u0001\r\u00111A\u0005\n\u00055\u0005bCAK\u0001\u0001\u0007\t\u0019!C\u0005\u0003/C1\"a'\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0010\"9\u0011q\u0014\u0001\u0005B\u0005\u0005\u0006bBAR\u0001\u0011\u0005\u0013Q\u0015\u0005\b\u0003[\u0003A\u0011IAQ\u0011\u001d\ty\u000b\u0001C\u0001\u0003cCq!a.\u0001\t\u0003\tI\fC\u0004\u0002>\u0002!\t!a0\t\u000f\u0005\r\u0007\u0001\"\u0005\u0002F\"9\u00111\u001a\u0001\u0005B\u0005\u0005\u0006bBAg\u0001\u0011%\u0011\u0011\u0015\u0005\b\u0003\u001f\u0004A\u0011BAQ\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'Dq!a9\u0001\t\u0013\t)\u000fC\u0004\u0002x\u0002!I!!?\t\u000f\u0005u\b\u0001\"\u0003\u0002\"\u001e9\u0011q`\u0018\t\u0002\t\u0005aA\u0002\u00180\u0011\u0003\u0011\u0019\u0001C\u0004\u0002\u0002-\"\tAa\u0003\t\u000f\t51\u0006\"\u0001\u0003\u0010\tI2\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uCRC'/Z1e\u0015\t\u0001\u0014'\u0001\u0003mS:\\'B\u0001\u001a4\u0003\u0019\u0019XM\u001d<fe*\tA'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u000194i\u0012\t\u0003q\u0005k\u0011!\u000f\u0006\u0003um\nA!\u001e;jY*\u0011!\u0007\u0010\u0006\u0003iuR!AP \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0015aA8sO&\u0011!)\u000f\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG\r\u0005\u0002E\u000b6\tq&\u0003\u0002G_\t9R*\u001a;bI\u0006$\u0018MU3ge\u0016\u001c\b\u000eT5ti\u0016tWM\u001d\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015N\nQ!\u001e;jYNL!\u0001T%\u0003\u000f1{wmZ5oO\u0006a!M]8lKJ\u001cuN\u001c4jOB\u0011q\nU\u0007\u0002c%\u0011\u0011+\r\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\tdYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\u0004\"\u0001\u0012+\n\u0005U{#!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO\u0006\t2m\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0007a[V,D\u0001Z\u0015\u0005Q\u0016!B:dC2\f\u0017B\u0001/Z\u0005\u0019y\u0005\u000f^5p]B\u0011AIX\u0005\u0003?>\u0012Ad\u00117vgR,'\u000fT5oW\u000e{gN\\3di&|g.T1oC\u001e,'/A\ndYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-F\u0001c!\t!5-\u0003\u0002e_\t\u00192\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uC\u0006!2\r\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uC\u0002\nq!\\3ue&\u001c7\u000f\u0005\u0002iY6\t\u0011N\u0003\u0002gU*\u00111\u000eP\u0001\u0007G>lWn\u001c8\n\u00055L'aB'fiJL7m]\u0001\u0018g\u0016dWm\u0019;pe6+GO]5dgJ+w-[:uef\u0004\"\u0001\u00129\n\u0005E|#AI\"mkN$XM\u001d'j].\u001cV\r\\3di>\u0014X*\u001a;sS\u000e\u001c(+Z4jgR\u0014\u00180\u0001\u0006dY&,g\u000e\u001e+za\u0016\u0004\"\u0001\u0012;\n\u0005U|#!F\"mkN$XM\u001d'j].\u001cE.[3oiRK\b/Z\u0001\u0006cV|G/\u0019\t\u0003\u001fbL!!_\u0019\u0003/\rcWo\u001d;fe2Kgn\u001b*fcV,7\u000f^)v_R\f\u0017\u0001\u0002;j[\u0016\u0004\"\u0001 @\u000e\u0003uT!A\u00136\n\u0005}l(\u0001\u0002+j[\u0016\fa\u0001P5oSRtD\u0003FA\u0003\u0003\u000f\tI!a\u0003\u0002\u000e\u0005=\u0011\u0011CA\n\u0003+\t9\u0002\u0005\u0002E\u0001!)Qj\u0003a\u0001\u001d\")!k\u0003a\u0001'\")ak\u0003a\u0001/\")\u0001m\u0003a\u0001E\")am\u0003a\u0001O\")an\u0003a\u0001_\")!o\u0003a\u0001g\")ao\u0003a\u0001o\")!p\u0003a\u0001w\u0006QAn\\4D_:$X\r\u001f;\u0016\u0005\u0005u\u0001c\u0001?\u0002 %\u0019\u0011\u0011E?\u0003\u00151{wmQ8oi\u0016DH/A\u0006m_\u001e\u001cuN\u001c;fqR\u0004\u0013!E2mkN$XM\u001d'j].\u001cE.[3oiV\u0011\u0011\u0011\u0006\t\u0004\t\u0006-\u0012bAA\u0017_\tA2\t\\;ti\u0016\u0014H*\u001b8l\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\u0002%\rdWo\u001d;fe2Kgn[\"mS\u0016tG\u000fI\u0001\u000eIft\u0017-\\5d\u0019><w-\u001a:\u0016\u0005\u0005U\u0002c\u0001#\u00028%\u0019\u0011\u0011H\u0018\u00031\rcWo\u001d;fe2Kgn\u001b#z]\u0006l\u0017n\u0019'pO\u001e,'/\u0001\bes:\fW.[2M_\u001e<WM\u001d\u0011\u0002#5,G/\u00193bi\u0006d\u0015n\u001d;f]\u0016\u00148/\u0006\u0002\u0002BA1\u00111IA'\u0003#j!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\b[V$\u0018M\u00197f\u0015\r\tY%W\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA(\u0003\u000b\u0012aAQ;gM\u0016\u0014\bc\u0001#\u0002T%\u0019\u0011QK\u0018\u0003!5+G/\u00193bi\u0006d\u0015n\u001d;f]\u0016\u0014\u0018AE7fi\u0006$\u0017\r^1MSN$XM\\3sg\u0002\nAcY8pe\u0012Lg.\u0019;pe2K7\u000f^3oKJ\u001cXCAA/!\u0019\t\u0019%!\u0014\u0002`A\u0019A)!\u0019\n\u0007\u0005\rtFA\nD_>\u0014H-\u001b8bi>\u0014H*[:uK:,'/A\u000bd_>\u0014H-\u001b8bi>\u0014H*[:uK:,'o\u001d\u0011\u0002-\r,(O]3oi6+G/\u00193bi\u0006\u001cE.^:uKJ,\"!a\u001b\u0011\t\u00055\u0014qN\u0007\u0002U&\u0019\u0011\u0011\u000f6\u0003\u000f\rcWo\u001d;fe\u0006Q2-\u001e:sK:$X*\u001a;bI\u0006$\u0018m\u00117vgR,'o\u0018\u0013fcR!\u0011qOA?!\rA\u0016\u0011P\u0005\u0004\u0003wJ&\u0001B+oSRD\u0011\"a \u0018\u0003\u0003\u0005\r!a\u001b\u0002\u0007a$\u0013'A\fdkJ\u0014XM\u001c;NKR\fG-\u0019;b\u00072,8\u000f^3sA!\u001a\u0001$!\"\u0011\u0007a\u000b9)C\u0002\u0002\nf\u0013\u0001B^8mCRLG.Z\u0001\u0013GV\u0014(/\u001a8u\u0007>|'\u000fZ5oCR|'/\u0006\u0002\u0002\u0010B!\u0011QNAI\u0013\r\t\u0019J\u001b\u0002\u0005\u001d>$W-\u0001\fdkJ\u0014XM\u001c;D_>\u0014H-\u001b8bi>\u0014x\fJ3r)\u0011\t9(!'\t\u0013\u0005}$$!AA\u0002\u0005=\u0015aE2veJ,g\u000e^\"p_J$\u0017N\\1u_J\u0004\u0003fA\u000e\u0002\u0006\u00061Am\\,pe.$\"!a\u001e\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^tGCAAT!\rA\u0016\u0011V\u0005\u0004\u0003WK&a\u0002\"p_2,\u0017M\\\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8\u0002\u0017\u0005$G\rT5ti\u0016tWM\u001d\u000b\u0005\u0003o\n\u0019\fC\u0004\u00026~\u0001\r!!\u0015\u0002\u00111L7\u000f^3oKJ\fa#\u00193e\u0007>|'\u000fZ5oCR|'\u000fT5ti\u0016tWM\u001d\u000b\u0005\u0003o\nY\fC\u0004\u00026\u0002\u0002\r!a\u0018\u0002+I,Wn\u001c;f\u0019&t7nQ8pe\u0012Lg.\u0019;peV\u0011\u0011\u0011\u0019\t\u00051n\u000by)A\nde\u0016\fG/\u001a(fi^|'o[\"mS\u0016tG\u000f\u0006\u0004\u0002*\u0005\u001d\u0017\u0011\u001a\u0005\u0006%\n\u0002\ra\u0015\u0005\u0006A\n\u0002\rAY\u0001\u0018_:lU\r^1eCR\f'+Z9vKN$X\u000b\u001d3bi\u0016\fA#\\1zE\u00164\u0015N\u001c3D_>\u0014H-\u001b8bi>\u0014\u0018!L7bs\n,g)\u001b8e\u0007>|'\u000fZ5oCR|'/V:j]\u001e$Um]2sS\n,7\t\\;ti\u0016\u0014H*\u001b8lg\u0006Q2/\u001a8e\r&tGmQ8pe\u0012Lg.\u0019;peJ+\u0017/^3tiR1\u0011qOAk\u00033Dq!a6'\u0001\u0004\ty)\u0001\u0003o_\u0012,\u0007bBAnM\u0001\u0007\u0011Q\\\u0001\u0004]><\bc\u0001-\u0002`&\u0019\u0011\u0011]-\u0003\t1{gnZ\u0001\u001faJ|7-Z:t\r&tGmQ8pe\u0012Lg.\u0019;peJ+7\u000f]8og\u0016$B!a\u001e\u0002h\"9\u0011\u0011^\u0014A\u0002\u0005-\u0018\u0001\u0003:fgB|gn]3\u0011\t\u00055\u00181_\u0007\u0003\u0003_T1!!==\u0003\u001d\u0019G.[3oiNLA!!>\u0002p\nq1\t\\5f]R\u0014Vm\u001d9p]N,\u0017A\t9s_\u000e,7o\u001d#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:MS:\\'+Z:q_:\u001cX\r\u0006\u0003\u0002x\u0005m\bbBAuQ\u0001\u0007\u00111^\u0001\u001fkN,7i\u001c8ue>dG.\u001a:Bg2Kgn[\"p_J$\u0017N\\1u_J\f\u0011d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006$\u0006N]3bIB\u0011AiK\n\u0004W\t\u0015\u0001c\u0001-\u0003\b%\u0019!\u0011B-\u0003\r\u0005s\u0017PU3g)\t\u0011\t!A\u000fiC:$G.\u001a$j]\u0012\u001cun\u001c:eS:\fGo\u001c:SKN\u0004xN\\:f)!\u0011\tBa\u0006\u00032\tU\u0002c\u0001#\u0003\u0014%\u0019!QC\u0018\u0003;\u0019Kg\u000eZ\"p_J$\u0017N\\1u_J\u0014Vm\u001d9p]N,'+Z:vYRDqA!\u0007.\u0001\u0004\u0011Y\"\u0001\u0005mS:\\g*Y7f!\u0011\u0011iBa\u000b\u000f\t\t}!q\u0005\t\u0004\u0005CIVB\u0001B\u0012\u0015\r\u0011)#N\u0001\u0007yI|w\u000e\u001e \n\u0007\t%\u0012,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005[\u0011yC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005SI\u0006B\u0002B\u001a[\u0001\u0007q)A\u0002m_\u001eDqAa\u000e.\u0001\u0004\u0011I$A\fgS:$7i\\8sI&t\u0017\r^8s%\u0016\u001c\bo\u001c8tKB!!1\bB!\u001b\t\u0011iDC\u0002\u0003@)\fq!\\3tg\u0006<W-\u0003\u0003\u0003D\tu\"a\u0007$j]\u0012\u001cun\u001c:eS:\fGo\u001c:SKN\u0004xN\\:f\t\u0006$\u0018\r")
public class ClusterLinkMetadataThread
extends ShutdownableThread
implements MetadataRefreshListener,
Logging {
    private final KafkaConfig brokerConfig;
    private final ClusterLinkConfig clusterLinkConfig;
    private final Option<ClusterLinkConnectionManager> connectionManager;
    private final ClusterLinkMetadata clusterLinkMetadata;
    private final Metrics metrics;
    private final ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry;
    private final ClusterLinkClientType clientType;
    private final ClusterLinkRequestQuota quota;
    private final Time time;
    private final LogContext logContext;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final ClusterLinkDynamicLogger dynamicLogger;
    private final Buffer<MetadataListener> metadataListeners;
    private final Buffer<CoordinatorListener> coordinatorListeners;
    private volatile Cluster currentMetadataCluster;
    private volatile Node currentCoordinator;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static FindCoordinatorResponseResult handleFindCoordinatorResponse(String linkName, Logging log, FindCoordinatorResponseData findCoordinatorResponse) {
        return ClusterLinkMetadataThread$.MODULE$.handleFindCoordinatorResponse(linkName, log, findCoordinatorResponse);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkMetadata clusterLinkMetadata() {
        return this.clusterLinkMetadata;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    public ClusterLinkNetworkClient clusterLinkClient() {
        return this.clusterLinkClient;
    }

    private ClusterLinkDynamicLogger dynamicLogger() {
        return this.dynamicLogger;
    }

    private Buffer<MetadataListener> metadataListeners() {
        return this.metadataListeners;
    }

    private Buffer<CoordinatorListener> coordinatorListeners() {
        return this.coordinatorListeners;
    }

    private Cluster currentMetadataCluster() {
        return this.currentMetadataCluster;
    }

    private void currentMetadataCluster_$eq(Cluster x$1) {
        this.currentMetadataCluster = x$1;
    }

    private Node currentCoordinator() {
        return this.currentCoordinator;
    }

    private void currentCoordinator_$eq(Node x$1) {
        this.currentCoordinator = x$1;
    }

    public void doWork() {
        block8: {
            Option start = Option$.MODULE$.empty();
            try {
                try {
                    this.clusterLinkClient().networkClient().poll(Long.MAX_VALUE, this.time.milliseconds());
                    start = new Some((Object)BoxesRunTime.boxToLong((long)this.time.nanoseconds()));
                    this.maybeFindCoordinator();
                    Cluster newMetadataCluster = this.clusterLinkMetadata().fetch();
                    if (newMetadataCluster != this.currentMetadataCluster()) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Process cluster link metadata ").append(newMetadataCluster).toString());
                        this.metadataListeners().foreach((Function1 & Serializable)x$4 -> {
                            x$4.onNewMetadata(newMetadataCluster);
                            return BoxedUnit.UNIT;
                        });
                        this.currentMetadataCluster_$eq(newMetadataCluster);
                        this.currentCoordinator_$eq(null);
                        this.maybeFindCoordinator();
                        this.dynamicLogger().resetErrors();
                    } else {
                        this.clusterLinkMetadata().maybeThrowFatalException();
                    }
                }
                catch (Throwable throwable) {
                    if (throwable instanceof DisconnectException && !this.clusterLinkClient().networkClient().active()) break block8;
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        this.dynamicLogger().error("Failed to refresh metadata", exception);
                        this.metadataListeners().foreach((Function1 & Serializable)x$5 -> {
                            x$5.onMetadataFailure(exception);
                            return BoxedUnit.UNIT;
                        });
                        break block8;
                    }
                    throw throwable;
                }
            }
            finally {
                start.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)s -> $this.quota.record($this.time.nanoseconds() - s, LinkRequestQuotaUsageType$Metadata$.MODULE$));
            }
        }
    }

    public boolean initiateShutdown() {
        if (super.initiateShutdown()) {
            this.clusterLinkClient().initiateClose();
            return true;
        }
        return false;
    }

    public void awaitShutdown() {
        try {
            super.awaitShutdown();
        }
        catch (InterruptedException interruptedException) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Interrupted while awaiting metadata shutdown");
            super.awaitShutdown();
        }
        try {
            this.clusterLinkClient().close();
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to close metadata client after shutting down thread", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public void addListener(MetadataListener listener) {
        this.metadataListeners().$plus$eq((Object)listener);
    }

    public void addCoordinatorListener(CoordinatorListener listener) {
        this.coordinatorListeners().$plus$eq((Object)listener);
    }

    public Option<Node> remoteLinkCoordinator() {
        return Option$.MODULE$.apply((Object)this.currentCoordinator());
    }

    public ClusterLinkNetworkClient createNetworkClient(ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata) {
        ClusterLinkNetworkClient clusterLinkClient = new ClusterLinkNetworkClient(this.brokerConfig, clusterLinkConfig, ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(clusterLinkMetadata.linkName()), (Option<ClusterLinkMetadata>)new Some((Object)clusterLinkMetadata), (Option<MetadataUpdater>)None$.MODULE$, this.metrics, this.selectorMetricsRegistry, ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()), this.time, new StringBuilder(22).append("cluster-link-metadata-").append(clusterLinkMetadata.linkDescription()).toString(), this.clientType, this.logContext(), (AtomicReference)this.connectionManager.map((Function1 & Serializable)x$6 -> x$6.maxLogLevel()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.connectionManager.foreach((Function1 & Serializable)x$7 -> {
            x$7.enableClusterLink(clusterLinkClient, (Option<AdminMetadataManager>)None$.MODULE$);
            return BoxedUnit.UNIT;
        });
        return clusterLinkClient;
    }

    @Override
    public void onMetadataRequestUpdate() {
        this.clusterLinkClient().networkClient().wakeup();
    }

    private void maybeFindCoordinator() {
        long now = this.time.milliseconds();
        if (this.currentCoordinator() == null && this.coordinatorListeners().nonEmpty()) {
            Node node = this.clusterLinkClient().networkClient().leastLoadedNode(now);
            if (node != null && this.clusterLinkClient().networkClient().ready(node, now)) {
                this.sendFindCoordinatorRequest(node, now);
                return;
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> "No connection available to least loaded node for finding coordinator.");
            return;
        }
    }

    private void maybeFindCoordinatorUsingDescribeClusterLinks() {
        Node controller;
        Node node = controller = this.currentMetadataCluster() == null ? null : this.currentMetadataCluster().controller();
        if (controller != null && controller.id() >= 0) {
            if (this.clusterLinkClient().networkClient().ready(controller, this.time.milliseconds())) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Determine link coordinator using DescribeClusterLinks controllerId=").append(controller).toString());
                DescribeClusterLinksRequest.Builder requestBuilder = new DescribeClusterLinksRequest.Builder(Optional.of(Collections.singleton(this.clusterLinkMetadata().linkName())), false, false, Predef$.MODULE$.Integer2int(this.clusterLinkConfig.requestTimeoutMs()), ApiKeys.DESCRIBE_CLUSTER_LINKS.oldestVersion(), 3);
                long now = this.time.milliseconds();
                ClientRequest request = this.clusterLinkClient().networkClient().newClientRequest(controller.idString(), (AbstractRequest.Builder)requestBuilder, now, true, Predef$.MODULE$.Integer2int(this.clusterLinkConfig.requestTimeoutMs()), response -> this.processDescribeClusterLinkResponse(response));
                this.clusterLinkClient().networkClient().send(request, now);
                return;
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Controller connection not yet ready to send DescribeClusterLinks request");
            return;
        }
    }

    private void sendFindCoordinatorRequest(Node node, long now) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Determine link coordinator using FindCoordinator to node=").append(node).toString());
        FindCoordinatorRequestData data = new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.CLUSTER_LINK.id()).setCoordinatorKeys(Collections.singletonList(this.clusterLinkMetadata().linkName()));
        FindCoordinatorRequest.Builder builder = new FindCoordinatorRequest.Builder(data);
        ClientRequest request = this.clusterLinkClient().networkClient().newClientRequest(node.idString(), (AbstractRequest.Builder)builder, now, true, Predef$.MODULE$.Integer2int(this.clusterLinkConfig.requestTimeoutMs()), response -> this.processFindCoordinatorResponse(response));
        this.clusterLinkClient().networkClient().send(request, now);
    }

    private void processFindCoordinatorResponse(ClientResponse response) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Process FindCoordinator response ").append(response).toString());
        if (response.wasDisconnected()) {
            this.clusterLinkMetadata().requestUpdate();
            return;
        }
        FindCoordinatorResponseData findCoordinatorResponse = ((FindCoordinatorResponse)response.responseBody()).data();
        FindCoordinatorResponseResult result = ClusterLinkMetadataThread$.MODULE$.handleFindCoordinatorResponse(this.clusterLinkMetadata().linkName(), this, findCoordinatorResponse);
        Option<Node> option = result.coordinator();
        if (option instanceof Some) {
            Node coordinator = (Node)((Some)option).value();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Remote link coordinator is ").append(coordinator).toString());
            this.currentCoordinator_$eq(coordinator);
            this.coordinatorListeners().foreach((Function1 & Serializable)x$8 -> {
                x$8.onNewRemoteLinkCoordinator(coordinator);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (None$.MODULE$.equals(option)) {
            if (result.retry()) {
                this.maybeFindCoordinatorUsingDescribeClusterLinks();
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    private void processDescribeClusterLinkResponse(ClientResponse response) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Process DescribeClusterLinks response ").append(response).toString());
        if (response.wasDisconnected()) {
            this.clusterLinkMetadata().requestUpdate();
            return;
        }
        if (response.versionMismatch() != null || response.requestHeader().apiVersion() < 1) {
            this.useControllerAsLinkCoordinator();
            return;
        }
        DescribeClusterLinksResponseData describeResponse = ((DescribeClusterLinksResponse)response.responseBody()).data();
        if (describeResponse.errorCode() == Errors.NONE.code() && !describeResponse.entries().isEmpty()) {
            DescribeClusterLinksResponseData.EntryData entry = (DescribeClusterLinksResponseData.EntryData)describeResponse.entries().get(0);
            if (entry.linkCoordinatorId() != -1) {
                Node coordinator = new Node(entry.linkCoordinatorId(), entry.linkCoordinatorHost(), entry.linkCoordinatorPort());
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Remote link coordinator is ").append(coordinator).toString());
                this.currentCoordinator_$eq(coordinator);
                this.coordinatorListeners().foreach((Function1 & Serializable)x$9 -> {
                    x$9.onNewRemoteLinkCoordinator(coordinator);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (entry.linkState() == ClusterLinkDescription.LinkState.ACTIVE.getValue()) {
                this.useControllerAsLinkCoordinator();
                return;
            }
            return;
        }
        this.useControllerAsLinkCoordinator();
    }

    private void useControllerAsLinkCoordinator() {
        Node controller;
        Node node = controller = this.currentMetadataCluster() == null ? null : this.currentMetadataCluster().controller();
        if (controller != null && controller.id() != -1) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Cluster link coordinator not known, using controller ").append(controller).append(" instead").toString());
            this.currentCoordinator_$eq(controller);
            this.coordinatorListeners().foreach((Function1 & Serializable)x$10 -> {
                x$10.onNewRemoteLinkCoordinator(controller);
                return BoxedUnit.UNIT;
            });
            return;
        }
        this.clusterLinkMetadata().requestUpdate();
    }

    public ClusterLinkMetadataThread(KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, Option<ClusterLinkConnectionManager> connectionManager, ClusterLinkMetadata clusterLinkMetadata, Metrics metrics, ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry, ClusterLinkClientType clientType, ClusterLinkRequestQuota quota, Time time) {
        this.brokerConfig = brokerConfig;
        this.clusterLinkConfig = clusterLinkConfig;
        this.connectionManager = connectionManager;
        this.clusterLinkMetadata = clusterLinkMetadata;
        this.metrics = metrics;
        this.selectorMetricsRegistry = selectorMetricsRegistry;
        this.clientType = clientType;
        this.quota = quota;
        this.time = time;
        super(new StringBuilder(13).append("LinkMetadata-").append(clusterLinkMetadata.linkDescription()).toString());
        this.logContext = new LogContext(new StringBuilder(29).append("[ClusterLinkMetadataClient ").append(clusterLinkMetadata.linkDescription()).append("] ").toString(), (AtomicReference)connectionManager.map((Function1 & Serializable)x$1 -> x$1.maxLogLevel()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.clusterLinkClient = this.createNetworkClient(clusterLinkConfig, clusterLinkMetadata);
        this.dynamicLogger = new ClusterLinkDynamicLogger(this, 10, 5, 10000);
        this.metadataListeners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.coordinatorListeners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        clusterLinkMetadata.setRefreshListener(this);
    }
}

