/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.AclBindingFilterTransformer;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import kafka.server.link.AclLimitExceededTaskErrorCode$;
import kafka.server.link.ActiveTaskState$;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthenticationTaskErrorCode$;
import kafka.server.link.BrokerAuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncAclsTaskType$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.InvalidRequestErrorCode$;
import kafka.server.link.MisconfigurationTaskErrorCode$;
import kafka.server.link.NotConfiguredTaskState$;
import kafka.server.link.SecurityDisabledTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TaskState;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\rec\u0001\u0002\"D\u0001)C\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001\u0016\u0005\t1\u0002\u0011\t\u0011)A\u0005+\"A\u0011\f\u0001BC\u0002\u0013\u0005!\f\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003\\\u0011!\u0011\u0007A!b\u0001\n\u0003\u0019\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011!\u0004!Q1A\u0005\u0002%D\u0001\" \u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\t}\u0002\u0011\t\u0011)A\u0005\u007f\"Q\u0011Q\u0001\u0001\u0003\u0006\u0004%\t!a\u0002\t\u0015\u0005=\u0001A!A!\u0002\u0013\tI\u0001\u0003\u0007\u0002\u0012\u0001\u0011\t\u0011)A\u0005\u0003'\t\u0019\u0003\u0003\u0007\u0002&\u0001\u0011\t\u0011)A\u0005\u0003O\ty\u0003\u0003\u0006\u00022\u0001\u0011)\u0019!C\u0001\u0003gA!\"a\u000f\u0001\u0005\u0003\u0005\u000b\u0011BA\u001b\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fA\u0011\"!\u0016\u0001\u0001\u0004%I!a\u0016\t\u0013\u0005}\u0003\u00011A\u0005\n\u0005\u0005\u0004\u0002CA7\u0001\u0001\u0006K!!\u0017\t\u0013\u0005=\u0004A1A\u0005\n\u0005E\u0004\u0002CA>\u0001\u0001\u0006I!a\u001d\t\u0013\u0005u\u0004A1A\u0005\n\u0005}\u0004\u0002CAL\u0001\u0001\u0006I!!!\t\u0013\u0005e\u0005A1A\u0005\n\u0005m\u0005\u0002CAW\u0001\u0001\u0006I!!(\t\u0013\u0005=\u0006\u00011A\u0005\n\u0005E\u0006\"CA]\u0001\u0001\u0007I\u0011BA^\u0011!\ty\f\u0001Q!\n\u0005M\u0006\"CAa\u0001\u0001\u0007I\u0011BA\u001a\u0011%\t\u0019\r\u0001a\u0001\n\u0013\t)\r\u0003\u0005\u0002J\u0002\u0001\u000b\u0015BA\u001b\u0011%\tY\r\u0001b\u0001\n\u0013\ti\rC\u0004\u0002P\u0002\u0001\u000b\u0011\u00029\t\u0013\u0005E\u0007\u00011A\u0005\n\u0005M\u0007\"CAq\u0001\u0001\u0007I\u0011BAr\u0011!\t9\u000f\u0001Q!\n\u0005U\u0007\"CAy\u0001\t\u0007I\u0011BAz\u0011!\tY\u0010\u0001Q\u0001\n\u0005U\bbBA\u007f\u0001\u0011E\u0013q \u0005\b\u0005+\u0001A\u0011\u0002B\f\u0011\u001d\u0011\u0019\u0005\u0001C\u0005\u0005\u000bBqAa\u0012\u0001\t\u0013\u0011I\u0005C\u0004\u0003P\u0001!IA!\u0015\t\u000f\t]\u0003\u0001\"\u0003\u0003Z!9!1\r\u0001\u0005\n\t\u0015\u0004b\u0002BC\u0001\u0011%!q\u0011\u0005\b\u0005?\u0003A\u0011\u0002BQ\u0011\u001d\u0011Y\u000b\u0001C\u0005\u0005[CqAa/\u0001\t\u0013\u0011i\fC\u0004\u0003F\u0002!IAa2\t\u0011\t]\u0007\u0001\"\u0001D\u00053DqA!;\u0001\t\u0013\u0011Y\u000fC\u0004\u0003t\u0002!IA!>\t\u000f\r\u001d\u0001\u0001\"\u0011\u0004\n!911\u0002\u0001\u0005\u0002\u0005E\u0006bBB\u0007\u0001\u0011\u00051q\u0002\u0005\b\u0007+\u0001A\u0011AA\u001a\u0011\u001d\u00199\u0002\u0001C)\u00073Aqa!\n\u0001\t\u0013\u00199\u0003C\u0004\u0004,\u0001!\te!\f\t\u000f\r=\u0002\u0001\"\u0001\u00042\u001dI11G\"\u0002\u0002#\u00051Q\u0007\u0004\t\u0005\u000e\u000b\t\u0011#\u0001\u00048!9\u0011QH \u0005\u0002\r}\u0002\"CB!\u007fE\u0005I\u0011AB\"\u0005M\u0019E.^:uKJd\u0015N\\6Ts:\u001c\u0017i\u00197t\u0015\t!U)\u0001\u0003mS:\\'B\u0001$H\u0003\u0019\u0019XM\u001d<fe*\t\u0001*A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Y\u0005C\u0001'Q\u001d\tie*D\u0001D\u0013\ty5)\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0005\u0003#J\u0013A\u0002U3sS>$\u0017n\u0019+bg.T!aT\"\u0002\u001b\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3s+\u0005)\u0006CA'W\u0013\t96I\u0001\u000fDYV\u001cH/\u001a:MS:\\G)Z:u\u00072LWM\u001c;NC:\fw-\u001a:\u0002\u001d\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3sA\u0005AA.\u001b8l\t\u0006$\u0018-F\u0001\\!\tav,D\u0001^\u0015\tqv)\u0001\u0002{W&\u0011\u0001-\u0018\u0002\u0010\u00072,8\u000f^3s\u0019&t7\u000eR1uC\u0006IA.\u001b8l\t\u0006$\u0018\rI\u0001\u0010[\u0016$\u0018\rZ1uC6\u000bg.Y4feV\tA\r\u0005\u0002NK&\u0011am\u0011\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u0011[\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0002\n\u0001\u0003Z3ti\u0006#W.\u001b8GC\u000e$xN]=\u0016\u0003)\u00042a\u001b8q\u001b\u0005a'\"A7\u0002\u000bM\u001c\u0017\r\\1\n\u0005=d'!\u0003$v]\u000e$\u0018n\u001c81!\t\t80D\u0001s\u0015\t\u0019H/A\u0003bI6LgN\u0003\u0002vm\u000691\r\\5f]R\u001c(B\u0001%x\u0015\tA\u00180\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002u\u0006\u0019qN]4\n\u0005q\u0014(AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u0012I\u0016\u001cH/\u00113nS:4\u0015m\u0019;pef\u0004\u0013aB7fiJL7m\u001d\t\u0004\u001b\u0006\u0005\u0011bAA\u0002\u0007\n\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003m\t7\r\u001c\"j]\u0012Lgn\u001a$jYR,'\u000f\u0016:b]N4wN]7feV\u0011\u0011\u0011\u0002\t\u0004\u001b\u0006-\u0011bAA\u0007\u0007\nY\u0012i\u00197CS:$\u0017N\\4GS2$XM\u001d+sC:\u001chm\u001c:nKJ\fA$Y2m\u0005&tG-\u001b8h\r&dG/\u001a:Ue\u0006t7OZ8s[\u0016\u0014\b%\u0001\u0003uS6,\u0007\u0003BA\u000b\u0003?i!!a\u0006\u000b\t\u0005e\u00111D\u0001\u0006kRLGn\u001d\u0006\u0004\u0003;1\u0018AB2p[6|g.\u0003\u0003\u0002\"\u0005]!\u0001\u0002+j[\u0016L1!!\u0005Q\u0003\u0015\tXo\u001c;b!\u0011\tI#a\u000b\u000e\u0003\u0015K1!!\fF\u0005]\u0019E.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018-C\u0002\u0002&A\u000b\u0001%Y2m\r&dG/\u001a:XSRD'+Z:pkJ\u001cW-\u00133Qe&t7-\u001b9bYV\u0011\u0011Q\u0007\t\u0004W\u0006]\u0012bAA\u001dY\n9!i\\8mK\u0006t\u0017!I1dY\u001aKG\u000e^3s/&$\bNU3t_V\u00148-Z%e!JLgnY5qC2\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u000b\u0002B\u0005\r\u0013QIA$\u0003\u0013\nY%!\u0014\u0002P\u0005E\u00131\u000b\t\u0003\u001b\u0002AQa\u0015\tA\u0002UCQ!\u0017\tA\u0002mCQA\u0019\tA\u0002\u0011DQ\u0001\u001b\tA\u0002)DQA \tA\u0002}Dq!!\u0002\u0011\u0001\u0004\tI\u0001C\u0004\u0002\u0012A\u0001\r!a\u0005\t\u000f\u0005\u0015\u0002\u00031\u0001\u0002(!I\u0011\u0011\u0007\t\u0011\u0002\u0003\u0007\u0011QG\u0001\u0007G>tg-[4\u0016\u0005\u0005e\u0003cA'\u0002\\%\u0019\u0011QL\"\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw-\u0001\u0006d_:4\u0017nZ0%KF$B!a\u0019\u0002jA\u00191.!\u001a\n\u0007\u0005\u001dDN\u0001\u0003V]&$\b\"CA6%\u0005\u0005\t\u0019AA-\u0003\rAH%M\u0001\bG>tg-[4!\u0003\u0019a\u0017N\\6JIV\u0011\u00111\u000f\t\u0005\u0003k\n9(\u0004\u0002\u0002\u001c%!\u0011\u0011PA\u000e\u0005\u0011)V/\u001b3\u0002\u000f1Lgn[%eA\u0005AA.\u001b8l\u001d\u0006lW-\u0006\u0002\u0002\u0002B!\u00111QAI\u001d\u0011\t))!$\u0011\u0007\u0005\u001dE.\u0004\u0002\u0002\n*\u0019\u00111R%\u0002\rq\u0012xn\u001c;?\u0013\r\ty\t\\\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0015Q\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=E.A\u0005mS:\\g*Y7fA\u0005a\u0011m\u00197MS:\\\u0017\nZ*fiV\u0011\u0011Q\u0014\t\u0007\u0003?\u000bI+a\u001d\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\u000bA!\u001e;jY*\u0011\u0011qU\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002,\u0006\u0005&aA*fi\u0006i\u0011m\u00197MS:\\\u0017\nZ*fi\u0002\n\u0001\u0003^1tWN|U\u000f^:uC:$\u0017N\\4\u0016\u0005\u0005M\u0006cA6\u00026&\u0019\u0011q\u00177\u0003\u0007%sG/\u0001\u000buCN\\7oT;ugR\fg\u000eZ5oO~#S-\u001d\u000b\u0005\u0003G\ni\fC\u0005\u0002lm\t\t\u00111\u0001\u00024\u0006\tB/Y:lg>+Ho\u001d;b]\u0012Lgn\u001a\u0011\u0002\u0017%t\u0017\u000e^5bY&TX\rZ\u0001\u0010S:LG/[1mSj,Gm\u0018\u0013fcR!\u00111MAd\u0011%\tYGHA\u0001\u0002\u0004\t)$\u0001\u0007j]&$\u0018.\u00197ju\u0016$\u0007%A\u0005eKN$\u0018\tZ7j]V\t\u0001/\u0001\u0006eKN$\u0018\tZ7j]\u0002\n\u0001\u0002^1tW\u0012+7oY\u000b\u0003\u0003+\u0004Ra[Al\u00037L1!!7m\u0005\u0019y\u0005\u000f^5p]B\u0019Q*!8\n\u0007\u0005}7IA\bUCN\\G)Z:de&\u0004H/[8o\u00031!\u0018m]6EKN\u001cw\fJ3r)\u0011\t\u0019'!:\t\u0013\u0005-4%!AA\u0002\u0005U\u0017!\u0003;bg.$Um]2!Q\r!\u00131\u001e\t\u0004W\u00065\u0018bAAxY\nAao\u001c7bi&dW-A\ffq\u000e,7o]5wK2{wmZ5oO\"\u000bg\u000e\u001a7feV\u0011\u0011Q\u001f\t\u0004\u001b\u0006]\u0018bAA}\u0007\n9R\t_2fgNLg/\u001a'pO\u001eLgn\u001a%b]\u0012dWM]\u0001\u0019Kb\u001cWm]:jm\u0016dunZ4j]\u001eD\u0015M\u001c3mKJ\u0004\u0013a\u0001:v]R\u0011!\u0011\u0001\t\u0005\u0005\u0007\u0011\tBD\u0002\u0003\u00069sAAa\u0002\u0003\u00109!!\u0011\u0002B\u0007\u001d\u0011\t9Ia\u0003\n\u0003!K!AR$\n\u0005\u0011+\u0015b\u0001B\n%\nQA+Y:l%\u0016\u001cX\u000f\u001c;\u0002\u0011MLhnY!dYN$bA!\u0001\u0003\u001a\t\r\u0002b\u0002B\u000eQ\u0001\u0007!QD\u0001\fi\u0006\u001c8nQ8oi\u0016DH\u000f\u0005\u0003\u0003\u0004\t}\u0011b\u0001B\u0011%\nYA+Y:l\u0007>tG/\u001a=u\u0011\u001d\u0011)\u0003\u000ba\u0001\u0005O\tQ\"Y2m\r&dG/\u001a:MSN$\bC\u0002B\u0015\u0005g\u00119$\u0004\u0002\u0003,)!!Q\u0006B\u0018\u0003\u001diW\u000f^1cY\u0016T1A!\rm\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005k\u0011YC\u0001\u0006MSN$()\u001e4gKJ\u0004BA!\u000f\u0003@5\u0011!1\b\u0006\u0005\u0005{\tY\"A\u0002bG2LAA!\u0011\u0003<\t\u0001\u0012i\u00197CS:$\u0017N\\4GS2$XM]\u0001\nC:Lh)\u001b7uKJ$\"Aa\u000e\u0002-%t\u0017\u000e^5bY&TX\r\u00165f]NKhnY!dYN$bA!\u0001\u0003L\t5\u0003b\u0002B\u000eU\u0001\u0007!Q\u0004\u0005\b\u0005KQ\u0003\u0019\u0001B\u0014\u0003)a\u0017N\\6GS2$XM\u001d\u000b\u0005\u0005o\u0011\u0019\u0006C\u0004\u0003V-\u0002\rAa\u000e\u0002\u0013\u0005\u001cGNR5mi\u0016\u0014\u0018a\u00027j].\f5\r\u001c\u000b\u0005\u00057\u0012\t\u0007\u0005\u0003\u0003:\tu\u0013\u0002\u0002B0\u0005w\u0011!\"Q2m\u0005&tG-\u001b8h\u0011\u001d\u0011i\u0004\fa\u0001\u00057\n\u0011dY;se\u0016tG\u000fR3ti\u0006\u001bGn],ji\"d\u0015N\\6JIR1!q\rB6\u0005{\u0002b!a!\u0003j\tm\u0013\u0002BAV\u0003+CqA!\u001c.\u0001\u0004\u0011y'\u0001\u0003bkRD\u0007\u0003\u0002B9\u0005sj!Aa\u001d\u000b\t\tU$qO\u0001\u000bCV$\bn\u001c:ju\u0016\u0014(B\u0001$w\u0013\u0011\u0011YHa\u001d\u0003\u0015\u0005+H\u000f[8sSj,'\u000fC\u0004\u0003&5\u0002\rAa \u0011\r\t%\"\u0011\u0011B\u001c\u0013\u0011\u0011\u0019Ia\u000b\u0003\r\t+hMZ3s\u0003IA\u0017M\u001c3mK\u0012+7o\u0019:jE\u0016\f5\r\\:\u0015\u0011\t\u0005!\u0011\u0012BF\u0005\u001bCqAa\u0007/\u0001\u0004\u0011i\u0002C\u0004\u0003&9\u0002\rAa\n\t\u000f\t=e\u00061\u0001\u0003\u0012\u0006Qa-\u001e;ve\u0016d\u0015n\u001d;\u0011\r\t%\"1\u0007BJ!\u0019\t)H!&\u0003\u001a&!!qSA\u000e\u0005-Y\u0015MZ6b\rV$XO]3\u0011\r\u0005}%1\u0014B.\u0013\u0011\u0011i*!)\u0003\u0015\r{G\u000e\\3di&|g.A\fva\u0012\fG/Z!dYN|e\u000eR3ti&t\u0017\r^5p]RA!\u0011\u0001BR\u0005K\u00139\u000bC\u0004\u0003\u001c=\u0002\rA!\b\t\u000f\t\u0015r\u00061\u0001\u0003(!9!\u0011V\u0018A\u0002\t\u001d\u0014AC:pkJ\u001cW-Q2mg\u0006i\u0012\r\u001a3UQ\u0016tG)\u001a7fi\u0016\f5\r\\:UQ\u0016t7+\u001f8d\u0003\u000ed7\u000f\u0006\u0006\u0003\u0002\t=&\u0011\u0017B[\u0005sCqAa\u00071\u0001\u0004\u0011i\u0002C\u0004\u00034B\u0002\rAa\u001a\u0002\u0019\u0005\u001cGn\u001d+p\u0007J,\u0017\r^3\t\u000f\t]\u0006\u00071\u0001\u0003h\u0005a\u0011m\u00197t)>$U\r\\3uK\"9!Q\u0005\u0019A\u0002\t\u001d\u0012!\u00053fY\u0016$X\r\u00165f]\u0006#G-Q2mgRA!\u0011\u0001B`\u0005\u0003\u0014\u0019\rC\u0004\u0003\u001cE\u0002\rA!\b\t\u000f\tM\u0016\u00071\u0001\u0003h!9!qW\u0019A\u0002\t\u001d\u0014A\u00033fY\u0016$X-Q2mgRA!\u0011\u0001Be\u0005\u0017\u0014i\rC\u0004\u0003\u001cI\u0002\rA!\b\t\u000f\t]&\u00071\u0001\u0003h!9!q\u001a\u001aA\u0002\tE\u0017\u0001C2bY2\u0014\u0017mY6\u0011\u000f-\u0014\u0019N!\b\u0003\u0002%\u0019!Q\u001b7\u0003\u0013\u0019+hn\u0019;j_:\f\u0014!\u00065b]\u0012dW-Q2m\t\u0016dW\r^3SKN,H\u000e\u001e\u000b\t\u0005\u0003\u0011YN!8\u0003h\"9!1D\u001aA\u0002\tu\u0001b\u0002Bpg\u0001\u0007!\u0011]\u0001\u0011I\u0016dW\r^3BG2\u001c(+Z:vYR\u00042!\u001dBr\u0013\r\u0011)O\u001d\u0002\u0011\t\u0016dW\r^3BG2\u001c(+Z:vYRDqAa44\u0001\u0004\u0011\t.\u0001\u0006de\u0016\fG/Z!dYN$\u0002B!\u0001\u0003n\n=(\u0011\u001f\u0005\b\u00057!\u0004\u0019\u0001B\u000f\u0011\u001d\u0011\u0019\f\u000ea\u0001\u0005OBqAa45\u0001\u0004\u0011\t.A\u000biC:$G.Z!dY\u000e\u0013X-\u0019;f%\u0016\u001cX\u000f\u001c;\u0015\u0011\t\u0005!q\u001fB}\u0007\u0007AqAa\u00076\u0001\u0004\u0011i\u0002C\u0004\u0003|V\u0002\rA!@\u0002!\r\u0014X-\u0019;f\u0003\u000ed7OU3tk2$\bcA9\u0003\u0000&\u00191\u0011\u0001:\u0003!\r\u0013X-\u0019;f\u0003\u000ed7OU3tk2$\bbBB\u0003k\u0001\u0007!\u0011[\u0001\tG\u0006dGNQ1dW\u0006A1\u000f[;uI><h\u000e\u0006\u0002\u0002d\u000592-\u001e:sK:$H+Y:lg>+Ho\u001d;b]\u0012LgnZ\u0001\u0012i\u0006\u001c8n](viN$\u0018M\u001c3j]\u001e|F\u0003BA2\u0007#Aqaa\u00059\u0001\u0004\t\u0019,A\u0001u\u00035I7/\u00138ji&\fG.\u001b>fI\u0006aqN\\\"p[BdW\r^5p]R!\u00111MB\u000e\u0011\u001d\u0019iB\u000fa\u0001\u0007?\taA]3tk2$\bc\u0001'\u0004\"%\u001911\u0005*\u0003'\r{W\u000e\u001d7fi\u0016$G+Y:l%\u0016\u001cX\u000f\u001c;\u0002-M,G\u000fV1tWN#\u0018\r^3Ge>l'+Z:vYR$B!!\u000e\u0004*!91QD\u001eA\u0002\r}\u0011a\u0004;bg.$Um]2sSB$\u0018n\u001c8\u0015\u0005\u0005U\u0017A\u00047pO\u001eLgn\u001a%b]\u0012dWM\u001d\u000b\u0003\u0003k\f1c\u00117vgR,'\u000fT5oWNKhnY!dYN\u0004\"!T \u0014\u0007}\u001aI\u0004E\u0002l\u0007wI1a!\u0010m\u0005\u0019\te.\u001f*fMR\u00111QG\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\r\u0015#\u0006BA\u001b\u0007\u000fZ#a!\u0013\u0011\t\r-3QK\u0007\u0003\u0007\u001bRAaa\u0014\u0004R\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007'b\u0017AC1o]>$\u0018\r^5p]&!1qKB'\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ClusterLinkSyncAcls
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkMetadataManager metadataManager;
    private final Function0<ConfluentAdmin> destAdminFactory;
    private final ClusterLinkMetrics metrics;
    private final AclBindingFilterTransformer aclBindingFilterTransformer;
    private final boolean aclFilterWithResourceIdPrincipal;
    private ClusterLinkConfig config;
    private final Uuid linkId;
    private final String linkName;
    private final Set<Uuid> aclLinkIdSet;
    private int tasksOutstanding;
    private boolean initialized;
    private final ConfluentAdmin destAdmin;
    private volatile Option<TaskDescription> taskDesc;
    private final ExcessiveLoggingHandler excessiveLoggingHandler;

    public static boolean $lessinit$greater$default$9() {
        return false;
    }

    public ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    public Function0<ConfluentAdmin> destAdminFactory() {
        return this.destAdminFactory;
    }

    public AclBindingFilterTransformer aclBindingFilterTransformer() {
        return this.aclBindingFilterTransformer;
    }

    public boolean aclFilterWithResourceIdPrincipal() {
        return this.aclFilterWithResourceIdPrincipal;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private String linkName() {
        return this.linkName;
    }

    private Set<Uuid> aclLinkIdSet() {
        return this.aclLinkIdSet;
    }

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    private ExcessiveLoggingHandler excessiveLoggingHandler() {
        return this.excessiveLoggingHandler;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        this.config_$eq(this.clientManager().currentConfig());
        if (this.metadataManager().isLinkCoordinator(this.clientManager().linkData().linkName()) && this.config().aclSyncEnable()) {
            if (this.tasksOutstanding() != 0) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Number of outstanding tasks was not 0 at the beginning of run. Resetting to 0 and continuing on.");
                this.tasksOutstanding_$eq(0);
            }
            if (this.config().aclFilters().isEmpty()) {
                String errMsg = new StringBuilder(108).append(this.linkName()).append(": ACL migration is enabled but acl.filters is not set. Please set acl.filters to ").append("proceed with ACL migration.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(MisconfigurationTaskErrorCode$.MODULE$, errMsg);
                .colon.colon completedTask_errs = new .colon.colon((Object)err, (List)Nil$.MODULE$);
                return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
            }
            ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
            AclFiltersJson aclFilterJson = (AclFiltersJson)this.config().aclFilters().get();
            ListBuffer<AclBindingFilter> aclFilterList = AclJson$.MODULE$.toAclBindingFilters(aclFilterJson);
            if (!this.initialized()) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Not initialized for ").append(this.linkId()).append(". Starting initialization process.").toString());
                return this.initializeThenSyncAcls(taskContext, aclFilterList);
            }
            return this.syncAcls(taskContext, aclFilterList);
        }
        scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult syncAcls(ClusterLinkScheduler.TaskContext taskContext, ListBuffer<AclBindingFilter> aclFilterList) {
        ListBuffer describeAclsFutureList = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        aclFilterList.foreach((Function1 & Serializable)aclFilter -> {
            this.trace((Function0<String>)(Function0 & Serializable)() -> "Attempting to retrieve ACLs from source cluster");
            return (ListBuffer)describeAclsFutureList.$plus$eq((Object)this.clientManager().getAdmin().describeAcls(aclFilter));
        });
        if (describeAclsFutureList.nonEmpty()) {
            ListBuffer futureList = (ListBuffer)describeAclsFutureList.map((Function1 & Serializable)result -> result.values());
            KafkaFuture future = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])futureList.toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
            this.scheduleWhenComplete(future, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleDescribeAcls((ClusterLinkScheduler.TaskContext)tc, aclFilterList, (ListBuffer<KafkaFuture<Collection<AclBinding>>>)futureList), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    private AclBindingFilter anyFilter() {
        if (this.aclFilterWithResourceIdPrincipal()) {
            return new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(MultiTenantPrincipal.WILDCARD_USERV2_PRINCIPAL.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        }
        return AclBindingFilter.ANY;
    }

    private ClusterLinkScheduler.TaskResult initializeThenSyncAcls(ClusterLinkScheduler.TaskContext taskContext, ListBuffer<AclBindingFilter> aclFilterList) {
        Option<Authorizer> option = this.clientManager().getAuthorizer();
        if (option instanceof Some) {
            Authorizer auth = (Authorizer)((Some)option).value();
            scala.collection.immutable.Set<AclBinding> linkAcls = this.currentDestAclsWithLinkId(auth, (Buffer<AclBindingFilter>)((Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{this.anyFilter()}))));
            scala.collection.immutable.Set<AclBinding> matchingAcls = this.currentDestAclsWithLinkId(auth, (Buffer<AclBindingFilter>)aclFilterList);
            scala.collection.immutable.Set notMatchingLinkAclsToDelete = (scala.collection.immutable.Set)linkAcls.diff(matchingAcls);
            scala.collection.immutable.Set localAclsToCreate = (scala.collection.immutable.Set)notMatchingLinkAclsToDelete.map((Function1 & Serializable)acl -> {
                AccessControlEntry ace = acl.entry();
                AccessControlEntry linkAce = new AccessControlEntry(ace.principal(), ace.host(), ace.operation(), ace.permissionType());
                return new AclBinding(acl.pattern(), linkAce);
            });
            return this.addThenDeleteAclsThenSyncAcls(taskContext, (scala.collection.immutable.Set<AclBinding>)localAclsToCreate, (scala.collection.immutable.Set<AclBinding>)notMatchingLinkAclsToDelete, aclFilterList);
        }
        if (None$.MODULE$.equals(option)) {
            String errMsg = "No authorizer is configured on the destination broker. Aborting initialization. No ACLs will be synced.";
            this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        throw new MatchError(option);
    }

    private AclBindingFilter linkFilter(AclBindingFilter aclFilter) {
        AccessControlEntryFilter ace = aclFilter.entryFilter();
        AccessControlEntryFilter linkFilter = new AccessControlEntryFilter(ace.principal(), ace.host(), ace.operation(), ace.permissionType(), this.aclLinkIdSet());
        return new AclBindingFilter(aclFilter.patternFilter(), linkFilter);
    }

    private AclBinding linkAcl(AclBinding acl) {
        Collection collection = acl.entry().clusterLinkIds();
        Set<Uuid> set = this.aclLinkIdSet();
        if (!(collection != null ? !((Object)collection).equals(set) : set != null)) {
            return acl;
        }
        return SecurityUtils.aclWithClusterLinkIds((AclBinding)acl, this.aclLinkIdSet());
    }

    private scala.collection.immutable.Set<AclBinding> currentDestAclsWithLinkId(Authorizer auth, Buffer<AclBindingFilter> aclFilterList) {
        return ((IterableOnceOps)((IterableOps)((IterableOps)aclFilterList.map((Function1 & Serializable)aclFilter -> this.linkFilter((AclBindingFilter)aclFilter))).flatMap((Function1 & Serializable)filter -> {
            AclBindingFilter transformedFilter = this.aclBindingFilterTransformer().transform((AclBindingFilter)filter);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Transformed filter from ").append(filter).append(" to ").append(transformedFilter).toString());
            return CollectionConverters$.MODULE$.IterableHasAsScala(auth.acls(transformedFilter)).asScala();
        })).map((Function1 & Serializable)acl -> this.linkAcl((AclBinding)acl))).toSet();
    }

    private ClusterLinkScheduler.TaskResult handleDescribeAcls(ClusterLinkScheduler.TaskContext taskContext, ListBuffer<AclBindingFilter> aclFilterList, ListBuffer<KafkaFuture<Collection<AclBinding>>> futureList) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        scala.collection.immutable.Seq bindingsAndErrors = ((IterableOnceOps)futureList.map((Function1 & Serializable)future -> {
            try {
                return new Tuple2((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)future.get()).asScala().map((Function1 & Serializable)acl -> this.linkAcl((AclBinding)acl))).toSeq(), (Object)None$.MODULE$);
            }
            catch (ExecutionException e) {
                KafkaException kafkaException;
                String errMsgPrefix = "Unable to retrieve ACLs on source cluster";
                $this.metrics.describeAclsFromSourceFailedSensor().record();
                Throwable throwable = e.getCause();
                if (throwable instanceof SecurityDisabledException) {
                    String errMsg = new StringBuilder(118).append(errMsgPrefix).append(" because no authorizer is configured on the source cluster. Please configure ").append("authorizer to proceed with ACL migration.").toString();
                    this.excessiveLoggingHandler().handle(e, this, errMsg);
                    return new Tuple2(null, (Object)new Some((Object)new TaskErrorCodeAndMsg(SecurityDisabledTaskErrorCode$.MODULE$, errMsg)));
                }
                if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                    String errMsg = new StringBuilder(30).append(errMsgPrefix).append(" due to authentication issues.").toString();
                    this.excessiveLoggingHandler().handle(e, this, errMsg);
                    return new Tuple2(null, (Object)new Some((Object)new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg)));
                }
                if (throwable instanceof AuthorizationException) {
                    String errMsg = new StringBuilder(110).append(errMsgPrefix).append(" due to authorization failure. ").append("Please enable DESCRIBE ACLs on the source cluster to proceed with ACL migration").toString();
                    this.excessiveLoggingHandler().handle(e, this, errMsg);
                    return new Tuple2(null, (Object)new Some((Object)new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg)));
                }
                String errMsg = new StringBuilder(23).append(errMsgPrefix).append(" for an unknown reason.").toString();
                this.excessiveLoggingHandler().handle(e, this, errMsg);
                return new Tuple2(null, (Object)new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)));
            }
            catch (Throwable e) {
                String errMsgPrefix = "Unable to retrieve ACLs on source cluster";
                $this.metrics.describeAclsFromSourceFailedSensor().record();
                String errMsg = new StringBuilder(23).append(errMsgPrefix).append(" for an unknown reason.").toString();
                this.excessiveLoggingHandler().handle(e, this, errMsg);
                return new Tuple2(null, (Object)new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)));
            }
        })).toSeq();
        scala.collection.immutable.Seq errs = (scala.collection.immutable.Seq)bindingsAndErrors.flatMap((Function1 & Serializable)x$1 -> (Option)x$1._2());
        if (errs.nonEmpty()) {
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)errs);
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        scala.collection.immutable.Set sourceAcls = ((IterableOnceOps)bindingsAndErrors.flatMap((Function1 & Serializable)x$2 -> (scala.collection.immutable.Seq)x$2._1())).toSet();
        return this.updateAclsOnDestination(taskContext, aclFilterList, (scala.collection.immutable.Set<AclBinding>)sourceAcls);
    }

    private ClusterLinkScheduler.TaskResult updateAclsOnDestination(ClusterLinkScheduler.TaskContext taskContext, ListBuffer<AclBindingFilter> aclFilterList, scala.collection.immutable.Set<AclBinding> sourceAcls) {
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Result of describeAcls on source cluster for ").append(this.linkId()).append(": ").append(sourceAcls).toString());
        Option<Authorizer> option = this.clientManager().getAuthorizer();
        if (option instanceof Some) {
            Authorizer auth = (Authorizer)((Some)option).value();
            scala.collection.immutable.Set<AclBinding> currentDestAcls = this.currentDestAclsWithLinkId(auth, (Buffer<AclBindingFilter>)aclFilterList);
            scala.collection.immutable.Set aclsToDelete = (scala.collection.immutable.Set)currentDestAcls.diff(sourceAcls);
            scala.collection.immutable.Set aclsToAdd = (scala.collection.immutable.Set)sourceAcls.diff(currentDestAcls);
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Removing following ACLs on destination cluster: ").append(aclsToDelete).toString());
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Adding following ACLs on destination cluster: ").append(aclsToAdd).toString());
            return this.deleteThenAddAcls(taskContext, (scala.collection.immutable.Set<AclBinding>)aclsToAdd, (scala.collection.immutable.Set<AclBinding>)aclsToDelete);
        }
        if (None$.MODULE$.equals(option)) {
            String errMsg = "No authorizer is configured on the destination broker. No ACLs will be synced.";
            this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        throw new MatchError(option);
    }

    private ClusterLinkScheduler.TaskResult addThenDeleteAclsThenSyncAcls(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<AclBinding> aclsToCreate, scala.collection.immutable.Set<AclBinding> aclsToDelete, ListBuffer<AclBindingFilter> aclFilterList) {
        Function1 & Serializable createAcls_callback = (Function1 & Serializable)taskContextForCreateCallback -> {
            Function1 & Serializable deleteAcls_callback = (Function1 & Serializable)taskContextForDeleteCallback -> {
                this.initialized_$eq(true);
                return this.syncAcls((ClusterLinkScheduler.TaskContext)taskContextForDeleteCallback, aclFilterList);
            };
            if (aclsToDelete.nonEmpty()) {
                try {
                    List deleteAcls_deleteAclsFilterList = ((IterableOnceOps)aclsToDelete.map((Function1 & Serializable)acl -> acl.toFilter())).toList();
                    DeleteAclsResult deleteAcls_deleteAclsResult = this.destAdmin().deleteAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)deleteAcls_deleteAclsFilterList).asJava());
                    Iterable deleteAcls_deleteAclsResultFutures = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(deleteAcls_deleteAclsResult.values()).asScala().map((Function1 & Serializable)x$3 -> (KafkaFuture)x$3._2());
                    this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])deleteAcls_deleteAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleAclDeleteResult((ClusterLinkScheduler.TaskContext)tc, deleteAcls_deleteAclsResult, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)deleteAcls_callback), (ClusterLinkScheduler.TaskContext)taskContextForCreateCallback));
                    this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                    scala.collection.immutable.Seq<TaskErrorCodeAndMsg> deleteAcls_inProgressTask_errs = taskContextForCreateCallback.errs();
                    return new ClusterLinkScheduler.TaskResult(false, deleteAcls_inProgressTask_errs);
                }
                catch (Throwable deleteAcls_e) {
                    String deleteAcls_errMsg = "Unexpected error encountered while trying to delete ACLs on destination cluster";
                    this.warn((Function0<String>)(Function0 & Serializable)() -> deleteAcls_errMsg, (Function0<Throwable>)(Function0 & Serializable)() -> deleteAcls_e);
                    $this.metrics.aclsDeletedSensor().record((double)aclsToDelete.size());
                    scala.collection.immutable.Seq deleteAcls_completedTask_errs = (scala.collection.immutable.Seq)taskContextForCreateCallback.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, deleteAcls_errMsg), (List)Nil$.MODULE$));
                    return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)deleteAcls_completedTask_errs);
                }
            }
            return ClusterLinkSyncAcls.$anonfun$addThenDeleteAclsThenSyncAcls$2(this, aclFilterList, taskContextForCreateCallback);
        };
        if (aclsToCreate.nonEmpty()) {
            try {
                List createAcls_aclsToCreateList = aclsToCreate.toList();
                CreateAclsResult createAcls_createAclResult = this.destAdmin().createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)createAcls_aclsToCreateList).asJava());
                Map createAcls_values = createAcls_createAclResult.values();
                Iterable createAcls_createAclsResultFutures = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(createAcls_values).asScala().map((Function1 & Serializable)x$4 -> (KafkaFuture)x$4._2());
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])createAcls_createAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleAclCreateResult((ClusterLinkScheduler.TaskContext)tc, createAcls_createAclResult, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)createAcls_callback), taskContext));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                scala.collection.immutable.Seq<TaskErrorCodeAndMsg> createAcls_inProgressTask_errs = taskContext.errs();
                return new ClusterLinkScheduler.TaskResult(false, createAcls_inProgressTask_errs);
            }
            catch (Throwable createAcls_e) {
                String createAcls_errMsg = "Unexpected error encountered while trying to create ACLs on destination cluster";
                this.warn((Function0<String>)(Function0 & Serializable)() -> createAcls_errMsg, (Function0<Throwable>)(Function0 & Serializable)() -> createAcls_e);
                this.metrics.aclsAddFailedSensor().record((double)aclsToCreate.size());
                scala.collection.immutable.Seq createAcls_completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, createAcls_errMsg), (List)Nil$.MODULE$));
                return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)createAcls_completedTask_errs);
            }
        }
        return ClusterLinkSyncAcls.$anonfun$addThenDeleteAclsThenSyncAcls$1(this, aclsToDelete, aclFilterList, taskContext);
    }

    private ClusterLinkScheduler.TaskResult deleteThenAddAcls(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<AclBinding> aclsToCreate, scala.collection.immutable.Set<AclBinding> aclsToDelete) {
        Function1 & Serializable deleteAcls_callback = (Function1 & Serializable)taskContextForDeleteCallback -> {
            Function1 & Serializable createAcls_callback = (Function1 & Serializable)taskContextForCreateCallback -> {
                scala.collection.immutable.Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContextForCreateCallback.errs();
                return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
            };
            if (aclsToCreate.nonEmpty()) {
                try {
                    List createAcls_aclsToCreateList = aclsToCreate.toList();
                    CreateAclsResult createAcls_createAclResult = this.destAdmin().createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)createAcls_aclsToCreateList).asJava());
                    Map createAcls_values = createAcls_createAclResult.values();
                    Iterable createAcls_createAclsResultFutures = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(createAcls_values).asScala().map((Function1 & Serializable)x$4 -> (KafkaFuture)x$4._2());
                    this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])createAcls_createAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleAclCreateResult((ClusterLinkScheduler.TaskContext)tc, createAcls_createAclResult, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)createAcls_callback), (ClusterLinkScheduler.TaskContext)taskContextForDeleteCallback));
                    this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                    scala.collection.immutable.Seq<TaskErrorCodeAndMsg> createAcls_inProgressTask_errs = taskContextForDeleteCallback.errs();
                    return new ClusterLinkScheduler.TaskResult(false, createAcls_inProgressTask_errs);
                }
                catch (Throwable createAcls_e) {
                    String createAcls_errMsg = "Unexpected error encountered while trying to create ACLs on destination cluster";
                    this.warn((Function0<String>)(Function0 & Serializable)() -> createAcls_errMsg, (Function0<Throwable>)(Function0 & Serializable)() -> createAcls_e);
                    $this.metrics.aclsAddFailedSensor().record((double)aclsToCreate.size());
                    scala.collection.immutable.Seq createAcls_completedTask_errs = (scala.collection.immutable.Seq)taskContextForDeleteCallback.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, createAcls_errMsg), (List)Nil$.MODULE$));
                    return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)createAcls_completedTask_errs);
                }
            }
            return ClusterLinkSyncAcls.$anonfun$deleteThenAddAcls$2(taskContextForDeleteCallback);
        };
        if (aclsToDelete.nonEmpty()) {
            try {
                List deleteAcls_deleteAclsFilterList = ((IterableOnceOps)aclsToDelete.map((Function1 & Serializable)acl -> acl.toFilter())).toList();
                DeleteAclsResult deleteAcls_deleteAclsResult = this.destAdmin().deleteAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)deleteAcls_deleteAclsFilterList).asJava());
                Iterable deleteAcls_deleteAclsResultFutures = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(deleteAcls_deleteAclsResult.values()).asScala().map((Function1 & Serializable)x$3 -> (KafkaFuture)x$3._2());
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])deleteAcls_deleteAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleAclDeleteResult((ClusterLinkScheduler.TaskContext)tc, deleteAcls_deleteAclsResult, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)deleteAcls_callback), taskContext));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                scala.collection.immutable.Seq<TaskErrorCodeAndMsg> deleteAcls_inProgressTask_errs = taskContext.errs();
                return new ClusterLinkScheduler.TaskResult(false, deleteAcls_inProgressTask_errs);
            }
            catch (Throwable deleteAcls_e) {
                String deleteAcls_errMsg = "Unexpected error encountered while trying to delete ACLs on destination cluster";
                this.warn((Function0<String>)(Function0 & Serializable)() -> deleteAcls_errMsg, (Function0<Throwable>)(Function0 & Serializable)() -> deleteAcls_e);
                this.metrics.aclsDeletedSensor().record((double)aclsToDelete.size());
                scala.collection.immutable.Seq deleteAcls_completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, deleteAcls_errMsg), (List)Nil$.MODULE$));
                return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)deleteAcls_completedTask_errs);
            }
        }
        return ClusterLinkSyncAcls.$anonfun$deleteThenAddAcls$1(this, aclsToCreate, taskContext);
    }

    private ClusterLinkScheduler.TaskResult deleteAcls(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<AclBinding> aclsToDelete, Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> callback) {
        if (aclsToDelete.nonEmpty()) {
            try {
                List deleteAclsFilterList = ((IterableOnceOps)aclsToDelete.map((Function1 & Serializable)acl -> acl.toFilter())).toList();
                DeleteAclsResult deleteAclsResult = this.destAdmin().deleteAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)deleteAclsFilterList).asJava());
                Iterable deleteAclsResultFutures = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(deleteAclsResult.values()).asScala().map((Function1 & Serializable)x$3 -> (KafkaFuture)x$3._2());
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])deleteAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleAclDeleteResult((ClusterLinkScheduler.TaskContext)tc, deleteAcls_deleteAclsResult, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)deleteAcls_callback), taskContext));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
                return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
            }
            catch (Throwable e) {
                String errMsg = "Unexpected error encountered while trying to delete ACLs on destination cluster";
                this.warn((Function0<String>)(Function0 & Serializable)() -> deleteAcls_errMsg, (Function0<Throwable>)(Function0 & Serializable)() -> deleteAcls_e);
                this.metrics.aclsDeletedSensor().record((double)aclsToDelete.size());
                scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
                return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
            }
        }
        return (ClusterLinkScheduler.TaskResult)callback.apply((Object)taskContext);
    }

    public ClusterLinkScheduler.TaskResult handleAclDeleteResult(ClusterLinkScheduler.TaskContext taskContext, DeleteAclsResult deleteAclsResult, Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> callback) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        scala.collection.immutable.Seq errs = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(deleteAclsResult.values()).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                AclBindingFilter binding = (AclBindingFilter)x0$1._1();
                try {
                    java.util.List filters = ((DeleteAclsResult.FilterResults)((KafkaFuture)x0$1._2()).get()).values();
                    return (Seq)CollectionConverters$.MODULE$.ListHasAsScala(filters).asScala().flatMap((Function1 & Serializable)aclBindingDeleteResult -> {
                        ApiException ex = aclBindingDeleteResult.exception();
                        if (ex != null) {
                            KafkaException kafkaException;
                            this.excessiveLoggingHandler().handle(ex, this, new StringBuilder(64).append("Encountered the following exception while trying to delete ACL: ").append((Object)aclBindingDeleteResult.exception()).toString());
                            $this.metrics.aclsDeleteFailedSensor().record();
                            String errMsgPrefix = new StringBuilder(29).append("Failed to delete ACL binding ").append(binding).toString();
                            Throwable throwable = ex.getCause();
                            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                                return new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, new StringBuilder(30).append(errMsgPrefix).append(" due to authentication issues.").toString()));
                            }
                            if (throwable instanceof AuthorizationException) {
                                return new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, new StringBuilder(29).append(errMsgPrefix).append(" due to authorization issues.").toString()));
                            }
                            return new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, new StringBuilder(23).append(errMsgPrefix).append(" for an unknown reason.").toString()));
                        }
                        $this.metrics.aclsDeletedSensor().record();
                        return None$.MODULE$;
                    });
                }
                catch (ExecutionException ex) {
                    KafkaException kafkaException;
                    this.excessiveLoggingHandler().handle(ex, this, "Unexpected error encountered while trying to delete ACL");
                    $this.metrics.aclsDeleteFailedSensor().record();
                    String errMsgPrefix = new StringBuilder(29).append("Failed to delete ACL binding ").append(binding).toString();
                    Throwable throwable = ex.getCause();
                    if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                        return new .colon.colon((Object)new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, new StringBuilder(30).append(errMsgPrefix).append(" due to authentication issues.").toString()), (List)Nil$.MODULE$);
                    }
                    if (throwable instanceof AuthorizationException) {
                        return new .colon.colon((Object)new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, new StringBuilder(29).append(errMsgPrefix).append(" due to authorization issues.").toString()), (List)Nil$.MODULE$);
                    }
                    return new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, new StringBuilder(23).append(errMsgPrefix).append(" for an unknown reason.").toString()), (List)Nil$.MODULE$);
                }
            }
            throw new MatchError(null);
        })).toSeq();
        if (errs.nonEmpty()) {
            if (this.tasksOutstanding() != 0) {
                throw new IllegalStateException(new StringBuilder(42).append("Failed to delete ACLs but there are still ").append(this.tasksOutstanding()).toString());
            }
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)errs);
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        return (ClusterLinkScheduler.TaskResult)callback.apply((Object)taskContext);
    }

    private ClusterLinkScheduler.TaskResult createAcls(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<AclBinding> aclsToCreate, Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> callback) {
        if (aclsToCreate.nonEmpty()) {
            try {
                List aclsToCreateList = aclsToCreate.toList();
                CreateAclsResult createAclResult = this.destAdmin().createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)aclsToCreateList).asJava());
                Map values = createAclResult.values();
                Iterable createAclsResultFutures = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(values).asScala().map((Function1 & Serializable)x$4 -> (KafkaFuture)x$4._2());
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])createAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleAclCreateResult((ClusterLinkScheduler.TaskContext)tc, createAcls_createAclResult, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)createAcls_callback), taskContext));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
                return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
            }
            catch (Throwable e) {
                String errMsg = "Unexpected error encountered while trying to create ACLs on destination cluster";
                this.warn((Function0<String>)(Function0 & Serializable)() -> createAcls_errMsg, (Function0<Throwable>)(Function0 & Serializable)() -> createAcls_e);
                this.metrics.aclsAddFailedSensor().record((double)aclsToCreate.size());
                scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
                return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
            }
        }
        return (ClusterLinkScheduler.TaskResult)callback.apply((Object)taskContext);
    }

    private ClusterLinkScheduler.TaskResult handleAclCreateResult(ClusterLinkScheduler.TaskContext taskContext, CreateAclsResult createAclsResult, Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> callBack) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        scala.collection.immutable.Seq errs = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(createAclsResult.values()).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                AclBinding binding = (AclBinding)x0$1._1();
                try {
                    ((KafkaFuture)x0$1._2()).get();
                    $this.metrics.aclsAddedSensor().record();
                    return None$.MODULE$;
                }
                catch (ExecutionException ex) {
                    KafkaException kafkaException;
                    $this.metrics.aclsAddFailedSensor().record();
                    this.excessiveLoggingHandler().handle(ex, this, "Unexpected error encountered while trying to create ACL");
                    String errMsgPrefix = new StringBuilder(29).append("Failed to create ACL binding ").append(binding).toString();
                    boolean bl = false;
                    InvalidRequestException invalidRequestException = null;
                    Throwable throwable = ex.getCause();
                    if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                        return new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, new StringBuilder(30).append(errMsgPrefix).append(" due to authentication issues.").toString()));
                    }
                    if (throwable instanceof AuthorizationException) {
                        return new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, new StringBuilder(29).append(errMsgPrefix).append(" due to authorization issues.").toString()));
                    }
                    if (throwable instanceof InvalidRequestException) {
                        bl = true;
                        invalidRequestException = (InvalidRequestException)throwable;
                        if (invalidRequestException.getMessage() != null && invalidRequestException.getMessage().contains("ACLs not created since it will exceed the limit")) {
                            return new Some((Object)new TaskErrorCodeAndMsg(AclLimitExceededTaskErrorCode$.MODULE$, new StringBuilder(58).append(errMsgPrefix).append(" due to reaching the ACL limit on the destination cluster.").toString()));
                        }
                    }
                    if (bl && invalidRequestException.getMessage() != null && invalidRequestException.getMessage().contains("Could not create ACLs because following resource names are invalid")) {
                        return new Some((Object)new TaskErrorCodeAndMsg(InvalidRequestErrorCode$.MODULE$, new StringBuilder(47).append(errMsgPrefix).append(" due to the ACL resource name(s) being invalid.").toString()));
                    }
                    return new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, new StringBuilder(23).append(errMsgPrefix).append(" for an unknown reason.").toString()));
                }
            }
            throw new MatchError(null);
        })).toSeq();
        if (errs.nonEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Failed to create ").append(errs.size()).append(" ACLs.").toString());
            if (this.tasksOutstanding() != 0) {
                throw new IllegalStateException(new StringBuilder(42).append("Failed to create ACLs but there are still ").append(this.tasksOutstanding()).toString());
            }
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)errs);
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        return (ClusterLinkScheduler.TaskResult)callBack.apply((Object)taskContext);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Task ").append(this.getClass().getName()).append(" shutting down").toString());
    }

    public int currentTasksOutstanding() {
        return this.tasksOutstanding();
    }

    public void tasksOutstanding_(int t) {
        this.tasksOutstanding_$eq(t);
    }

    public boolean isInitialized() {
        return this.initialized();
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        if (this.setTaskStateFromResult(result)) {
            this.excessiveLoggingHandler().clear();
            return;
        }
    }

    private boolean setTaskStateFromResult(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        if (this.metadataManager().isLinkCoordinator(this.linkData().linkName())) {
            if (this.config().aclSyncEnable()) {
                this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkSyncAclsTaskType$.MODULE$, "run the sync acls task"));
                Option<TaskDescription> option = this.taskDesc();
                if (option instanceof Some) {
                    TaskState taskState = ((TaskDescription)((Some)option).value()).state();
                    ActiveTaskState$ activeTaskState$ = ActiveTaskState$.MODULE$;
                    return taskState != null && taskState.equals(activeTaskState$);
                }
                return false;
            }
            this.taskDesc_$eq((Option<TaskDescription>)new Some((Object)new TaskDescription(NotConfiguredTaskState$.MODULE$, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))));
            return true;
        }
        this.taskDesc_$eq((Option<TaskDescription>)None$.MODULE$);
        return true;
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    public ExcessiveLoggingHandler loggingHandler() {
        return this.excessiveLoggingHandler();
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkSyncAcls(ClusterLinkDestClientManager clientManager, ClusterLinkData linkData, ClusterLinkMetadataManager metadataManager, Function0<ConfluentAdmin> destAdminFactory, ClusterLinkMetrics metrics, AclBindingFilterTransformer aclBindingFilterTransformer, Time time, ClusterLinkRequestQuota quota, boolean aclFilterWithResourceIdPrincipal) {
        void apply_now;
        void apply_ttlMs;
        this.clientManager = clientManager;
        this.linkData = linkData;
        this.metadataManager = metadataManager;
        this.destAdminFactory = destAdminFactory;
        this.metrics = metrics;
        this.aclBindingFilterTransformer = aclBindingFilterTransformer;
        this.aclFilterWithResourceIdPrincipal = aclFilterWithResourceIdPrincipal;
        super(clientManager.scheduler(), "ClusterLinkSyncAcls", Predef$.MODULE$.Integer2int(clientManager.currentConfig().aclSyncMs()), time, quota);
        this.logIdent_$eq(new StringBuilder(23).append("[ClusterLinkSyncAcls-").append(linkData.linkName()).append("] ").toString());
        this.config = clientManager.currentConfig();
        this.linkId = linkData.linkId();
        this.linkName = linkData.linkName();
        this.aclLinkIdSet = Collections.singleton(this.linkId());
        this.tasksOutstanding = 0;
        this.initialized = false;
        this.destAdmin = (ConfluentAdmin)destAdminFactory.apply();
        this.taskDesc = None$.MODULE$;
        ExcessiveLoggingHandler$ apply$default$3_this = ExcessiveLoggingHandler$.MODULE$;
        Object var14_10 = null;
        Function0<Object> function0 = apply$default$3_this.nowDefault();
        long l = ExcessiveLoggingHandler$.MODULE$.ttlMsDefault();
        int apply_capacity = 1000;
        this.excessiveLoggingHandler = new ExcessiveLoggingHandler(apply_capacity, (long)apply_ttlMs, (Function0<Object>)apply_now);
    }
}

