/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthenticationTaskErrorCode$;
import kafka.server.link.BrokerAuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncOffsets$;
import kafka.server.link.ClusterLinkSyncOffsetsTaskType$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.CommittedOffsetTopicPartition;
import kafka.server.link.ConsumerGroupInUseTaskErrorCode$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.FilterType$;
import kafka.server.link.GroupClusterLinkFilter;
import kafka.server.link.GroupFilterJson;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.LocalMirrorTopic;
import kafka.server.link.MatchedGroup;
import kafka.server.link.MisconfigurationTaskErrorCode$;
import kafka.server.link.NotConfiguredTaskState$;
import kafka.server.link.RegularTopic;
import kafka.server.link.RemoteLinkMetadata;
import kafka.server.link.RemoteLinkNotFoundTaskErrorCode$;
import kafka.server.link.RemoteMirrorTopic;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicType$;
import kafka.server.link.UnknownTopicOrPartitionErrorCode$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeMirrorsOptions;
import org.apache.kafka.clients.admin.DescribeMirrorsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r5u!\u0002\u001f>\u0011\u0003!e!\u0002$>\u0011\u00039\u0005\"\u0002(\u0002\t\u0003y\u0005b\u0002)\u0002\u0005\u0004%\t!\u0015\u0005\u0007+\u0006\u0001\u000b\u0011\u0002*\t\u000fY\u000b!\u0019!C\u0001/\"1Q-\u0001Q\u0001\naCqAZ\u0001C\u0002\u0013\u0005q\r\u0003\u0004l\u0003\u0001\u0006I\u0001[\u0003\u0005Y\u0006\u0001QNB\u0003G{\u0001\t\u0019\u0003\u0003\u0006\u00024)\u0011)\u0019!C\u0001\u0003kA!\"!\u0010\u000b\u0005\u0003\u0005\u000b\u0011BA\u001c\u0011)\tyD\u0003BC\u0002\u0013\u0005\u0011\u0011\t\u0005\u000b\u0003\u0013R!\u0011!Q\u0001\n\u0005\r\u0003BCA&\u0015\t\u0005\t\u0015!\u0003\u0002N!Q\u0011\u0011\f\u0006\u0003\u0006\u0004%\t!a\u0017\t\u0015\u0005%$B!A!\u0002\u0013\ti\u0006\u0003\u0006\u0002l)\u0011\t\u0011)A\u0005\u0003[BA\"a\u001d\u000b\u0005\u0003\u0005\u000b\u0011BA;\u0003\u0003CA\"a!\u000b\u0005\u0003\u0005\u000b\u0011BAC\u0003\u001bCaA\u0014\u0006\u0005\u0002\u0005=\u0005\"CAQ\u0015\u0001\u0007I\u0011BAR\u0011%\tYK\u0003a\u0001\n\u0013\ti\u000b\u0003\u0005\u0002:*\u0001\u000b\u0015BAS\u0011!\tYL\u0003a\u0001\n\u0013\t\u0006\"CA_\u0015\u0001\u0007I\u0011BA`\u0011\u001d\t\u0019M\u0003Q!\nIC\u0011\"!2\u000b\u0001\u0004%I!a2\t\u0013\u0005U'\u00021A\u0005\n\u0005]\u0007\u0002CAn\u0015\u0001\u0006K!!3\t\u0013\u0005u'\u00021A\u0005\n\u0005}\u0007\"CAu\u0015\u0001\u0007I\u0011BAv\u0011!\tyO\u0003Q!\n\u0005\u0005\b\"CA}\u0015\t\u0007I\u0011BA~\u0011!\u0011\u0019A\u0003Q\u0001\n\u0005u\bb\u0002B\u0003\u0015\u0011E#q\u0001\u0005\b\u0005;QA\u0011\u0002B\u0010\u0011\u001d\u0011YC\u0003C\u0005\u0005[AqA!\r\u000b\t\u0013\u0011\u0019\u0004C\u0004\u0003P)!IA!\u0015\t\u000f\t}#\u0002\"\u0003\u0003b!9!q\u000e\u0006\u0005\n\tE\u0004b\u0002B@\u0015\u0011%!\u0011\u0011\u0005\b\u0005\u0013SA\u0011\u0002BF\u0011\u001d\u0011yI\u0003C\u0005\u0005#CqA!)\u000b\t\u0013\u0011\u0019\u000bC\u0004\u00030*!IA!-\t\u000f\t}'\u0002\"\u0003\u0003b\"9!Q \u0006\u0005\n\t}\bbBB\t\u0015\u0011%11\u0003\u0005\b\u0007;QA\u0011BB\u0010\u0011\u001d\u0019\tD\u0003C\u0005\u0007gAqaa\u0012\u000b\t\u0013\u0019I\u0005C\u0004\u0004d)!Ia!\u001a\t\u000f\r\u001d$\u0002\"\u0003\u0004f!9!q\u0012\u0006\u0005\u0012\r%\u0004bBB=\u0015\u0011%11\u0010\u0005\b\u0007{RA\u0011KB@\u0011\u001d\u0019II\u0003C!\u0007\u0017\u000bac\u00117vgR,'\u000fT5oWNKhnY(gMN,Go\u001d\u0006\u0003}}\nA\u0001\\5oW*\u0011\u0001)Q\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\t\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002F\u00035\tQH\u0001\fDYV\u001cH/\u001a:MS:\\7+\u001f8d\u001f\u001a47/\u001a;t'\t\t\u0001\n\u0005\u0002J\u00196\t!JC\u0001L\u0003\u0015\u00198-\u00197b\u0013\ti%J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u000b\u0001\u0005T5ti\u000e{gn];nKJ<%o\\;q\u001f\u001a47/\u001a;CCR\u001c\u0007nU5{KV\t!\u000b\u0005\u0002J'&\u0011AK\u0013\u0002\u0004\u0013:$\u0018!\t'jgR\u001cuN\\:v[\u0016\u0014xI]8va>3gm]3u\u0005\u0006$8\r[*ju\u0016\u0004\u0013a\u0007'jgR|eMZ:fiN4uN]!mYB\u000b'\u000f^5uS>t7/F\u0001Y!\tI6-D\u0001[\u0015\tYF,A\u0003bI6LgN\u0003\u0002^=\u000691\r\\5f]R\u001c(B\u0001\"`\u0015\t\u0001\u0017-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0006\u0019qN]4\n\u0005\u0011T&\u0001\b'jgR\u001cuN\\:v[\u0016\u0014xI]8va>3gm]3ugN\u0003XmY\u0001\u001d\u0019&\u001cHo\u00144gg\u0016$8OR8s\u00032d\u0007+\u0019:uSRLwN\\:!\u0003Ia\u0015n\u001d;PM\u001a\u001cX\r^:PaRLwN\\:\u0016\u0003!\u0004\"!W5\n\u0005)T&a\b'jgR\u001cuN\\:v[\u0016\u0014xI]8va>3gm]3ug>\u0003H/[8og\u0006\u0019B*[:u\u001f\u001a47/\u001a;t\u001fB$\u0018n\u001c8tA\tiqJ\u001a4tKR4U\u000f^;sKN\u0004BA\\;yw:\u0011qn\u001d\t\u0003a*k\u0011!\u001d\u0006\u0003e\u000e\u000ba\u0001\u0010:p_Rt\u0014B\u0001;K\u0003\u0019\u0001&/\u001a3fM&\u0011ao\u001e\u0002\u0004\u001b\u0006\u0004(B\u0001;K!\t)\u00150\u0003\u0002{{\taQ*\u0019;dQ\u0016$wI]8vaB!Ap`A\u0002\u001b\u0005i(B\u0001@_\u0003\u0019\u0019w.\\7p]&\u0019\u0011\u0011A?\u0003\u0017-\u000bgm[1GkR,(/\u001a\t\t\u0003\u000b\ty!!\u0005\u0002\u00185\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0003vi&d'BAA\u0007\u0003\u0011Q\u0017M^1\n\u0007Y\f9\u0001E\u0002}\u0003'I1!!\u0006~\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;a\u0016\u0001C2p]N,X.\u001a:\n\t\u0005\u0005\u00121\u0004\u0002\u0012\u001f\u001a47/\u001a;B]\u0012lU\r^1eCR\f7c\u0001\u0006\u0002&A!\u0011qEA\u0017\u001d\r)\u0015\u0011F\u0005\u0004\u0003Wi\u0014\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0003\u0003\u00020\u0005E\"\u0001\u0004)fe&|G-[2UCN\\'bAA\u0016{\u0005i1\r\\5f]Rl\u0015M\\1hKJ,\"!a\u000e\u0011\u0007\u0015\u000bI$C\u0002\u0002<u\u0012Ad\u00117vgR,'\u000fT5oW\u0012+7\u000f^\"mS\u0016tG/T1oC\u001e,'/\u0001\bdY&,g\u000e^'b]\u0006<WM\u001d\u0011\u0002\u001f5,G/\u00193bi\u0006l\u0015M\\1hKJ,\"!a\u0011\u0011\u0007\u0015\u000b)%C\u0002\u0002Hu\u0012!d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ\f\u0001#\\3uC\u0012\fG/Y'b]\u0006<WM\u001d\u0011\u0002\u00111Lgn\u001b#bi\u0006\u0004B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'\n\u0015A\u0001>l\u0013\u0011\t9&!\u0015\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006\f\u0001\u0003Z3ti\u0006#W.\u001b8GC\u000e$xN]=\u0016\u0005\u0005u\u0003#B%\u0002`\u0005\r\u0014bAA1\u0015\nIa)\u001e8di&|g\u000e\r\t\u00043\u0006\u0015\u0014bAA45\nq1i\u001c8gYV,g\u000e^!e[&t\u0017!\u00053fgR\fE-\\5o\r\u0006\u001cGo\u001c:zA\u00059Q.\u001a;sS\u000e\u001c\bcA#\u0002p%\u0019\u0011\u0011O\u001f\u0003%\rcWo\u001d;fe2Kgn['fiJL7m]\u0001\u0005i&lW\r\u0005\u0003\u0002x\u0005uTBAA=\u0015\r\tY(`\u0001\u0006kRLGn]\u0005\u0005\u0003\u007f\nIH\u0001\u0003US6,\u0017\u0002BA:\u0003[\tQ!];pi\u0006\u0004B!a\"\u0002\n6\tq(C\u0002\u0002\f~\u0012qc\u00117vgR,'\u000fT5oWJ+\u0017/^3tiF+x\u000e^1\n\t\u0005\r\u0015Q\u0006\u000b\u0011\u0003#\u000b\u0019*!&\u0002\u0018\u0006e\u00151TAO\u0003?\u0003\"!\u0012\u0006\t\u000f\u0005MR\u00031\u0001\u00028!9\u0011qH\u000bA\u0002\u0005\r\u0003bBA&+\u0001\u0007\u0011Q\n\u0005\b\u00033*\u0002\u0019AA/\u0011\u001d\tY'\u0006a\u0001\u0003[Bq!a\u001d\u0016\u0001\u0004\t)\bC\u0004\u0002\u0004V\u0001\r!!\"\u0002\r\r|gNZ5h+\t\t)\u000bE\u0002F\u0003OK1!!+>\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017nZ\u0001\u000bG>tg-[4`I\u0015\fH\u0003BAX\u0003k\u00032!SAY\u0013\r\t\u0019L\u0013\u0002\u0005+:LG\u000fC\u0005\u00028^\t\t\u00111\u0001\u0002&\u0006\u0019\u0001\u0010J\u0019\u0002\u000f\r|gNZ5hA\u0005\u0001B/Y:lg>+Ho\u001d;b]\u0012LgnZ\u0001\u0015i\u0006\u001c8n](viN$\u0018M\u001c3j]\u001e|F%Z9\u0015\t\u0005=\u0016\u0011\u0019\u0005\t\u0003oS\u0012\u0011!a\u0001%\u0006\tB/Y:lg>+Ho\u001d;b]\u0012Lgn\u001a\u0011\u0002%I,Wn\u001c;f\u0019&t7.T3uC\u0012\fG/Y\u000b\u0003\u0003\u0013\u0004R!SAf\u0003\u001fL1!!4K\u0005\u0019y\u0005\u000f^5p]B\u0019Q)!5\n\u0007\u0005MWH\u0001\nSK6|G/\u001a'j].lU\r^1eCR\f\u0017A\u0006:f[>$X\rT5oW6+G/\u00193bi\u0006|F%Z9\u0015\t\u0005=\u0016\u0011\u001c\u0005\n\u0003ok\u0012\u0011!a\u0001\u0003\u0013\f1C]3n_R,G*\u001b8l\u001b\u0016$\u0018\rZ1uC\u0002\n\u0001\u0002^1tW\u0012+7oY\u000b\u0003\u0003C\u0004R!SAf\u0003G\u00042!RAs\u0013\r\t9/\u0010\u0002\u0010)\u0006\u001c8\u000eR3tGJL\u0007\u000f^5p]\u0006aA/Y:l\t\u0016\u001c8m\u0018\u0013fcR!\u0011qVAw\u0011%\t9\fIA\u0001\u0002\u0004\t\t/A\u0005uCN\\G)Z:dA!\u001a\u0011%a=\u0011\u0007%\u000b)0C\u0002\u0002x*\u0013\u0001B^8mCRLG.Z\u0001\u0017I\u0016\u001c8M]5cK6K'O]8sg>\u0003H/[8ogV\u0011\u0011Q \t\u00043\u0006}\u0018b\u0001B\u00015\n1B)Z:de&\u0014W-T5se>\u00148o\u00149uS>t7/A\feKN\u001c'/\u001b2f\u001b&\u0014(o\u001c:t\u001fB$\u0018n\u001c8tA\u0005\u0019!/\u001e8\u0015\u0005\t%\u0001\u0003\u0002B\u0006\u00053qAA!\u0004\u0002*9!!q\u0002B\f\u001d\u0011\u0011\tB!\u0006\u000f\u0007A\u0014\u0019\"C\u0001C\u0013\t\u0001\u0015)\u0003\u0002?\u007f%!!1DA\u0019\u0005)!\u0016m]6SKN,H\u000e^\u0001\fgft7m\u00144gg\u0016$8\u000f\u0006\u0003\u0003\n\t\u0005\u0002b\u0002B\u0012K\u0001\u0007!QE\u0001\fi\u0006\u001c8nQ8oi\u0016DH\u000f\u0005\u0003\u0003\f\t\u001d\u0012\u0002\u0002B\u0015\u0003c\u00111\u0002V1tW\u000e{g\u000e^3yi\u0006qCO]=J]&$\u0018.\u00197ju\u0016\u0014V-\\8uK6K'O]8s'ft7-\u001b8h\u0003:$7+\u001f8d\u001f\u001a47/\u001a;t)\u0011\u0011IAa\f\t\u000f\t\rb\u00051\u0001\u0003&\u0005\u0019\u0005.\u00198eY\u0016$Um]2sS\n,7i\u001c8gS\u001e\u001c(+Z:q_:\u001cX\rV8J]&$\u0018.\u00197ju\u0016\u0014V-\\8uK6K'O]8s'ft7-\u001b8h\u0003:$7+\u001f8d)!\u0011IA!\u000e\u00038\t\u0015\u0003b\u0002B\u0012O\u0001\u0007!Q\u0005\u0005\b\u0005s9\u0003\u0019\u0001B\u001e\u0003!\u0011Xm]8ve\u000e,\u0007\u0003\u0002B\u001f\u0005\u0003j!Aa\u0010\u000b\u0007\u0005\u0005V0\u0003\u0003\u0003D\t}\"AD\"p]\u001aLwMU3t_V\u00148-\u001a\u0005\b\u0005\u000f:\u0003\u0019\u0001B%\u0003\u0019\u0011Xm];miB\u0019\u0011La\u0013\n\u0007\t5#LA\u000bEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\u001cX\u000f\u001c;\u0002=!\fg\u000e\u001a7f\u0019&\u001cHoQ8ogVlWM]$s_V\u00048OU3tk2$HC\u0002B\u0005\u0005'\u0012)\u0006C\u0004\u0003$!\u0002\rA!\n\t\u000f\t]\u0003\u00061\u0001\u0003Z\u0005AB.[:u\u0007>t7/^7fe\u001e\u0013x.\u001e9t%\u0016\u001cX\u000f\u001c;\u0011\u0007e\u0013Y&C\u0002\u0003^i\u0013\u0001\u0004T5ti\u000e{gn];nKJ<%o\\;qgJ+7/\u001e7u\u0003QA\u0017M\u001c3mK\u001aKG\u000e^3sK\u0012<%o\\;qgR1!\u0011\u0002B2\u0005KBqAa\t*\u0001\u0004\u0011)\u0003C\u0004\u0003h%\u0002\rA!\u001b\u0002\u001d\u0019LG\u000e^3sK\u0012<%o\\;qgB!aNa\u001by\u0013\r\u0011ig\u001e\u0002\u0004'\u0016$\u0018\u0001\u00064jYR,'oQ8ogVlWM]$s_V\u00048\u000f\u0006\u0003\u0003j\tM\u0004b\u0002B;U\u0001\u0007!qO\u0001\u0007OJ|W\u000f]:\u0011\u000b9\u0014YG!\u001f\u0011\u00079\u0014Y(C\u0002\u0003~]\u0014aa\u0015;sS:<\u0017\u0001\b7jgR$Um\u001d;D_:\u001cX/\\3s\u000fJ|W\u000f](gMN,Go\u001d\u000b\u0005\u0005\u0007\u00139\tE\u0002\u0003\u0006&q1A!\u0004\u0001\u0011\u001d\u0011)h\u000ba\u0001\u0005S\na\u0004\\5tiN{WO]2f\u0007>t7/^7fe\u001e\u0013x.\u001e9PM\u001a\u001cX\r^:\u0015\t\t\r%Q\u0012\u0005\b\u0005kb\u0003\u0019\u0001B5\u0003aa\u0017n\u001d;D_:\u001cX/\\3s\u000fJ|W\u000f](gMN,Go\u001d\u000b\t\u0005\u0007\u0013\u0019J!&\u0003\u0018\"9!QO\u0017A\u0002\t%\u0004BB..\u0001\u0004\t\u0019\u0007C\u0004\u0003\u001a6\u0002\rAa'\u0002\u0011%\u001c8k\\;sG\u0016\u00042!\u0013BO\u0013\r\u0011yJ\u0013\u0002\b\u0005>|G.Z1o\u0003iA\u0017M\u001c3mKN{WO]2f\u0003:$G)Z:u\u001f\u001a47/\u001a;t)!\u0011IA!*\u0003(\n-\u0006b\u0002B\u0012]\u0001\u0007!Q\u0005\u0005\b\u0005Ss\u0003\u0019\u0001BB\u0003M\u0019x.\u001e:dK>3gm]3u\rV$XO]3t\u0011\u001d\u0011iK\fa\u0001\u0005\u0007\u000b\u0011\u0003Z3ti>3gm]3u\rV$XO]3t\u0003Aj\u0017\r\u001d+pa&\u001c\u0007+\u0019:uSRLwN\u001c+p\u0007>lW.\u001b;uK\u0012|eMZ:fiR{\u0007/[2QCJ$\u0018\u000e^5p]R1!1\u0017B_\u0005\u000b\u0004bA\\;\u0003z\tU\u0006C\u00028v\u0005o\u000b9\u0002E\u0002F\u0005sK1Aa/>\u0005u\u0019u.\\7jiR,Gm\u00144gg\u0016$Hk\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002B`_\u0001\u0007!\u0011Y\u0001\u000eg>,(oY3PM\u001a\u001cX\r^:\u0011\u000b9,\bPa1\u0011\r9,\u0018\u0011CA\f\u0011\u001d\t)m\fa\u0001\u0005\u000f\u0004r!\u0013Be\u0005\u001b\u0014i.C\u0002\u0003L*\u0013a\u0001V;qY\u0016\u0014\u0004C\u00028v\u0005s\u0012y\r\u0005\u0003\u0003R\n]gbA-\u0003T&\u0019!Q\u001b.\u0002-5K'O]8s)>\u0004\u0018n\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:LAA!7\u0003\\\n)1\u000b^1uK*\u0019!Q\u001b.\u0011\u000b%\u000bYM!\u001f\u0002+!\fg\u000e\u001a7f\t\u0016\u001c8M]5cK6K'O]8sgRa!\u0011\u0002Br\u0005K\u00149Oa;\u0003z\"9!1\u0005\u0019A\u0002\t\u0015\u0002b\u0002B`a\u0001\u0007!\u0011\u0019\u0005\b\u0005S\u0004\u0004\u0019\u0001Ba\u0003-!Wm\u001d;PM\u001a\u001cX\r^:\t\u000f\t5\b\u00071\u0001\u0003p\u0006)B-Z:de&\u0014W-T5se>\u00148OR;ukJ,\u0007C\u00028v\u0005s\u0012\t\u0010\u0005\u0003}\u007f\nM\bcA-\u0003v&\u0019!q\u001f.\u0003-5K'O]8s)>\u0004\u0018n\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:DqAa?1\u0001\u0004\u0011i.\u0001\u0007sK6|G/\u001a)sK\u001aL\u00070A\u0010u_\u000e{W.\\5ui\u0016$wJ\u001a4tKR$v\u000e]5d!\u0006\u0014H/\u001b;j_:$\"Ba.\u0004\u0002\r\u00151\u0011BB\b\u0011\u0019\u0019\u0019!\ra\u0001q\u0006)qM]8va\"91qA\u0019A\u0002\u0005E\u0011A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0007\u0017\t\u0004\u0019AB\u0007\u0003Y\u0011X-\\8uK6K'O]8s)>\u0004\u0018nY*uCR,\u0007#B%\u0002L\n=\u0007b\u0002B~c\u0001\u0007!Q\\\u0001\u000eG>lW.\u001b;PM\u001a\u001cX\r^:\u0015\u0011\t%1QCB\f\u00073AqAa\t3\u0001\u0004\u0011)\u0003C\u0004\u0003@J\u0002\rAa-\t\u000f\t%(\u00071\u0001\u0004\u001cA1a.\u001eB=\u0005\u0007\f\u0001\u0006[1oI2,G)Z:uS:\fG/[8o\u00072,8\u000f^3s\u0007>lW.\u001b;uK\u0012|eMZ:fiN$\u0002B!\u0003\u0004\"\r\r2q\u0006\u0005\b\u0005G\u0019\u0004\u0019\u0001B\u0013\u0011\u001d\u0019)c\ra\u0001\u0007O\tQbY8n[&$(+Z:vYR\u001c\bC\u00028v\u0005s\u001aI\u0003E\u0002Z\u0007WI1a!\f[\u0005}\tE\u000e^3s\u0007>t7/^7fe\u001e\u0013x.\u001e9PM\u001a\u001cX\r^:SKN,H\u000e\u001e\u0005\b\u0005\u007f\u001b\u0004\u0019\u0001BZ\u0003\u001dygMZ:fiN$\u0002b!\u000e\u0004@\r\u00053Q\t\t\b\u0013\n%'1YB\u001c!\u0015I\u00151ZB\u001d!\r)51H\u0005\u0004\u0007{i$a\u0005+bg.,%O]8s\u0007>$W-\u00118e\u001bN<\u0007bBB\u0002i\u0001\u0007!\u0011\u0010\u0005\u0007\u0007\u0007\"\u0004\u0019A>\u0002\r\u0019,H/\u001e:f\u0011\u001d\u0011I\n\u000ea\u0001\u00057\u000b\u0011c\u001c4gg\u0016$h)\u001a;dQ\u001a\u000b\u0017\u000e\\3e)\u0019\tyka\u0013\u0004N!9!\u0011T\u001bA\u0002\tm\u0005bBB(k\u0001\u00071\u0011K\u0001\u0002KB!11KB/\u001d\u0011\u0019)f!\u0017\u000f\u0007A\u001c9&C\u0001L\u0013\r\u0019YFS\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0019yf!\u0019\u0003\u0013QC'o\\<bE2,'bAB.\u0015\u0006Y1o\\;sG\u0016\fE-\\5o+\t\t\u0019'A\u0005eKN$\u0018\tZ7j]R111NB9\u0007g\u00022!WB7\u0013\r\u0019yG\u0017\u0002\u001f\u0019&\u001cHoQ8ogVlWM]$s_V\u0004xJ\u001a4tKR\u001c(+Z:vYRDaa\u0017\u001dA\u0002\u0005\r\u0004bBB;q\u0001\u00071qO\u0001\u000bOJ|W\u000f]*qK\u000e\u001c\bcBA\u0003\u0003\u001f\u0011I\bW\u0001!G>tg-[4ve\u0016$Gk\\%oG2,H-\u001a*f[>$X-T5se>\u00148/\u0006\u0002\u0003\u001c\u0006aqN\\\"p[BdW\r^5p]R!\u0011qVBA\u0011\u001d\u00119E\u000fa\u0001\u0007\u0007\u0003BAa\u0003\u0004\u0006&!1qQA\u0019\u0005M\u0019u.\u001c9mKR,G\rV1tWJ+7/\u001e7u\u0003=!\u0018m]6EKN\u001c'/\u001b9uS>tGCAAq\u0001")
public class ClusterLinkSyncOffsets
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkData linkData;
    private final Function0<ConfluentAdmin> destAdminFactory;
    private final ClusterLinkMetrics metrics;
    private ClusterLinkConfig config;
    private int tasksOutstanding;
    private Option<RemoteLinkMetadata> remoteLinkMetadata;
    private volatile Option<TaskDescription> taskDesc;
    private final DescribeMirrorsOptions describeMirrorsOptions;

    public static ListConsumerGroupOffsetsOptions ListOffsetsOptions() {
        return ClusterLinkSyncOffsets$.MODULE$.ListOffsetsOptions();
    }

    public static ListConsumerGroupOffsetsSpec ListOffsetsForAllPartitions() {
        return ClusterLinkSyncOffsets$.MODULE$.ListOffsetsForAllPartitions();
    }

    public static int ListConsumerGroupOffsetBatchSize() {
        return ClusterLinkSyncOffsets$.MODULE$.ListConsumerGroupOffsetBatchSize();
    }

    public ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    public Function0<ConfluentAdmin> destAdminFactory() {
        return this.destAdminFactory;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    private Option<RemoteLinkMetadata> remoteLinkMetadata() {
        return this.remoteLinkMetadata;
    }

    private void remoteLinkMetadata_$eq(Option<RemoteLinkMetadata> x$1) {
        this.remoteLinkMetadata = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    private DescribeMirrorsOptions describeMirrorsOptions() {
        return this.describeMirrorsOptions;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        this.config_$eq(this.clientManager().currentConfig());
        if (this.metadataManager().isLinkCoordinator(this.linkData.linkName()) && this.config().consumerOffsetSyncEnable()) {
            ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
            if (this.tasksOutstanding() != 0) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(91).append("Number of outstanding tasks was ").append(this.tasksOutstanding()).append(" at the beginning of run. Resetting to 0 and continuing on.").toString());
                this.tasksOutstanding_$eq(0);
            }
            if (this.configuredToIncludeRemoteMirrors() && this.remoteLinkMetadata().isEmpty()) {
                return this.tryInitializeRemoteMirrorSyncingAndSyncOffsets(taskContext);
            }
            return this.syncOffsets(taskContext);
        }
        scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult syncOffsets(ClusterLinkScheduler.TaskContext taskContext) {
        if (this.config().consumerGroupFilters().isEmpty()) {
            String errMsg = new StringBuilder(91).append(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()).append(" is true but no consumer group filters are ").append("specified. No consumer offsets will be migrated.").toString();
            this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
            TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(MisconfigurationTaskErrorCode$.MODULE$, errMsg);
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)err, (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Attempting to retrieve consumer groups from source cluster");
        ListConsumerGroupsResult listConsumerGroupsResult = this.sourceAdmin().listConsumerGroups();
        this.scheduleWhenComplete(listConsumerGroupsResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> {
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            return this.handleListConsumerGroupsResult((ClusterLinkScheduler.TaskContext)tc, listConsumerGroupsResult);
        }, taskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult tryInitializeRemoteMirrorSyncingAndSyncOffsets(ClusterLinkScheduler.TaskContext taskContext) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, this.linkData.linkName());
        DescribeConfigsResult result = this.sourceAdmin().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)).asJava(), new DescribeConfigsOptions());
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> {
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            return this.handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync((ClusterLinkScheduler.TaskContext)tc, resource, result);
        }, taskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync(ClusterLinkScheduler.TaskContext taskContext, ConfigResource resource, DescribeConfigsResult result) {
        void var7_7;
        void var6_6;
        KafkaFuture configFuture = (KafkaFuture)result.values().get(resource);
        if (configFuture == null) {
            throw new IllegalStateException(new StringBuilder(37).append("Failed to find link ").append(this.linkData.linkName()).append(" in the response.").toString());
        }
        Tuple2 tuple2 = this.liftedTree1$1(configFuture);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option configOpt = (Option)tuple2._1();
        scala.collection.immutable.Seq errs = (scala.collection.immutable.Seq)tuple2._2();
        var6_6.foreach((Function1 & Serializable)linkConfig -> {
            ClusterLinkSyncOffsets.$anonfun$handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync$3(this, linkConfig);
            return BoxedUnit.UNIT;
        });
        return this.syncOffsets(new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)var7_7))));
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult handleListConsumerGroupsResult(ClusterLinkScheduler.TaskContext taskContext, ListConsumerGroupsResult listConsumerGroupsResult) {
        void var5_5;
        Tuple2 tuple2 = this.liftedTree2$1(listConsumerGroupsResult, taskContext);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Collection consumerGroupListing = (Collection)tuple2._1();
        Option errOpt = (Option)tuple2._2();
        if (var5_5 instanceof Some) {
            return (ClusterLinkScheduler.TaskResult)((Some)var5_5).value();
        }
        if (None$.MODULE$.equals(var5_5)) {
            void var4_4;
            scala.collection.immutable.Set<MatchedGroup> filteredGroups = this.filterConsumerGroups((scala.collection.immutable.Set<String>)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)var4_4).asScala().map((Function1 & Serializable)x$6 -> x$6.groupId())).toSet());
            return this.handleFilteredGroups(taskContext, filteredGroups);
        }
        throw new MatchError((Object)var5_5);
    }

    private ClusterLinkScheduler.TaskResult handleFilteredGroups(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<MatchedGroup> filteredGroups) {
        scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> destOffsetFutures = this.listDestConsumerGroupOffsets(filteredGroups);
        scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> sourceOffsetFutures = this.listSourceConsumerGroupOffsets(filteredGroups);
        if (sourceOffsetFutures.nonEmpty()) {
            Iterable futures = (Iterable)sourceOffsetFutures.values().$plus$plus((IterableOnce)destOffsetFutures.values());
            this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])futures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> {
                this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
                return this.handleSourceAndDestOffsets((ClusterLinkScheduler.TaskContext)tc, sourceOffsetFutures, destOffsetFutures);
            }, taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Set<MatchedGroup> filterConsumerGroups(scala.collection.immutable.Set<String> groups) {
        void var4_4;
        void var5_5;
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Filtering consumer groups ").append(groups).append(" to match consumer group JSON").toString());
        Option<String> clusterLinkPrefix = Predef$.MODULE$.Boolean2boolean(this.config().clusterLinkPrefixConsumerGroupEnable()) ? this.config().clusterLinkPrefix() : None$.MODULE$;
        Tuple2<scala.collection.immutable.Set<MatchedGroup>, scala.collection.immutable.Seq<ClusterLinkFilterInfo>> tuple2 = ClusterLinkUtils$.MODULE$.doFilterGroups(groups, this.config().consumerGroupFilters(), this.linkData.tenantPrefix(), clusterLinkPrefix, this.config().linkMode());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set filtered = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Seq unusedFilters = (scala.collection.immutable.Seq)tuple2._2();
        var5_5.foreach((Function1 & Serializable)unusedFilter -> {
            ClusterLinkSyncOffsets.$anonfun$filterConsumerGroups$2(this, unusedFilter);
            return BoxedUnit.UNIT;
        });
        this.trace((Function0<String>)((Function0 & Serializable)() -> ClusterLinkSyncOffsets.$anonfun$filterConsumerGroups$4((scala.collection.immutable.Set)var4_4)));
        return var4_4;
    }

    private scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> listDestConsumerGroupOffsets(scala.collection.immutable.Set<MatchedGroup> groups) {
        return this.listConsumerGroupOffsets(groups, this.destAdmin(), false);
    }

    private scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> listSourceConsumerGroupOffsets(scala.collection.immutable.Set<MatchedGroup> groups) {
        return this.listConsumerGroupOffsets(groups, this.sourceAdmin(), true);
    }

    private scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> listConsumerGroupOffsets(scala.collection.immutable.Set<MatchedGroup> groups, ConfluentAdmin admin, boolean isSource) {
        String targetCluster = isSource ? "source" : "destination";
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("Listing consumer group offsets on ").append(targetCluster).append(" cluster for following consumer groups: ").append(groups).toString());
        scala.collection.mutable.Map groupFutures = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        try {
            groups.grouped(ClusterLinkSyncOffsets$.MODULE$.ListConsumerGroupOffsetBatchSize()).foreach((Function1 & Serializable)batch -> {
                ClusterLinkSyncOffsets.$anonfun$listConsumerGroupOffsets$2(this, targetCluster, admin, groupFutures, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable ex) {
            this.offsetFetchFailed(isSource, ex);
        }
        return groupFutures.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private ClusterLinkScheduler.TaskResult handleSourceAndDestOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> sourceOffsetFutures, scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> destOffsetFutures) {
        scala.collection.immutable.Map sourceGroupToOffsets = (scala.collection.immutable.Map)sourceOffsetFutures.map((Function1 & Serializable)groupAndOffsetInfo -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(groupAndOffsetInfo._1()), this.offsets(((MatchedGroup)groupAndOffsetInfo._1()).name(), (KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>)((KafkaFuture)groupAndOffsetInfo._2()), true)));
        scala.collection.immutable.Map sourceOffsets = (scala.collection.immutable.Map)sourceGroupToOffsets.map((Function1 & Serializable)groupAndOffsetInfo -> new Tuple2(groupAndOffsetInfo._1(), ((Tuple2)groupAndOffsetInfo._2())._1()));
        scala.collection.immutable.Seq sourceErrs = (scala.collection.immutable.Seq)((IterableOps)((MapOps)sourceGroupToOffsets.map((Function1 & Serializable)groupAndOffsetInfo -> new Tuple2(groupAndOffsetInfo._1(), ((Tuple2)groupAndOffsetInfo._2())._2()))).values().toSeq().filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.nonEmpty()))).map((Function1 & Serializable)x$9 -> (TaskErrorCodeAndMsg)x$9.get());
        scala.collection.immutable.Map destGroupToOffsets = (scala.collection.immutable.Map)destOffsetFutures.map((Function1 & Serializable)groupAndOffsetInfo -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(groupAndOffsetInfo._1()), this.offsets(((MatchedGroup)groupAndOffsetInfo._1()).name(), (KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>)((KafkaFuture)groupAndOffsetInfo._2()), false)));
        scala.collection.immutable.Map destOffsets = (scala.collection.immutable.Map)destGroupToOffsets.map((Function1 & Serializable)groupAndOffsetInfo -> new Tuple2(groupAndOffsetInfo._1(), ((Tuple2)groupAndOffsetInfo._2())._1()));
        scala.collection.immutable.Seq destErrs = (scala.collection.immutable.Seq)((IterableOps)((MapOps)destGroupToOffsets.map((Function1 & Serializable)groupAndOffsetInfo -> new Tuple2(groupAndOffsetInfo._1(), ((Tuple2)groupAndOffsetInfo._2())._2()))).values().toSeq().filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.nonEmpty()))).map((Function1 & Serializable)x$11 -> (TaskErrorCodeAndMsg)x$11.get());
        ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)((IterableOps)taskContext.errs().$plus$plus((IterableOnce)sourceErrs)).$plus$plus((IterableOnce)destErrs)));
        if (this.configuredToIncludeRemoteMirrors() && this.remoteLinkMetadata().isDefined()) {
            Option<String> remotePrefix = ((RemoteLinkMetadata)this.remoteLinkMetadata().get()).remotePrefix();
            scala.collection.immutable.Set topics = (scala.collection.immutable.Set)((scala.collection.immutable.MapOps)sourceOffsets.flatMap((Function1 & Serializable)x$12 -> (scala.collection.immutable.Map)x$12._2())).keySet().map((Function1 & Serializable)x$13 -> x$13.topic());
            DescribeMirrorsResult describeMirrorsResult = this.sourceAdmin().describeMirrors((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)topics).asJava(), this.describeMirrorsOptions());
            this.scheduleWhenComplete(describeMirrorsResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> {
                this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
                return this.handleDescribeMirrors((ClusterLinkScheduler.TaskContext)tc, (scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)sourceOffsets, (scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)destOffsets, (scala.collection.immutable.Map<String, KafkaFuture<MirrorTopicDescription>>)CollectionConverters$.MODULE$.MapHasAsScala(describeMirrorsResult.result()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), remotePrefix);
            }, newTaskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = newTaskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        return this.commitOffsets(newTaskContext, this.mapTopicPartitionToCommittedOffsetTopicPartition((scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)sourceOffsets, (Tuple2<scala.collection.immutable.Map<String, MirrorTopicDescription.State>, Option<String>>)new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)None$.MODULE$)), (scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)((scala.collection.immutable.Map)destOffsets.map((Function1 & Serializable)kv -> new Tuple2((Object)((MatchedGroup)kv._1()).name(), kv._2()))));
    }

    private scala.collection.immutable.Map<String, scala.collection.immutable.Map<CommittedOffsetTopicPartition, OffsetAndMetadata>> mapTopicPartitionToCommittedOffsetTopicPartition(scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sourceOffsets, Tuple2<scala.collection.immutable.Map<String, MirrorTopicDescription.State>, Option<String>> remoteLinkMetadata) {
        return (scala.collection.immutable.Map)sourceOffsets.map((Function1 & Serializable)groupToTopicPartitionToOffsetMetadata -> {
            scala.collection.immutable.Map mappedTopicPartitionAndOffsetMetadataMap = (scala.collection.immutable.Map)((MapOps)groupToTopicPartitionToOffsetMetadata._2()).map((Function1 & Serializable)topicPartitionToOffsetMetadata -> {
                TopicPartition topicPartition = (TopicPartition)topicPartitionToOffsetMetadata._1();
                String sourceTopicName = topicPartition.topic();
                return new Tuple2((Object)this.toCommittedOffsetTopicPartition((MatchedGroup)groupToTopicPartitionToOffsetMetadata._1(), topicPartition, (Option<MirrorTopicDescription.State>)((MapOps)remoteLinkMetadata._1()).get((Object)sourceTopicName), (Option<String>)((Option)remoteLinkMetadata._2())), topicPartitionToOffsetMetadata._2());
            });
            return new Tuple2((Object)((MatchedGroup)groupToTopicPartitionToOffsetMetadata._1()).name(), (Object)mappedTopicPartitionAndOffsetMetadataMap);
        });
    }

    private ClusterLinkScheduler.TaskResult handleDescribeMirrors(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sourceOffsets, scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> destOffsets, scala.collection.immutable.Map<String, KafkaFuture<MirrorTopicDescription>> describeMirrorsFuture, Option<String> remotePrefix) {
        scala.collection.immutable.Map describeMirrorAndErrors = (scala.collection.immutable.Map)describeMirrorsFuture.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Tuple2 tuple2;
                String topic = (String)x0$1._1();
                try {
                    MirrorTopicDescription mirrorTopicDescription = (MirrorTopicDescription)((KafkaFuture)x0$1._2()).get();
                    if (mirrorTopicDescription != null) {
                        return new Tuple2((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)mirrorTopicDescription)), (Object)None$.MODULE$);
                    }
                    tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
                }
                catch (ExecutionException ex) {
                    KafkaException kafkaException;
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Failed to describe remote mirror.", (Function0<Throwable>)(Function0 & Serializable)() -> ex);
                    Throwable throwable = ex.getCause();
                    Some taskErrorCodeAndMsg = throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable) ? new Some((Object)new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, "Failed to describe remote mirror due to authentication issues.")) : (throwable instanceof AuthorizationException ? new Some((Object)new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, "Failed to describe remote mirror due to authorization issues.")) : (throwable instanceof ClusterLinkNotFoundException ? None$.MODULE$ : new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Failed to describe remote mirror for an unknown reason."))));
                    tuple2 = new Tuple2((Object)None$.MODULE$, (Object)taskErrorCodeAndMsg);
                }
                return tuple2;
            }
            throw new MatchError(null);
        });
        scala.collection.immutable.Map remoteMirrors = (scala.collection.immutable.Map)((scala.collection.immutable.Map)((MapOps)describeMirrorAndErrors.filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$handleDescribeMirrors$4(x$14)))).map((Function1 & Serializable)x$15 -> (Tuple2)((Option)x$15._1()).get())).flatMap((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String topic = (String)x0$2._1();
                MirrorTopicDescription desc = (MirrorTopicDescription)x0$2._2();
                if (desc.linkName().equals($this.linkData.linkName()) && desc.clusterLinkId().equals((Object)$this.linkData.linkId())) {
                    return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)desc.state()));
                }
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Filtering out ").append(topic).append(" from a different link ").append(desc.linkName()).append(" ").append(desc.clusterLinkId()).append(".").toString());
                return None$.MODULE$;
            }
            throw new MatchError(null);
        });
        return this.commitOffsets(new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)((IterableOnceOps)((IterableOps)describeMirrorAndErrors.filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$handleDescribeMirrors$8(x$16)))).map((Function1 & Serializable)x$17 -> (TaskErrorCodeAndMsg)((Option)x$17._2()).get())).toSeq()))), this.mapTopicPartitionToCommittedOffsetTopicPartition(sourceOffsets, (Tuple2<scala.collection.immutable.Map<String, MirrorTopicDescription.State>, Option<String>>)new Tuple2((Object)remoteMirrors, remotePrefix)), (scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)((scala.collection.immutable.Map)destOffsets.map((Function1 & Serializable)kv -> new Tuple2((Object)((MatchedGroup)kv._1()).name(), kv._2()))));
    }

    private CommittedOffsetTopicPartition toCommittedOffsetTopicPartition(MatchedGroup group, TopicPartition topicPartition, Option<MirrorTopicDescription.State> remoteMirrorTopicState, Option<String> remotePrefix) {
        boolean isRemoteMirror = remoteMirrorTopicState.isDefined();
        Option localMirrorTopicsState = this.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicPartition.topic()})))).get((Object)topicPartition.topic());
        boolean isLocalMirror = localMirrorTopicsState.isDefined();
        if (isRemoteMirror && isLocalMirror) {
            return new LocalMirrorTopic(topicPartition, (Option<TopicLinkState>)new Some((Object)((ClusterLinkTopicState)localMirrorTopicsState.get()).state()), group);
        }
        if (isLocalMirror) {
            return new LocalMirrorTopic(topicPartition, (Option<TopicLinkState>)new Some((Object)((ClusterLinkTopicState)localMirrorTopicsState.get()).state()), group);
        }
        if (isRemoteMirror) {
            return new RemoteMirrorTopic(topicPartition, (MirrorTopicDescription.State)remoteMirrorTopicState.get(), this.linkData, this.config().clusterLinkPrefix(), remotePrefix, group);
        }
        return new RegularTopic(topicPartition);
    }

    private ClusterLinkScheduler.TaskResult commitOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, scala.collection.immutable.Map<CommittedOffsetTopicPartition, OffsetAndMetadata>> sourceOffsets, scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> destOffsets) {
        scala.collection.immutable.Map commitResults = (scala.collection.immutable.Map)sourceOffsets.flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                scala.collection.immutable.Map map;
                String consumerGroup = (String)x0$1._1();
                scala.collection.immutable.Map offsetMetadata = (scala.collection.immutable.Map)x0$1._2();
                Option option = destOffsets.get((Object)consumerGroup);
                if (option instanceof Some) {
                    map = (scala.collection.immutable.Map)((Some)option).value();
                } else if (None$.MODULE$.equals(option)) {
                    map = Predef$.MODULE$.Map().empty();
                } else {
                    throw new MatchError((Object)option);
                }
                scala.collection.immutable.Map destTopicPartition = map;
                scala.collection.immutable.Map offsetsToCommit = (scala.collection.immutable.Map)offsetMetadata.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$commitOffsets$2(this, consumerGroup, destTopicPartition, x0$2)));
                if (offsetsToCommit.nonEmpty()) {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Committing offsets on destination cluster for consumer group ").append(consumerGroup).append(": ").append(offsetsToCommit).toString());
                    scala.collection.immutable.Map offsetAndMetadataToCommit = (scala.collection.immutable.Map)offsetsToCommit.map((Function1 & Serializable)keyVal -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((CommittedOffsetTopicPartition)keyVal._1()).destTopic()), keyVal._2()));
                    return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)consumerGroup), (Object)this.destAdmin().alterConsumerGroupOffsets(consumerGroup, CollectionConverters$.MODULE$.MapHasAsJava((Map)offsetAndMetadataToCommit).asJava())));
                }
                return None$.MODULE$;
            }
            throw new MatchError(null);
        });
        if (commitResults.nonEmpty()) {
            return this.handleDestinationClusterCommittedOffsets(taskContext, (scala.collection.immutable.Map<String, AlterConsumerGroupOffsetsResult>)commitResults, sourceOffsets);
        }
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleDestinationClusterCommittedOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, AlterConsumerGroupOffsetsResult> commitResults, scala.collection.immutable.Map<String, scala.collection.immutable.Map<CommittedOffsetTopicPartition, OffsetAndMetadata>> sourceOffsets) {
        KafkaFuture allCommitFutures = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((IterableOnceOps)commitResults.values().map((Function1 & Serializable)x$19 -> x$19.all())).toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(allCommitFutures, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> {
            void apply_now;
            void apply_ttlMs;
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            ExcessiveLoggingHandler$ apply$default$3_this = ExcessiveLoggingHandler$.MODULE$;
            Object var11_4 = null;
            Function0<Object> function0 = apply$default$3_this.nowDefault();
            long l = ExcessiveLoggingHandler$.MODULE$.ttlMsDefault();
            int apply_capacity = 1000;
            function0 = null;
            ExcessiveLoggingHandler excessiveLoggingHandler = new ExcessiveLoggingHandler(apply_capacity, (long)apply_ttlMs, (Function0<Object>)apply_now);
            scala.collection.immutable.Iterable errs = (scala.collection.immutable.Iterable)commitResults.flatMap((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String group = (String)x0$1._1();
                    try {
                        ((AlterConsumerGroupOffsetsResult)x0$1._2()).all().get();
                        ((IterableOnceOps)sourceOffsets.apply((Object)group)).foreach((Function1 & Serializable)topicPartitionAndOffsetMetadata -> {
                            ClusterLinkSyncOffsets.$anonfun$handleDestinationClusterCommittedOffsets$4(this, group, topicPartitionAndOffsetMetadata);
                            return BoxedUnit.UNIT;
                        });
                        return None$.MODULE$;
                    }
                    catch (ExecutionException ex) {
                        KafkaException kafkaException;
                        Throwable throwable = ex.getCause();
                        if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                            String errMsg = new StringBuilder(98).append("Unable to commit offsets for group ").append(group).append(" on the destination due to authentication issues on the broker.").toString();
                            excessiveLoggingHandler.handle(ex, this, errMsg);
                            return new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, errMsg));
                        }
                        if (throwable instanceof UnknownMemberIdException) {
                            String errMsg = new StringBuilder(132).append("Unable to commit offsets for consumer group ").append(group).append(" on the destination cluster because there are active members on the destination already.").toString();
                            excessiveLoggingHandler.handle(ex, this, errMsg);
                            $this.metrics.consumerOffsetCommitFailedSensor().record();
                            return new Some((Object)new TaskErrorCodeAndMsg(ConsumerGroupInUseTaskErrorCode$.MODULE$, errMsg));
                        }
                        if (throwable instanceof GroupAuthorizationException) {
                            GroupAuthorizationException groupAuthorizationException = (GroupAuthorizationException)throwable;
                            String errMsg = new StringBuilder(296).append("Unable to commit offsets for consumer group ").append(group).append(" on the destination cluster due to group authorization issues on the broker.").append(" Please add READ ACLs for the consumer group. This action is taken by the inter-broker principal defined in the broker ").append("configuration so ACLs should be added for this principal.").toString();
                            excessiveLoggingHandler.handle((Throwable)groupAuthorizationException, this, errMsg);
                            $this.metrics.consumerOffsetCommitFailedSensor().record();
                            return new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, new StringBuilder(70).append("Unable to commit offsets for group ").append(group).append(" due to group authorization issues.").toString()));
                        }
                        if (throwable instanceof TopicAuthorizationException) {
                            String errMsg = new StringBuilder(303).append("Unable to commit offsets for consumer group ").append(group).append(" on the destination cluster due to topic authorization issues on the broker.").append(" Please add READ ACLs for the topics being migrated. This action is taken by the inter-broker principal defined in the broker ").append("configuration so ACLs should be added for this principal.").toString();
                            excessiveLoggingHandler.handle(ex, this, errMsg);
                            $this.metrics.consumerOffsetCommitFailedSensor().record();
                            return new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, new StringBuilder(70).append("Unable to commit offsets for group ").append(group).append(" due to topic authorization issues.").toString()));
                        }
                        if (throwable instanceof UnknownTopicOrPartitionException) {
                            String errMsg = new StringBuilder(102).append("Unable to commit offsets for consumer group ").append(group).append(" on destination cluster due to unknown topic or partition.").toString();
                            excessiveLoggingHandler.handle((Throwable)Option$.MODULE$.apply((Object)ex.getCause()).getOrElse((Function0 & Serializable)() -> ex), this, errMsg);
                            $this.metrics.consumerOffsetCommitFailedSensor().record();
                            return new Some((Object)new TaskErrorCodeAndMsg(UnknownTopicOrPartitionErrorCode$.MODULE$, errMsg));
                        }
                        String errMsg = new StringBuilder(90).append("Unable to commit offsets for consumer group ").append(group).append(" on destination cluster for an unknown reason.").toString();
                        excessiveLoggingHandler.handle((Throwable)Option$.MODULE$.apply((Object)ex.getCause()).getOrElse((Function0 & Serializable)() -> ex), this, errMsg);
                        $this.metrics.consumerOffsetCommitFailedSensor().record();
                        return new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                    }
                    catch (Throwable ex) {
                        String errMsg = new StringBuilder(99).append("Unable to commit offsets for consumer group ").append(group).append(" on destination cluster due to an unexpected exception.").toString();
                        excessiveLoggingHandler.handle(ex, this, errMsg);
                        $this.metrics.consumerOffsetCommitFailedSensor().record();
                        return new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                    }
                }
                throw new MatchError(null);
            });
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)tc.errs().$plus$plus((IterableOnce)errs);
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }, taskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private Tuple2<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>, Option<TaskErrorCodeAndMsg>> offsets(String group, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>> future, boolean isSource) {
        try {
            return new Tuple2((Object)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)future.get()).asScala().map((Function1 & Serializable)topicPartitionAndOffsetMetadata -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartitionAndOffsetMetadata._1()), topicPartitionAndOffsetMetadata._2())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)None$.MODULE$);
        }
        catch (ExecutionException ex) {
            KafkaException kafkaException;
            Throwable throwable;
            KafkaException kafkaException2;
            Throwable throwable2;
            this.offsetFetchFailed(isSource, ex);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Failed to get offsets for group ").append(group).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> ex);
            TaskErrorCodeAndMsg taskErrorCodeAndMsg = isSource ? ((throwable2 = ex.getCause()) instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException2 = (KafkaException)throwable2) ? new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, new StringBuilder(90).append("Failed to get offsets for group ").append(group).append(" on the source due to authentication issues with the link.").toString()) : (throwable2 instanceof AuthorizationException ? new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, new StringBuilder(89).append("Failed to get offsets for group ").append(group).append(" on the source due to authorization issues with the link.").toString()) : new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, new StringBuilder(69).append("Failed to get offsets for group ").append(group).append(" on the source for an unknown reason.").toString()))) : ((throwable = ex.getCause()) instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable) ? new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, new StringBuilder(95).append("Failed to get offsets for group ").append(group).append(" on the destination due to authentication issues on the broker.").toString()) : (throwable instanceof AuthorizationException ? new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, new StringBuilder(94).append("Failed to get offsets for group ").append(group).append(" on the destination due to authorization issues on the broker.").toString()) : new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, new StringBuilder(74).append("Failed to get offsets for group ").append(group).append(" on the destination for an unknown reason.").toString())));
            TaskErrorCodeAndMsg err = taskErrorCodeAndMsg;
            return new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)new Some((Object)err));
        }
    }

    private void offsetFetchFailed(boolean isSource, Throwable e) {
        if (isSource) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Unable to list consumer group offsets on source cluster. Offsets will not be migrated.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.metrics.listConsumerGroupOffsetsFromSourceFailedSensor().record();
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Unable to list consumer group offsets on destination cluster. All available source offsets will be committed.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
        this.metrics.listConsumerGroupOffsetsFromDestinationFailedSensor().record();
    }

    private ConfluentAdmin sourceAdmin() {
        return this.clientManager().getAdmin();
    }

    private ConfluentAdmin destAdmin() {
        return (ConfluentAdmin)this.destAdminFactory().apply();
    }

    public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(ConfluentAdmin admin, java.util.Map<String, ListConsumerGroupOffsetsSpec> groupSpecs) {
        return admin.listConsumerGroupOffsets(groupSpecs, ClusterLinkSyncOffsets$.MODULE$.ListOffsetsOptions());
    }

    private boolean configuredToIncludeRemoteMirrors() {
        return this.config().linkMode().equals((Object)ClusterLinkConfig.LinkMode.BIDIRECTIONAL) && this.config().consumerGroupFilters().exists((Function1 & Serializable)groupFiltersJson -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$configuredToIncludeRemoteMirrors$1(this, groupFiltersJson)));
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        if (this.metadataManager().isLinkCoordinator(this.linkData.linkName())) {
            if (this.config().consumerOffsetSyncEnable()) {
                this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkSyncOffsetsTaskType$.MODULE$, "run the consumer offsets sync task"));
                return;
            }
            this.taskDesc_$eq((Option<TaskDescription>)new Some((Object)new TaskDescription(NotConfiguredTaskState$.MODULE$, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))));
            return;
        }
        this.taskDesc_$eq((Option<TaskDescription>)None$.MODULE$);
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(KafkaFuture configFuture$1) {
        try {
            return new Tuple2((Object)new Some(configFuture$1.get()), (Object)package$.MODULE$.Seq().empty());
        }
        catch (ExecutionException ex) {
            KafkaException kafkaException;
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(79).append("Failed to get remote link config on the remote cluster for bi-directional link ").append($this.linkData.linkName()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> ex);
            Throwable throwable = ex.getCause();
            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                return new Tuple2((Object)None$.MODULE$, (Object)new .colon.colon((Object)new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, "Failed to get remote link config due to authentication issues."), (List)Nil$.MODULE$));
            }
            if (throwable instanceof AuthorizationException) {
                return new Tuple2((Object)None$.MODULE$, (Object)new .colon.colon((Object)new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, "Failed to get remote link config due to authorization issues."), (List)Nil$.MODULE$));
            }
            if (throwable instanceof ClusterLinkNotFoundException) {
                return new Tuple2((Object)None$.MODULE$, (Object)new .colon.colon((Object)new TaskErrorCodeAndMsg(RemoteLinkNotFoundTaskErrorCode$.MODULE$, "Failed to get remote link config due to link not being found on the remote cluster."), (List)Nil$.MODULE$));
            }
            return new Tuple2((Object)None$.MODULE$, (Object)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Failed to get remote link config for an unknown reason."), (List)Nil$.MODULE$));
        }
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync$5(String x$3) {
        return x$3 != null;
    }

    public static final /* synthetic */ void $anonfun$handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync$3(ClusterLinkSyncOffsets $this, Config linkConfig) {
        ConfigEntry prefix = linkConfig.get(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp());
        Option remotePrefix = Option$.MODULE$.apply((Object)prefix).map((Function1 & Serializable)x$2 -> x$2.value()).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync$5(x$3))).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$4))));
        $this.remoteLinkMetadata_$eq((Option<RemoteLinkMetadata>)new Some((Object)new RemoteLinkMetadata((Option<String>)remotePrefix)));
    }

    private final /* synthetic */ Tuple2 liftedTree2$1(ListConsumerGroupsResult listConsumerGroupsResult$2, ClusterLinkScheduler.TaskContext taskContext$1) {
        try {
            Collection result = (Collection)listConsumerGroupsResult$2.all().get();
            return new Tuple2((Object)result, (Object)None$.MODULE$);
        }
        catch (ExecutionException ex) {
            KafkaException kafkaException;
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Unable to list consumer group offsets. Offsets will not be migrated.", (Function0<Throwable>)(Function0 & Serializable)() -> ex);
            this.metrics.listConsumerGroupsFromSourceFailedSensor().record();
            Throwable throwable = ex.getCause();
            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext$1.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, "Unable to list consumer groups due to authentication issues."), (List)Nil$.MODULE$));
                Object var7_7 = null;
                return new Tuple2(null, (Object)new Some((Object)new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs)));
            }
            if (throwable instanceof AuthorizationException) {
                scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext$1.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, "Unable to list consumer groups due to authorization issues."), (List)Nil$.MODULE$));
                Object var8_8 = null;
                return new Tuple2(null, (Object)new Some((Object)new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs)));
            }
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext$1.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Unable to list consumer groups for an unknown reason."), (List)Nil$.MODULE$));
            Object var9_9 = null;
            return new Tuple2(null, (Object)new Some((Object)new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs)));
        }
    }

    public static final /* synthetic */ void $anonfun$filterConsumerGroups$2(ClusterLinkSyncOffsets $this, ClusterLinkFilterInfo unusedFilter) {
        String string = unusedFilter.configuredFilter().filterType();
        String string2 = "EXCLUDE";
        if (string == null || !string.equals(string2)) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(199).append("The filter ").append(unusedFilter).append(" does not match any consumer group. This filter may not be ").append("required or the groups it referred to may not have the correct DESCRIBE ACL ").append("for the cluster link principal on the source cluster.").toString());
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$filterConsumerGroups$4(scala.collection.immutable.Set filtered$1) {
        return new StringBuilder(26).append("Filtered consumer groups: ").append(filtered$1).toString();
    }

    public static final /* synthetic */ void $anonfun$listConsumerGroupOffsets$5(ListConsumerGroupOffsetsResult result$2, scala.collection.mutable.Map groupFutures$1, MatchedGroup group) {
        Option$.MODULE$.apply((Object)result$2.partitionsToOffsetAndMetadata(group.name())).foreach((Function1 & Serializable)offsets -> (scala.collection.mutable.Map)groupFutures$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), offsets)));
    }

    public static final /* synthetic */ void $anonfun$listConsumerGroupOffsets$2(ClusterLinkSyncOffsets $this, String targetCluster$1, ConfluentAdmin admin$1, scala.collection.mutable.Map groupFutures$1, scala.collection.immutable.Set batch) {
        $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("Listing consumer group offsets on ").append(targetCluster$1).append(" cluster for following consumer groups: ").append(batch).toString());
        java.util.Map groupMap = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)batch.map((Function1 & Serializable)g -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)g.name()), (Object)ClusterLinkSyncOffsets$.MODULE$.ListOffsetsForAllPartitions()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        ListConsumerGroupOffsetsResult result = $this.listConsumerGroupOffsets(admin$1, groupMap);
        batch.foreach((Function1 & Serializable)group -> {
            ClusterLinkSyncOffsets.$anonfun$listConsumerGroupOffsets$5(result, groupFutures$1, group);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeMirrors$4(Tuple2 x$14) {
        return ((Option)x$14._1()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeMirrors$8(Tuple2 x$16) {
        return ((Option)x$16._2()).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$commitOffsets$3(CommittedOffsetTopicPartition tp$1, String reason$1) {
        return new StringBuilder(36).append("Not committing offsets for ").append(tp$1).append(" because ").append(reason$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$commitOffsets$5(OffsetAndMetadata sourceOffset$1, OffsetAndMetadata destOffset) {
        return destOffset.offset() == sourceOffset$1.offset();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$commitOffsets$2(ClusterLinkSyncOffsets $this, String consumerGroup$1, scala.collection.immutable.Map destTopicPartition$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            void var7_7;
            CommittedOffsetTopicPartition tp = (CommittedOffsetTopicPartition)x0$2._1();
            OffsetAndMetadata sourceOffset = (OffsetAndMetadata)x0$2._2();
            Tuple2<Object, String> tuple2 = tp.shouldSync();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            boolean shouldSync = tuple2._1$mcZ$sp();
            String reason = (String)tuple2._2();
            if (var7_7 == false) {
                void var8_8;
                $this.trace((Function0<String>)((Function0 & Serializable)() -> ClusterLinkSyncOffsets.$anonfun$commitOffsets$3(tp, (String)var8_8)));
                return false;
            }
            if (sourceOffset == null) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Not committing offsets for ").append(tp).append(" since no committed offset exists on the source cluster for ").append(consumerGroup$1).toString());
                return false;
            }
            if (destTopicPartition$1.get((Object)tp.destTopic()).exists((Function1 & Serializable)destOffset -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$commitOffsets$5(sourceOffset, destOffset)))) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(82).append("Not committing offsets for ").append(tp).append(" since offset=").append(sourceOffset).append(" is already committed on the destination.").toString());
                return false;
            }
            return true;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$handleDestinationClusterCommittedOffsets$4(ClusterLinkSyncOffsets $this, String group$2, Tuple2 topicPartitionAndOffsetMetadata) {
        if (((CommittedOffsetTopicPartition)topicPartitionAndOffsetMetadata._1()).shouldSync()._1$mcZ$sp()) {
            $this.metrics.consumerOffsetCommitSensor().record();
            $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("Committed offsets on destination cluster for consumer group ").append(group$2).toString());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$configuredToIncludeRemoteMirrors$2(ClusterLinkSyncOffsets $this, GroupClusterLinkFilter filter) {
        return FilterType$.MODULE$.fromString(filter.filterType()).contains((Object)FilterType$.MODULE$.INCLUDE()) && filter.effectiveTopicTypes($this.config().linkMode()).contains((Object)TopicType$.MODULE$.REMOTE_MIRROR());
    }

    public static final /* synthetic */ boolean $anonfun$configuredToIncludeRemoteMirrors$1(ClusterLinkSyncOffsets $this, GroupFilterJson groupFiltersJson) {
        return groupFiltersJson.filters().exists((Function1 & Serializable)filter -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$configuredToIncludeRemoteMirrors$2($this, filter)));
    }

    public ClusterLinkSyncOffsets(ClusterLinkDestClientManager clientManager, ClusterLinkMetadataManager metadataManager, ClusterLinkData linkData, Function0<ConfluentAdmin> destAdminFactory, ClusterLinkMetrics metrics, Time time, ClusterLinkRequestQuota quota) {
        this.clientManager = clientManager;
        this.metadataManager = metadataManager;
        this.linkData = linkData;
        this.destAdminFactory = destAdminFactory;
        this.metrics = metrics;
        super(clientManager.scheduler(), "ClusterLinkSyncOffsets", Predef$.MODULE$.Integer2int(clientManager.currentConfig().consumerOffsetSyncMs()), time, quota);
        this.config = clientManager.currentConfig();
        this.tasksOutstanding = 0;
        this.remoteLinkMetadata = None$.MODULE$;
        this.taskDesc = None$.MODULE$;
        this.describeMirrorsOptions = new DescribeMirrorsOptions().linkNames(Collections.singleton(linkData.linkName())).states(Collections.singleton(MirrorTopicDescription.State.ACTIVE.name()));
    }
}

