/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import kafka.cluster.Partition;
import kafka.server.link.ClusterLinkFetcher;
import kafka.server.link.EpochUpdateState;
import kafka.server.link.FetchState;
import kafka.server.link.FetcherAssignmentState;
import kafka.server.link.MirrorFailureType;
import kafka.server.link.MirrorFailureType$;
import kafka.server.link.MirrorFailureType$NoSourceRecords$;
import kafka.server.link.UnavailableLinkReason;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.common.replica.ReplicaStatus;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005eg!\u0002\u0011\"\u0001\u0005:\u0003\u0002\u0003\u0018\u0001\u0005\u000b\u0007I\u0011\u0001\u0019\t\u0011]\u0002!\u0011!Q\u0001\nEB\u0001\u0002\u000f\u0001\u0003\u0002\u0004%\t!\u000f\u0005\t}\u0001\u0011\t\u0019!C\u0001\u007f!AQ\t\u0001B\u0001B\u0003&!\b\u0003\u0005K\u0001\t\u0005\r\u0011\"\u0001L\u0011!y\u0005A!a\u0001\n\u0003\u0001\u0006\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0015\u0002'\t\u000bQ\u0003A\u0011A+\t\u000fi\u0003\u0001\u0019!C\u00017\"9Q\u000f\u0001a\u0001\n\u00031\bB\u0002=\u0001A\u0003&A\fC\u0004z\u0001\t\u0007I\u0011\u0001>\t\u000f\u0005=\u0001\u0001)A\u0005w\"I\u0011\u0011\u0003\u0001A\u0002\u0013\u0005\u00111\u0003\u0005\n\u0003C\u0001\u0001\u0019!C\u0001\u0003GA\u0001\"a\n\u0001A\u0003&\u0011Q\u0003\u0005\n\u0003W\u0001\u0001\u0019!C\u0001\u0003'A\u0011\"!\f\u0001\u0001\u0004%\t!a\f\t\u0011\u0005M\u0002\u0001)Q\u0005\u0003+A\u0011\"a\u000e\u0001\u0001\u0004%\t!!\u000f\t\u0013\u0005\r\u0003\u00011A\u0005\u0002\u0005\u0015\u0003\u0002CA%\u0001\u0001\u0006K!a\u000f\t\u0013\u00055\u0003\u00011A\u0005\u0002\u0005=\u0003\"CA-\u0001\u0001\u0007I\u0011AA.\u0011!\ty\u0006\u0001Q!\n\u0005E\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003c\u0002A\u0011AA:\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+Cq!a&\u0001\t\u0003\tI\nC\u0004\u0002 \u0002!\t!!)\u0003#A\u000b'\u000f^5uS>t\u0017I\u001c3Ti\u0006$XM\u0003\u0002#G\u0005!A.\u001b8l\u0015\t!S%\u0001\u0004tKJ4XM\u001d\u0006\u0002M\u0005)1.\u00194lCN\u0011\u0001\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\u0013A\f'\u000f^5uS>t7\u0001A\u000b\u0002cA\u0011!'N\u0007\u0002g)\u0011A'J\u0001\bG2,8\u000f^3s\u0013\t14GA\u0005QCJ$\u0018\u000e^5p]\u0006Q\u0001/\u0019:uSRLwN\u001c\u0011\u0002)1\f7\u000f^#q_\u000eDW\u000b\u001d3bi\u0016\u001cF/\u0019;f+\u0005Q\u0004CA\u001e=\u001b\u0005\t\u0013BA\u001f\"\u0005A)\u0005o\\2i+B$\u0017\r^3Ti\u0006$X-\u0001\rmCN$X\t]8dQV\u0003H-\u0019;f'R\fG/Z0%KF$\"\u0001Q\"\u0011\u0005%\n\u0015B\u0001\"+\u0005\u0011)f.\u001b;\t\u000f\u0011#\u0011\u0011!a\u0001u\u0005\u0019\u0001\u0010J\u0019\u0002+1\f7\u000f^#q_\u000eDW\u000b\u001d3bi\u0016\u001cF/\u0019;fA!\u0012Qa\u0012\t\u0003S!K!!\u0013\u0016\u0003\u0011Y|G.\u0019;jY\u0016\faCZ3uG\",'/Q:tS\u001etW.\u001a8u'R\fG/Z\u000b\u0002\u0019B\u00111(T\u0005\u0003\u001d\u0006\u0012aCR3uG\",'/Q:tS\u001etW.\u001a8u'R\fG/Z\u0001\u001bM\u0016$8\r[3s\u0003N\u001c\u0018n\u001a8nK:$8\u000b^1uK~#S-\u001d\u000b\u0003\u0001FCq\u0001R\u0004\u0002\u0002\u0003\u0007A*A\fgKR\u001c\u0007.\u001a:BgNLwM\\7f]R\u001cF/\u0019;fA!\u0012\u0001bR\u0001\u0007y%t\u0017\u000e\u001e \u0015\tY;\u0006,\u0017\t\u0003w\u0001AQAL\u0005A\u0002EBQ\u0001O\u0005A\u0002iBQAS\u0005A\u00021\u000bAc]8ve\u000e,G*Z1eKJ\fe\u000eZ#q_\u000eDW#\u0001/\u0011\u0005u\u0013hB\u00010p\u001d\tyFN\u0004\u0002aU:\u0011\u0011m\u001a\b\u0003E\u0016l\u0011a\u0019\u0006\u0003I>\na\u0001\u0010:p_Rt\u0014\"\u00014\u0002\u0007=\u0014x-\u0003\u0002iS\u00061\u0011\r]1dQ\u0016T\u0011AZ\u0005\u0003M-T!\u0001[5\n\u00055t\u0017aB2mS\u0016tGo\u001d\u0006\u0003M-L!\u0001]9\u0002\u00115+G/\u00193bi\u0006T!!\u001c8\n\u0005M$(A\u0004'fC\u0012,'/\u00118e\u000bB|7\r\u001b\u0006\u0003aF\f\u0001d]8ve\u000e,G*Z1eKJ\fe\u000eZ#q_\u000eDw\fJ3r)\t\u0001u\u000fC\u0004E\u0017\u0005\u0005\t\u0019\u0001/\u0002+M|WO]2f\u0019\u0016\fG-\u001a:B]\u0012,\u0005o\\2iA\u0005qa-Y5mkJ,7\u000b^1si6\u001bX#A>\u0011\u0007q\fY!D\u0001~\u0015\tqx0\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003\u0003\t\u0019!\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u0002\u0002\b\u0005!Q\u000f^5m\u0015\t\tI!\u0001\u0003kCZ\f\u0017bAA\u0007{\nQ\u0011\t^8nS\u000eduN\\4\u0002\u001f\u0019\f\u0017\u000e\\;sKN#\u0018M\u001d;Ng\u0002\nq\u0002\\1ti\u001a\u000b\u0017\u000e\\;sKRK\b/Z\u000b\u0003\u0003+\u0001R!KA\f\u00037I1!!\u0007+\u0005\u0019y\u0005\u000f^5p]B\u00191(!\b\n\u0007\u0005}\u0011EA\tNSJ\u0014xN\u001d$bS2,(/\u001a+za\u0016\f1\u0003\\1ti\u001a\u000b\u0017\u000e\\;sKRK\b/Z0%KF$2\u0001QA\u0013\u0011!!\u0005#!AA\u0002\u0005U\u0011\u0001\u00057bgR4\u0015-\u001b7ve\u0016$\u0016\u0010]3!Q\t\tr)\u0001\bba&4\u0015-\u001b7ve\u0016$\u0016\u0010]3\u0002%\u0005\u0004\u0018NR1jYV\u0014X\rV=qK~#S-\u001d\u000b\u0004\u0001\u0006E\u0002\u0002\u0003#\u0014\u0003\u0003\u0005\r!!\u0006\u0002\u001f\u0005\u0004\u0018NR1jYV\u0014X\rV=qK\u0002B#\u0001F$\u0002\u0015\u0019,Go\u00195Ti\u0006$X-\u0006\u0002\u0002<A)\u0011&a\u0006\u0002>A\u00191(a\u0010\n\u0007\u0005\u0005\u0013E\u0001\u0006GKR\u001c\u0007n\u0015;bi\u0016\faBZ3uG\"\u001cF/\u0019;f?\u0012*\u0017\u000fF\u0002A\u0003\u000fB\u0001\u0002\u0012\f\u0002\u0002\u0003\u0007\u00111H\u0001\fM\u0016$8\r[*uCR,\u0007\u0005\u000b\u0002\u0018\u000f\u00069a-\u001a;dQ\u0016\u0014XCAA)!\u0015I\u0013qCA*!\rY\u0014QK\u0005\u0004\u0003/\n#AE\"mkN$XM\u001d'j].4U\r^2iKJ\f1BZ3uG\",'o\u0018\u0013fcR\u0019\u0001)!\u0018\t\u0011\u0011K\u0012\u0011!a\u0001\u0003#\n\u0001BZ3uG\",'\u000f\t\u0015\u00035\u001d\u000b\u0001#\u001e9eCR,W\t]8dQN#\u0018\r^3\u0015\t\u0005\u001d\u0014Q\u000e\t\u0004S\u0005%\u0014bAA6U\t9!i\\8mK\u0006t\u0007BBA87\u0001\u0007A,\u0001\bmK\u0006$WM]!oI\u0016\u0003xn\u00195\u0002\u001b=tG*\u001b8l\r\u0006LG.\u001e:f)!\t)(!!\u0002\u0006\u0006%\u0005cB\u0015\u0002x\u0005m\u0014qM\u0005\u0004\u0003sR#A\u0002+va2,'\u0007E\u0002*\u0003{J1!a +\u0005\u0011auN\\4\t\u000f\u0005\rE\u00041\u0001\u0002\u001c\u0005Ya-Y5mkJ,G+\u001f9f\u0011\u001d\t9\t\ba\u0001\u0003w\n1A\\8x\u0011\u001d\tY\t\ba\u0001\u0003\u001b\u000baB]3uef$\u0016.\\3pkRl5\u000fE\u0002*\u0003\u001fK1!!%+\u0005\rIe\u000e^\u0001\u0012e\u0016\u001cX\r^#q_\u000eDW\u000b\u001d3bi\u0016\u001cH#\u0001!\u0002!\rdW-\u0019:MS:\\g)Y5mkJ,G\u0003BA4\u00037Cq!!(\u001f\u0001\u0004\t9'A\u0007iCNtUm\u001e*fG>\u0014Hm]\u0001\f[&\u0014(o\u001c:Ti\u0006$X\r\u0006\u0004\u0002$\u0006m\u0016Q\u001a\t\u0005\u0003K\u000b)L\u0004\u0003\u0002(\u0006EVBAAU\u0015\u0011\tY+!,\u0002\u000fI,\u0007\u000f\\5dC*\u0019\u0011q\u00168\u0002\r\r|W.\\8o\u0013\u0011\t\u0019,!+\u0002\u001bI+\u0007\u000f\\5dCN#\u0018\r^;t\u0013\u0011\t9,!/\u0003\u00155K'O]8s\u0013:4wN\u0003\u0003\u00024\u0006%\u0006bBA_?\u0001\u0007\u0011qX\u0001\u0016a\u0016\u00148/[:uK:$X*\u001b:s_J\u001cF/\u0019;f!\u0011\t\t-a2\u000f\t\u0005\u0015\u00161Y\u0005\u0005\u0003\u000b\fI,\u0001\u0006NSJ\u0014xN]%oM>LA!!3\u0002L\n)1\u000b^1uK*!\u0011QYA]\u0011\u001d\tym\ba\u0001\u0003#\fQ#\u001e8bm\u0006LG.\u00192mK2Kgn\u001b*fCN|g\u000eE\u0003*\u0003/\t\u0019\u000eE\u0002<\u0003+L1!a6\"\u0005U)f.\u0019<bS2\f'\r\\3MS:\\'+Z1t_:\u0004")
public class PartitionAndState {
    private final Partition partition;
    private volatile EpochUpdateState lastEpochUpdateState;
    private volatile FetcherAssignmentState fetcherAssignmentState;
    private Metadata.LeaderAndEpoch sourceLeaderAndEpoch;
    private final AtomicLong failureStartMs;
    private volatile Option<MirrorFailureType> lastFailureType;
    private volatile Option<MirrorFailureType> apiFailureType;
    private volatile Option<FetchState> fetchState;
    private volatile Option<ClusterLinkFetcher> fetcher;

    public Partition partition() {
        return this.partition;
    }

    public EpochUpdateState lastEpochUpdateState() {
        return this.lastEpochUpdateState;
    }

    public void lastEpochUpdateState_$eq(EpochUpdateState x$1) {
        this.lastEpochUpdateState = x$1;
    }

    public FetcherAssignmentState fetcherAssignmentState() {
        return this.fetcherAssignmentState;
    }

    public void fetcherAssignmentState_$eq(FetcherAssignmentState x$1) {
        this.fetcherAssignmentState = x$1;
    }

    public Metadata.LeaderAndEpoch sourceLeaderAndEpoch() {
        return this.sourceLeaderAndEpoch;
    }

    public void sourceLeaderAndEpoch_$eq(Metadata.LeaderAndEpoch x$1) {
        this.sourceLeaderAndEpoch = x$1;
    }

    public AtomicLong failureStartMs() {
        return this.failureStartMs;
    }

    public Option<MirrorFailureType> lastFailureType() {
        return this.lastFailureType;
    }

    public void lastFailureType_$eq(Option<MirrorFailureType> x$1) {
        this.lastFailureType = x$1;
    }

    public Option<MirrorFailureType> apiFailureType() {
        return this.apiFailureType;
    }

    public void apiFailureType_$eq(Option<MirrorFailureType> x$1) {
        this.apiFailureType = x$1;
    }

    public Option<FetchState> fetchState() {
        return this.fetchState;
    }

    public void fetchState_$eq(Option<FetchState> x$1) {
        this.fetchState = x$1;
    }

    public Option<ClusterLinkFetcher> fetcher() {
        return this.fetcher;
    }

    public void fetcher_$eq(Option<ClusterLinkFetcher> x$1) {
        this.fetcher = x$1;
    }

    public boolean updateEpochState(Metadata.LeaderAndEpoch leaderAndEpoch) {
        BooleanRef updated = BooleanRef.create((boolean)false);
        leaderAndEpoch.epoch.ifPresent(currentEpoch -> {
            Option<Object> option;
            EpochUpdateState epochUpdateState = this.lastEpochUpdateState();
            if (epochUpdateState != null) {
                Option<Object> option2 = epochUpdateState.sourceEpoch();
                int lastEmptyUpdates = epochUpdateState.numEmptyEpochUpdates();
                if (option2 instanceof Some) {
                    int lastEpoch = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    if (Predef$.MODULE$.Integer2int(currentEpoch) > lastEpoch) {
                        this.lastEpochUpdateState_$eq(new EpochUpdateState((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(currentEpoch))), lastEmptyUpdates + 1));
                        updated$1.elem = true;
                        return;
                    }
                    return;
                }
            }
            if (epochUpdateState != null && None$.MODULE$.equals(option = epochUpdateState.sourceEpoch())) {
                this.lastEpochUpdateState_$eq(new EpochUpdateState((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(currentEpoch))), 1));
                updated$1.elem = true;
                return;
            }
            throw new MatchError((Object)epochUpdateState);
        });
        return updated.elem;
    }

    public Tuple2<Object, Object> onLinkFailure(MirrorFailureType failureType, long now, int retryTimeoutMs) {
        boolean apiFailureTypeChanged;
        long remainingRetryMs;
        Option<MirrorFailureType> lastFailureType = this.lastFailureType();
        this.lastFailureType_$eq((Option<MirrorFailureType>)new Some((Object)failureType));
        if (failureType.persistFailure() && !lastFailureType.exists((Function1 & Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)x$39.persistFailure()))) {
            this.failureStartMs().set(now);
        } else {
            this.failureStartMs().compareAndSet(0L, now);
        }
        long l = remainingRetryMs = failureType.retriable() ? this.failureStartMs().get() + (long)retryTimeoutMs - now : 0L;
        boolean bl = remainingRetryMs <= 0L || !failureType.retriable() ? !this.apiFailureType().contains((Object)failureType) : (apiFailureTypeChanged = false);
        if (apiFailureTypeChanged) {
            this.apiFailureType_$eq((Option<MirrorFailureType>)new Some((Object)failureType));
        }
        return new Tuple2.mcJZ.sp(remainingRetryMs, apiFailureTypeChanged);
    }

    public void resetEpochUpdates() {
        this.lastEpochUpdateState_$eq(new EpochUpdateState(this.lastEpochUpdateState().sourceEpoch(), 0));
    }

    public boolean clearLinkFailure(boolean hasNewRecords) {
        if (hasNewRecords && this.lastEpochUpdateState().numEmptyEpochUpdates() > 0) {
            this.resetEpochUpdates();
        }
        this.apiFailureType_$eq((Option<MirrorFailureType>)None$.MODULE$);
        this.lastFailureType_$eq((Option<MirrorFailureType>)None$.MODULE$);
        return this.failureStartMs().getAndSet(0L) != 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReplicaStatus.MirrorInfo mirrorState(ReplicaStatus.MirrorInfo.State persistentMirrorState, Option<UnavailableLinkReason> unavailableLinkReason) {
        ReplicaStatus.MirrorInfo.State state;
        Object object;
        Option<MirrorFailureType> option = this.apiFailureType();
        if (option instanceof Some) {
            object = this.apiFailureType();
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            object = this.lastEpochUpdateState().numEmptyEpochUpdates() > MirrorFailureType$NoSourceRecords$.MODULE$.ConsecutiveEpochChangeLowerThreshold() ? new Some((Object)MirrorFailureType$NoSourceRecords$.MODULE$) : None$.MODULE$;
        }
        None$ currentFailure = object;
        Option<FetchState> currentFetchState = this.fetchState();
        if (ReplicaStatus.MirrorInfo.State.ACTIVE.equals(persistentMirrorState)) {
            ReplicaStatus.MirrorInfo.State state2;
            Option option2 = currentFailure.map((Function1 & Serializable)x$40 -> x$40.replicaStatusState());
            if (option2 instanceof Some && ReplicaStatus.MirrorInfo.State.ACTIVE.equals(state2 = (ReplicaStatus.MirrorInfo.State)((Some)option2).value()) ? true : None$.MODULE$.equals(option2)) {
                if (unavailableLinkReason instanceof Some) {
                    UnavailableLinkReason e = (UnavailableLinkReason)((Some)unavailableLinkReason).value();
                    state = (ReplicaStatus.MirrorInfo.State)MirrorFailureType$.MODULE$.failureType(e).map((Function1 & Serializable)x$41 -> x$41.replicaStatusState()).getOrElse((Function0 & Serializable)() -> ReplicaStatus.MirrorInfo.State.ACTIVE);
                } else {
                    state = ReplicaStatus.MirrorInfo.State.ACTIVE;
                }
            } else {
                if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                state = (ReplicaStatus.MirrorInfo.State)((Some)option2).value();
            }
        } else {
            state = persistentMirrorState;
        }
        ReplicaStatus.MirrorInfo.State mirrorState = state;
        return new ReplicaStatus.MirrorInfo(mirrorState, BoxesRunTime.unboxToLong((Object)currentFetchState.map((Function1 & Serializable)x$42 -> BoxesRunTime.boxToLong((long)x$42.lastFetchTimeMs())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)), BoxesRunTime.unboxToLong((Object)currentFetchState.map((Function1 & Serializable)x$43 -> BoxesRunTime.boxToLong((long)x$43.lastFetchHighWatermark())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
    }

    public PartitionAndState(Partition partition, EpochUpdateState lastEpochUpdateState, FetcherAssignmentState fetcherAssignmentState) {
        this.partition = partition;
        this.lastEpochUpdateState = lastEpochUpdateState;
        this.fetcherAssignmentState = fetcherAssignmentState;
        this.sourceLeaderAndEpoch = Metadata.LeaderAndEpoch.noLeaderOrEpoch();
        this.failureStartMs = new AtomicLong();
        this.lastFailureType = None$.MODULE$;
        this.apiFailureType = None$.MODULE$;
        this.fetchState = None$.MODULE$;
        this.fetcher = None$.MODULE$;
    }
}

