/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import kafka.controller.StateChangeLogger;
import kafka.server.CachedControllerId;
import kafka.server.KRaftCachedControllerId$;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Logging;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.MetadataVersion;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0005\u0011\u001dc\u0001B\u001f?\u0001\u0015C\u0001B\u0017\u0001\u0003\u0006\u0004%\ta\u0017\u0005\t?\u0002\u0011\t\u0011)A\u00059\")\u0001\r\u0001C\u0001C\"9A\r\u0001a\u0001\n\u0013)\u0007bB9\u0001\u0001\u0004%IA\u001d\u0005\u0007q\u0002\u0001\u000b\u0015\u00024\t\u000fu\u0004!\u0019!C\u0005}\"9\u00111\u0002\u0001!\u0002\u0013y\bbBA\u0007\u0001\u0011%\u0011q\u0002\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\tY\u0006\u0001C\u0005\u0003;Bq!a1\u0001\t\u0013\t)\rC\u0004\u0002p\u0002!I!!=\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b!9!q\u0003\u0001\u0005\n\te\u0001b\u0002B\u0010\u0001\u0011%!\u0011\u0005\u0005\b\u0005k\u0001A\u0011\tB\u001c\u0011%\u0011Y\u0006AI\u0001\n\u0003\u0011i\u0006C\u0005\u0003t\u0001\t\n\u0011\"\u0001\u0003^!9!Q\u000f\u0001\u0005B\t]\u0004b\u0002B@\u0001\u0011\u0005!\u0011\u0011\u0005\b\u0005G\u0003A\u0011\tBS\u0011\u001d\u0011\t\f\u0001C!\u0005gCqA!0\u0001\t\u0003\u0012y\fC\u0004\u0003F\u0002!\tEa2\t\u000f\t-\u0007\u0001\"\u0001\u0003N\"9!\u0011\u001b\u0001\u0005\u0002\tM\u0007b\u0002Bl\u0001\u0011\u0005#\u0011\u001c\u0005\b\u0005/\u0004A\u0011\u0002Bw\u0011\u001d\u0011\t\u0010\u0001C!\u0005gDqA!?\u0001\t\u0003\u0012Y\u0010C\u0004\u0004\u0006\u0001!\tea\u0002\t\u000f\r-\u0001\u0001\"\u0011\u0004\u000e!911\u0003\u0001\u0005B\rU\u0001bBB\u0017\u0001\u0011\u00051q\u0006\u0005\b\u0007g\u0001A\u0011IB\u001b\u0011\u001d\u0019Y\u0004\u0001C!\u0007{Aqaa\u0011\u0001\t\u0003\u001a)\u0005C\u0004\u0004J\u0001!\tea\u0013\t\u000f\r=\u0003\u0001\"\u0011\u0004R!91\u0011\f\u0001\u0005B\rm\u0003bBB3\u0001\u0011\u00053q\r\u0005\b\u0007c\u0002A\u0011IB:\u0011\u001d\u0019)\b\u0001C\u0005\u0007oBqaa\u001f\u0001\t\u0003\u0019i\bC\u0004\u0004\n\u0002!\tea#\t\u000f\re\u0005\u0001\"\u0001\u0004\u001c\"91Q\u0014\u0001\u0005\u0002\r}\u0005bBBS\u0001\u0011\u00053q\u0015\u0005\b\u0007K\u0003A\u0011IBV\u0011\u001d\u0019y\u000b\u0001C\u0001\u0007cCqaa.\u0001\t\u0003\u001aI\fC\u0004\u0004P\u0002!\ta!5\t\u000f\r\r\b\u0001\"\u0001\u0004f\"91Q\u001f\u0001\u0005B\r]\bb\u0002C\u0003\u0001\u0011\u0005Cq\u0001\u0005\b\t\u001f\u0001A\u0011\tC\t\u0011\u001d!)\u0002\u0001C!\t/Aq\u0001\"\f\u0001\t\u0003\"y\u0003C\u0004\u0005D\u0001!\t\u0005\"\u0012\u0003%-\u0013\u0016M\u001a;NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0006\u0003\u007f\u0001\u000b\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003\u0003\n\u000baa]3sm\u0016\u0014(\"A\"\u0002\u000b-\fgm[1\u0004\u0001M)\u0001A\u0012'Q-B\u0011qIS\u0007\u0002\u0011*\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\n1\u0011I\\=SK\u001a\u0004\"!\u0014(\u000e\u0003\u0001K!a\u0014!\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f!\t\tF+D\u0001S\u0015\t\u0019&)A\u0003vi&d7/\u0003\u0002V%\n9Aj\\4hS:<\u0007CA,Y\u001b\u0005q\u0014BA-?\u0005A\u0019uN\u001c4jOJ+\u0007o\\:ji>\u0014\u00180\u0001\u0005ce>\\WM]%e+\u0005a\u0006CA$^\u0013\tq\u0006JA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\rqJg.\u001b;?)\t\u00117\r\u0005\u0002X\u0001!)!l\u0001a\u00019\u0006iqlY;se\u0016tG/S7bO\u0016,\u0012A\u001a\t\u0003O>l\u0011\u0001\u001b\u0006\u0003S*\fQ![7bO\u0016T!aQ6\u000b\u00051l\u0017AB1qC\u000eDWMC\u0001o\u0003\ry'oZ\u0005\u0003a\"\u0014Q\"T3uC\u0012\fG/Y%nC\u001e,\u0017!E0dkJ\u0014XM\u001c;J[\u0006<Wm\u0018\u0013fcR\u00111O\u001e\t\u0003\u000fRL!!\u001e%\u0003\tUs\u0017\u000e\u001e\u0005\bo\u0016\t\t\u00111\u0001g\u0003\rAH%M\u0001\u000f?\u000e,(O]3oi&k\u0017mZ3!Q\t1!\u0010\u0005\u0002Hw&\u0011A\u0010\u0013\u0002\tm>d\u0017\r^5mK\u0006\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0016\u0003}\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000b\u0011\u0015AC2p]R\u0014x\u000e\u001c7fe&!\u0011\u0011BA\u0002\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u0001\u0013gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\b%\u0001\rnCf\u0014WMR5mi\u0016\u0014\u0018\t\\5wKJ+\u0007\u000f\\5dCN$\"\"!\u0005\u0002.\u0005=\u0012\u0011HA'!\u0019\t\u0019\"!\b\u0002\"5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0003vi&d'BAA\u000e\u0003\u0011Q\u0017M^1\n\t\u0005}\u0011Q\u0003\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\u0011\t9#!\u0007\u0002\t1\fgnZ\u0005\u0005\u0003W\t)CA\u0004J]R,w-\u001a:\t\u000b%L\u0001\u0019\u00014\t\u000f\u0005E\u0012\u00021\u0001\u00024\u00059!M]8lKJ\u001c\b\u0003B$\u00026qK1!a\u000eI\u0005\u0015\t%O]1z\u0011\u001d\tY$\u0003a\u0001\u0003{\tA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004B!a\u0010\u0002J5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%A\u0004oKR<xN]6\u000b\u0007\u0005\u001d#.\u0001\u0004d_6lwN\\\u0005\u0005\u0003\u0017\n\tE\u0001\u0007MSN$XM\\3s\u001d\u0006lW\rC\u0004\u0002P%\u0001\r!!\u0015\u00025\u0019LG\u000e^3s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\u0011\u0007\u001d\u000b\u0019&C\u0002\u0002V!\u0013qAQ8pY\u0016\fg.\u0001\u0007dkJ\u0014XM\u001c;J[\u0006<W\rF\u0001g\u0003Q9W\r\u001e)beRLG/[8o\u001b\u0016$\u0018\rZ1uCRa\u0011qLAR\u0003K\u000bI,a/\u0002@B)q)!\u0019\u0002f%\u0019\u00111\r%\u0003\r=\u0003H/[8o!\u0019\t9'a\u001e\u0002~9!\u0011\u0011NA:\u001d\u0011\tY'!\u001d\u000e\u0005\u00055$bAA8\t\u00061AH]8pizJ\u0011!S\u0005\u0004\u0003kB\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003s\nYH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\t)\b\u0013\t\u0005\u0003\u007f\niJ\u0004\u0003\u0002\u0002\u0006]e\u0002BAB\u0003'sA!!\"\u0002\u0012:!\u0011qQAH\u001d\u0011\tI)!$\u000f\t\u0005-\u00141R\u0005\u0002]&\u0011A.\\\u0005\u0003\u0007.L1!a\u0012k\u0013\u0011\t)*!\u0012\u0002\u000f5,7o]1hK&!\u0011\u0011TAN\u0003QiU\r^1eCR\f'+Z:q_:\u001cX\rR1uC*!\u0011QSA#\u0013\u0011\ty*!)\u000335+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0007+\u0019:uSRLwN\u001c\u0006\u0005\u00033\u000bY\nC\u0003j\u0017\u0001\u0007a\rC\u0004\u0002(.\u0001\r!!+\u0002\u0013Q|\u0007/[2OC6,\u0007\u0003BAV\u0003gsA!!,\u00020B\u0019\u00111\u000e%\n\u0007\u0005E\u0006*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\u000b9L\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003cC\u0005bBA\u001e\u0017\u0001\u0007\u0011Q\b\u0005\b\u0003{[\u0001\u0019AA)\u0003e)'O]8s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\t\u000f\u0005\u00057\u00021\u0001\u0002R\u0005IRM\u001d:peVs\u0017M^1jY\u0006\u0014G.\u001a'jgR,g.\u001a:t\u00031:W\r\u001e)beRLG/[8o\u001b\u0016$\u0018\rZ1uC\u001a{'\u000fR3tGJL'-\u001a+pa&\u001c'+Z:q_:\u001cX\r\u0006\u0007\u0002H\u0006\u0005\u00181]As\u0003O\fY\u000f\u0005\u0004H\u0003\u0013\fi\rX\u0005\u0004\u0003\u0017D%A\u0002+va2,'\u0007E\u0003H\u0003C\ny\r\u0005\u0004\u0002h\u0005E\u00171[\u0005\u0005\u0003?\tY\b\u0005\u0003\u0002V\u0006mg\u0002BAA\u0003/LA!!7\u0002\u001c\u0006\u0019C)Z:de&\u0014W\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d*fgB|gn]3ECR\f\u0017\u0002BAo\u0003?\u0014\u0001\u0006R3tGJL'-\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\:SKN\u0004xN\\:f!\u0006\u0014H/\u001b;j_:TA!!7\u0002\u001c\")\u0011\u000e\u0004a\u0001M\"9\u0011q\u0015\u0007A\u0002\u0005%\u0006bBA\u001e\u0019\u0001\u0007\u0011Q\b\u0005\u0007\u0003Sd\u0001\u0019\u0001/\u0002\u0015M$\u0018M\u001d;J]\u0012,\u0007\u0010\u0003\u0004\u0002n2\u0001\r\u0001X\u0001\t[\u0006D8i\\;oi\u0006\u0011r-\u001a;PM\u001ad\u0017N\\3SKBd\u0017nY1t)!\t\t\"a=\u0002v\n\r\u0001\"B5\u000e\u0001\u00041\u0007bBA|\u001b\u0001\u0007\u0011\u0011`\u0001\na\u0006\u0014H/\u001b;j_:\u0004B!a?\u0002\u00006\u0011\u0011Q \u0006\u0003\u007f)LAA!\u0001\u0002~\n)\u0002+\u0019:uSRLwN\u001c*fO&\u001cHO]1uS>t\u0007bBA\u001e\u001b\u0001\u0007\u0011QH\u0001\u0011SN\u0014V\r\u001d7jG\u0006|eM\u001a7j]\u0016$\u0002\"!\u0015\u0003\n\t-!Q\u0002\u0005\b\u0003ot\u0001\u0019AA}\u0011\u001d\tYD\u0004a\u0001\u0003{AqAa\u0004\u000f\u0001\u0004\u0011\t\"\u0001\u0004ce>\\WM\u001d\t\u0005\u0003w\u0014\u0019\"\u0003\u0003\u0003\u0016\u0005u(A\u0005\"s_.,'OU3hSN$(/\u0019;j_:\fQ#[:SKBd\u0017nY1J]>3g\r\\5oK\u0012K'\u000f\u0006\u0004\u0002R\tm!Q\u0004\u0005\b\u0005\u001fy\u0001\u0019\u0001B\t\u0011\u001d\t9p\u0004a\u0001\u0003s\f\u0001cZ3u\u00032Lg/Z#oIB|\u0017N\u001c;\u0015\u0011\t\r\"Q\u0006B\u0018\u0005g\u0001RaRA1\u0005K\u0001BAa\n\u0003*5\u0011\u0011QI\u0005\u0005\u0005W\t)E\u0001\u0003O_\u0012,\u0007\"B5\u0011\u0001\u00041\u0007B\u0002B\u0019!\u0001\u0007A,\u0001\u0002jI\"9\u00111\b\tA\u0002\u0005u\u0012\u0001E4fiR{\u0007/[2NKR\fG-\u0019;b))\u0011IDa\u0013\u0003V\t]#\u0011\f\t\u0007\u0005w\u0011\tE!\u0012\u000e\u0005\tu\"b\u0001B \u0011\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\r#Q\b\u0002\u0004'\u0016\f\b\u0003BA@\u0005\u000fJAA!\u0013\u0002\"\n)R*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a+pa&\u001c\u0007b\u0002B'#\u0001\u0007!qJ\u0001\u0007i>\u0004\u0018nY:\u0011\r\tm\"\u0011KAU\u0013\u0011\u0011\u0019F!\u0010\u0003\u0007M+G\u000fC\u0004\u0002<E\u0001\r!!\u0010\t\u0013\u0005u\u0016\u0003%AA\u0002\u0005E\u0003\"CAa#A\u0005\t\u0019AA)\u0003i9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011yF\u000b\u0003\u0002R\t\u00054F\u0001B2!\u0011\u0011)Ga\u001c\u000e\u0005\t\u001d$\u0002\u0002B5\u0005W\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t5\u0004*\u0001\u0006b]:|G/\u0019;j_:LAA!\u001d\u0003h\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00025\u001d,G\u000fV8qS\u000elU\r^1eCR\fG\u0005Z3gCVdG\u000f\n\u001b\u0002\u0019\u001d,G/\u00117m)>\u0004\u0018nY:\u0015\t\t=#\u0011\u0010\u0005\b\u0005w\"\u0002\u0019\u0001B?\u0003=!XM\\1oiB\u0013XMZ5y\u001fB$\b#B$\u0002b\u0005%\u0016\u0001K4fiR{\u0007/[2NKR\fG-\u0019;b\r>\u0014H)Z:de&\u0014W\rV8qS\u000e\u0014Vm\u001d9p]N,G\u0003\u0004BB\u0005\u0017\u0013yI!%\u0003\u001c\n}\u0005\u0003\u0002BC\u0005\u000fk!!a'\n\t\t%\u00151\u0014\u0002$\t\u0016\u001c8M]5cKR{\u0007/[2QCJ$\u0018\u000e^5p]N\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u001d\u0011i%\u0006a\u0001\u0005\u001b\u0003b!a\u001a\u0002x\u0005%\u0006bBA\u001e+\u0001\u0007\u0011Q\b\u0005\b\u0005'+\u0002\u0019\u0001BK\u0003a!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cF/\u0019:u\u0013:$W\r\u001f\t\u0007\u000f\n]\u0015\u0011\u0016/\n\u0007\te\u0005JA\u0005Gk:\u001cG/[8oc!1!QT\u000bA\u0002q\u000b\u0011$\\1yS6,XNT;nE\u0016\u0014xJ\u001a)beRLG/[8og\"9!\u0011U\u000bA\u0002\u0005E\u0013AG5h]>\u0014X\rV8qS\u000e\u001cx+\u001b;i\u000bb\u001cW\r\u001d;j_:\u001c\u0018AE4fiR{\u0007/[2QCJ$\u0018\u000e^5p]N$BAa*\u00030B1!1\bB)\u0005S\u0003BAa\n\u0003,&!!QVA#\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a*\u0017\u0001\u0004\tI+\u0001\u0006hKR$v\u000e]5d\u0013\u0012$BA!.\u0003<B!!q\u0005B\\\u0013\u0011\u0011I,!\u0012\u0003\tU+\u0018\u000e\u001a\u0005\b\u0003O;\u0002\u0019AAU\u000319W\r\u001e+pa&\u001cg*Y7f)\u0011\u0011iH!1\t\u000f\t\r\u0007\u00041\u0001\u00036\u00069Ao\u001c9jG&#\u0017A\u00045bg\u0006c\u0017N^3Ce>\\WM\u001d\u000b\u0005\u0003#\u0012I\rC\u0003[3\u0001\u0007A,\u0001\bjg\n\u0013xn[3s\r\u0016t7-\u001a3\u0015\t\u0005E#q\u001a\u0005\u00065j\u0001\r\u0001X\u0001\u0015SN\u0014%o\\6feNCW\u000f\u001e;j]\u001e$un\u001e8\u0015\t\u0005E#Q\u001b\u0005\u00065n\u0001\r\u0001X\u0001\u0010O\u0016$\u0018\t\\5wK\n\u0013xn[3sgR\u0011!1\u001c\t\u0007\u0003O\u0012iN!9\n\t\t}\u00171\u0010\u0002\t\u0013R,'/\u00192mKB!!1\u001dBu\u001b\t\u0011)OC\u0002\u0003h*\fQ!\u00193nS:LAAa;\u0003f\nq!I]8lKJlU\r^1eCR\fG\u0003\u0002Bn\u0005_DQ![\u000fA\u0002\u0019\f!cZ3u\u00032Lg/\u001a\"s_.,'OT8eKR1!1\u0005B{\u0005oDQA\u0017\u0010A\u0002qCq!a\u000f\u001f\u0001\u0004\ti$A\u0007hKR\u0014%o\\6feR\u000bwm\u001d\u000b\u0005\u0005{\u001c\u0019\u0001\u0005\u0005\u0003<\t}\u0018\u0011VAU\u0013\u0011\u0019\tA!\u0010\u0003\u00075\u000b\u0007\u000fC\u0003[?\u0001\u0007A,A\bhKR\u0014%o\\6fe\u000e+G\u000e\\%e)\ra6\u0011\u0002\u0005\u00065\u0002\u0002\r\u0001X\u0001\u0014O\u0016$\u0018\t\\5wK\n\u0013xn[3s\u001d>$Wm\u001d\u000b\u0005\u0007\u001f\u0019\t\u0002\u0005\u0004\u0003<\t\u0005#Q\u0005\u0005\b\u0003w\t\u0003\u0019AA\u001f\u0003A9W\r\u001e)beRLG/[8o\u0013:4w\u000e\u0006\u0004\u0004\u0018\r\u001d2\u0011\u0006\t\u0006\u000f\u0006\u00054\u0011\u0004\t\u0005\u00077\u0019\tC\u0004\u0003\u0002\u0002\u000eu\u0011\u0002BB\u0010\u00037\u000b\u0011$\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fR1uC&!11EB\u0013\u0005q)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016TAaa\b\u0002\u001c\"9\u0011q\u0015\u0012A\u0002\u0005%\u0006BBB\u0016E\u0001\u0007A,A\u0006qCJ$\u0018\u000e^5p]&#\u0017!E4fiB\u000b'\u000f^5uS>t\u0017J\u001c4pgR\u00111\u0011\u0007\t\u0007\u0005w\u0011\te!\u0007\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t)\u0011\u00199d!\u000f\u0011\t\u001d\u000b\t\u0007\u0018\u0005\b\u0003O#\u0003\u0019AAU\u0003=!x\u000e]5d\u001d\u0006lWm\u001d+p\u0013\u0012\u001cHCAB !!\t\u0019b!\u0011\u0002*\nU\u0016\u0002BB\u0001\u0003+\tq\u0002^8qS\u000eLEm\u001d+p\u001d\u0006lWm\u001d\u000b\u0003\u0007\u000f\u0002\u0002\"a\u0005\u0004B\tU\u0016\u0011V\u0001\fi>\u0004\u0018nY%e\u0013:4w\u000e\u0006\u0002\u0004NA9q)!3\u0004@\r\u001d\u0013AG4fiB\u000b'\u000f^5uS>tG*Z1eKJ,e\u000e\u001a9pS:$H\u0003\u0003B\u0012\u0007'\u001a)fa\u0016\t\u000f\u0005\u001d\u0006\u00061\u0001\u0002*\"111\u0006\u0015A\u0002qCq!a\u000f)\u0001\u0004\ti$\u0001\u000fhKR\u0004\u0016M\u001d;ji&|gNU3qY&\u001c\u0017-\u00128ea>Lg\u000e^:\u0015\r\ru3qLB2!\u001d\u0011YDa@]\u0005KAqa!\u0019*\u0001\u0004\u0011I+\u0001\u0002ua\"9\u00111H\u0015A\u0002\u0005u\u0012aD4fi\u000e{g\u000e\u001e:pY2,'/\u00133\u0016\u0005\r%\u0004#B$\u0002b\r-\u0004cA'\u0004n%\u00191q\u000e!\u0003%\r\u000b7\r[3e\u0007>tGO]8mY\u0016\u0014\u0018\nZ\u0001\u0017O\u0016$(+\u00198e_6\fE.\u001b<f\u0005J|7.\u001a:JIV\u00111qG\u0001\u0015O\u0016$(+\u00198e_6\fE.\u001b<f\u0005J|7.\u001a:\u0015\t\r]2\u0011\u0010\u0005\u0006S2\u0002\rAZ\u0001\u0014O\u0016$\u0018\t\\5wK\n\u0013xn[3s\u000bB|7\r\u001b\u000b\u0005\u0007\u007f\u001a9\tE\u0003H\u0003C\u001a\t\tE\u0002H\u0007\u0007K1a!\"I\u0005\u0011auN\\4\t\u000bik\u0003\u0019\u0001/\u0002%\u001d,Go\u00117vgR,'/T3uC\u0012\fG/\u0019\u000b\u0007\u0007\u001b\u001b\u0019ja&\u0011\t\t\u001d2qR\u0005\u0005\u0007#\u000b)EA\u0004DYV\u001cH/\u001a:\t\u000f\rUe\u00061\u0001\u0002*\u0006I1\r\\;ti\u0016\u0014\u0018\n\u001a\u0005\b\u0003wq\u0003\u0019AA\u001f\u0003]\u0019H/\u0019;f\u0007\"\fgnZ3Ue\u0006\u001cW-\u00128bE2,G\r\u0006\u0002\u0002R\u0005\u0019Bn\\4Ti\u0006$Xm\u00115b]\u001e,GK]1dKR\u00191o!)\t\u000f\r\r\u0006\u00071\u0001\u0002*\u0006\u00191\u000f\u001e:\u0002\u0011\r|g\u000e^1j]N$B!!\u0015\u0004*\"9\u0011qU\u0019A\u0002\u0005%F\u0003BA)\u0007[Cqa!\u00193\u0001\u0004\u0011I+\u0001\u0005tKRLU.Y4f)\r\u001981\u0017\u0005\u0007\u0007k\u001b\u0004\u0019\u00014\u0002\u00119,w/S7bO\u0016\faaY8oM&<G\u0003BB^\u0007\u0003\u0004B!a\u0005\u0004>&!1qXA\u000b\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0007\u0007$\u0004\u0019ABc\u00039\u0019wN\u001c4jOJ+7o\\;sG\u0016\u0004Baa2\u0004L6\u00111\u0011\u001a\u0006\u0005\u0007o\u000b)%\u0003\u0003\u0004N\u000e%'AD\"p]\u001aLwMU3t_V\u00148-Z\u0001\u0015I\u0016\u001c8M]5cK\u000ec\u0017.\u001a8u#V|G/Y:\u0015\t\rM7\u0011\u001c\t\u0005\u0005\u000b\u001b).\u0003\u0003\u0004X\u0006m%\u0001\t#fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7OU3ta>t7/\u001a#bi\u0006Dqaa76\u0001\u0004\u0019i.A\u0004sKF,Xm\u001d;\u0011\t\t\u00155q\\\u0005\u0005\u0007C\fYJA\u0010EKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m\u001d*fcV,7\u000f\u001e#bi\u0006\f\u0001\u0004Z3tGJL'-Z*de\u0006l7I]3eK:$\u0018.\u00197t)\u0011\u00199o!<\u0011\t\t\u00155\u0011^\u0005\u0005\u0007W\fYJ\u0001\u0015EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKN\u0004xN\\:f\t\u0006$\u0018\rC\u0004\u0004\\Z\u0002\raa<\u0011\t\t\u00155\u0011_\u0005\u0005\u0007g\fYJA\u0014EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;ECR\f\u0017aD7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0015\u0005\re\b\u0003BB~\t\u0003i!a!@\u000b\t\u0005\u001d3q \u0006\u0003\u0003*LA\u0001b\u0001\u0004~\nyQ*\u001a;bI\u0006$\u0018MV3sg&|g.\u0001\u0005gK\u0006$XO]3t)\t!I\u0001\u0005\u0003\u0004|\u0012-\u0011\u0002\u0002C\u0007\u0007{\u0014\u0001BR3biV\u0014Xm]\u0001\u0011SN\u0014%o\\6fe\u0012+wM]1eK\u0012$B!!\u0015\u0005\u0014!)!,\u000fa\u00019\u0006I\u0012n\u001d\"s_.,'oQ8na>tWM\u001c;EK\u001e\u0014\u0018\rZ3e)\u0019\t\t\u0006\"\u0007\u0005\u001c!)!L\u000fa\u00019\"9AQ\u0004\u001eA\u0002\u0011}\u0011!C2p[B|g.\u001a8u!\u0011!\t\u0003\"\u000b\u000e\u0005\u0011\r\"\u0002\u0002Bt\tKQ1\u0001b\nk\u0003\u001d\u0019G.[3oiNLA\u0001b\u000b\u0005$\ty!I]8lKJ\u001cu.\u001c9p]\u0016tG/\u0001\tnSJ\u0014xN\u001d+pa&\u001c7\u000b^1uKR!A\u0011\u0007C !\u00159\u0015\u0011\rC\u001a!\u0011!)\u0004b\u000f\u000e\u0005\u0011]\"b\u0001C\u001d\u0001\u0006!A.\u001b8l\u0013\u0011!i\u0004b\u000e\u0003+\rcWo\u001d;fe2Kgn\u001b+pa&\u001c7\u000b^1uK\"9A\u0011I\u001eA\u0002\u0005%\u0016!\u0002;pa&\u001c\u0017A\u00067j].\u001cun\u001c:eS:\fGo\u001c:F]\u0006\u0014G.\u001a3\u0016\u0005\u0005E\u0003")
public class KRaftMetadataCache
implements MetadataCache,
Logging,
ConfigRepository {
    private final int brokerId;
    private volatile MetadataImage _currentImage;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Properties topicConfig(String topicName) {
        return ConfigRepository.topicConfig$(this, topicName);
    }

    @Override
    public Properties brokerConfig(int brokerId) {
        return ConfigRepository.brokerConfig$(this, brokerId);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataImage image, int[] brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return Replicas.toList((int[])brokers);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(brokers.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(brokers), (Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Option$.MODULE$.apply((Object)image.cluster().broker(brokerId)).foreach((Function1 & Serializable)b -> {
            if (!b.fenced() && b.listeners().containsKey(listenerName.value())) {
                return BoxesRunTime.boxToBoolean((boolean)res.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }));
        return res;
    }

    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topicName, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return new Some((Object)((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().entrySet()).asScala().map((Function1 & Serializable)entry -> {
                Integer partitionId = (Integer)entry.getKey();
                PartitionRegistration partition = (PartitionRegistration)entry.getValue();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredObservers = this.maybeFilterAliveReplicas(image, partition.observers, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partition, listenerName);
                Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leader, listenerName);
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!image.cluster().brokers().containsKey(BoxesRunTime.boxToInteger((int)partition.leader))) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": leader not available").toString());
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(partition$1.leader).toString());
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (maybeLeader instanceof Some) {
                    Errors errors;
                    Node leader = (Node)((Some)maybeLeader).value();
                    if (filteredReplicas.size() < partition.replicas.length) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(93).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": replica information not available for ").append("following brokers ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.replicas), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < partition.isr.length) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(101).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": in sync replica information not available for ").append("following brokers ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.isr), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(maybeLeader);
            })).iterator());
        }
        throw new MatchError((Object)option);
    }

    private Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> getPartitionMetadataForDescribeTopicResponse(MetadataImage image, String topicName, ListenerName listenerName, int startIndex, int maxCount) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)-1));
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            ListBuffer result = new ListBuffer();
            java.util.Set partitions = topic.partitions().keySet();
            int upperIndex = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(topic.partitions().size()), startIndex + maxCount);
            int nextIndex = upperIndex < partitions.size() ? upperIndex : -1;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startIndex), upperIndex).foreach((Function1 & Serializable)partitionId -> KRaftMetadataCache.$anonfun$getPartitionMetadataForDescribeTopicResponse$1(this, topic, image, listenerName, result, topicName, BoxesRunTime.unboxToInt((Object)partitionId)));
            return new Tuple2((Object)new Some((Object)result.toList()), (Object)BoxesRunTime.boxToInteger((int)nextIndex));
        }
        throw new MatchError((Object)option);
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)brokerId -> KRaftMetadataCache.$anonfun$getOfflineReplicas$1(this, image, offlineReplicas, partition, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        return offlineReplicas;
    }

    private boolean isReplicaOffline(PartitionRegistration partition, ListenerName listenerName, BrokerRegistration broker) {
        return broker.fenced() || !broker.listeners().containsKey(listenerName.value()) || this.isReplicaInOfflineDir(broker, partition);
    }

    private boolean isReplicaInOfflineDir(BrokerRegistration broker, PartitionRegistration partition) {
        return !broker.hasOnlineDir(partition.directory(broker.id()));
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)image.cluster().broker(id)).flatMap((Function1 & Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.node(listenerName.value()))));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable)topic -> this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)Option$.MODULE$.apply((Object)image.topics().getTopic(topic).id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava())));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics(Option<String> tenantPrefixOpt) {
        if (None$.MODULE$.equals(tenantPrefixOpt)) {
            return CollectionConverters$.MODULE$.SetHasAsScala(this._currentImage().topics().topicsByName().keySet()).asScala();
        }
        if (tenantPrefixOpt instanceof Some) {
            String tenantName = (String)((Some)tenantPrefixOpt).value();
            return CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)this._currentImage().topics().topicsByTenant(tenantName)).asScala();
        }
        throw new MatchError(tenantPrefixOpt);
    }

    public DescribeTopicPartitionsResponseData getTopicMetadataForDescribeTopicResponse(Iterator<String> topics, ListenerName listenerName, Function1<String, Object> topicPartitionStartIndex, int maximumNumberOfPartitions, boolean ignoreTopicsWithExceptions) {
        MetadataImage image = this._currentImage();
        IntRef remaining = IntRef.create((int)maximumNumberOfPartitions);
        DescribeTopicPartitionsResponseData result = new DescribeTopicPartitionsResponseData();
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> topics.foreach((Function1 & Serializable)topicName -> {
            if (remaining$1.elem > 0) {
                void var9_9;
                Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> tuple2 = this.getPartitionMetadataForDescribeTopicResponse(image, (String)topicName, listenerName, BoxesRunTime.unboxToInt((Object)topicPartitionStartIndex.apply(topicName)), remaining$1.elem);
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Option partitionResponse = (Option)tuple2._1();
                int n = tuple2._2$mcI$sp();
                var9_9.map((Function1 & Serializable)partitions -> {
                    KRaftMetadataCache.$anonfun$getTopicMetadataForDescribeTopicResponse$3(topicName, image, result, n, remaining, partitions);
                    return BoxedUnit.UNIT;
                });
                if (!ignoreTopicsWithExceptions && !var9_9.isDefined()) {
                    Errors errors;
                    try {
                        Topic.validate((String)topicName);
                        errors = Errors.UNKNOWN_TOPIC_OR_PARTITION;
                    }
                    catch (InvalidTopicException invalidTopicException) {
                        errors = Errors.INVALID_TOPIC_EXCEPTION;
                    }
                    Errors error = errors;
                    return BoxesRunTime.boxToBoolean((boolean)result.topics().add((ImplicitLinkedHashCollection.Element)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(error.code()).setName(topicName).setTopicId(this.getTopicId((String)topicName)).setIsInternal(Topic.isInternal((String)topicName))));
                }
                return BoxedUnit.UNIT;
            }
            if (remaining$1.elem == 0) {
                result.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName).setPartitionIndex(0));
                throw Breaks$.MODULE$.break();
            }
            return BoxedUnit.UNIT;
        }));
        return result;
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return (Set)Set$.MODULE$.empty();
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return (Set)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().keySet()).asScala().map((Function1 & Serializable)x$3 -> new TopicPartition(topicName, Predef$.MODULE$.Integer2int(x$3)));
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this._currentImage().topics().topicsByName()).asScala().get((Object)topicName).map((Function1 & Serializable)x$4 -> x$4.id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this._currentImage().topics().topicsById()).asScala().get((Object)topicId).map((Function1 & Serializable)x$5 -> x$5.name());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$hasAliveBroker$1(x$6))) == 1;
    }

    public boolean isBrokerFenced(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.fenced())) == 1;
    }

    public boolean isBrokerShuttingDown(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.inControlledShutdown())) == 1;
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return this.getAliveBrokers(this._currentImage());
    }

    private Iterable<BrokerMetadata> getAliveBrokers(MetadataImage image) {
        return (Iterable)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(image.cluster().brokers().values()).asScala().filterNot((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.fenced()))).map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), b.rack()));
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.fenced())).flatMap((Function1 & Serializable)x$11 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$11.node(listenerName.value()))));
    }

    @Override
    public Map<String, String> getBrokerTags(int brokerId) {
        return (Map)Map$.MODULE$.empty();
    }

    @Override
    public int getBrokerCellId(int brokerId) {
        return this._currentImage().cells().getBrokerCellId(brokerId);
    }

    public Seq<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this._currentImage().cluster().brokers().values()).asScala().filterNot((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.fenced()))).flatMap((Function1 & Serializable)x$13 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$13.node(listenerName.value()))))).toSeq();
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topicName, int partitionId) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).flatMap((Function1 & Serializable)topic -> Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)))).flatMap((Function1 & Serializable)partition -> new Some((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partitionId).setControllerEpoch(-1).setLeader(partition.leader).setLeaderEpoch(partition.leaderEpoch).setIsr(Replicas.toList((int[])partition.isr)).setZkVersion(partition.partitionEpoch).setReplicas(Replicas.toList((int[])partition.replicas)).setObservers(Replicas.toList((int[])partition.observers))));
    }

    @Override
    public Seq<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfos() {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this._currentImage().topics().topicsByName().values()).asScala().flatMap((Function1 & Serializable)img -> (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(img.partitions().keySet()).asScala().map((Function1 & Serializable)partitionId -> (UpdateMetadataRequestData.UpdateMetadataPartitionState)this.getPartitionInfo(img.name(), Predef$.MODULE$.Integer2int(partitionId)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))).filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$getPartitionInfos$3(p)))).toSeq();
    }

    @Override
    public Option<Object> numPartitions(String topicName) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).map((Function1 & Serializable)topic -> BoxesRunTime.boxToInteger((int)KRaftMetadataCache.$anonfun$numPartitions$1(topic)));
    }

    @Override
    public java.util.Map<String, Uuid> topicNamesToIds() {
        return this._currentImage().topics().topicNameToIdView();
    }

    @Override
    public java.util.Map<Uuid, String> topicIdsToNames() {
        return this._currentImage().topics().topicIdToNameView();
    }

    @Override
    public Tuple2<java.util.Map<String, Uuid>, java.util.Map<Uuid, String>> topicIdInfo() {
        MetadataImage image = this._currentImage();
        return new Tuple2((Object)image.topics().topicNameToIdView(), (Object)image.topics().topicIdToNameView());
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)));
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                Option option3 = Option$.MODULE$.apply((Object)image.cluster().broker(partition.leader));
                if (None$.MODULE$.equals(option3)) {
                    return new Some((Object)Node.noNode());
                }
                if (option3 instanceof Some) {
                    BrokerRegistration broker = (BrokerRegistration)((Some)option3).value();
                    return new Some((Object)broker.node(listenerName.value()).orElse(Node.noNode()));
                }
                throw new MatchError((Object)option3);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.HashMap result = new scala.collection.mutable.HashMap();
        Option$.MODULE$.apply((Object)image.topics().getTopic(tp.topic())).foreach((Function1 & Serializable)topic -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$1(image, listenerName, result, topic);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    @Override
    public Option<CachedControllerId> getControllerId() {
        return this.getRandomAliveBroker(this._currentImage()).map((Function1)KRaftCachedControllerId$.MODULE$);
    }

    @Override
    public Option<Object> getRandomAliveBrokerId() {
        return this.getRandomAliveBroker(this._currentImage());
    }

    private Option<Object> getRandomAliveBroker(MetadataImage image) {
        List aliveBrokers = this.getAliveBrokers(image).toList();
        if (aliveBrokers.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((BrokerMetadata)aliveBrokers.apply((int)ThreadLocalRandom.current().nextInt((int)aliveBrokers.size()))).id));
    }

    public Option<Object> getAliveBrokerEpoch(int brokerId) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.fenced())).map((Function1 & Serializable)brokerRegistration -> BoxesRunTime.boxToLong((long)brokerRegistration.epoch()));
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap nodes = new HashMap();
        image.cluster().brokers().values().forEach(broker -> {
            if (!broker.fenced()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName.value()))).foreach((Function1 & Serializable)node -> nodes.put(Predef$.MODULE$.int2Integer(broker.id()), node));
                return;
            }
        });
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        image.topics().topicsByName().values().forEach(topic -> topic.partitions().entrySet().forEach(entry -> {
            Integer partitionId = (Integer)entry.getKey();
            PartitionRegistration partition = (PartitionRegistration)entry.getValue();
            partitionInfos.add(new PartitionInfo(topic.name(), Predef$.MODULE$.Integer2int(partitionId), KRaftMetadataCache.node$1(partition.leader, nodes), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.isr), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.getOfflineReplicas(image, partition, listenerName)).asScala().map((Function1 & Serializable)replica -> KRaftMetadataCache.node$1(Predef$.MODULE$.Integer2int(replica), nodes))).toArray(ClassTag$.MODULE$.apply(Node.class))));
            if (Topic.isInternal((String)topic.name())) {
                internalTopics.add(topic.name());
                return;
            }
        }));
        Node controllerNode = KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)this.getRandomAliveBroker(image).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), nodes);
        return new Cluster(clusterId, nodes.values(), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    public boolean stateChangeTraceEnabled() {
        return this.stateChangeLogger().isTraceEnabled();
    }

    public void logStateChangeTrace(String str) {
        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> str);
    }

    @Override
    public boolean contains(String topicName) {
        return this._currentImage().topics().topicsByName().containsKey((Object)topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(tp.topic()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return ((TopicImage)((Some)option).value()).partitions().containsKey(BoxesRunTime.boxToInteger((int)tp.partition()));
        }
        throw new MatchError((Object)option);
    }

    public void setImage(MetadataImage newImage) {
        this._currentImage_$eq(newImage);
    }

    @Override
    public Properties config(ConfigResource configResource) {
        return this._currentImage().configs().configProperties(configResource);
    }

    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this._currentImage().clientQuotas().describe(request);
    }

    public DescribeUserScramCredentialsResponseData describeScramCredentials(DescribeUserScramCredentialsRequestData request) {
        return this._currentImage().scram().describe(request);
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this._currentImage().features().metadataVersion();
    }

    @Override
    public Features features() {
        MetadataImage image = this._currentImage();
        return new Features(image.features().metadataVersion(), image.features().finalizedVersions(), image.highestOffsetAndEpoch().offset(), true);
    }

    @Override
    public boolean isBrokerDegraded(int brokerId) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).exists((Function1 & Serializable)registration -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$isBrokerDegraded$1(registration)));
    }

    @Override
    public boolean isBrokerComponentDegraded(int brokerId, BrokerComponent component) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).exists((Function1 & Serializable)registration -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$isBrokerComponentDegraded$1(component, registration)));
    }

    @Override
    public Option<ClusterLinkTopicState> mirrorTopicState(String topic) {
        TopicImage topicImage = this._currentImage().topics().getTopic(topic);
        if (topicImage == null) {
            return None$.MODULE$;
        }
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(topicImage.mirrorTopic())).map((Function1 & Serializable)state -> ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)state));
    }

    @Override
    public boolean linkCoordinatorEnabled() {
        return true;
    }

    public static final /* synthetic */ Object $anonfun$getPartitionMetadataForDescribeTopicResponse$1(KRaftMetadataCache $this, TopicImage topic$1, MetadataImage image$3, ListenerName listenerName$3, ListBuffer result$1, String topicName$2, int partitionId) {
        PartitionRegistration partitionRegistration = (PartitionRegistration)topic$1.partitions().get(BoxesRunTime.boxToInteger((int)partitionId));
        if (partitionRegistration != null) {
            java.util.List<Integer> filteredReplicas = $this.maybeFilterAliveReplicas(image$3, partitionRegistration.replicas, listenerName$3, false);
            java.util.List<Integer> filteredIsr = $this.maybeFilterAliveReplicas(image$3, partitionRegistration.isr, listenerName$3, false);
            java.util.List<Integer> offlineReplicas = $this.getOfflineReplicas(image$3, partitionRegistration, listenerName$3);
            Option<Node> maybeLeader = $this.getAliveEndpoint(image$3, partitionRegistration.leader, listenerName$3);
            if (None$.MODULE$.equals(maybeLeader)) {
                return (ListBuffer)result$1.append((Object)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(-1).setLeaderEpoch(partitionRegistration.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList((int[])partitionRegistration.elr)).setLastKnownElr(Replicas.toList((int[])partitionRegistration.lastKnownElr)));
            }
            if (maybeLeader instanceof Some) {
                Node leader = (Node)((Some)maybeLeader).value();
                return (ListBuffer)result$1.append((Object)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(leader.id()).setLeaderEpoch(partitionRegistration.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList((int[])partitionRegistration.elr)).setLastKnownElr(Replicas.toList((int[])partitionRegistration.lastKnownElr)));
            }
            throw new MatchError(maybeLeader);
        }
        $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("The partition ").append(partitionId).append(" does not exist for ").append(topicName$2).toString());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(KRaftMetadataCache $this, MetadataImage image$4, ArrayList offlineReplicas$1, PartitionRegistration partition$2, ListenerName listenerName$4, int brokerId) {
        Option option = Option$.MODULE$.apply((Object)image$4.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        }
        if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            if ($this.isReplicaOffline(partition$2, listenerName$4, broker)) {
                return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadataForDescribeTopicResponse$3(String topicName$3, MetadataImage image$6, DescribeTopicPartitionsResponseData result$2, int nextPartition$1, IntRef remaining$1, List partitions) {
        DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic response = new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(Errors.NONE.code()).setName(topicName$3).setTopicId((Uuid)Option$.MODULE$.apply((Object)image$6.topics().getTopic(topicName$3).id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topicName$3)).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitions).asJava());
        result$2.topics().add((ImplicitLinkedHashCollection.Element)response);
        if (nextPartition$1 != -1) {
            result$2.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName$3).setPartitionIndex(nextPartition$1));
            throw Breaks$.MODULE$.break();
        }
        remaining$1.elem -= partitions.size();
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveBroker$1(BrokerRegistration x$6) {
        return !x$6.fenced();
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionInfos$3(UpdateMetadataRequestData.UpdateMetadataPartitionState p) {
        return p != null;
    }

    public static final /* synthetic */ int $anonfun$numPartitions$1(TopicImage topic) {
        return topic.partitions().size();
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$1(MetadataImage image$7, ListenerName listenerName$10, scala.collection.mutable.HashMap result$3, TopicImage topic) {
        topic.partitions().values().forEach(partition -> ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1)(JFunction1.mcVI.sp & Serializable)replicaId -> {
            BrokerRegistration broker = image$7.cluster().broker(replicaId);
            if (broker != null && !broker.fenced()) {
                broker.node(listenerName$10.value()).ifPresent(node -> {
                    if (!node.isEmpty()) {
                        result$3.put((Object)BoxesRunTime.boxToInteger((int)replicaId), node);
                        return;
                    }
                });
                return;
            }
        }));
    }

    private static final Node node$1(int id, HashMap nodes$1) {
        return (Node)Option$.MODULE$.apply(nodes$1.get(BoxesRunTime.boxToInteger((int)id))).getOrElse((Function0 & Serializable)() -> Node.noNode());
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerDegraded$1(BrokerRegistration registration) {
        return !registration.degradedComponents().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerComponentDegraded$1(BrokerComponent component$1, BrokerRegistration registration) {
        return registration.degradedComponents().stream().anyMatch(degradedComponent -> {
            BrokerComponent brokerComponent = degradedComponent.component();
            return !(brokerComponent != null ? !brokerComponent.equals(component$1) : component$1 != null);
        });
    }

    public KRaftMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this._currentImage = MetadataImage.EMPTY;
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }
}

