/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import kafka.restore.schedulers.RetryableException;
import kafka.tier.common.RestServerRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServerUtil {
    public static final int HTTP_MAX_RETRIES = 2;
    public static final long HTTP_RETRY_INTERVAL_IN_MS = TimeUnit.SECONDS.toMillis(3L);
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServerUtil.class);

    public static HttpPost buildKafkaHttpPostRequest(RestServerRequest request, URI uri) throws JsonProcessingException {
        if (request.requestType() != RestServerRequest.RestRequestType.POST) {
            throw new IllegalArgumentException("Received unsupported request of type: " + (Object)((Object)request.requestType()));
        }
        String body = request.requestBodyAsJson();
        HttpPost post = new HttpPost(uri);
        LOGGER.info("build http request with uri: " + uri.toString() + ", body: " + body);
        StringEntity params = new StringEntity(body, ContentType.APPLICATION_FORM_URLENCODED);
        post.setEntity((HttpEntity)params);
        return post;
    }

    public static HttpGet buildKafkaHttpGetRequest(RestServerRequest request, URI uri) {
        if (request.requestType() != RestServerRequest.RestRequestType.GET) {
            throw new IllegalArgumentException("Received unsupported request of type: " + (Object)((Object)request.requestType()));
        }
        HttpGet get = new HttpGet(uri);
        LOGGER.info("build http request with uri: " + uri.toString());
        return get;
    }

    public static CloseableHttpClient buildHttpClient() {
        return HttpClients.custom().addInterceptorLast((response, context) -> {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String errorMessage = String.format("Received non-successful status code %s in response.", statusCode);
                LOGGER.error(errorMessage + " throws IOException to trigger retry.");
                throw new IOException(errorMessage);
            }
        }).setRetryHandler((exception, executionCount, context) -> {
            if (executionCount < 2) {
                long delayMs = HTTP_RETRY_INTERVAL_IN_MS * (long)executionCount;
                try {
                    LOGGER.info(String.format("httpclient retry #%s, sleeping for %s ms before retry.", executionCount, delayMs), (Throwable)exception);
                    Thread.sleep(delayMs);
                    return true;
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.error("Interrupted while waiting to retry HTTP request. Giving up on retrying request.", (Throwable)interruptedException);
                    return false;
                }
            }
            LOGGER.error(String.format("exhaust max http retries: %d", 2));
            return false;
        }).build();
    }

    /*
     * Loose catch block
     */
    public static String sendRequest(RestServerRequest request, CloseableHttpClient httpClient) {
        Object post;
        CloseableHttpResponse httpResponse;
        block18: {
            httpResponse = null;
            URI uri = request.uri();
            switch (request.requestType()) {
                case POST: {
                    post = RestServerUtil.buildKafkaHttpPostRequest(request, uri);
                    httpResponse = httpClient.execute((HttpUriRequest)post);
                    break;
                }
                case GET: {
                    HttpGet get = RestServerUtil.buildKafkaHttpGetRequest(request, uri);
                    httpResponse = httpClient.execute((HttpUriRequest)get);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Received unsupported request of type: " + (Object)((Object)request.requestType()));
                }
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) break block18;
            LOGGER.debug("{}: Successfully received request response on broker", (Object)request.brokerUrl());
            post = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
                httpClient.close();
            }
            catch (IOException e) {
                LOGGER.error(String.format("[%s]: Received IOException while closing HTTP client after replying to request %s", request.brokerUrl(), request.requestName()), (Throwable)e);
            }
            return post;
        }
        LOGGER.error(String.format("[%s]: Received non-retryable failure status code, http response error status: %s, http response body: %s.", request.brokerUrl(), httpResponse.getStatusLine().getStatusCode(), httpResponse.getEntity().toString()));
        post = null;
        try {
            if (httpResponse != null) {
                httpResponse.close();
            }
            httpClient.close();
        }
        catch (IOException e) {
            LOGGER.error(String.format("[%s]: Received IOException while closing HTTP client after replying to request %s", request.brokerUrl(), request.requestName()), (Throwable)e);
        }
        return post;
        catch (Exception e) {
            try {
                String errorMessage = String.format("[%s]: Exception while executing request %s, throw retryable exception", request.brokerUrl(), request.requestName());
                LOGGER.error(errorMessage, (Throwable)e);
                throw new RetryableException(errorMessage, e);
            }
            catch (Throwable throwable) {
                try {
                    if (httpResponse != null) {
                        httpResponse.close();
                    }
                    httpClient.close();
                }
                catch (IOException e2) {
                    LOGGER.error(String.format("[%s]: Received IOException while closing HTTP client after replying to request %s", request.brokerUrl(), request.requestName()), (Throwable)e2);
                }
                throw throwable;
            }
        }
    }
}

