/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.InputStream;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.TierTimestampIndexIterator;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import org.apache.kafka.storage.internals.log.TimestampOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TimestampIndexFetchRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestampIndexFetchRequest.class);

    TimestampIndexFetchRequest() {
    }

    static TimestampOffset fetchOffsetForTimestamp(CancellationContext cancellationContext, TierObjectStore tierObjectStore, ObjectMetadata tierObjectMetadata, long targetTimestamp) throws Exception {
        try (TierObjectStoreResponse timestampResponse = tierObjectStore.getObjectStoreFragment(tierObjectMetadata, FragmentType.TIMESTAMP_INDEX);){
            TimestampOffset timestampOffset = TimestampIndexFetchRequest.searchByTargetTimestamp(cancellationContext, tierObjectMetadata, targetTimestamp, timestampResponse)[0];
            return timestampOffset;
        }
    }

    static CompletableFuture<TimestampOffset[]> fetchOffsetForTimestampAsync(CancellationContext cancellationContext, TierObjectStore tierObjectStore, ObjectMetadata tierObjectMetadata, long targetTimestamp) {
        return tierObjectStore.getObjectStoreFragmentAsync(tierObjectMetadata, FragmentType.TIMESTAMP_INDEX).thenApply(res -> {
            try {
                TimestampOffset[] timestampOffsetArray = TimestampIndexFetchRequest.searchByTargetTimestamp(cancellationContext, tierObjectMetadata, targetTimestamp, res);
                return timestampOffsetArray;
            }
            finally {
                try {
                    res.close();
                }
                catch (Exception e) {
                    LOGGER.warn("failed to close TierObjectStoreResponse of TIMESTAMP_INDEX", (Throwable)e);
                }
            }
        });
    }

    private static TimestampOffset[] searchByTargetTimestamp(CancellationContext cancellationContext, ObjectMetadata tierObjectMetadata, long targetTimestamp, TierObjectStoreResponse timestampResponse) {
        long startOffset = tierObjectMetadata.baseOffset();
        TimestampOffset found = new TimestampOffset(targetTimestamp, tierObjectMetadata.baseOffset());
        TimestampOffset next = null;
        InputStream timestampStream = timestampResponse.getInputStream();
        TierTimestampIndexIterator tierTimestampIterator = new TierTimestampIndexIterator(timestampStream, startOffset);
        while (tierTimestampIterator.hasNext()) {
            if (cancellationContext.isCancelled()) {
                throw new CancellationException("Tiered timestamp index fetch request cancelled");
            }
            TimestampOffset timestampOffset = (TimestampOffset)tierTimestampIterator.next();
            if (timestampOffset.timestamp == targetTimestamp) {
                found = timestampOffset;
                if (!tierTimestampIterator.hasNext()) break;
                next = (TimestampOffset)tierTimestampIterator.next();
                break;
            }
            if (timestampOffset.timestamp < targetTimestamp) {
                found = timestampOffset;
                continue;
            }
            next = timestampOffset;
            break;
        }
        return new TimestampOffset[]{found, next};
    }
}

