/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeyTemplates;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.aead.AeadConfig;
import io.confluent.kafka.storage.checksum.ChecksumInfo;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.BucketHealthResult;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.encryption.CleartextDataKey;
import kafka.tier.store.encryption.EncryptionKeyManager;
import kafka.tier.store.encryption.KeyContext;
import kafka.tier.store.encryption.KeySha;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.utils.Throttler;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function3;

public class MockInMemoryTierObjectStore
extends TierObjectStore
implements AutoCloseable {
    public static UploadedObject deleteMarker = new UploadedObject(new HashMap(), null, null, new VersionInformation("delete-marker"), System.currentTimeMillis());
    public volatile boolean throwExceptionOnSegmentFetch = false;
    public volatile boolean throwExceptionOnTransactionFetch = false;
    public Function3<String, ObjectStoreMetadata, ObjectType, Boolean> throwOnCondition = null;
    public Supplier<Boolean> throwOnListCondition = () -> false;
    private static final ConcurrentHashMap<String, ConcurrentLinkedDeque<UploadedObject>> KEY_TO_BLOB = new ConcurrentHashMap();
    private static final Aead MASTER_KEY;
    private static Map<String, String> wellKnownKeyPathMetadata;
    private final ConcurrentHashMap<ObjectType, Integer> objectCounts = new ConcurrentHashMap();
    private final MockInMemoryTierObjectStoreConfig config;
    private final String keyPrefix;
    private final EncryptionKeyManager encryptionKeyManager;
    private final Optional<E2EChecksumStore> checksumStoreOpt;
    private final ConcurrentHashMap<ObjectType, ChecksumInfo> checksums = new ConcurrentHashMap();

    @Override
    public String keyPrefix() {
        return this.keyPrefix;
    }

    public MockInMemoryTierObjectStore(Time time, MockInMemoryTierObjectStoreConfig config) {
        this(time, null, config, Optional.empty());
    }

    public MockInMemoryTierObjectStore(Time time, MockInMemoryTierObjectStoreConfig config, Optional<E2EChecksumStore> checksumStoreOpt) {
        this(time, null, config, checksumStoreOpt);
    }

    public MockInMemoryTierObjectStore(Time time, Metrics metrics, MockInMemoryTierObjectStoreConfig config) {
        this(time, metrics, config, Optional.empty());
    }

    public MockInMemoryTierObjectStore(Time time, Metrics metrics, MockInMemoryTierObjectStoreConfig config, Optional<E2EChecksumStore> checksumStoreOpt) {
        this.config = config;
        this.keyPrefix = config.prefix;
        this.encryptionKeyManager = new EncryptionKeyManager(time, metrics, MASTER_KEY, Duration.ofSeconds(1L));
        this.encryptionKeyManager.bindHook(new EncryptionKeyManager.WellKnownKeypathHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeWellKnownPathMetadata(Map<String, String> metadata) {
                Aead aead = MASTER_KEY;
                synchronized (aead) {
                    wellKnownKeyPathMetadata = metadata;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, String> fetchWellKnownPathMetadata() {
                Aead aead = MASTER_KEY;
                synchronized (aead) {
                    return wellKnownKeyPathMetadata;
                }
            }
        });
        this.checksumStoreOpt = checksumStoreOpt;
    }

    public List<String> getStoredKeys() {
        return this.getStored().keySet().stream().filter(k -> k.startsWith(this.keyPrefix)).collect(Collectors.toList());
    }

    public ConcurrentHashMap<ObjectType, Integer> getObjectCounts() {
        return this.objectCounts;
    }

    public ConcurrentHashMap<ObjectType, ChecksumInfo> getChecksums() {
        return this.checksums;
    }

    private boolean shouldThrow(String method, ObjectStoreMetadata metadata, ObjectType objectType) {
        return this.throwOnCondition != null && (Boolean)this.throwOnCondition.apply((Object)method, (Object)metadata, (Object)objectType) != false || this.throwExceptionOnSegmentFetch && objectType == ObjectType.SEGMENT || this.throwExceptionOnTransactionFetch && objectType == ObjectType.TRANSACTION_INDEX;
    }

    public ConcurrentHashMap<String, byte[]> getStored() {
        ConcurrentHashMap<String, byte[]> returnMap = new ConcurrentHashMap<String, byte[]>();
        for (Map.Entry<String, ConcurrentLinkedDeque<UploadedObject>> entry : KEY_TO_BLOB.entrySet()) {
            if (entry.getValue().isEmpty() || entry.getValue().getFirst() == deleteMarker) continue;
            returnMap.put(entry.getKey(), entry.getValue().getFirst().data);
        }
        return returnMap;
    }

    private String generateVersion() {
        String letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        String digits = "0123456789";
        String lettersAndDigits = letters + digits;
        Random random = new Random();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 1024; ++i) {
            b.append(lettersAndDigits.charAt(random.nextInt(lettersAndDigits.length())));
        }
        return b.toString();
    }

    @Override
    public TierObjectStore.Backend getBackend() {
        return TierObjectStore.Backend.Mock;
    }

    @Override
    public Map<String, List<VersionInformation>> listObject(String keyPrefix, boolean getVersionInfo) {
        if (this.throwOnListCondition.get().booleanValue()) {
            throw new TierObjectStoreRetriableException("Mocked retriable");
        }
        HashMap<String, List<VersionInformation>> blobKeysToVersions = new HashMap<String, List<VersionInformation>>();
        for (Map.Entry<String, ConcurrentLinkedDeque<UploadedObject>> entry : KEY_TO_BLOB.entrySet()) {
            String blobKey = entry.getKey();
            if (!blobKey.startsWith(keyPrefix)) continue;
            ConcurrentLinkedDeque<UploadedObject> uploadedObjects = entry.getValue();
            LinkedList versionInformation = new LinkedList();
            if (getVersionInfo) {
                uploadedObjects.forEach(blobWithMetadata -> versionInformation.add(blobWithMetadata.versionInfo));
                blobKeysToVersions.put(blobKey, versionInformation);
                continue;
            }
            if (uploadedObjects.getFirst().getVersionId().equals("delete-marker")) continue;
            blobKeysToVersions.put(blobKey, versionInformation);
        }
        return blobKeysToVersions;
    }

    @Override
    public TierObjectStoreResponse getObject(ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive, VersionInformation versionInformation) throws TierObjectStoreRetriableException {
        if (this.shouldThrow("getObject", objectMetadata, objectType)) {
            throw new TierObjectStoreRetriableException("Mocked retriable");
        }
        String key = this.keyPath(objectMetadata, objectType);
        ConcurrentLinkedDeque<UploadedObject> uploadedObjectLinkedList = KEY_TO_BLOB.get(key);
        if (uploadedObjectLinkedList == null || uploadedObjectLinkedList.isEmpty() || uploadedObjectLinkedList.getFirst() == deleteMarker) {
            throw new TierObjectStoreRetriableException(String.format("Key not found: %s", key));
        }
        UploadedObject uploadedObject = versionInformation != null ? KEY_TO_BLOB.get(key).stream().filter(obj -> Objects.equals(obj.getVersionId(), versionInformation.getVersionId())).findFirst().get() : uploadedObjectLinkedList.getFirst();
        byte[] blob = uploadedObject.data;
        if (objectType.equals((Object)ObjectType.SEGMENT)) {
            if (!objectMetadata.opaqueData().equals(OpaqueData.ZEROED)) {
                KeySha keySha = KeySha.fromRawBytes(objectMetadata.opaqueData().intoByteArray());
                KeyContext keyContext = this.encryptionKeyManager.keyContext(keySha);
                if (keyContext == null) {
                    KeySha registeredKeySha = this.encryptionKeyManager.registerKeyFromObjectMetadata(uploadedObject.metadata);
                    if (!registeredKeySha.equals(keySha)) {
                        throw new IllegalStateException("key sha does not match");
                    }
                    keyContext = this.encryptionKeyManager.keyContext(registeredKeySha);
                }
                if (!keyContext.cleartextDataKey.equals(uploadedObject.cleartextDataKey)) {
                    throw new IllegalStateException("decryption failed, decrypted data keys do not match");
                }
            } else if (uploadedObject.encrypted()) {
                throw new IllegalStateException("tried to download an encrypted segment without OpaqueData");
            }
        }
        int start = byteOffsetStart != null ? byteOffsetStart.intValue() : 0;
        int end = (int)Math.min(byteOffsetEndExclusive != null ? byteOffsetEndExclusive : Long.MAX_VALUE, (long)blob.length);
        int byteBufferSize = end - start;
        ByteBuffer buf = ByteBuffer.allocate(byteBufferSize);
        buf.put(blob, start, byteBufferSize);
        buf.flip();
        return new MockInMemoryTierObjectStoreResponse((InputStream)new ByteBufferInputStream(buf));
    }

    @Override
    public ByteBuffer getSnapshot(ObjectStoreMetadata metadata, FragmentType fragmentType, int estimatedBufferSize) {
        ByteBuffer buffer;
        if (fragmentType != FragmentType.TIER_PARTITION_STATE_METADATA_SNAPSHOT && fragmentType != FragmentType.TIER_STATE_SNAPSHOT && fragmentType != FragmentType.PRODUCER_STATE) {
            throw new IllegalArgumentException("getSnapshot does not support the given fragmentType: " + (Object)((Object)fragmentType));
        }
        try (TierObjectStoreResponse response = this.getObjectStoreFragment(metadata, fragmentType);){
            buffer = ByteBuffer.wrap(Utils.readFullyToArray((InputStream)response.getInputStream(), (int)estimatedBufferSize));
        }
        catch (Exception e) {
            throw new TierObjectStoreRetriableException("Encountered an exception when fetching snapshot from object store.", e);
        }
        return buffer;
    }

    @Override
    public OpaqueData prepPutSegment() throws TierObjectStoreRetriableException {
        KeySha activeKeySha = this.encryptionKeyManager.activeKeySha();
        if (activeKeySha != null) {
            return OpaqueData.fromByteArray(activeKeySha.toRawBytes());
        }
        return OpaqueData.ZEROED;
    }

    @Override
    public void close() {
    }

    private void incrementObjectCount(ObjectType objectType) {
        this.objectCounts.compute(objectType, (key, integer) -> integer == null ? 1 : integer + 1);
    }

    @Override
    public void putInMemorySegment(ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<ByteBuffer> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState) throws IOException {
        String segmentKeyPath = this.keyPath(objectMetadata, ObjectType.SEGMENT);
        this.writeSegmentFile(segmentKeyPath, segmentData, objectMetadata.opaqueData());
        if (this.shouldThrow("putInMemorySegment", objectMetadata, ObjectType.SEGMENT)) {
            throw new TierObjectStoreRetriableException("Mocked retriable");
        }
        if (this.shouldThrow("E2EChecksumValidation", objectMetadata, ObjectType.SEGMENT)) {
            throw new E2EChecksumInvalidException(objectMetadata, (Throwable)new Exception());
        }
        this.incrementObjectCount(ObjectType.SEGMENT);
        this.updateChecksums(ObjectType.SEGMENT, segmentData);
        this.writeFileToArray(this.keyPath(objectMetadata, ObjectType.OFFSET_INDEX), offsetIndexData);
        this.incrementObjectCount(ObjectType.OFFSET_INDEX);
        this.updateChecksums(ObjectType.OFFSET_INDEX, offsetIndexData);
        this.writeFileToArray(this.keyPath(objectMetadata, ObjectType.TIMESTAMP_INDEX), timestampIndexData);
        this.incrementObjectCount(ObjectType.TIMESTAMP_INDEX);
        this.updateChecksums(ObjectType.TIMESTAMP_INDEX, timestampIndexData);
        producerStateSnapshotData.ifPresent(data -> {
            this.writeBufToArray(this.keyPath(objectMetadata, ObjectType.PRODUCER_STATE), (ByteBuffer)data);
            this.incrementObjectCount(ObjectType.PRODUCER_STATE);
        });
        transactionIndexData.ifPresent(data -> {
            this.writeBufToArray(this.keyPath(objectMetadata, ObjectType.TRANSACTION_INDEX), (ByteBuffer)data);
            this.incrementObjectCount(ObjectType.TRANSACTION_INDEX);
        });
        if (epochState.isPresent()) {
            this.writeBufToArray(this.keyPath(objectMetadata, ObjectType.EPOCH_STATE), epochState.get());
            this.incrementObjectCount(ObjectType.EPOCH_STATE);
        }
    }

    private void updateChecksums(ObjectType type, File file) {
        this.checksumStoreOpt.flatMap(checksumStore -> checksumStore.store().get(file.getAbsolutePath())).ifPresent(checksumInfo -> this.checksums.put(type, (ChecksumInfo)checksumInfo));
    }

    @Override
    public void putSegment(ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<File> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState, Optional<Throttler> throttlerOpt) throws IOException {
        String segmentKeyPath = this.keyPath(objectMetadata, ObjectType.SEGMENT);
        this.writeSegmentFile(segmentKeyPath, segmentData, objectMetadata.opaqueData());
        this.incrementObjectCount(ObjectType.SEGMENT);
        this.writeFileToArray(this.keyPath(objectMetadata, ObjectType.OFFSET_INDEX), offsetIndexData);
        this.incrementObjectCount(ObjectType.OFFSET_INDEX);
        this.writeFileToArray(this.keyPath(objectMetadata, ObjectType.TIMESTAMP_INDEX), timestampIndexData);
        this.incrementObjectCount(ObjectType.TIMESTAMP_INDEX);
        producerStateSnapshotData.ifPresent(data -> {
            this.writeFileToArray(this.keyPath(objectMetadata, ObjectType.PRODUCER_STATE), (File)data);
            this.incrementObjectCount(ObjectType.PRODUCER_STATE);
        });
        transactionIndexData.ifPresent(data -> {
            this.writeBufToArray(this.keyPath(objectMetadata, ObjectType.TRANSACTION_INDEX), (ByteBuffer)data);
            this.incrementObjectCount(ObjectType.TRANSACTION_INDEX);
        });
        if (epochState.isPresent()) {
            this.writeBufToArray(this.keyPath(objectMetadata, ObjectType.EPOCH_STATE), epochState.get());
            this.incrementObjectCount(ObjectType.EPOCH_STATE);
        }
    }

    @Override
    public String putObject(ObjectStoreMetadata objectMetadata, File file, ObjectType objectType) {
        if (this.shouldThrow("putObject", objectMetadata, objectType)) {
            throw new TierObjectStoreRetriableException("Mocked retriable");
        }
        String key = this.keyPath(objectMetadata, objectType);
        this.writeFileToArray(key, file);
        return key;
    }

    @Override
    public String putBuffer(ObjectStoreMetadata objectMetadata, ByteBuffer buffer, ObjectType objectType) {
        if (this.shouldThrow("putBuffer", objectMetadata, objectType)) {
            throw new TierObjectStoreRetriableException("Mocked retriable");
        }
        String key = this.keyPath(objectMetadata, objectType);
        this.writeBufToArray(key, buffer);
        return key;
    }

    @Override
    public void restoreObjectByCopy(ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
        Optional<UploadedObject> toBeRestoredOpt;
        if (KEY_TO_BLOB.containsKey(key) && (toBeRestoredOpt = KEY_TO_BLOB.get(key).stream().filter(obj -> obj.getVersionId() == lastLiveVersion.getVersionId()).findFirst()).isPresent()) {
            UploadedObject toBeRestored = toBeRestoredOpt.get();
            KEY_TO_BLOB.get(key).addFirst(new UploadedObject(toBeRestored.metadata, toBeRestored.cleartextDataKey, toBeRestored.data, new VersionInformation(this.generateVersion()), System.currentTimeMillis()));
        }
    }

    @Override
    public void deleteSegment(ObjectMetadata objectMetadata) {
        for (ObjectType type : TierObjectStore.getObjectTypesPerSegment()) {
            if (!KEY_TO_BLOB.containsKey(this.keyPath(objectMetadata, type))) continue;
            KEY_TO_BLOB.get(this.keyPath(objectMetadata, type)).addFirst(deleteMarker);
        }
    }

    @Override
    public void deleteVersions(List<TierObjectStore.KeyAndVersion> keys) {
        for (TierObjectStore.KeyAndVersion k : keys) {
            if (!KEY_TO_BLOB.containsKey(k.key())) continue;
            if (k.versionId() == null) {
                KEY_TO_BLOB.get(k.key()).removeIf(element -> element.getVersionId() == null);
                KEY_TO_BLOB.get(k.key()).addFirst(deleteMarker);
                continue;
            }
            KEY_TO_BLOB.get(k.key()).removeIf(element -> element.versionInfo.getVersionId().equals(k.versionId()));
            if (KEY_TO_BLOB.get(k.key()).size() != 1 || KEY_TO_BLOB.get(k.key()).getFirst() != deleteMarker) continue;
            KEY_TO_BLOB.remove(k.key());
        }
    }

    @Override
    public TierObjectAttribute objectExists(ObjectStoreMetadata objectMetadata, ObjectType type) {
        TierObjectAttribute result = new TierObjectAttribute(false);
        if (KEY_TO_BLOB.containsKey(this.keyPath(objectMetadata, type)) && KEY_TO_BLOB.get(this.keyPath(objectMetadata, type)).getFirst() != deleteMarker) {
            result.exist = true;
            result.size = MockInMemoryTierObjectStore.KEY_TO_BLOB.get((Object)this.keyPath((ObjectStoreMetadata)objectMetadata, (ObjectType)type)).getFirst().data.length;
        }
        return result;
    }

    @Override
    public BucketHealthResult checkBucketHealth() {
        return BucketHealthResult.HEALTHY;
    }

    public void clearForClusterId() {
        this.getStoredKeys().forEach(KEY_TO_BLOB::remove);
    }

    private String keyPath(ObjectStoreMetadata objectMetadata, ObjectType objectType) {
        return objectMetadata.toFragmentLocation(this.keyPrefix, objectType.getDesignatedFragmentType().get()).get().objectPath();
    }

    private void writeSegmentFile(String filePath, File file, OpaqueData opaqueData) {
        ByteBuffer buf;
        try (FileChannel sourceChan = FileChannel.open(file.toPath(), new OpenOption[0]);){
            buf = ByteBuffer.allocate((int)sourceChan.size());
            sourceChan.read(buf);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ConcurrentLinkedDeque<UploadedObject> up = new ConcurrentLinkedDeque<UploadedObject>();
        if (!opaqueData.equals(OpaqueData.ZEROED)) {
            KeySha keySha = KeySha.fromRawBytes(opaqueData.intoByteArray());
            KeyContext keyContext = this.encryptionKeyManager.keyContext(keySha);
            if (keyContext == null) {
                throw new TierObjectStoreFatalException(String.format("no key context on upload for '%s'", keySha));
            }
            up.add(new UploadedObject(keyContext.metadata, keyContext.cleartextDataKey, buf.array(), new VersionInformation(this.generateVersion()), System.currentTimeMillis()));
            KEY_TO_BLOB.put(filePath, up);
        } else {
            up.add(new UploadedObject(new HashMap(), null, buf.array(), new VersionInformation(this.generateVersion()), System.currentTimeMillis()));
            KEY_TO_BLOB.put(filePath, up);
        }
    }

    private void addBuffertoObjectStore(String filePath, byte[] buf) {
        if (KEY_TO_BLOB.containsKey(filePath)) {
            KEY_TO_BLOB.get(filePath).addFirst(new UploadedObject(new HashMap(), null, buf, new VersionInformation(this.generateVersion()), System.currentTimeMillis()));
        } else {
            ConcurrentLinkedDeque<UploadedObject> uploadedObjects = new ConcurrentLinkedDeque<UploadedObject>();
            uploadedObjects.addFirst(new UploadedObject(new HashMap(), null, buf, new VersionInformation(this.generateVersion()), System.currentTimeMillis()));
            KEY_TO_BLOB.put(filePath, uploadedObjects);
        }
    }

    private void writeFileToArray(String filePath, File file) {
        try (FileChannel sourceChan = FileChannel.open(file.toPath(), new OpenOption[0]);){
            ByteBuffer buf = ByteBuffer.allocate((int)sourceChan.size());
            sourceChan.read(buf);
            this.addBuffertoObjectStore(filePath, buf.array());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeBufToArray(String filePath, ByteBuffer buf) {
        try {
            ByteBufferInputStream inputStream = new ByteBufferInputStream(buf);
            byte[] bs = new byte[buf.limit()];
            Utils.readFully((InputStream)inputStream, (byte[])bs, (boolean)false);
            this.addBuffertoObjectStore(filePath, bs);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    static {
        wellKnownKeyPathMetadata = null;
        try {
            AeadConfig.register();
            KeyTemplate keyTemplate = KeyTemplates.get((String)"AES256_GCM_RAW");
            KeysetHandle keySetHandle = KeysetHandle.generateNew((KeyTemplate)keyTemplate);
            MASTER_KEY = (Aead)keySetHandle.getPrimitive(Aead.class);
        }
        catch (GeneralSecurityException e) {
            throw new TierObjectStoreFatalException("failed to initialize Tink", e);
        }
    }

    public static class UploadedObject {
        final HashMap<String, String> metadata;
        final CleartextDataKey cleartextDataKey;
        final byte[] data;
        VersionInformation versionInfo;
        long timestamp;

        private UploadedObject(HashMap<String, String> metadata, CleartextDataKey cleartextDataKey, byte[] data, VersionInformation versionInfo, long timestamp) {
            this.metadata = metadata;
            this.cleartextDataKey = cleartextDataKey;
            this.data = data;
            this.versionInfo = versionInfo;
            this.timestamp = timestamp;
        }

        public String getVersionId() {
            return this.versionInfo.getVersionId();
        }

        boolean encrypted() {
            return this.cleartextDataKey != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UploadedObject that = (UploadedObject)o;
            return this.timestamp == that.timestamp && Objects.equals(this.cleartextDataKey, that.cleartextDataKey) && Arrays.equals(this.data, that.data) && Objects.equals(this.versionInfo, that.versionInfo);
        }

        public int hashCode() {
            int result = Objects.hash(this.cleartextDataKey, this.versionInfo, this.timestamp);
            result = 31 * result + Arrays.hashCode(this.data);
            return result;
        }
    }

    private static class MockInMemoryTierObjectStoreResponse
    implements TierObjectStoreResponse {
        private final InputStream inputStream;

        MockInMemoryTierObjectStoreResponse(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public void close() {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

