/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum FragmentType {
    HEADER(0),
    SEGMENT(1),
    OFFSET_INDEX(2),
    TIMESTAMP_INDEX(3),
    TRANSACTION_INDEX(4),
    PRODUCER_STATE(5),
    EPOCH_STATE(6),
    TIER_STATE_SNAPSHOT(7),
    LIFECYCLE_MANAGER_STATE(8),
    BACKUP_OBJECTS_LIST(9),
    HEALTH_CHECK(10),
    TIER_PARTITION_STATE_METADATA_SNAPSHOT(11),
    TIER_TOPIC_SNAPSHOT(12),
    DA_OFFSET_MAP(13),
    KRAFT_SNAPSHOT(14),
    FILE_TIER_PARTITION_STATE_UPLOAD(15),
    TIER_RECOVERY_METADATA_UPLOAD(16),
    TIER_OFFSETS_UPLOAD(17),
    TIER_TOPIC_HEAD_DATA_LOSS_REPORT(18);

    private static final Map<Byte, FragmentType> BYTE_ENUM_MAP;
    private final byte b;

    private FragmentType(byte b) {
        this.b = b;
    }

    public byte getByte() {
        return this.b;
    }

    public static FragmentType byteToFragmentType(byte b) {
        FragmentType type = BYTE_ENUM_MAP.get(b);
        if (type == null) {
            throw new IllegalArgumentException(String.format("No FragmentType exists with byte value %02x", b));
        }
        return type;
    }

    static {
        BYTE_ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(FragmentType.values()).collect(Collectors.toMap(FragmentType::getByte, Function.identity())));
    }

    private static class ByteValues {
        public static final byte HEADER_BYTE = 0;
        public static final byte SEGMENT_BYTE = 1;
        public static final byte OFFSET_INDEX_BYTE = 2;
        public static final byte TIMESTAMP_INDEX_BYTE = 3;
        public static final byte TRANSACTION_INDEX_BYTE = 4;
        public static final byte PRODUCER_STATE_BYTE = 5;
        public static final byte EPOCH_STATE_BYTE = 6;
        public static final byte TIER_STATE_SNAPSHOT_BYTE = 7;
        public static final byte LIFECYCLE_MANAGER_STATE_BYTE = 8;
        public static final byte BACKUP_OBJECTS_LIST_BYTE = 9;
        public static final byte HEALTH_CHECK_BYTE = 10;
        public static final byte TIER_PARTITION_STATE_METADATA_SNAPSHOT_BYTE = 11;
        public static final byte TIER_TOPIC_SNAPSHOT_BYTE = 12;
        public static final byte DA_OFFSET_MAP_BYTE = 13;
        public static final byte KRAFT_SNAPSHOT_BYTE = 14;
        public static final byte FILE_TIER_PARTITION_STATE_UPLOAD_BYTE = 15;
        public static final byte TIER_RECOVERY_METADATA_UPLOAD_BYTE = 16;
        public static final byte TIER_OFFSETS_UPLOAD_BYTE = 17;
        public static final byte TIER_TOPIC_HEAD_DATA_LOSS_REPORT_BYTE = 18;

        private ByteValues() {
        }
    }
}

