/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects;

import io.confluent.kafka.storage.checksum.E2EChecksumProtectedObjectType;
import java.util.Optional;
import kafka.tier.store.objects.FragmentType;

public enum ObjectType {
    SEGMENT("segment", 0, FragmentType.SEGMENT),
    OFFSET_INDEX("offset-index", 1, FragmentType.OFFSET_INDEX),
    TIMESTAMP_INDEX("timestamp-index", 2, FragmentType.TIMESTAMP_INDEX),
    TRANSACTION_INDEX("transaction-index", 3, FragmentType.TRANSACTION_INDEX),
    PRODUCER_STATE("producer-state", 4, FragmentType.PRODUCER_STATE),
    EPOCH_STATE("epoch-state", 5, FragmentType.EPOCH_STATE),
    TIER_STATE_SNAPSHOT("tier-state-snapshot", 6, FragmentType.TIER_STATE_SNAPSHOT),
    LIFECYCLE_MANAGER_STATE("lifecycle-manager-state", 7, FragmentType.LIFECYCLE_MANAGER_STATE),
    BACKUP_OBJECTS_LIST("bkp-list", 8, FragmentType.BACKUP_OBJECTS_LIST),
    HEALTH_CHECK("health", 9, FragmentType.HEALTH_CHECK),
    TIER_PARTITION_STATE_METADATA_SNAPSHOT("tier-partition-state-metadata-snapshot", 10, FragmentType.TIER_PARTITION_STATE_METADATA_SNAPSHOT),
    TIER_TOPIC_SNAPSHOT("tier-topic-snapshot", 11, FragmentType.TIER_TOPIC_SNAPSHOT),
    DA_OFFSET_MAP("da-offset-map", 12, FragmentType.DA_OFFSET_MAP),
    KRAFT_SNAPSHOT("kraft-checkpoint", 13, FragmentType.KRAFT_SNAPSHOT),
    SEGMENT_WITH_METADATA("segment-with-metadata", 14),
    FILE_TIER_PARTITION_STATE_UPLOAD("tier-partition-state-upload", 15, FragmentType.FILE_TIER_PARTITION_STATE_UPLOAD),
    TIER_RECOVERY_METADATA_UPLOAD("tier-recovery-metadata-upload", 16, FragmentType.TIER_RECOVERY_METADATA_UPLOAD),
    TIER_OFFSETS_UPLOAD("tier-offsets-upload", 17, FragmentType.TIER_OFFSETS_UPLOAD),
    TIER_TOPIC_HEAD_DATA_LOSS_REPORT("tier-topic-head-data-loss-report", 18, FragmentType.TIER_TOPIC_HEAD_DATA_LOSS_REPORT);

    private final String suffix;
    private final byte b;
    private final Optional<FragmentType> designatedFragmentType;

    public String suffix() {
        return this.suffix;
    }

    public byte getByte() {
        return this.b;
    }

    private ObjectType(String suffix, byte b) {
        this(suffix, b, null);
    }

    private ObjectType(String suffix, byte b, FragmentType fragmentType) {
        this.suffix = suffix;
        this.b = b;
        this.designatedFragmentType = Optional.ofNullable(fragmentType);
    }

    public E2EChecksumProtectedObjectType toE2EChecksumProtectedObjectType() {
        return E2EChecksumProtectedObjectType.valueOf((String)this.name());
    }

    public Optional<FragmentType> getDesignatedFragmentType() {
        return this.designatedFragmentType;
    }

    public static String getObjectTypeSuffix(String objectPath) {
        return objectPath.substring(objectPath.lastIndexOf(".") + 1);
    }

    public static Optional<ObjectType> getDefaultObjectTypeForFragmentType(FragmentType fragmentType) {
        switch (fragmentType) {
            case SEGMENT: {
                return Optional.of(SEGMENT);
            }
            case OFFSET_INDEX: {
                return Optional.of(OFFSET_INDEX);
            }
            case TIMESTAMP_INDEX: {
                return Optional.of(TIMESTAMP_INDEX);
            }
            case TRANSACTION_INDEX: {
                return Optional.of(TRANSACTION_INDEX);
            }
            case PRODUCER_STATE: {
                return Optional.of(PRODUCER_STATE);
            }
            case EPOCH_STATE: {
                return Optional.of(EPOCH_STATE);
            }
            case TIER_STATE_SNAPSHOT: {
                return Optional.of(TIER_STATE_SNAPSHOT);
            }
            case LIFECYCLE_MANAGER_STATE: {
                return Optional.of(LIFECYCLE_MANAGER_STATE);
            }
            case BACKUP_OBJECTS_LIST: {
                return Optional.of(BACKUP_OBJECTS_LIST);
            }
            case HEALTH_CHECK: {
                return Optional.of(HEALTH_CHECK);
            }
            case TIER_PARTITION_STATE_METADATA_SNAPSHOT: {
                return Optional.of(TIER_PARTITION_STATE_METADATA_SNAPSHOT);
            }
            case TIER_TOPIC_SNAPSHOT: {
                return Optional.of(TIER_TOPIC_SNAPSHOT);
            }
            case DA_OFFSET_MAP: {
                return Optional.of(DA_OFFSET_MAP);
            }
            case KRAFT_SNAPSHOT: {
                return Optional.of(KRAFT_SNAPSHOT);
            }
            case FILE_TIER_PARTITION_STATE_UPLOAD: {
                return Optional.of(FILE_TIER_PARTITION_STATE_UPLOAD);
            }
            case TIER_RECOVERY_METADATA_UPLOAD: {
                return Optional.of(TIER_RECOVERY_METADATA_UPLOAD);
            }
            case TIER_OFFSETS_UPLOAD: {
                return Optional.of(TIER_OFFSETS_UPLOAD);
            }
            case TIER_TOPIC_HEAD_DATA_LOSS_REPORT: {
                return Optional.of(TIER_TOPIC_HEAD_DATA_LOSS_REPORT);
            }
        }
        return Optional.empty();
    }

    public static ObjectType byteToObjectType(byte b) {
        switch (b) {
            case 0: {
                return SEGMENT;
            }
            case 1: {
                return OFFSET_INDEX;
            }
            case 2: {
                return TIMESTAMP_INDEX;
            }
            case 3: {
                return TRANSACTION_INDEX;
            }
            case 4: {
                return PRODUCER_STATE;
            }
            case 5: {
                return EPOCH_STATE;
            }
            case 6: {
                return TIER_STATE_SNAPSHOT;
            }
            case 7: {
                return LIFECYCLE_MANAGER_STATE;
            }
            case 8: {
                return BACKUP_OBJECTS_LIST;
            }
            case 9: {
                return HEALTH_CHECK;
            }
            case 10: {
                return TIER_PARTITION_STATE_METADATA_SNAPSHOT;
            }
            case 11: {
                return TIER_TOPIC_SNAPSHOT;
            }
            case 12: {
                return DA_OFFSET_MAP;
            }
            case 13: {
                return KRAFT_SNAPSHOT;
            }
            case 14: {
                return SEGMENT_WITH_METADATA;
            }
            case 15: {
                return FILE_TIER_PARTITION_STATE_UPLOAD;
            }
            case 16: {
                return TIER_RECOVERY_METADATA_UPLOAD;
            }
            case 17: {
                return TIER_OFFSETS_UPLOAD;
            }
            case 18: {
                return TIER_TOPIC_HEAD_DATA_LOSS_REPORT;
            }
        }
        throw new IllegalArgumentException(String.format("No ObjectType exists with byte value %02x", b));
    }

    private static class ByteValues {
        public static final byte SEGMENT_BYTE = 0;
        public static final byte OFFSET_INDEX_BYTE = 1;
        public static final byte TIMESTAMP_INDEX_BYTE = 2;
        public static final byte TRANSACTION_INDEX_BYTE = 3;
        public static final byte PRODUCER_STATE_BYTE = 4;
        public static final byte EPOCH_STATE_BYTE = 5;
        public static final byte TIER_STATE_SNAPSHOT_BYTE = 6;
        public static final byte LIFECYCLE_MANAGER_STATE_BYTE = 7;
        public static final byte BACKUP_OBJECTS_LIST_BYTE = 8;
        public static final byte HEALTH_CHECK_BYTE = 9;
        public static final byte TIER_PARTITION_STATE_METADATA_SNAPSHOT_BYTE = 10;
        public static final byte TIER_TOPIC_SNAPSHOT_BYTE = 11;
        public static final byte DA_OFFSET_MAP_BYTE = 12;
        public static final byte KRAFT_SNAPSHOT_BYTE = 13;
        public static final byte SEGMENT_WITH_METADATA_BYTE = 14;
        public static final byte FILE_TIER_PARTITION_STATE_UPLOAD_BYTE = 15;
        public static final byte TIER_RECOVERY_METADATA_UPLOAD_BYTE = 16;
        public static final byte TIER_OFFSETS_UPLOAD_BYTE = 17;
        public static final byte TIER_TOPIC_HEAD_DATA_LOSS_REPORT_BYTE = 18;

        private ByteValues() {
        }
    }
}

