/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\t\rb!\u0002\u000e\u001c\u0003\u0003\u0011\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000b\u0001\u0003A\u0011A!\t\u00115\u0003\u0001\u0019!C\u0001;9C\u0001B\u0015\u0001A\u0002\u0013\u0005Qd\u0015\u0005\u00073\u0002\u0001\u000b\u0015B(\t\u000fy\u0003\u0001\u0019!C\u0005?\"9\u0011\u000e\u0001a\u0001\n\u0013Q\u0007B\u00027\u0001A\u0003&\u0001\rC\u0004o\u0001\t\u0007I\u0011B8\t\u000f\u0005\u0015\u0001\u0001)A\u0005a\"9\u0011q\u0001\u0001\u0007\u0002\u0005%\u0001bBA\n\u0001\u0019\u0005\u0011Q\u0003\u0005\b\u0003G\u0001a\u0011AA\u0013\u0011\u0019\t\u0019\u000b\u0001C\u0001?\"9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0006bBAX\u0001\u0011\u00051d\u001c\u0005\b\u0003c\u0003A\u0011AAZ\u0011!\ti\f\u0001C\t7\u0005}\u0006\u0002CA_\u0001\u0011E1$a6\t\u000f\u0005}\u0007\u0001\"\u0005\u0002b\"A\u0011\u0011\u001e\u0001\u0005\u0012m\tY\u000f\u0003\u0005\u0002p\u0002!\tbGAy\u0011!\u0011\t\u0002\u0001C\t7\tM\u0001b\u0002B\f\u0001\u0011E!\u0011\u0004\u0005\b\u00057\u0001A\u0011\u0003B\u000f\u0005!!\u0016.\u001a:UCN\\'B\u0001\u000f\u001e\u0003\u0015!\u0018m]6t\u0015\tqr$\u0001\u0003uS\u0016\u0014(\"\u0001\u0011\u0002\u000b-\fgm[1\u0004\u0001U\u00111ER\n\u0004\u0001\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g\r\u0005\u0002,]5\tAF\u0003\u0002.?\u0005)Q\u000f^5mg&\u0011q\u0006\f\u0002\b\u0019><w-\u001b8h\u00031\u0011X\r\u001e:z%\u0006$Xm\u00149u!\r)#\u0007N\u0005\u0003g\u0019\u0012aa\u00149uS>t\u0007CA\u001b?\u001b\u00051$BA\u001c9\u0003\u0011\u0019wN]3\u000b\u0005eR\u0014aB7fiJL7m\u001d\u0006\u0003wq\na!_1n[\u0016\u0014(\"A\u001f\u0002\u0007\r|W.\u0003\u0002@m\t)Q*\u001a;fe\u00061A(\u001b8jiz\"\"A\u0011'\u0011\u0007\r\u0003A)D\u0001\u001c!\t)e\t\u0004\u0001\u0005\u000b\u001d\u0003!\u0019\u0001%\u0003\u0003Q\u000b\"!\u0013\"\u0011\u0005\u0015R\u0015BA&'\u0005\u001dqu\u000e\u001e5j]\u001eDQ\u0001\r\u0002A\u0002E\n!B]3uef\u001cu.\u001e8u+\u0005y\u0005CA\u0013Q\u0013\t\tfEA\u0002J]R\faB]3uef\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0002U/B\u0011Q%V\u0005\u0003-\u001a\u0012A!\u00168ji\"9\u0001\fBA\u0001\u0002\u0004y\u0015a\u0001=%c\u0005Y!/\u001a;ss\u000e{WO\u001c;!Q\t)1\f\u0005\u0002&9&\u0011QL\n\u0002\tm>d\u0017\r^5mK\u0006aq\f]1vg\u0016$WK\u001c;jYV\t\u0001\rE\u0002&e\u0005\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\tQLW.\u001a\u0006\u0002M\u0006!!.\u0019<b\u0013\tA7MA\u0004J]N$\u0018M\u001c;\u0002!}\u0003\u0018-^:fIVsG/\u001b7`I\u0015\fHC\u0001+l\u0011\u001dAv!!AA\u0002\u0001\fQb\u00189bkN,G-\u00168uS2\u0004\u0003F\u0001\u0005\\\u0003\u001dyVM\u001d:peN,\u0012\u0001\u001d\t\u0004cR4X\"\u0001:\u000b\u0005M,\u0017\u0001B;uS2L!!\u001e:\u0003\u0007M+G\u000f\u0005\u0002x\u007f:\u0011\u00010 \b\u0003srl\u0011A\u001f\u0006\u0003w\u0006\na\u0001\u0010:p_Rt\u0014\"A\u0014\n\u0005y4\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0003\t\u0019AA\u0005UQJ|w/\u00192mK*\u0011aPJ\u0001\t?\u0016\u0014(o\u001c:tA\u0005\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00105\tQ$C\u0002\u0002\u0012u\u0011\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002\u0007\r$\b0\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001eu\tqAZ3uG\",'/\u0003\u0003\u0002\"\u0005m!aE\"b]\u000e,G\u000e\\1uS>t7i\u001c8uKb$\u0018A\u0003;sC:\u001c\u0018\u000e^5p]Rq\u0011qEA \u00033\nI'!\u001f\u0002\n\u0006]E\u0003BA\u0015\u0003k\u0001R!a\u000b\u00022\u0011k!!!\f\u000b\u0007\u0005=b%\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\r\u0002.\t1a)\u001e;ve\u0016Dq!a\u000e\u000e\u0001\b\tI$\u0001\u0002fGB!\u00111FA\u001e\u0013\u0011\ti$!\f\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\bB\u00023\u000e\u0001\u0004\t\t\u0005\u0005\u0003\u0002D\u0005USBAA#\u0015\ri\u0013q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0004d_6lwN\u001c\u0006\u0004A\u00055#\u0002BA(\u0003#\na!\u00199bG\",'BAA*\u0003\ry'oZ\u0005\u0005\u0003/\n)E\u0001\u0003US6,\u0007bBA.\u001b\u0001\u0007\u0011QL\u0001\u0012i&,'\u000fV8qS\u000e\f\u0005\u000f]3oI\u0016\u0014\b\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\rT$A\u0003u_BL7-\u0003\u0003\u0002h\u0005\u0005$!\u0005+jKJ$v\u000e]5d\u0003B\u0004XM\u001c3fe\"9\u00111N\u0007A\u0002\u00055\u0014a\u0004;jKJ|%M[3diN#xN]3\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001d\u001e\u0003\u0015\u0019Ho\u001c:f\u0013\u0011\t9(!\u001d\u0003\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016Dq!a\u001f\u000e\u0001\u0004\ti(\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003S1!a! \u0003\u0019\u0019XM\u001d<fe&!\u0011qQAA\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDq!a#\u000e\u0001\u0004\ti)\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003\u001f\u000b\u0019*\u0004\u0002\u0002\u0012*\u0019\u00111R\u000e\n\t\u0005U\u0015\u0011\u0013\u0002\u0010)&,'\u000fV1tWN\u001cuN\u001c4jO\"9\u0011\u0011T\u0007A\u0002\u0005m\u0015!\u0003;ie>$H\u000f\\3s!\u0011)#'!(\u0011\u0007-\ny*C\u0002\u0002\"2\u0012\u0011\u0002\u00165s_R$H.\u001a:\u0002\u0017A\fWo]3e+:$\u0018\u000e\\\u0001\rSN,%O]8s'R\fG/Z\u000b\u0003\u0003S\u00032!JAV\u0013\r\tiK\n\u0002\b\u0005>|G.Z1o\u0003-)'O]8s'R\fG/Z:\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\u0011\u0011Q\u0017\t\u0005\u0003o\u000bI,\u0004\u0002\u0002H%!\u00111XA$\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\faB]3uef$\u0016m]6MCR,'\u000fF\u0005U\u0003\u0003\f)-!3\u0002T\"1\u00111\u0019\nA\u0002=\u000b\u0011#\\1y%\u0016$(/\u001f\"bG.|gMZ't\u0011\u0019\t9M\u0005a\u0001\u001f\u0006\tR.\u001b8SKR\u0014\u0018PQ1dW>4g-T:\t\u000f\u0005-'\u00031\u0001\u0002N\u0006)an\\<NgB\u0019Q%a4\n\u0007\u0005EgE\u0001\u0003M_:<\u0007BBAk%\u0001\u0007a/A\u0001u)\u001d!\u0016\u0011\\An\u0003;Da!a1\u0014\u0001\u0004y\u0005bBAf'\u0001\u0007\u0011Q\u001a\u0005\u0007\u0003+\u001c\u0002\u0019\u0001<\u0002\u0013\u0011,G.Y=UCN\\G#\u0002+\u0002d\u0006\u001d\bBBAs)\u0001\u0007q*A\u0004eK2\f\u00170T:\t\u000f\u0005-G\u00031\u0001\u0002N\u0006i1/\u001a;FeJ|'o\u0015;bi\u0016$2\u0001VAw\u0011\u0019\t).\u0006a\u0001m\u0006y1\r\\3be\u0016\u0013(o\u001c:Ti\u0006$X\rF\u0002U\u0003gDq!!>\u0017\u0001\u0004\t90\u0001\buQJ|w/\u00192mK\u000ec\u0017m]:1\t\u0005e(1\u0002\t\u0007\u0003w\u0014\u0019A!\u0003\u000f\t\u0005u\u0018q \t\u0003s\u001aJ1A!\u0001'\u0003\u0019\u0001&/\u001a3fM&!!Q\u0001B\u0004\u0005\u0015\u0019E.Y:t\u0015\r\u0011\tA\n\t\u0004\u000b\n-A\u0001\u0004B\u0007\u0003g\f\t\u0011!A\u0003\u0002\t=!aA0%cE\u0011\u0011J^\u0001\u0017G\u0006t7-\u001a7B]\u0012\u001cV\r^#se>\u00148\u000b^1uKR\u0019AK!\u0006\t\r\u0005Uw\u00031\u0001w\u0003YygnU;dG\u0016\u001c8OZ;m)J\fgn]5uS>tG#\u0001+\u0002?=t7+^2dKN\u001ch-\u001e7Ue\u0006t7/\u001b;j_:<\u0016\u000e\u001e5EK2\f\u0017\u0010F\u0003U\u0005?\u0011\t\u0003C\u0004\u0002ff\u0001\r!!4\t\u000f\u0005-\u0017\u00041\u0001\u0002N\u0002")
public abstract class TierTask<T extends TierTask<T>>
implements Logging {
    private final Option<Meter> retryRateOpt;
    private volatile int retryCount;
    private volatile Option<Instant> _pausedUntil;
    private final Set<Throwable> _errors;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int retryCount() {
        return this.retryCount;
    }

    public void retryCount_$eq(int x$1) {
        this.retryCount = x$1;
    }

    private Option<Instant> _pausedUntil() {
        return this._pausedUntil;
    }

    private void _pausedUntil_$eq(Option<Instant> x$1) {
        this._pausedUntil = x$1;
    }

    private Set<Throwable> _errors() {
        return this._errors;
    }

    public abstract TopicIdPartition topicIdPartition();

    public abstract CancellationContext ctx();

    public abstract Future<T> transition(Time var1, TierTopicAppender var2, TierObjectStore var3, ReplicaManager var4, TierTasksConfig var5, Option<Throttler> var6, ExecutionContext var7);

    public Option<Instant> pausedUntil() {
        return this._pausedUntil();
    }

    public boolean isErrorState() {
        return !this._errors().isEmpty();
    }

    public Set<Throwable> errorStates() {
        return this._errors();
    }

    public TopicPartition topicPartition() {
        return this.topicIdPartition().topicPartition();
    }

    public void retryTaskLater(int maxRetryBackoffMs, int minRetryBackoffMs, long nowMs, Throwable t) {
        this.retryCount_$eq(this.retryCount() + 1);
        this.retryRateOpt.foreach((Function1 & Serializable)x$1 -> {
            x$1.mark();
            return BoxedUnit.UNIT;
        });
        Instant now = Instant.ofEpochMilli(nowMs);
        int pauseMs = Math.max(Math.min(maxRetryBackoffMs, (Random$.MODULE$.nextInt(this.retryCount()) + 1) * 1000), minRetryBackoffMs);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("retrying ").append(this).append(" after ").append(pauseMs).append("ms").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
        this._pausedUntil_$eq((Option<Instant>)new Some((Object)now.plusMillis(pauseMs)));
    }

    public void retryTaskLater(int maxRetryBackoffMs, long nowMs, Throwable t) {
        this.retryTaskLater(maxRetryBackoffMs, 0, nowMs, t);
    }

    public void delayTask(int delayMs, long nowMs) {
        Instant now = Instant.ofEpochMilli(nowMs);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("retrying ").append(this).append(" after ").append(delayMs).append("ms").toString());
        this._pausedUntil_$eq((Option<Instant>)new Some((Object)now.plusMillis(delayMs)));
    }

    public void setErrorState(Throwable t) {
        this._errors().add(t);
    }

    public void clearErrorState(Class<? extends Throwable> throwableClass) {
        this._errors().removeIf(error -> {
            Class<?> clazz = error.getClass();
            return !(clazz != null ? !clazz.equals(throwableClass) : throwableClass != null);
        });
    }

    public void cancelAndSetErrorState(Throwable t) {
        this.setErrorState(t);
        this.ctx().cancel();
    }

    public void onSuccessfulTransition() {
        this.retryCount_$eq(0);
        this._pausedUntil_$eq((Option<Instant>)None$.MODULE$);
    }

    public void onSuccessfulTransitionWithDelay(long delayMs, long nowMs) {
        Instant now = Instant.ofEpochMilli(nowMs);
        this.onSuccessfulTransition();
        this._pausedUntil_$eq((Option<Instant>)new Some((Object)now.plusMillis(delayMs)));
    }

    public TierTask(Option<Meter> retryRateOpt) {
        this.retryRateOpt = retryRateOpt;
        this.retryCount = 0;
        this._pausedUntil = None$.MODULE$;
        this._errors = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

