/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierMetadataRecoveryConstants;
import kafka.tier.tools.TierMetadataRecoveryOrchestrator;
import kafka.tier.tools.TierMetadataRecoveryUtils;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;

public final class GetTierRecoveryDataUploadResultCommand {
    static final String COMMAND = "get-tier-recovery-data-upload-result";
    private static final String JOB_ID = "job-id";
    private static final String JOB_ID_DOC = "The unique identifier for the upload job whose result we want to obtain.";
    private static final String BROKER_ID = "broker-id";
    private static final String BROKER_ID_DOC = "The integer ID of the broker which had initiated this upload.";

    static void addCommand(Subparsers subparsers) {
        Subparser getTierRecoveryDataUploadResult = subparsers.addParser(COMMAND).help("Get the result of the previously initiated recovery upload job.");
        getTierRecoveryDataUploadResult.addArgument(new String[]{RecoveryUtils.makeArgument("rest-server-port-override")}).dest("rest-server-port-override").type(Integer.class).setDefault((Object)TierMetadataRecoveryConstants.DEFAULT_REST_SERVER_PORT_OVERRIDE).help(TierMetadataRecoveryConstants.REST_SERVER_PORT_OVERRIDE_DOC);
        getTierRecoveryDataUploadResult.addArgument(new String[]{RecoveryUtils.makeArgument(JOB_ID)}).required(true).dest(JOB_ID).type(String.class).help(JOB_ID_DOC);
        getTierRecoveryDataUploadResult.addArgument(new String[]{RecoveryUtils.makeArgument(BROKER_ID)}).required(true).dest(BROKER_ID).type(Integer.class).help(BROKER_ID_DOC);
    }

    static int execute(Namespace namespace) throws ExecutionException, InterruptedException, IOException {
        String bootstrapServers = namespace.getString("bootstrap-servers");
        String adminConfig = namespace.getString("admin.config");
        Integer restServerPort = namespace.getInt("rest-server-port-override");
        int brokerId = namespace.getInt(BROKER_ID);
        String jobId = namespace.getString(JOB_ID);
        TierMetadataRecoveryOrchestrator orchestrator = TierMetadataRecoveryUtils.getTierMetadataRecoveryOrchestrator(bootstrapServers, adminConfig, restServerPort);
        orchestrator.getTierRecoveryDataUploadJobResultForBroker(brokerId, UUID.fromString(jobId));
        return 0;
    }
}

