/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.tier.tools.TierPartitionStateRestoreTrigger;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.utils.Time;

public abstract class RestoreRawInput<T, E> {
    static TierObjectStore getObjectStore(Time time, Properties props) {
        TierObjectStore.Backend backend = TierObjectStore.Backend.valueOf(props.getProperty(KafkaConfig.TierBackendProp()));
        TierObjectStoreConfig config = TierObjectStoreUtils.generateBackendConfig(backend, props);
        return TierObjectStoreFactory.getObjectStoreInstance(time, backend, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void injectStateFromRestoreInput(Time time, Properties props, String tierTopicName, File outputFile, List<T> inputs) throws Exception {
        Producer<byte[], byte[]> producer = null;
        TierObjectStore objectStore = null;
        try {
            producer = RecoveryUtils.createTierTopicProducer(props, TierPartitionStateRestoreTrigger.class.getSimpleName());
            objectStore = RestoreRawInput.getObjectStore(time, props);
            int numTierTopicPartitions = RecoveryUtils.getNumPartitions(producer, tierTopicName);
            ArrayList<E> outputs = new ArrayList<E>();
            for (T input : inputs) {
                File file = this.getFtpsForTopicPartition(input, objectStore);
                Boolean restoreLogStartOffset = this.getRestoreLogStartOffset(input);
                TierPartitionForceRestore restore = TierPartitionStateRestoreTrigger.injectState(tierTopicName, numTierTopicPartitions, producer, objectStore, file, restoreLogStartOffset);
                E output = this.getRawOutputInfo(input, restore.toString());
                outputs.add(output);
            }
            this.writeOutputFile(outputs, outputFile);
        }
        finally {
            if (producer != null) {
                producer.close();
            }
            if (objectStore != null) {
                objectStore.close();
            }
        }
    }

    protected abstract File getFtpsForTopicPartition(T var1, TierObjectStore var2) throws IOException, InterruptedException;

    protected abstract Boolean getRestoreLogStartOffset(T var1);

    protected abstract E getRawOutputInfo(T var1, String var2);

    protected abstract void writeOutputFile(List<E> var1, File var2) throws IOException;
}

