/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierMetadataRecoveryConstants;
import kafka.tier.tools.TierMetadataRecoveryOrchestrator;
import kafka.tier.tools.TierMetadataRecoveryUtils;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.TopicPartition;

public class TierTopicHeadDataLossDetectionCommand {
    static final String COMMAND = "tier-topic-head-data-loss-detection-command";
    private static final String IDENTIFIER = "identifier";
    private static final String IDENTIFIER_DOC = "Unique identifier representing the on-demand data loss validation run.";
    private static final String TTP_ALLOW_LIST_FILE = "ttp-allow-list-file";
    private static final String TTP_ALLOW_LIST_FILE_DOC = "Name of the file that contains the list of tier topic partitions we want to validate. If not provided, defaults to running on all tier topic partitions.";

    static void addCommand(Subparsers subparsers) {
        Subparser tierTopicHeadDataLossDetection = subparsers.addParser(COMMAND).help("Runs on-demand data loss validator on provided tier topic partitions.");
        MutuallyExclusiveGroup runScopeGroup = tierTopicHeadDataLossDetection.addMutuallyExclusiveGroup().required(true);
        runScopeGroup.addArgument(new String[]{RecoveryUtils.makeArgument("broker-ids")}).dest("broker-ids").action((ArgumentAction)Arguments.store()).help("Runs the operation only on the specified brokers");
        runScopeGroup.addArgument(new String[]{RecoveryUtils.makeArgument("all-brokers")}).dest("all-brokers").action((ArgumentAction)Arguments.storeTrue()).help("Runs the operation for all brokers in the cluster");
        tierTopicHeadDataLossDetection.addArgument(new String[]{RecoveryUtils.makeArgument("rest-server-port-override")}).dest("rest-server-port-override").type(Integer.class).action((ArgumentAction)Arguments.store()).setDefault((Object)TierMetadataRecoveryConstants.DEFAULT_REST_SERVER_PORT_OVERRIDE).help(TierMetadataRecoveryConstants.REST_SERVER_PORT_OVERRIDE_DOC);
        tierTopicHeadDataLossDetection.addArgument(new String[]{RecoveryUtils.makeArgument(IDENTIFIER)}).dest(IDENTIFIER).type(String.class).action((ArgumentAction)Arguments.store()).required(true).help(IDENTIFIER_DOC);
        tierTopicHeadDataLossDetection.addArgument(new String[]{RecoveryUtils.makeArgument(TTP_ALLOW_LIST_FILE)}).dest(TTP_ALLOW_LIST_FILE).type(String.class).action((ArgumentAction)Arguments.store()).required(false).help(TTP_ALLOW_LIST_FILE_DOC);
    }

    static Set<TopicPartition> parseTierTopicPartitionAllowList(String tierTopicPartitionAllowListFile) throws IOException {
        HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>();
        try (BufferedReader reader = new BufferedReader(new FileReader(tierTopicPartitionAllowListFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                TopicPartition topicPartition = TopicPartition.fromString((String)line.trim());
                if (!topicPartition.topic().equals("_confluent-tier-state")) {
                    throw new IllegalArgumentException(String.format("Expected tier topic: %s, Received topic: %s", "_confluent-tier-state", topicPartition.topic()));
                }
                topicPartitions.add(topicPartition);
            }
        }
        return topicPartitions;
    }

    static int execute(Namespace namespace) throws IOException, ExecutionException, InterruptedException {
        String bootstrapServers = namespace.getString("bootstrap-servers");
        String adminConfig = namespace.getString("admin.config");
        Integer restServerPort = namespace.getInt("rest-server-port-override");
        TierMetadataRecoveryOrchestrator orchestrator = TierMetadataRecoveryUtils.getTierMetadataRecoveryOrchestrator(bootstrapServers, adminConfig, restServerPort);
        String identifier = namespace.getString(IDENTIFIER);
        String tierTopicPartitionAllowListFile = namespace.getString(TTP_ALLOW_LIST_FILE);
        HashSet<TopicPartition> tierTopicPartitionsAllowList = new HashSet();
        if (tierTopicPartitionAllowListFile != null) {
            tierTopicPartitionsAllowList = TierTopicHeadDataLossDetectionCommand.parseTierTopicPartitionAllowList(tierTopicPartitionAllowListFile);
        }
        if (namespace.getBoolean("all-brokers").booleanValue()) {
            orchestrator.detectDataLossInTierTopicForCluster(identifier, tierTopicPartitionsAllowList);
        } else {
            Set<Integer> brokers = TierMetadataRecoveryUtils.getBrokerList(namespace);
            for (Integer broker : brokers) {
                orchestrator.detectDataLossInTierTopicForBroker(broker, identifier, tierTopicPartitionsAllowList);
            }
        }
        return 0;
    }
}

